/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill.ui;

import android.content.Context;
import android.content.IntentSender;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.service.autofill.Dataset;
import android.service.autofill.FillResponse;
import android.text.TextUtils;
import android.util.Slog;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutofillWindowPresenter;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.server.UiThread;
import com.android.server.autofill.AutofillManagerService;
import com.android.server.autofill.Helper;
import com.android.server.autofill.ui.OverlayControl;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class FillUi {
    private static final String TAG = "FillUi";
    private static final int THEME_ID_LIGHT = 16974821;
    private static final int THEME_ID_DARK = 16974812;
    private static final TypedValue sTempTypedValue = new TypedValue();
    private final Point mTempPoint = new Point();
    private final AutofillWindowPresenter mWindowPresenter = new AutofillWindowPresenter();
    private final Context mContext;
    private final AnchoredWindow mWindow;
    private final Callback mCallback;
    private final View mHeader;
    private final ListView mListView;
    private final View mFooter;
    private final ItemsAdapter mAdapter;
    private String mFilterText;
    private AnnounceFilterResult mAnnounceFilterResult;
    private final boolean mFullScreen;
    private final int mVisibleDatasetsMaxCount;
    private int mContentWidth;
    private int mContentHeight;
    private boolean mDestroyed;
    private final int mThemeId;

    public static boolean isFullScreen(Context context) {
        if (Helper.sFullScreenMode != null) {
            if (Helper.sVerbose) {
                Slog.v(TAG, "forcing full-screen mode to " + Helper.sFullScreenMode);
            }
            return Helper.sFullScreenMode;
        }
        return context.getPackageManager().hasSystemFeature("android.software.leanback");
    }

    FillUi(Context context, FillResponse response, AutofillId focusedViewId, String filterText, OverlayControl overlayControl, CharSequence serviceLabel, Drawable serviceIcon, boolean nightMode, Callback callback) {
        ImageView iconView;
        if (Helper.sVerbose) {
            Slog.v(TAG, "nightMode: " + nightMode);
        }
        this.mThemeId = nightMode ? 16974812 : 16974821;
        this.mCallback = callback;
        this.mFullScreen = FillUi.isFullScreen(context);
        this.mContext = new ContextThemeWrapper(context, this.mThemeId);
        LayoutInflater inflater = LayoutInflater.from(this.mContext);
        RemoteViews headerPresentation = response.getHeader();
        RemoteViews footerPresentation = response.getFooter();
        ViewGroup decor = this.mFullScreen ? (ViewGroup)inflater.inflate(17367101, null) : (headerPresentation != null || footerPresentation != null ? (ViewGroup)inflater.inflate(17367102, null) : (ViewGroup)inflater.inflate(17367100, null));
        decor.setClipToOutline(true);
        TextView titleView = (TextView)decor.findViewById(16908747);
        if (titleView != null) {
            titleView.setText(this.mContext.getString(17039593, serviceLabel));
        }
        if ((iconView = (ImageView)decor.findViewById(16908744)) != null) {
            iconView.setImageDrawable(serviceIcon);
        }
        if (this.mFullScreen) {
            Point outPoint = this.mTempPoint;
            this.mContext.getDisplay().getSize(outPoint);
            this.mContentWidth = -1;
            this.mContentHeight = outPoint.y / 2;
            if (Helper.sVerbose) {
                Slog.v(TAG, "initialized fillscreen LayoutParams " + this.mContentWidth + "," + this.mContentHeight);
            }
        }
        decor.addOnUnhandledKeyEventListener((view, event) -> {
            switch (event.getKeyCode()) {
                case 4: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 66: 
                case 111: {
                    return false;
                }
            }
            this.mCallback.dispatchUnhandledKey(event);
            return true;
        });
        if (AutofillManagerService.getVisibleDatasetsMaxCount() > 0) {
            this.mVisibleDatasetsMaxCount = AutofillManagerService.getVisibleDatasetsMaxCount();
            if (Helper.sVerbose) {
                Slog.v(TAG, "overriding maximum visible datasets to " + this.mVisibleDatasetsMaxCount);
            }
        } else {
            this.mVisibleDatasetsMaxCount = this.mContext.getResources().getInteger(17694724);
        }
        RemoteViews.OnClickHandler interceptionHandler = (view, pendingIntent, r) -> {
            if (pendingIntent != null) {
                this.mCallback.startIntentSender(pendingIntent.getIntentSender());
            }
            return true;
        };
        if (response.getAuthentication() != null) {
            View content;
            this.mHeader = null;
            this.mListView = null;
            this.mFooter = null;
            this.mAdapter = null;
            ViewGroup container = (ViewGroup)decor.findViewById(16908746);
            try {
                content = response.getPresentation().applyWithTheme(this.mContext, decor, interceptionHandler, this.mThemeId);
                container.addView(content);
            }
            catch (RuntimeException e) {
                callback.onCanceled();
                Slog.e(TAG, "Error inflating remote views", e);
                this.mWindow = null;
                return;
            }
            container.setFocusable(true);
            container.setOnClickListener(v -> this.mCallback.onResponsePicked(response));
            if (!this.mFullScreen) {
                Point maxSize = this.mTempPoint;
                FillUi.resolveMaxWindowSize(this.mContext, maxSize);
                content.getLayoutParams().width = this.mFullScreen ? maxSize.x : -2;
                content.getLayoutParams().height = -2;
                int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxSize.x, Integer.MIN_VALUE);
                int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxSize.y, Integer.MIN_VALUE);
                decor.measure(widthMeasureSpec, heightMeasureSpec);
                this.mContentWidth = content.getMeasuredWidth();
                this.mContentHeight = content.getMeasuredHeight();
            }
            this.mWindow = new AnchoredWindow(decor, overlayControl);
            this.requestShowFillUi();
        } else {
            int datasetCount = response.getDatasets().size();
            if (Helper.sVerbose) {
                Slog.v(TAG, "Number datasets: " + datasetCount + " max visible: " + this.mVisibleDatasetsMaxCount);
            }
            RemoteViews.OnClickHandler clickBlocker = null;
            if (headerPresentation != null) {
                clickBlocker = this.newClickBlocker();
                this.mHeader = headerPresentation.applyWithTheme(this.mContext, null, clickBlocker, this.mThemeId);
                LinearLayout headerContainer = (LinearLayout)decor.findViewById(16908743);
                if (Helper.sVerbose) {
                    Slog.v(TAG, "adding header");
                }
                headerContainer.addView(this.mHeader);
                headerContainer.setVisibility(0);
            } else {
                this.mHeader = null;
            }
            if (footerPresentation != null) {
                LinearLayout footerContainer = (LinearLayout)decor.findViewById(16908742);
                if (footerContainer != null) {
                    if (clickBlocker == null) {
                        clickBlocker = this.newClickBlocker();
                    }
                    this.mFooter = footerPresentation.applyWithTheme(this.mContext, null, clickBlocker, this.mThemeId);
                    if (Helper.sVerbose) {
                        Slog.v(TAG, "adding footer");
                    }
                    footerContainer.addView(this.mFooter);
                    footerContainer.setVisibility(0);
                } else {
                    this.mFooter = null;
                }
            } else {
                this.mFooter = null;
            }
            ArrayList<ViewItem> items = new ArrayList<ViewItem>(datasetCount);
            for (int i = 0; i < datasetCount; ++i) {
                View view2;
                Dataset dataset = response.getDatasets().get(i);
                int index = dataset.getFieldIds().indexOf(focusedViewId);
                if (index < 0) continue;
                RemoteViews presentation = dataset.getFieldPresentation(index);
                if (presentation == null) {
                    Slog.w(TAG, "not displaying UI on field " + focusedViewId + " because service didn't provide a presentation for it on " + dataset);
                    continue;
                }
                try {
                    if (Helper.sVerbose) {
                        Slog.v(TAG, "setting remote view for " + focusedViewId);
                    }
                    view2 = presentation.applyWithTheme(this.mContext, null, interceptionHandler, this.mThemeId);
                }
                catch (RuntimeException e) {
                    Slog.e(TAG, "Error inflating remote views", e);
                    continue;
                }
                Dataset.DatasetFieldFilter filter = dataset.getFilter(index);
                Pattern filterPattern = null;
                String valueText = null;
                boolean filterable = true;
                if (filter == null) {
                    AutofillValue value = dataset.getFieldValues().get(index);
                    if (value != null && value.isText()) {
                        valueText = value.getTextValue().toString().toLowerCase();
                    }
                } else {
                    filterPattern = filter.pattern;
                    if (filterPattern == null) {
                        if (Helper.sVerbose) {
                            Slog.v(TAG, "Explicitly disabling filter at id " + focusedViewId + " for dataset #" + index);
                        }
                        filterable = false;
                    }
                }
                items.add(new ViewItem(dataset, filterPattern, filterable, valueText, view2));
            }
            this.mAdapter = new ItemsAdapter(items);
            this.mListView = (ListView)decor.findViewById(16908745);
            this.mListView.setAdapter(this.mAdapter);
            this.mListView.setVisibility(0);
            this.mListView.setOnItemClickListener((adapter, view, position, id2) -> {
                ViewItem vi = this.mAdapter.getItem(position);
                this.mCallback.onDatasetPicked(vi.dataset);
            });
            this.mFilterText = filterText == null ? null : filterText.toLowerCase();
            this.applyNewFilterText();
            this.mWindow = new AnchoredWindow(decor, overlayControl);
        }
    }

    void requestShowFillUi() {
        this.mCallback.requestShowFillUi(this.mContentWidth, this.mContentHeight, this.mWindowPresenter);
    }

    private RemoteViews.OnClickHandler newClickBlocker() {
        return (view, pendingIntent, response) -> {
            if (Helper.sVerbose) {
                Slog.v(TAG, "Ignoring click on " + view);
            }
            return true;
        };
    }

    private void applyNewFilterText() {
        int oldCount = this.mAdapter.getCount();
        this.mAdapter.getFilter().filter(this.mFilterText, count -> {
            if (this.mDestroyed) {
                return;
            }
            if (count <= 0) {
                if (Helper.sDebug) {
                    int size = this.mFilterText == null ? 0 : this.mFilterText.length();
                    Slog.d(TAG, "No dataset matches filter with " + size + " chars");
                }
                this.mCallback.requestHideFillUi();
            } else {
                if (this.updateContentSize()) {
                    this.requestShowFillUi();
                }
                if (this.mAdapter.getCount() > this.mVisibleDatasetsMaxCount) {
                    this.mListView.setVerticalScrollBarEnabled(true);
                    this.mListView.onVisibilityAggregated(true);
                } else {
                    this.mListView.setVerticalScrollBarEnabled(false);
                }
                if (this.mAdapter.getCount() != oldCount) {
                    this.mListView.requestLayout();
                }
            }
        });
    }

    public void setFilterText(String filterText) {
        this.throwIfDestroyed();
        if (this.mAdapter == null) {
            if (TextUtils.isEmpty(filterText)) {
                this.requestShowFillUi();
            } else {
                this.mCallback.requestHideFillUi();
            }
            return;
        }
        if (Objects.equals(this.mFilterText, filterText = filterText == null ? null : filterText.toLowerCase())) {
            return;
        }
        this.mFilterText = filterText;
        this.applyNewFilterText();
    }

    public void destroy(boolean notifyClient) {
        this.throwIfDestroyed();
        if (this.mWindow != null) {
            this.mWindow.hide(false);
        }
        this.mCallback.onDestroy();
        if (notifyClient) {
            this.mCallback.requestHideFillUi();
        }
        this.mDestroyed = true;
    }

    private boolean updateContentSize() {
        if (this.mAdapter == null) {
            return false;
        }
        if (this.mFullScreen) {
            return true;
        }
        boolean changed = false;
        if (this.mAdapter.getCount() <= 0) {
            if (this.mContentWidth != 0) {
                this.mContentWidth = 0;
                changed = true;
            }
            if (this.mContentHeight != 0) {
                this.mContentHeight = 0;
                changed = true;
            }
            return changed;
        }
        Point maxSize = this.mTempPoint;
        FillUi.resolveMaxWindowSize(this.mContext, maxSize);
        this.mContentWidth = 0;
        this.mContentHeight = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxSize.x, Integer.MIN_VALUE);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(maxSize.y, Integer.MIN_VALUE);
        int itemCount = this.mAdapter.getCount();
        if (this.mHeader != null) {
            this.mHeader.measure(widthMeasureSpec, heightMeasureSpec);
            changed |= this.updateWidth(this.mHeader, maxSize);
            changed |= this.updateHeight(this.mHeader, maxSize);
        }
        for (int i = 0; i < itemCount; ++i) {
            View view = this.mAdapter.getItem((int)i).view;
            view.measure(widthMeasureSpec, heightMeasureSpec);
            changed |= this.updateWidth(view, maxSize);
            if (i >= this.mVisibleDatasetsMaxCount) continue;
            changed |= this.updateHeight(view, maxSize);
        }
        if (this.mFooter != null) {
            this.mFooter.measure(widthMeasureSpec, heightMeasureSpec);
            changed |= this.updateWidth(this.mFooter, maxSize);
            changed |= this.updateHeight(this.mFooter, maxSize);
        }
        return changed;
    }

    private boolean updateWidth(View view, Point maxSize) {
        boolean changed = false;
        int clampedMeasuredWidth = Math.min(view.getMeasuredWidth(), maxSize.x);
        int newContentWidth = Math.max(this.mContentWidth, clampedMeasuredWidth);
        if (newContentWidth != this.mContentWidth) {
            this.mContentWidth = newContentWidth;
            changed = true;
        }
        return changed;
    }

    private boolean updateHeight(View view, Point maxSize) {
        boolean changed = false;
        int clampedMeasuredHeight = Math.min(view.getMeasuredHeight(), maxSize.y);
        int newContentHeight = this.mContentHeight + clampedMeasuredHeight;
        if (newContentHeight != this.mContentHeight) {
            this.mContentHeight = newContentHeight;
            changed = true;
        }
        return changed;
    }

    private void throwIfDestroyed() {
        if (this.mDestroyed) {
            throw new IllegalStateException("cannot interact with a destroyed instance");
        }
    }

    private static void resolveMaxWindowSize(Context context, Point outPoint) {
        context.getDisplay().getSize(outPoint);
        TypedValue typedValue = sTempTypedValue;
        context.getTheme().resolveAttribute(17956883, typedValue, true);
        outPoint.x = (int)typedValue.getFraction(outPoint.x, outPoint.x);
        context.getTheme().resolveAttribute(0x1120012, typedValue, true);
        outPoint.y = (int)typedValue.getFraction(outPoint.y, outPoint.y);
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mCallback: ");
        pw.println(this.mCallback != null);
        pw.print(prefix);
        pw.print("mFullScreen: ");
        pw.println(this.mFullScreen);
        pw.print(prefix);
        pw.print("mVisibleDatasetsMaxCount: ");
        pw.println(this.mVisibleDatasetsMaxCount);
        if (this.mHeader != null) {
            pw.print(prefix);
            pw.print("mHeader: ");
            pw.println(this.mHeader);
        }
        if (this.mListView != null) {
            pw.print(prefix);
            pw.print("mListView: ");
            pw.println(this.mListView);
        }
        if (this.mFooter != null) {
            pw.print(prefix);
            pw.print("mFooter: ");
            pw.println(this.mFooter);
        }
        if (this.mAdapter != null) {
            pw.print(prefix);
            pw.print("mAdapter: ");
            pw.println(this.mAdapter);
        }
        if (this.mFilterText != null) {
            pw.print(prefix);
            pw.print("mFilterText: ");
            Helper.printlnRedactedText(pw, this.mFilterText);
        }
        pw.print(prefix);
        pw.print("mContentWidth: ");
        pw.println(this.mContentWidth);
        pw.print(prefix);
        pw.print("mContentHeight: ");
        pw.println(this.mContentHeight);
        pw.print(prefix);
        pw.print("mDestroyed: ");
        pw.println(this.mDestroyed);
        pw.print(prefix);
        pw.print("theme id: ");
        pw.print(this.mThemeId);
        switch (this.mThemeId) {
            case 16974812: {
                pw.println(" (dark)");
                break;
            }
            case 16974821: {
                pw.println(" (light)");
                break;
            }
            default: {
                pw.println("(UNKNOWN_MODE)");
            }
        }
        if (this.mWindow != null) {
            pw.print(prefix);
            pw.print("mWindow: ");
            String prefix2 = prefix + "  ";
            pw.println();
            pw.print(prefix2);
            pw.print("showing: ");
            pw.println(this.mWindow.mShowing);
            pw.print(prefix2);
            pw.print("view: ");
            pw.println(this.mWindow.mContentView);
            if (this.mWindow.mShowParams != null) {
                pw.print(prefix2);
                pw.print("params: ");
                pw.println(this.mWindow.mShowParams);
            }
            pw.print(prefix2);
            pw.print("screen coordinates: ");
            if (this.mWindow.mContentView == null) {
                pw.println("N/A");
            } else {
                int[] coordinates = this.mWindow.mContentView.getLocationOnScreen();
                pw.print(coordinates[0]);
                pw.print("x");
                pw.println(coordinates[1]);
            }
        }
    }

    private void announceSearchResultIfNeeded() {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            if (this.mAnnounceFilterResult == null) {
                this.mAnnounceFilterResult = new AnnounceFilterResult();
            }
            this.mAnnounceFilterResult.post();
        }
    }

    private final class AnnounceFilterResult
    implements Runnable {
        private static final int SEARCH_RESULT_ANNOUNCEMENT_DELAY = 1000;

        private AnnounceFilterResult() {
        }

        public void post() {
            this.remove();
            FillUi.this.mListView.postDelayed(this, 1000L);
        }

        public void remove() {
            FillUi.this.mListView.removeCallbacks(this);
        }

        @Override
        public void run() {
            int count = FillUi.this.mListView.getAdapter().getCount();
            String text = count <= 0 ? FillUi.this.mContext.getString(17039566) : FillUi.this.mContext.getResources().getQuantityString(0x1150000, count, count);
            FillUi.this.mListView.announceForAccessibility(text);
        }
    }

    private final class ItemsAdapter
    extends BaseAdapter
    implements Filterable {
        private final List<ViewItem> mAllItems;
        private final List<ViewItem> mFilteredItems = new ArrayList<ViewItem>();

        ItemsAdapter(List<ViewItem> items) {
            this.mAllItems = Collections.unmodifiableList(new ArrayList<ViewItem>(items));
            this.mFilteredItems.addAll(items);
        }

        @Override
        public Filter getFilter() {
            return new Filter(){

                @Override
                protected Filter.FilterResults performFiltering(CharSequence filterText) {
                    List filtered = ItemsAdapter.this.mAllItems.stream().filter((? super T item) -> item.matches(filterText)).collect(Collectors.toList());
                    Filter.FilterResults results = new Filter.FilterResults();
                    results.values = filtered;
                    results.count = filtered.size();
                    return results;
                }

                @Override
                protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                    boolean resultCountChanged;
                    int oldItemCount = ItemsAdapter.this.mFilteredItems.size();
                    ItemsAdapter.this.mFilteredItems.clear();
                    if (results.count > 0) {
                        List items = (List)results.values;
                        ItemsAdapter.this.mFilteredItems.addAll(items);
                    }
                    boolean bl = resultCountChanged = oldItemCount != ItemsAdapter.this.mFilteredItems.size();
                    if (resultCountChanged) {
                        FillUi.this.announceSearchResultIfNeeded();
                    }
                    ItemsAdapter.this.notifyDataSetChanged();
                }
            };
        }

        @Override
        public int getCount() {
            return this.mFilteredItems.size();
        }

        @Override
        public ViewItem getItem(int position) {
            return this.mFilteredItems.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            return this.getItem((int)position).view;
        }

        public String toString() {
            return "ItemsAdapter: [all=" + this.mAllItems + ", filtered=" + this.mFilteredItems + "]";
        }
    }

    final class AnchoredWindow {
        private final OverlayControl mOverlayControl;
        private final WindowManager mWm;
        private final View mContentView;
        private boolean mShowing;
        private WindowManager.LayoutParams mShowParams;

        AnchoredWindow(View contentView, OverlayControl overlayControl) {
            this.mWm = contentView.getContext().getSystemService(WindowManager.class);
            this.mContentView = contentView;
            this.mOverlayControl = overlayControl;
        }

        public void show(WindowManager.LayoutParams params) {
            this.mShowParams = params;
            if (Helper.sVerbose) {
                Slog.v(FillUi.TAG, "show(): showing=" + this.mShowing + ", params=" + Helper.paramsToString(params));
            }
            try {
                params.packageName = "android";
                params.setTitle("Autofill UI");
                if (!this.mShowing) {
                    params.accessibilityTitle = this.mContentView.getContext().getString(17039565);
                    this.mWm.addView(this.mContentView, params);
                    this.mOverlayControl.hideOverlays();
                    this.mShowing = true;
                } else {
                    this.mWm.updateViewLayout(this.mContentView, params);
                }
            }
            catch (WindowManager.BadTokenException e) {
                if (Helper.sDebug) {
                    Slog.d(FillUi.TAG, "Filed with with token " + params.token + " gone.");
                }
                FillUi.this.mCallback.onDestroy();
            }
            catch (IllegalStateException e) {
                Slog.wtf(FillUi.TAG, "Exception showing window " + params, e);
                FillUi.this.mCallback.onDestroy();
            }
        }

        void hide() {
            this.hide(true);
        }

        void hide(boolean destroyCallbackOnError) {
            try {
                if (this.mShowing) {
                    this.mWm.removeView(this.mContentView);
                    this.mShowing = false;
                }
            }
            catch (IllegalStateException e) {
                Slog.e(FillUi.TAG, "Exception hiding window ", e);
                if (destroyCallbackOnError) {
                    FillUi.this.mCallback.onDestroy();
                }
            }
            finally {
                this.mOverlayControl.showOverlays();
            }
        }
    }

    private final class AutofillWindowPresenter
    extends IAutofillWindowPresenter.Stub {
        private AutofillWindowPresenter() {
        }

        @Override
        public void show(WindowManager.LayoutParams p, Rect transitionEpicenter, boolean fitsSystemWindows, int layoutDirection) {
            if (Helper.sVerbose) {
                Slog.v(FillUi.TAG, "AutofillWindowPresenter.show(): fit=" + fitsSystemWindows + ", params=" + Helper.paramsToString(p));
            }
            UiThread.getHandler().post(() -> FillUi.this.mWindow.show(p));
        }

        @Override
        public void hide(Rect transitionEpicenter) {
            UiThread.getHandler().post(FillUi.this.mWindow::hide);
        }
    }

    private static class ViewItem {
        public final String value;
        public final Dataset dataset;
        public final View view;
        public final Pattern filter;
        public final boolean filterable;

        ViewItem(Dataset dataset, Pattern filter, boolean filterable, String value, View view) {
            this.dataset = dataset;
            this.value = value;
            this.view = view;
            this.filter = filter;
            this.filterable = filterable;
        }

        public boolean matches(CharSequence filterText) {
            if (TextUtils.isEmpty(filterText)) {
                return true;
            }
            if (!this.filterable) {
                return false;
            }
            String constraintLowerCase = filterText.toString().toLowerCase();
            if (this.filter != null) {
                return this.filter.matcher(constraintLowerCase).matches();
            }
            return this.value == null ? this.dataset.getAuthentication() == null : this.value.toLowerCase().startsWith(constraintLowerCase);
        }

        public String toString() {
            String datasetId;
            StringBuilder builder = new StringBuilder("ViewItem:[view=").append(this.view.getAutofillId());
            String string2 = datasetId = this.dataset == null ? null : this.dataset.getId();
            if (datasetId != null) {
                builder.append(", dataset=").append(datasetId);
            }
            if (this.value != null) {
                builder.append(", value=").append(this.value.length()).append("_chars");
            }
            if (this.filterable) {
                builder.append(", filterable");
            }
            if (this.filter != null) {
                builder.append(", filter=").append(this.filter.pattern().length()).append("_chars");
            }
            return builder.append(']').toString();
        }
    }

    static interface Callback {
        public void onResponsePicked(FillResponse var1);

        public void onDatasetPicked(Dataset var1);

        public void onCanceled();

        public void onDestroy();

        public void requestShowFillUi(int var1, int var2, IAutofillWindowPresenter var3);

        public void requestHideFillUi();

        public void startIntentSender(IntentSender var1);

        public void dispatchUnhandledKey(KeyEvent var1);
    }
}

