/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.content.ContentResolver;
import android.os.Handler;
import android.provider.Settings;
import android.util.KeyValueListParser;
import android.util.KeyValueSettingObserver;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;

public class BackupAgentTimeoutParameters
extends KeyValueSettingObserver {
    private static final String TAG = "BackupAgentTimeout";
    @VisibleForTesting
    public static final String SETTING = "backup_agent_timeout_parameters";
    @VisibleForTesting
    public static final String SETTING_KV_BACKUP_AGENT_TIMEOUT_MILLIS = "kv_backup_agent_timeout_millis";
    @VisibleForTesting
    public static final String SETTING_FULL_BACKUP_AGENT_TIMEOUT_MILLIS = "full_backup_agent_timeout_millis";
    @VisibleForTesting
    public static final String SETTING_SHARED_BACKUP_AGENT_TIMEOUT_MILLIS = "shared_backup_agent_timeout_millis";
    @VisibleForTesting
    public static final String SETTING_RESTORE_AGENT_TIMEOUT_MILLIS = "restore_agent_timeout_millis";
    @VisibleForTesting
    public static final String SETTING_RESTORE_AGENT_FINISHED_TIMEOUT_MILLIS = "restore_agent_finished_timeout_millis";
    @VisibleForTesting
    public static final String SETTING_QUOTA_EXCEEDED_TIMEOUT_MILLIS = "quota_exceeded_timeout_millis";
    @VisibleForTesting
    public static final long DEFAULT_KV_BACKUP_AGENT_TIMEOUT_MILLIS = 30000L;
    @VisibleForTesting
    public static final long DEFAULT_FULL_BACKUP_AGENT_TIMEOUT_MILLIS = 300000L;
    @VisibleForTesting
    public static final long DEFAULT_SHARED_BACKUP_AGENT_TIMEOUT_MILLIS = 1800000L;
    @VisibleForTesting
    public static final long DEFAULT_RESTORE_AGENT_TIMEOUT_MILLIS = 60000L;
    @VisibleForTesting
    public static final long DEFAULT_RESTORE_AGENT_FINISHED_TIMEOUT_MILLIS = 30000L;
    @VisibleForTesting
    public static final long DEFAULT_QUOTA_EXCEEDED_TIMEOUT_MILLIS = 3000L;
    @GuardedBy(value={"mLock"})
    private long mKvBackupAgentTimeoutMillis;
    @GuardedBy(value={"mLock"})
    private long mFullBackupAgentTimeoutMillis;
    @GuardedBy(value={"mLock"})
    private long mSharedBackupAgentTimeoutMillis;
    @GuardedBy(value={"mLock"})
    private long mRestoreAgentTimeoutMillis;
    @GuardedBy(value={"mLock"})
    private long mRestoreAgentFinishedTimeoutMillis;
    @GuardedBy(value={"mLock"})
    private long mQuotaExceededTimeoutMillis;
    private final Object mLock = new Object();

    public BackupAgentTimeoutParameters(Handler handler, ContentResolver resolver) {
        super(handler, resolver, Settings.Global.getUriFor(SETTING));
    }

    @Override
    public String getSettingValue(ContentResolver resolver) {
        return Settings.Global.getString(resolver, SETTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(KeyValueListParser parser) {
        Object object = this.mLock;
        synchronized (object) {
            this.mKvBackupAgentTimeoutMillis = parser.getLong(SETTING_KV_BACKUP_AGENT_TIMEOUT_MILLIS, 30000L);
            this.mFullBackupAgentTimeoutMillis = parser.getLong(SETTING_FULL_BACKUP_AGENT_TIMEOUT_MILLIS, 300000L);
            this.mSharedBackupAgentTimeoutMillis = parser.getLong(SETTING_SHARED_BACKUP_AGENT_TIMEOUT_MILLIS, 1800000L);
            this.mRestoreAgentTimeoutMillis = parser.getLong(SETTING_RESTORE_AGENT_TIMEOUT_MILLIS, 60000L);
            this.mRestoreAgentFinishedTimeoutMillis = parser.getLong(SETTING_RESTORE_AGENT_FINISHED_TIMEOUT_MILLIS, 30000L);
            this.mQuotaExceededTimeoutMillis = parser.getLong(SETTING_QUOTA_EXCEEDED_TIMEOUT_MILLIS, 3000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getKvBackupAgentTimeoutMillis() {
        Object object = this.mLock;
        synchronized (object) {
            Slog.v(TAG, "getKvBackupAgentTimeoutMillis(): " + this.mKvBackupAgentTimeoutMillis);
            return this.mKvBackupAgentTimeoutMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFullBackupAgentTimeoutMillis() {
        Object object = this.mLock;
        synchronized (object) {
            Slog.v(TAG, "getFullBackupAgentTimeoutMillis(): " + this.mFullBackupAgentTimeoutMillis);
            return this.mFullBackupAgentTimeoutMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSharedBackupAgentTimeoutMillis() {
        Object object = this.mLock;
        synchronized (object) {
            Slog.v(TAG, "getSharedBackupAgentTimeoutMillis(): " + this.mSharedBackupAgentTimeoutMillis);
            return this.mSharedBackupAgentTimeoutMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRestoreAgentTimeoutMillis() {
        Object object = this.mLock;
        synchronized (object) {
            Slog.v(TAG, "getRestoreAgentTimeoutMillis(): " + this.mRestoreAgentTimeoutMillis);
            return this.mRestoreAgentTimeoutMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRestoreAgentFinishedTimeoutMillis() {
        Object object = this.mLock;
        synchronized (object) {
            Slog.v(TAG, "getRestoreAgentFinishedTimeoutMillis(): " + this.mRestoreAgentFinishedTimeoutMillis);
            return this.mRestoreAgentFinishedTimeoutMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getQuotaExceededTimeoutMillis() {
        Object object = this.mLock;
        synchronized (object) {
            Slog.v(TAG, "getQuotaExceededTimeoutMillis(): " + this.mQuotaExceededTimeoutMillis);
            return this.mQuotaExceededTimeoutMillis;
        }
    }
}

