/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.Bundle;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.backup.BackupManagerConstants;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.JobIdManager;
import com.android.server.backup.Trampoline;

public class FullBackupJob
extends JobService {
    private static final String USER_ID_EXTRA_KEY = "userId";
    @VisibleForTesting
    public static final int MIN_JOB_ID = 52418896;
    @VisibleForTesting
    public static final int MAX_JOB_ID = 52419896;
    private static ComponentName sIdleService = new ComponentName("android", FullBackupJob.class.getName());
    @GuardedBy(value={"mParamsForUser"})
    private final SparseArray<JobParameters> mParamsForUser = new SparseArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(int userId, Context ctx, long minDelay, BackupManagerConstants constants) {
        JobScheduler js = (JobScheduler)ctx.getSystemService("jobscheduler");
        JobInfo.Builder builder = new JobInfo.Builder(FullBackupJob.getJobIdForUserId(userId), sIdleService);
        BackupManagerConstants backupManagerConstants = constants;
        synchronized (backupManagerConstants) {
            builder.setRequiresDeviceIdle(true).setRequiredNetworkType(constants.getFullBackupRequiredNetworkType()).setRequiresCharging(constants.getFullBackupRequireCharging());
        }
        if (minDelay > 0L) {
            builder.setMinimumLatency(minDelay);
        }
        Bundle extraInfo = new Bundle();
        extraInfo.putInt(USER_ID_EXTRA_KEY, userId);
        builder.setTransientExtras(extraInfo);
        js.schedule(builder.build());
    }

    public static void cancel(int userId, Context ctx) {
        JobScheduler js = (JobScheduler)ctx.getSystemService("jobscheduler");
        js.cancel(FullBackupJob.getJobIdForUserId(userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBackupPass(int userId) {
        SparseArray<JobParameters> sparseArray = this.mParamsForUser;
        synchronized (sparseArray) {
            JobParameters jobParameters = this.mParamsForUser.get(userId);
            if (jobParameters != null) {
                this.jobFinished(jobParameters, false);
                this.mParamsForUser.remove(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStartJob(JobParameters params) {
        int userId = params.getTransientExtras().getInt(USER_ID_EXTRA_KEY);
        SparseArray<JobParameters> sparseArray = this.mParamsForUser;
        synchronized (sparseArray) {
            this.mParamsForUser.put(userId, params);
        }
        Trampoline service = BackupManagerService.getInstance();
        return service.beginFullBackup(userId, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStopJob(JobParameters params) {
        int userId = params.getTransientExtras().getInt(USER_ID_EXTRA_KEY);
        SparseArray<JobParameters> sparseArray = this.mParamsForUser;
        synchronized (sparseArray) {
            if (this.mParamsForUser.removeReturnOld(userId) == null) {
                return false;
            }
        }
        Trampoline service = BackupManagerService.getInstance();
        service.endFullBackup(userId);
        return false;
    }

    private static int getJobIdForUserId(int userId) {
        return JobIdManager.getJobIdForUserId(52418896, 52419896, userId);
    }
}

