/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.SparseLongArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.backup.BackupManagerConstants;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.JobIdManager;
import com.android.server.backup.Trampoline;
import java.util.Random;

public class KeyValueBackupJob
extends JobService {
    private static final String TAG = "KeyValueBackupJob";
    private static ComponentName sKeyValueJobService = new ComponentName("android", KeyValueBackupJob.class.getName());
    private static final String USER_ID_EXTRA_KEY = "userId";
    private static final long MAX_DEFERRAL = 86400000L;
    @GuardedBy(value={"KeyValueBackupJob.class"})
    private static final SparseBooleanArray sScheduledForUserId = new SparseBooleanArray();
    @GuardedBy(value={"KeyValueBackupJob.class"})
    private static final SparseLongArray sNextScheduledForUserId = new SparseLongArray();
    @VisibleForTesting
    public static final int MIN_JOB_ID = 52417896;
    @VisibleForTesting
    public static final int MAX_JOB_ID = 52418896;

    public static void schedule(int userId, Context ctx, BackupManagerConstants constants) {
        KeyValueBackupJob.schedule(userId, ctx, 0L, constants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(int userId, Context ctx, long delay, BackupManagerConstants constants) {
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            boolean needsCharging;
            int networkType;
            long fuzz;
            long interval;
            if (sScheduledForUserId.get(userId)) {
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
            BackupManagerConstants backupManagerConstants = constants;
            synchronized (backupManagerConstants) {
                interval = constants.getKeyValueBackupIntervalMilliseconds();
                fuzz = constants.getKeyValueBackupFuzzMilliseconds();
                networkType = constants.getKeyValueBackupRequiredNetworkType();
                needsCharging = constants.getKeyValueBackupRequireCharging();
            }
            if (delay <= 0L) {
                delay = interval + (long)new Random().nextInt((int)fuzz);
            }
            Slog.v(TAG, "Scheduling k/v pass in " + delay / 1000L / 60L + " minutes");
            JobInfo.Builder builder = new JobInfo.Builder(KeyValueBackupJob.getJobIdForUserId(userId), sKeyValueJobService).setMinimumLatency(delay).setRequiredNetworkType(networkType).setRequiresCharging(needsCharging).setOverrideDeadline(86400000L);
            Bundle extraInfo = new Bundle();
            extraInfo.putInt(USER_ID_EXTRA_KEY, userId);
            builder.setTransientExtras(extraInfo);
            JobScheduler js = (JobScheduler)ctx.getSystemService("jobscheduler");
            js.schedule(builder.build());
            sScheduledForUserId.put(userId, true);
            sNextScheduledForUserId.put(userId, System.currentTimeMillis() + delay);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancel(int userId, Context ctx) {
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            JobScheduler js = (JobScheduler)ctx.getSystemService("jobscheduler");
            js.cancel(KeyValueBackupJob.getJobIdForUserId(userId));
            KeyValueBackupJob.clearScheduledForUserId(userId);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextScheduled(int userId) {
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sNextScheduledForUserId.get(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static boolean isScheduled(int userId) {
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sScheduledForUserId.get(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStartJob(JobParameters params) {
        int userId = params.getTransientExtras().getInt(USER_ID_EXTRA_KEY);
        Class<KeyValueBackupJob> clazz = KeyValueBackupJob.class;
        synchronized (KeyValueBackupJob.class) {
            KeyValueBackupJob.clearScheduledForUserId(userId);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            Trampoline service = BackupManagerService.getInstance();
            try {
                service.backupNowForUser(userId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return false;
        }
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        return false;
    }

    @GuardedBy(value={"KeyValueBackupJob.class"})
    private static void clearScheduledForUserId(int userId) {
        sScheduledForUserId.delete(userId);
        sNextScheduledForUserId.delete(userId);
    }

    private static int getJobIdForUserId(int userId) {
        return JobIdManager.getJobIdForUserId(52417896, 52418896, userId);
    }
}

