/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.INotificationManager;
import android.app.backup.BlobBackupHelper;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Slog;

public class NotificationBackupHelper
extends BlobBackupHelper {
    static final String TAG = "NotifBackupHelper";
    static final boolean DEBUG = Log.isLoggable("NotifBackupHelper", 3);
    static final int BLOB_VERSION = 1;
    static final String KEY_NOTIFICATIONS = "notifications";
    private final int mUserId;

    public NotificationBackupHelper(int userId) {
        super(1, KEY_NOTIFICATIONS);
        this.mUserId = userId;
    }

    @Override
    protected byte[] getBackupPayload(String key) {
        byte[] newPayload = null;
        if (KEY_NOTIFICATIONS.equals(key)) {
            try {
                INotificationManager nm = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
                newPayload = nm.getBackupPayload(this.mUserId);
            }
            catch (Exception e) {
                Slog.e(TAG, "Couldn't communicate with notification manager");
                newPayload = null;
            }
        }
        return newPayload;
    }

    @Override
    protected void applyRestoredPayload(String key, byte[] payload) {
        if (DEBUG) {
            Slog.v(TAG, "Got restore of " + key);
        }
        if (KEY_NOTIFICATIONS.equals(key)) {
            try {
                INotificationManager nm = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
                nm.applyRestore(payload, this.mUserId);
            }
            catch (Exception e) {
                Slog.e(TAG, "Couldn't communicate with notification manager");
            }
        }
    }
}

