/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.backup.BackupAgent;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.content.ComponentName;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Slog;
import com.android.server.LocalServices;
import com.android.server.backup.BackupUtils;
import com.android.server.backup.utils.AppBackupUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class PackageManagerBackupAgent
extends BackupAgent {
    private static final String TAG = "PMBA";
    private static final boolean DEBUG = false;
    private static final String GLOBAL_METADATA_KEY = "@meta@";
    private static final String DEFAULT_HOME_KEY = "@home@";
    private static final String STATE_FILE_HEADER = "=state=";
    private static final int STATE_FILE_VERSION = 2;
    private static final String ANCESTRAL_RECORD_KEY = "@ancestral_record@";
    private static final int ANCESTRAL_RECORD_VERSION = 1;
    private static final int UNDEFINED_ANCESTRAL_RECORD_VERSION = -1;
    private int mUserId;
    private List<PackageInfo> mAllPackages;
    private PackageManager mPackageManager;
    private HashMap<String, Metadata> mRestoredSignatures;
    private HashMap<String, Metadata> mStateVersions = new HashMap();
    private final HashSet<String> mExisting = new HashSet();
    private int mStoredSdkVersion;
    private String mStoredIncrementalVersion;
    private ComponentName mStoredHomeComponent;
    private long mStoredHomeVersion;
    private ArrayList<byte[]> mStoredHomeSigHashes;
    private boolean mHasMetadata;
    private ComponentName mRestoredHome;
    private long mRestoredHomeVersion;
    private String mRestoredHomeInstaller;
    private ArrayList<byte[]> mRestoredHomeSigHashes;

    public PackageManagerBackupAgent(PackageManager packageMgr, List<PackageInfo> packages, int userId) {
        this.init(packageMgr, packages, userId);
    }

    public PackageManagerBackupAgent(PackageManager packageMgr, int userId) {
        this.init(packageMgr, null, userId);
        this.evaluateStorablePackages();
    }

    private void init(PackageManager packageMgr, List<PackageInfo> packages, int userId) {
        this.mPackageManager = packageMgr;
        this.mAllPackages = packages;
        this.mRestoredSignatures = null;
        this.mHasMetadata = false;
        this.mStoredSdkVersion = Build.VERSION.SDK_INT;
        this.mStoredIncrementalVersion = Build.VERSION.INCREMENTAL;
        this.mUserId = userId;
    }

    public void evaluateStorablePackages() {
        this.mAllPackages = PackageManagerBackupAgent.getStorableApplications(this.mPackageManager, this.mUserId);
    }

    public static List<PackageInfo> getStorableApplications(PackageManager pm, int userId) {
        List<PackageInfo> pkgs = pm.getInstalledPackagesAsUser(0x8000000, userId);
        int N = pkgs.size();
        for (int a = N - 1; a >= 0; --a) {
            PackageInfo pkg = pkgs.get(a);
            if (AppBackupUtils.appIsEligibleForBackup(pkg.applicationInfo, userId)) continue;
            pkgs.remove(a);
        }
        return pkgs;
    }

    public boolean hasMetadata() {
        return this.mHasMetadata;
    }

    public Metadata getRestoredMetadata(String packageName) {
        if (this.mRestoredSignatures == null) {
            Slog.w(TAG, "getRestoredMetadata() before metadata read!");
            return null;
        }
        return this.mRestoredSignatures.get(packageName);
    }

    public Set<String> getRestoredPackages() {
        if (this.mRestoredSignatures == null) {
            Slog.w(TAG, "getRestoredPackages() before metadata read!");
            return null;
        }
        return this.mRestoredSignatures.keySet();
    }

    @Override
    public void onBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) {
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        DataOutputStream outputBufferStream = new DataOutputStream(outputBuffer);
        this.parseStateFile(oldState);
        if (this.mStoredIncrementalVersion == null || !this.mStoredIncrementalVersion.equals(Build.VERSION.INCREMENTAL)) {
            Slog.i(TAG, "Previous metadata " + this.mStoredIncrementalVersion + " mismatch vs " + Build.VERSION.INCREMENTAL + " - rewriting");
            this.mExisting.clear();
        }
        try {
            outputBufferStream.writeInt(1);
            PackageManagerBackupAgent.writeEntity(data, ANCESTRAL_RECORD_KEY, outputBuffer.toByteArray());
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to write package backup data file!");
            return;
        }
        long homeVersion = 0L;
        ArrayList<byte[]> homeSigHashes = null;
        PackageInfo homeInfo = null;
        String homeInstaller = null;
        ComponentName home = this.getPreferredHomeComponent();
        if (home != null) {
            try {
                homeInfo = this.mPackageManager.getPackageInfoAsUser(home.getPackageName(), 0x8000000, this.mUserId);
                homeInstaller = this.mPackageManager.getInstallerPackageName(home.getPackageName());
                homeVersion = homeInfo.getLongVersionCode();
                SigningInfo signingInfo = homeInfo.signingInfo;
                if (signingInfo == null) {
                    Slog.e(TAG, "Home app has no signing information");
                } else {
                    Signature[] homeInfoSignatures = signingInfo.getApkContentsSigners();
                    homeSigHashes = BackupUtils.hashSignatureArray(homeInfoSignatures);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.w(TAG, "Can't access preferred home info");
                home = null;
            }
        }
        try {
            boolean needHomeBackup;
            PackageManagerInternal pmi = LocalServices.getService(PackageManagerInternal.class);
            boolean bl = needHomeBackup = homeVersion != this.mStoredHomeVersion || !Objects.equals(home, this.mStoredHomeComponent) || home != null && !BackupUtils.signaturesMatch(this.mStoredHomeSigHashes, homeInfo, pmi);
            if (needHomeBackup) {
                if (home != null) {
                    outputBuffer.reset();
                    outputBufferStream.writeUTF(home.flattenToString());
                    outputBufferStream.writeLong(homeVersion);
                    outputBufferStream.writeUTF(homeInstaller != null ? homeInstaller : "");
                    PackageManagerBackupAgent.writeSignatureHashArray(outputBufferStream, homeSigHashes);
                    PackageManagerBackupAgent.writeEntity(data, DEFAULT_HOME_KEY, outputBuffer.toByteArray());
                } else {
                    data.writeEntityHeader(DEFAULT_HOME_KEY, -1);
                }
            }
            outputBuffer.reset();
            if (!this.mExisting.contains(GLOBAL_METADATA_KEY)) {
                outputBufferStream.writeInt(Build.VERSION.SDK_INT);
                outputBufferStream.writeUTF(Build.VERSION.INCREMENTAL);
                PackageManagerBackupAgent.writeEntity(data, GLOBAL_METADATA_KEY, outputBuffer.toByteArray());
            } else {
                this.mExisting.remove(GLOBAL_METADATA_KEY);
            }
            for (PackageInfo pkg : this.mAllPackages) {
                SigningInfo signingInfo;
                String packName = pkg.packageName;
                if (packName.equals(GLOBAL_METADATA_KEY)) continue;
                PackageInfo info = null;
                try {
                    info = this.mPackageManager.getPackageInfoAsUser(packName, 0x8000000, this.mUserId);
                }
                catch (PackageManager.NameNotFoundException e) {
                    this.mExisting.add(packName);
                    continue;
                }
                if (this.mExisting.contains(packName)) {
                    this.mExisting.remove(packName);
                    if (info.getLongVersionCode() == this.mStateVersions.get((Object)packName).versionCode) continue;
                }
                if ((signingInfo = info.signingInfo) == null) {
                    Slog.w(TAG, "Not backing up package " + packName + " since it appears to have no signatures.");
                    continue;
                }
                outputBuffer.reset();
                if (info.versionCodeMajor != 0) {
                    outputBufferStream.writeInt(Integer.MIN_VALUE);
                    outputBufferStream.writeLong(info.getLongVersionCode());
                } else {
                    outputBufferStream.writeInt(info.versionCode);
                }
                Signature[] infoSignatures = signingInfo.getApkContentsSigners();
                PackageManagerBackupAgent.writeSignatureHashArray(outputBufferStream, BackupUtils.hashSignatureArray(infoSignatures));
                PackageManagerBackupAgent.writeEntity(data, packName, outputBuffer.toByteArray());
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to write package backup data file!");
            return;
        }
        this.writeStateFile(this.mAllPackages, home, homeVersion, homeSigHashes, newState);
    }

    private static void writeEntity(BackupDataOutput data, String key, byte[] bytes) throws IOException {
        data.writeEntityHeader(key, bytes.length);
        data.writeEntityData(bytes, bytes.length);
    }

    @Override
    public void onRestore(BackupDataInput data, int appVersionCode, ParcelFileDescriptor newState) throws IOException {
        int ancestralRecordVersion = this.getAncestralRecordVersionValue(data);
        RestoreDataConsumer consumer = this.getRestoreDataConsumer(ancestralRecordVersion);
        if (consumer == null) {
            Slog.w(TAG, "Ancestral restore set version is unknown to this Android version; not restoring");
            return;
        }
        consumer.consumeRestoreData(data);
    }

    private int getAncestralRecordVersionValue(BackupDataInput data) throws IOException {
        int ancestralRecordVersionValue = -1;
        if (data.readNextHeader()) {
            String key = data.getKey();
            int dataSize = data.getDataSize();
            if (ANCESTRAL_RECORD_KEY.equals(key)) {
                byte[] inputBytes = new byte[dataSize];
                data.readEntityData(inputBytes, 0, dataSize);
                ByteArrayInputStream inputBuffer = new ByteArrayInputStream(inputBytes);
                DataInputStream inputBufferStream = new DataInputStream(inputBuffer);
                ancestralRecordVersionValue = inputBufferStream.readInt();
            }
        }
        return ancestralRecordVersionValue;
    }

    private RestoreDataConsumer getRestoreDataConsumer(int ancestralRecordVersion) {
        switch (ancestralRecordVersion) {
            case -1: {
                return new LegacyRestoreDataConsumer();
            }
            case 1: {
                return new AncestralVersion1RestoreDataConsumer();
            }
        }
        Slog.e(TAG, "Unrecognized ANCESTRAL_RECORD_VERSION: " + ancestralRecordVersion);
        return null;
    }

    private static void writeSignatureHashArray(DataOutputStream out, ArrayList<byte[]> hashes) throws IOException {
        out.writeInt(hashes.size());
        for (byte[] buffer : hashes) {
            out.writeInt(buffer.length);
            out.write(buffer);
        }
    }

    private static ArrayList<byte[]> readSignatureHashArray(DataInputStream in) {
        try {
            int num;
            try {
                num = in.readInt();
            }
            catch (EOFException e) {
                Slog.w(TAG, "Read empty signature block");
                return null;
            }
            if (num > 20) {
                Slog.e(TAG, "Suspiciously large sig count in restore data; aborting");
                throw new IllegalStateException("Bad restore state");
            }
            boolean nonHashFound = false;
            ArrayList<byte[]> sigs = new ArrayList<byte[]>(num);
            for (int i = 0; i < num; ++i) {
                int len = in.readInt();
                byte[] readHash = new byte[len];
                in.read(readHash);
                sigs.add(readHash);
                if (len == 32) continue;
                nonHashFound = true;
            }
            if (nonHashFound) {
                sigs = BackupUtils.hashSignatureArray(sigs);
            }
            return sigs;
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to read signatures");
            return null;
        }
    }

    private void parseStateFile(ParcelFileDescriptor stateFile) {
        this.mExisting.clear();
        this.mStateVersions.clear();
        this.mStoredSdkVersion = 0;
        this.mStoredIncrementalVersion = null;
        this.mStoredHomeComponent = null;
        this.mStoredHomeVersion = 0L;
        this.mStoredHomeSigHashes = null;
        FileInputStream instream = new FileInputStream(stateFile.getFileDescriptor());
        BufferedInputStream inbuffer = new BufferedInputStream(instream);
        DataInputStream in = new DataInputStream(inbuffer);
        try {
            boolean ignoreExisting = false;
            String pkg = in.readUTF();
            if (pkg.equals(STATE_FILE_HEADER)) {
                int stateVersion = in.readInt();
                if (stateVersion > 2) {
                    Slog.w(TAG, "Unsupported state file version " + stateVersion + ", redoing from start");
                    return;
                }
                pkg = in.readUTF();
            } else {
                Slog.i(TAG, "Older version of saved state - rewriting");
                ignoreExisting = true;
            }
            if (pkg.equals(DEFAULT_HOME_KEY)) {
                this.mStoredHomeComponent = ComponentName.unflattenFromString(in.readUTF());
                this.mStoredHomeVersion = in.readLong();
                this.mStoredHomeSigHashes = PackageManagerBackupAgent.readSignatureHashArray(in);
                pkg = in.readUTF();
            }
            if (pkg.equals(GLOBAL_METADATA_KEY)) {
                this.mStoredSdkVersion = in.readInt();
                this.mStoredIncrementalVersion = in.readUTF();
                if (!ignoreExisting) {
                    this.mExisting.add(GLOBAL_METADATA_KEY);
                }
            } else {
                Slog.e(TAG, "No global metadata in state file!");
                return;
            }
            while (true) {
                pkg = in.readUTF();
                int versionCodeInt = in.readInt();
                long versionCode = versionCodeInt == Integer.MIN_VALUE ? in.readLong() : (long)versionCodeInt;
                if (!ignoreExisting) {
                    this.mExisting.add(pkg);
                }
                this.mStateVersions.put(pkg, new Metadata(versionCode, null));
            }
        }
        catch (EOFException ignoreExisting) {
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to read Package Manager state file: " + e);
        }
    }

    private ComponentName getPreferredHomeComponent() {
        return this.mPackageManager.getHomeActivities(new ArrayList<ResolveInfo>());
    }

    private void writeStateFile(List<PackageInfo> pkgs, ComponentName preferredHome, long homeVersion, ArrayList<byte[]> homeSigHashes, ParcelFileDescriptor stateFile) {
        FileOutputStream outstream = new FileOutputStream(stateFile.getFileDescriptor());
        BufferedOutputStream outbuf = new BufferedOutputStream(outstream);
        DataOutputStream out = new DataOutputStream(outbuf);
        try {
            out.writeUTF(STATE_FILE_HEADER);
            out.writeInt(2);
            if (preferredHome != null) {
                out.writeUTF(DEFAULT_HOME_KEY);
                out.writeUTF(preferredHome.flattenToString());
                out.writeLong(homeVersion);
                PackageManagerBackupAgent.writeSignatureHashArray(out, homeSigHashes);
            }
            out.writeUTF(GLOBAL_METADATA_KEY);
            out.writeInt(Build.VERSION.SDK_INT);
            out.writeUTF(Build.VERSION.INCREMENTAL);
            for (PackageInfo pkg : pkgs) {
                out.writeUTF(pkg.packageName);
                if (pkg.versionCodeMajor != 0) {
                    out.writeInt(Integer.MIN_VALUE);
                    out.writeLong(pkg.getLongVersionCode());
                    continue;
                }
                out.writeInt(pkg.versionCode);
            }
            out.flush();
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to write package manager state file!");
        }
    }

    private class AncestralVersion1RestoreDataConsumer
    implements RestoreDataConsumer {
        private AncestralVersion1RestoreDataConsumer() {
        }

        @Override
        public void consumeRestoreData(BackupDataInput data) throws IOException {
            ArrayList<ApplicationInfo> restoredApps = new ArrayList<ApplicationInfo>();
            HashMap<String, Metadata> sigMap = new HashMap<String, Metadata>();
            int storedSystemVersion = -1;
            while (data.readNextHeader()) {
                String key = data.getKey();
                int dataSize = data.getDataSize();
                byte[] inputBytes = new byte[dataSize];
                data.readEntityData(inputBytes, 0, dataSize);
                ByteArrayInputStream inputBuffer = new ByteArrayInputStream(inputBytes);
                DataInputStream inputBufferStream = new DataInputStream(inputBuffer);
                if (key.equals(PackageManagerBackupAgent.GLOBAL_METADATA_KEY)) {
                    int storedSdkVersion = inputBufferStream.readInt();
                    PackageManagerBackupAgent.this.mStoredSdkVersion = storedSdkVersion;
                    PackageManagerBackupAgent.this.mStoredIncrementalVersion = inputBufferStream.readUTF();
                    PackageManagerBackupAgent.this.mHasMetadata = true;
                    continue;
                }
                if (key.equals(PackageManagerBackupAgent.DEFAULT_HOME_KEY)) {
                    String cn = inputBufferStream.readUTF();
                    PackageManagerBackupAgent.this.mRestoredHome = ComponentName.unflattenFromString(cn);
                    PackageManagerBackupAgent.this.mRestoredHomeVersion = inputBufferStream.readLong();
                    PackageManagerBackupAgent.this.mRestoredHomeInstaller = inputBufferStream.readUTF();
                    PackageManagerBackupAgent.this.mRestoredHomeSigHashes = PackageManagerBackupAgent.readSignatureHashArray(inputBufferStream);
                    continue;
                }
                int versionCodeInt = inputBufferStream.readInt();
                long versionCode = versionCodeInt == Integer.MIN_VALUE ? inputBufferStream.readLong() : (long)versionCodeInt;
                ArrayList sigs = PackageManagerBackupAgent.readSignatureHashArray(inputBufferStream);
                if (sigs == null || sigs.size() == 0) {
                    Slog.w(PackageManagerBackupAgent.TAG, "Not restoring package " + key + " since it appears to have no signatures.");
                    continue;
                }
                ApplicationInfo app = new ApplicationInfo();
                app.packageName = key;
                restoredApps.add(app);
                sigMap.put(key, new Metadata(versionCode, sigs));
            }
            PackageManagerBackupAgent.this.mRestoredSignatures = sigMap;
        }
    }

    private class LegacyRestoreDataConsumer
    implements RestoreDataConsumer {
        private LegacyRestoreDataConsumer() {
        }

        @Override
        public void consumeRestoreData(BackupDataInput data) throws IOException {
            ArrayList<ApplicationInfo> restoredApps = new ArrayList<ApplicationInfo>();
            HashMap<String, Metadata> sigMap = new HashMap<String, Metadata>();
            int storedSystemVersion = -1;
            while (true) {
                boolean readNextHeader;
                String key = data.getKey();
                int dataSize = data.getDataSize();
                byte[] inputBytes = new byte[dataSize];
                data.readEntityData(inputBytes, 0, dataSize);
                ByteArrayInputStream inputBuffer = new ByteArrayInputStream(inputBytes);
                DataInputStream inputBufferStream = new DataInputStream(inputBuffer);
                if (key.equals(PackageManagerBackupAgent.GLOBAL_METADATA_KEY)) {
                    int storedSdkVersion = inputBufferStream.readInt();
                    PackageManagerBackupAgent.this.mStoredSdkVersion = storedSdkVersion;
                    PackageManagerBackupAgent.this.mStoredIncrementalVersion = inputBufferStream.readUTF();
                    PackageManagerBackupAgent.this.mHasMetadata = true;
                } else if (key.equals(PackageManagerBackupAgent.DEFAULT_HOME_KEY)) {
                    String cn = inputBufferStream.readUTF();
                    PackageManagerBackupAgent.this.mRestoredHome = ComponentName.unflattenFromString(cn);
                    PackageManagerBackupAgent.this.mRestoredHomeVersion = inputBufferStream.readLong();
                    PackageManagerBackupAgent.this.mRestoredHomeInstaller = inputBufferStream.readUTF();
                    PackageManagerBackupAgent.this.mRestoredHomeSigHashes = PackageManagerBackupAgent.readSignatureHashArray(inputBufferStream);
                } else {
                    int versionCodeInt = inputBufferStream.readInt();
                    long versionCode = versionCodeInt == Integer.MIN_VALUE ? inputBufferStream.readLong() : (long)versionCodeInt;
                    ArrayList sigs = PackageManagerBackupAgent.readSignatureHashArray(inputBufferStream);
                    if (sigs == null || sigs.size() == 0) {
                        Slog.w(PackageManagerBackupAgent.TAG, "Not restoring package " + key + " since it appears to have no signatures.");
                        continue;
                    }
                    ApplicationInfo app = new ApplicationInfo();
                    app.packageName = key;
                    restoredApps.add(app);
                    sigMap.put(key, new Metadata(versionCode, sigs));
                }
                if (!(readNextHeader = data.readNextHeader())) break;
            }
            PackageManagerBackupAgent.this.mRestoredSignatures = sigMap;
        }
    }

    static interface RestoreDataConsumer {
        public void consumeRestoreData(BackupDataInput var1) throws IOException;
    }

    public class Metadata {
        public long versionCode;
        public ArrayList<byte[]> sigHashes;

        Metadata(long version, ArrayList<byte[]> hashes) {
            this.versionCode = version;
            this.sigHashes = hashes;
        }
    }
}

