/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.backup.BlobBackupHelper;
import android.os.UserHandle;
import android.permission.PermissionManagerInternal;
import android.util.Slog;
import com.android.server.LocalServices;

public class PermissionBackupHelper
extends BlobBackupHelper {
    private static final String TAG = "PermissionBackup";
    private static final boolean DEBUG = false;
    private static final int STATE_VERSION = 1;
    private static final String KEY_PERMISSIONS = "permissions";
    private final UserHandle mUser;
    private final PermissionManagerInternal mPermissionManager;

    public PermissionBackupHelper(int userId) {
        super(1, KEY_PERMISSIONS);
        this.mUser = UserHandle.of(userId);
        this.mPermissionManager = LocalServices.getService(PermissionManagerInternal.class);
    }

    @Override
    protected byte[] getBackupPayload(String key) {
        try {
            switch (key) {
                case "permissions": {
                    return this.mPermissionManager.backupRuntimePermissions(this.mUser);
                }
            }
            Slog.w(TAG, "Unexpected backup key " + key);
        }
        catch (Exception e) {
            Slog.e(TAG, "Unable to store payload " + key);
        }
        return null;
    }

    @Override
    protected void applyRestoredPayload(String key, byte[] payload) {
        try {
            switch (key) {
                case "permissions": {
                    this.mPermissionManager.restoreRuntimePermissions(payload, this.mUser);
                    break;
                }
                default: {
                    Slog.w(TAG, "Unexpected restore key " + key);
                    break;
                }
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "Unable to restore key " + key);
        }
    }
}

