/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.backup.BlobBackupHelper;
import android.app.slice.ISliceManager;
import android.content.Context;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Slog;

public class SliceBackupHelper
extends BlobBackupHelper {
    static final String TAG = "SliceBackupHelper";
    static final boolean DEBUG = Log.isLoggable("SliceBackupHelper", 3);
    static final int BLOB_VERSION = 1;
    static final String KEY_SLICES = "slices";

    public SliceBackupHelper(Context context) {
        super(1, KEY_SLICES);
    }

    @Override
    protected byte[] getBackupPayload(String key) {
        byte[] newPayload = null;
        if (KEY_SLICES.equals(key)) {
            try {
                ISliceManager sm = ISliceManager.Stub.asInterface(ServiceManager.getService("slice"));
                newPayload = sm.getBackupPayload(0);
            }
            catch (Exception e) {
                Slog.e(TAG, "Couldn't communicate with slice manager");
                newPayload = null;
            }
        }
        return newPayload;
    }

    @Override
    protected void applyRestoredPayload(String key, byte[] payload) {
        if (DEBUG) {
            Slog.v(TAG, "Got restore of " + key);
        }
        if (KEY_SLICES.equals(key)) {
            try {
                ISliceManager sm = ISliceManager.Stub.asInterface(ServiceManager.getService("slice"));
                sm.applyRestore(payload, 0);
            }
            catch (Exception e) {
                Slog.e(TAG, "Couldn't communicate with slice manager");
            }
        }
    }
}

