/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.backup.IBackupManager;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IBackupObserver;
import android.app.backup.IFullBackupRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.ISelectBackupTransportCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.DumpUtils;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.FullBackupJob;
import com.android.server.backup.UserBackupManagerFiles;
import com.android.server.backup.utils.RandomAccessFileUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;

public class Trampoline
extends IBackupManager.Stub {
    private static final String BACKUP_SUPPRESS_FILENAME = "backup-suppress";
    private static final String BACKUP_ACTIVATED_FILENAME = "backup-activated";
    private static final String REMEMBER_ACTIVATED_FILENAME = "backup-remember-activated";
    private static final String BACKUP_DISABLE_PROPERTY = "ro.backup.disable";
    private static final String BACKUP_THREAD = "backup";
    private final Context mContext;
    private final UserManager mUserManager;
    private final boolean mGlobalDisable;
    private final Object mStateLock = new Object();
    private volatile BackupManagerService mService;
    private HandlerThread mHandlerThread;
    private Handler mHandler;

    public Trampoline(Context context) {
        this.mContext = context;
        this.mGlobalDisable = this.isBackupDisabled();
        this.mHandlerThread = new HandlerThread(BACKUP_THREAD, 10);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mUserManager = UserManager.get(context);
    }

    protected boolean isBackupDisabled() {
        return SystemProperties.getBoolean(BACKUP_DISABLE_PROPERTY, false);
    }

    protected int binderGetCallingUserId() {
        return Binder.getCallingUserHandle().getIdentifier();
    }

    protected int binderGetCallingUid() {
        return Binder.getCallingUid();
    }

    protected File getSuppressFileForSystemUser() {
        return new File(UserBackupManagerFiles.getBaseStateDir(0), BACKUP_SUPPRESS_FILENAME);
    }

    protected File getRememberActivatedFileForNonSystemUser(int userId) {
        return UserBackupManagerFiles.getStateFileInSystemDir(REMEMBER_ACTIVATED_FILENAME, userId);
    }

    protected File getActivatedFileForNonSystemUser(int userId) {
        return UserBackupManagerFiles.getStateFileInSystemDir(BACKUP_ACTIVATED_FILENAME, userId);
    }

    private void createFile(File file) throws IOException {
        if (file.exists()) {
            return;
        }
        file.getParentFile().mkdirs();
        if (!file.createNewFile()) {
            Slog.w("BackupManagerService", "Failed to create file " + file.getPath());
        }
    }

    private void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (!file.delete()) {
            Slog.w("BackupManagerService", "Failed to delete file " + file.getPath());
        }
    }

    @GuardedBy(value={"mStateLock"})
    private void deactivateBackupForUserLocked(int userId) throws IOException {
        if (userId == 0) {
            this.createFile(this.getSuppressFileForSystemUser());
        } else {
            this.deleteFile(this.getActivatedFileForNonSystemUser(userId));
        }
    }

    @GuardedBy(value={"mStateLock"})
    private void activateBackupForUserLocked(int userId) throws IOException {
        if (userId == 0) {
            this.deleteFile(this.getSuppressFileForSystemUser());
        } else {
            this.createFile(this.getActivatedFileForNonSystemUser(userId));
        }
    }

    private boolean isUserReadyForBackup(int userId) {
        return this.mService != null && this.mService.getServiceUsers().get(userId) != null && this.isBackupActivatedForUser(userId);
    }

    private boolean isBackupActivatedForUser(int userId) {
        if (this.getSuppressFileForSystemUser().exists()) {
            return false;
        }
        return userId == 0 || this.getActivatedFileForNonSystemUser(userId).exists();
    }

    protected Context getContext() {
        return this.mContext;
    }

    protected UserManager getUserManager() {
        return this.mUserManager;
    }

    protected BackupManagerService createBackupManagerService() {
        return new BackupManagerService(this.mContext, this, this.mHandlerThread);
    }

    protected void postToHandler(Runnable runnable) {
        this.mHandler.post(runnable);
    }

    void initializeService() {
        this.postToHandler(() -> {
            Trace.traceBegin(64L, "backup init");
            if (this.mGlobalDisable) {
                Slog.i("BackupManagerService", "Backup service not supported");
                return;
            }
            Object object = this.mStateLock;
            synchronized (object) {
                if (this.mService == null) {
                    this.mService = this.createBackupManagerService();
                }
            }
            Trace.traceEnd(64L);
        });
    }

    void unlockUser(int userId) {
        this.postToHandler(() -> this.startServiceForUser(userId));
    }

    private void startServiceForUser(int userId) {
        if (this.mService != null && this.isBackupActivatedForUser(userId)) {
            Slog.i("BackupManagerService", "Starting service for user: " + userId);
            this.mService.startServiceForUser(userId);
        }
    }

    void stopUser(int userId) {
        this.postToHandler(() -> {
            if (this.mService != null) {
                Slog.i("BackupManagerService", "Stopping service for user: " + userId);
                this.mService.stopServiceForUser(userId);
            }
        });
    }

    private void enforcePermissionsOnUser(int userId) throws SecurityException {
        boolean isRestrictedUser;
        boolean bl = isRestrictedUser = userId == 0 || this.getUserManager().getUserInfo(userId).isManagedProfile();
        if (isRestrictedUser) {
            int caller = this.binderGetCallingUid();
            if (caller != 1000 && caller != 0) {
                throw new SecurityException("No permission to configure backup activity");
            }
        } else {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "No permission to configure backup activity");
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "No permission to configure backup activity");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackupServiceActive(int userId, boolean makeActive) {
        this.enforcePermissionsOnUser(userId);
        if (userId != 0) {
            try {
                File rememberFile = this.getRememberActivatedFileForNonSystemUser(userId);
                this.createFile(rememberFile);
                RandomAccessFileUtils.writeBoolean(rememberFile, makeActive);
            }
            catch (IOException e) {
                Slog.e("BackupManagerService", "Unable to persist backup service activity", e);
            }
        }
        if (this.mGlobalDisable) {
            Slog.i("BackupManagerService", "Backup service not supported");
            return;
        }
        Object object = this.mStateLock;
        synchronized (object) {
            Slog.i("BackupManagerService", "Making backup " + (makeActive ? "" : "in") + "active");
            if (makeActive) {
                if (this.mService == null) {
                    this.mService = this.createBackupManagerService();
                }
                try {
                    this.activateBackupForUserLocked(userId);
                }
                catch (IOException e) {
                    Slog.e("BackupManagerService", "Unable to persist backup service activity");
                }
                if (this.getUserManager().isUserUnlocked(userId)) {
                    long oldId = Binder.clearCallingIdentity();
                    try {
                        this.startServiceForUser(userId);
                    }
                    finally {
                        Binder.restoreCallingIdentity(oldId);
                    }
                }
            } else {
                try {
                    this.deactivateBackupForUserLocked(userId);
                }
                catch (IOException e) {
                    Slog.e("BackupManagerService", "Unable to persist backup service inactivity");
                }
                this.stopUser(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBackupServiceActive(int userId) {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mService != null && this.isBackupActivatedForUser(userId);
        }
    }

    @Override
    public void dataChangedForUser(int userId, String packageName) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.dataChanged(userId, packageName);
        }
    }

    @Override
    public void dataChanged(String packageName) throws RemoteException {
        this.dataChangedForUser(this.binderGetCallingUserId(), packageName);
    }

    @Override
    public void initializeTransportsForUser(int userId, String[] transportNames, IBackupObserver observer) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.initializeTransports(userId, transportNames, observer);
        }
    }

    @Override
    public void clearBackupDataForUser(int userId, String transportName, String packageName) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.clearBackupData(userId, transportName, packageName);
        }
    }

    @Override
    public void clearBackupData(String transportName, String packageName) throws RemoteException {
        this.clearBackupDataForUser(this.binderGetCallingUserId(), transportName, packageName);
    }

    @Override
    public void agentConnectedForUser(int userId, String packageName, IBinder agent) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.agentConnected(userId, packageName, agent);
        }
    }

    @Override
    public void agentConnected(String packageName, IBinder agent) throws RemoteException {
        this.agentConnectedForUser(this.binderGetCallingUserId(), packageName, agent);
    }

    @Override
    public void agentDisconnectedForUser(int userId, String packageName) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.agentDisconnected(userId, packageName);
        }
    }

    @Override
    public void agentDisconnected(String packageName) throws RemoteException {
        this.agentDisconnectedForUser(this.binderGetCallingUserId(), packageName);
    }

    @Override
    public void restoreAtInstallForUser(int userId, String packageName, int token) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.restoreAtInstall(userId, packageName, token);
        }
    }

    @Override
    public void restoreAtInstall(String packageName, int token) throws RemoteException {
        this.restoreAtInstallForUser(this.binderGetCallingUserId(), packageName, token);
    }

    @Override
    public void setBackupEnabledForUser(int userId, boolean isEnabled) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.setBackupEnabled(userId, isEnabled);
        }
    }

    @Override
    public void setBackupEnabled(boolean isEnabled) throws RemoteException {
        this.setBackupEnabledForUser(this.binderGetCallingUserId(), isEnabled);
    }

    @Override
    public void setAutoRestoreForUser(int userId, boolean doAutoRestore) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.setAutoRestore(userId, doAutoRestore);
        }
    }

    @Override
    public void setAutoRestore(boolean doAutoRestore) throws RemoteException {
        this.setAutoRestoreForUser(this.binderGetCallingUserId(), doAutoRestore);
    }

    @Override
    public boolean isBackupEnabledForUser(int userId) throws RemoteException {
        return this.isUserReadyForBackup(userId) && this.mService.isBackupEnabled(userId);
    }

    @Override
    public boolean isBackupEnabled() throws RemoteException {
        return this.isBackupEnabledForUser(this.binderGetCallingUserId());
    }

    @Override
    public boolean setBackupPassword(String currentPw, String newPw) throws RemoteException {
        int userId = this.binderGetCallingUserId();
        return this.isUserReadyForBackup(userId) && this.mService.setBackupPassword(currentPw, newPw);
    }

    @Override
    public boolean hasBackupPassword() throws RemoteException {
        int userId = this.binderGetCallingUserId();
        return this.isUserReadyForBackup(userId) && this.mService.hasBackupPassword();
    }

    @Override
    public void backupNowForUser(int userId) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.backupNow(userId);
        }
    }

    @Override
    public void backupNow() throws RemoteException {
        this.backupNowForUser(this.binderGetCallingUserId());
    }

    @Override
    public void adbBackup(int userId, ParcelFileDescriptor fd, boolean includeApks, boolean includeObbs, boolean includeShared, boolean doWidgets, boolean allApps, boolean allIncludesSystem, boolean doCompress, boolean doKeyValue, String[] packageNames) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.adbBackup(userId, fd, includeApks, includeObbs, includeShared, doWidgets, allApps, allIncludesSystem, doCompress, doKeyValue, packageNames);
        }
    }

    @Override
    public void fullTransportBackupForUser(int userId, String[] packageNames) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.fullTransportBackup(userId, packageNames);
        }
    }

    @Override
    public void adbRestore(int userId, ParcelFileDescriptor fd) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.adbRestore(userId, fd);
        }
    }

    @Override
    public void acknowledgeFullBackupOrRestoreForUser(int userId, int token, boolean allow, String curPassword, String encryptionPassword, IFullBackupRestoreObserver observer) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.acknowledgeAdbBackupOrRestore(userId, token, allow, curPassword, encryptionPassword, observer);
        }
    }

    @Override
    public void acknowledgeFullBackupOrRestore(int token, boolean allow, String curPassword, String encryptionPassword, IFullBackupRestoreObserver observer) throws RemoteException {
        this.acknowledgeFullBackupOrRestoreForUser(this.binderGetCallingUserId(), token, allow, curPassword, encryptionPassword, observer);
    }

    @Override
    public String getCurrentTransportForUser(int userId) throws RemoteException {
        return this.isUserReadyForBackup(userId) ? this.mService.getCurrentTransport(userId) : null;
    }

    @Override
    public String getCurrentTransport() throws RemoteException {
        return this.getCurrentTransportForUser(this.binderGetCallingUserId());
    }

    @Override
    public ComponentName getCurrentTransportComponentForUser(int userId) {
        return this.isUserReadyForBackup(userId) ? this.mService.getCurrentTransportComponent(userId) : null;
    }

    @Override
    public String[] listAllTransportsForUser(int userId) throws RemoteException {
        return this.isUserReadyForBackup(userId) ? this.mService.listAllTransports(userId) : null;
    }

    @Override
    public String[] listAllTransports() throws RemoteException {
        return this.listAllTransportsForUser(this.binderGetCallingUserId());
    }

    @Override
    public ComponentName[] listAllTransportComponentsForUser(int userId) throws RemoteException {
        return this.isUserReadyForBackup(userId) ? this.mService.listAllTransportComponents(userId) : null;
    }

    @Override
    public String[] getTransportWhitelist() {
        int userId = this.binderGetCallingUserId();
        return this.isUserReadyForBackup(userId) ? this.mService.getTransportWhitelist() : null;
    }

    @Override
    public void updateTransportAttributesForUser(int userId, ComponentName transportComponent, String name, Intent configurationIntent, String currentDestinationString, Intent dataManagementIntent, CharSequence dataManagementLabel) {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.updateTransportAttributes(userId, transportComponent, name, configurationIntent, currentDestinationString, dataManagementIntent, dataManagementLabel);
        }
    }

    @Override
    public String selectBackupTransportForUser(int userId, String transport) throws RemoteException {
        return this.isUserReadyForBackup(userId) ? this.mService.selectBackupTransport(userId, transport) : null;
    }

    @Override
    public String selectBackupTransport(String transport) throws RemoteException {
        return this.selectBackupTransportForUser(this.binderGetCallingUserId(), transport);
    }

    @Override
    public void selectBackupTransportAsyncForUser(int userId, ComponentName transport, ISelectBackupTransportCallback listener) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.selectBackupTransportAsync(userId, transport, listener);
        } else if (listener != null) {
            try {
                listener.onFailure(-2001);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public Intent getConfigurationIntentForUser(int userId, String transport) throws RemoteException {
        return this.isUserReadyForBackup(userId) ? this.mService.getConfigurationIntent(userId, transport) : null;
    }

    @Override
    public Intent getConfigurationIntent(String transport) throws RemoteException {
        return this.getConfigurationIntentForUser(this.binderGetCallingUserId(), transport);
    }

    @Override
    public String getDestinationStringForUser(int userId, String transport) throws RemoteException {
        return this.isUserReadyForBackup(userId) ? this.mService.getDestinationString(userId, transport) : null;
    }

    @Override
    public String getDestinationString(String transport) throws RemoteException {
        return this.getDestinationStringForUser(this.binderGetCallingUserId(), transport);
    }

    @Override
    public Intent getDataManagementIntentForUser(int userId, String transport) throws RemoteException {
        return this.isUserReadyForBackup(userId) ? this.mService.getDataManagementIntent(userId, transport) : null;
    }

    @Override
    public Intent getDataManagementIntent(String transport) throws RemoteException {
        return this.getDataManagementIntentForUser(this.binderGetCallingUserId(), transport);
    }

    @Override
    public CharSequence getDataManagementLabelForUser(int userId, String transport) throws RemoteException {
        return this.isUserReadyForBackup(userId) ? this.mService.getDataManagementLabel(userId, transport) : null;
    }

    @Override
    public IRestoreSession beginRestoreSessionForUser(int userId, String packageName, String transportID) throws RemoteException {
        return this.isUserReadyForBackup(userId) ? this.mService.beginRestoreSession(userId, packageName, transportID) : null;
    }

    @Override
    public void opCompleteForUser(int userId, int token, long result) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.opComplete(userId, token, result);
        }
    }

    @Override
    public void opComplete(int token, long result) throws RemoteException {
        this.opCompleteForUser(this.binderGetCallingUserId(), token, result);
    }

    @Override
    public long getAvailableRestoreTokenForUser(int userId, String packageName) {
        return this.isUserReadyForBackup(userId) ? this.mService.getAvailableRestoreToken(userId, packageName) : 0L;
    }

    @Override
    public boolean isAppEligibleForBackupForUser(int userId, String packageName) {
        return this.isUserReadyForBackup(userId) && this.mService.isAppEligibleForBackup(userId, packageName);
    }

    @Override
    public String[] filterAppsEligibleForBackupForUser(int userId, String[] packages) {
        return this.isUserReadyForBackup(userId) ? this.mService.filterAppsEligibleForBackup(userId, packages) : null;
    }

    @Override
    public int requestBackupForUser(int userId, String[] packages, IBackupObserver observer, IBackupManagerMonitor monitor, int flags) throws RemoteException {
        if (!this.isUserReadyForBackup(userId)) {
            return -2001;
        }
        return this.mService.requestBackup(userId, packages, observer, monitor, flags);
    }

    @Override
    public int requestBackup(String[] packages, IBackupObserver observer, IBackupManagerMonitor monitor, int flags) throws RemoteException {
        return this.requestBackupForUser(this.binderGetCallingUserId(), packages, observer, monitor, flags);
    }

    @Override
    public void cancelBackupsForUser(int userId) throws RemoteException {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.cancelBackups(userId);
        }
    }

    @Override
    public void cancelBackups() throws RemoteException {
        this.cancelBackupsForUser(this.binderGetCallingUserId());
    }

    @Override
    public UserHandle getUserForAncestralSerialNumber(long ancestralSerialNumber) {
        if (this.mService != null) {
            return this.mService.getUserForAncestralSerialNumber(ancestralSerialNumber);
        }
        return null;
    }

    @Override
    public void setAncestralSerialNumber(long ancestralSerialNumber) {
        if (this.mService != null) {
            this.mService.setAncestralSerialNumber(ancestralSerialNumber);
        }
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, "BackupManagerService", pw)) {
            return;
        }
        int userId = this.binderGetCallingUserId();
        if (this.isUserReadyForBackup(userId)) {
            this.mService.dump(fd, pw, args);
        } else {
            pw.println("Inactive");
        }
    }

    boolean beginFullBackup(int userId, FullBackupJob scheduledJob) {
        return this.isUserReadyForBackup(userId) && this.mService.beginFullBackup(userId, scheduledJob);
    }

    void endFullBackup(int userId) {
        if (this.isUserReadyForBackup(userId)) {
            this.mService.endFullBackup(userId);
        }
    }
}

