/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.util.Slog;
import com.android.server.backup.UserBackupManagerFiles;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

final class UserBackupManagerFilePersistedSettings {
    private static final String BACKUP_ENABLE_FILE = "backup_enabled";

    UserBackupManagerFilePersistedSettings() {
    }

    static boolean readBackupEnableState(int userId) {
        return UserBackupManagerFilePersistedSettings.readBackupEnableState(UserBackupManagerFiles.getBaseStateDir(userId));
    }

    static void writeBackupEnableState(int userId, boolean enable) {
        UserBackupManagerFilePersistedSettings.writeBackupEnableState(UserBackupManagerFiles.getBaseStateDir(userId), enable);
    }

    private static boolean readBackupEnableState(File baseDir) {
        File enableFile = new File(baseDir, BACKUP_ENABLE_FILE);
        if (enableFile.exists()) {
            boolean bl;
            FileInputStream fin = new FileInputStream(enableFile);
            Throwable throwable = null;
            try {
                int state = fin.read();
                bl = state != 0;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        UserBackupManagerFilePersistedSettings.$closeResource(throwable, fin);
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    Slog.e("BackupManagerService", "Cannot read enable state; assuming disabled");
                }
            }
            UserBackupManagerFilePersistedSettings.$closeResource(throwable, fin);
            return bl;
        } else {
            Slog.i("BackupManagerService", "isBackupEnabled() => false due to absent settings file");
        }
        return false;
    }

    private static void writeBackupEnableState(File baseDir, boolean enable) {
        File enableFile = new File(baseDir, BACKUP_ENABLE_FILE);
        File stage = new File(baseDir, "backup_enabled-stage");
        try (FileOutputStream fout = new FileOutputStream(stage);){
            fout.write(enable ? 1 : 0);
            fout.close();
            stage.renameTo(enableFile);
        }
        catch (IOException | RuntimeException e) {
            Slog.e("BackupManagerService", "Unable to record backup enable state; reverting to disabled: " + e.getMessage());
            enableFile.delete();
            stage.delete();
        }
    }
}

