/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.os.Environment;
import java.io.File;

final class UserBackupManagerFiles {
    private static final String BACKUP_PERSISTENT_DIR = "backup";
    private static final String BACKUP_STAGING_DIR = "backup_stage";

    UserBackupManagerFiles() {
    }

    private static File getBaseDir(int userId) {
        return Environment.getDataSystemCeDirectory(userId);
    }

    static File getBaseStateDir(int userId) {
        if (userId != 0) {
            return new File(UserBackupManagerFiles.getBaseDir(userId), BACKUP_PERSISTENT_DIR);
        }
        return new File(Environment.getDataDirectory(), BACKUP_PERSISTENT_DIR);
    }

    static File getDataDir(int userId) {
        if (userId != 0) {
            return new File(UserBackupManagerFiles.getBaseDir(userId), BACKUP_STAGING_DIR);
        }
        return new File(Environment.getDownloadCacheDirectory(), BACKUP_STAGING_DIR);
    }

    static File getStateDirInSystemDir(int userId) {
        return new File(UserBackupManagerFiles.getBaseStateDir(0), "" + userId);
    }

    static File getStateFileInSystemDir(String filename, int userId) {
        return new File(UserBackupManagerFiles.getStateDirInSystemDir(userId), filename);
    }
}

