/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.IBackupAgent;
import android.app.PendingIntent;
import android.app.backup.BackupAgent;
import android.app.backup.IBackupManager;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IBackupObserver;
import android.app.backup.IFullBackupRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.ISelectBackupTransportCallback;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.PowerSaveState;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.os.storage.IStorageManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.EventLog;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.backup.IBackupTransport;
import com.android.internal.util.Preconditions;
import com.android.server.AppWidgetBackupBridge;
import com.android.server.LocalServices;
import com.android.server.backup.BackupAgentTimeoutParameters;
import com.android.server.backup.BackupManagerConstants;
import com.android.server.backup.BackupPasswordManager;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.DataChangedJournal;
import com.android.server.backup.FullBackupJob;
import com.android.server.backup.KeyValueBackupJob;
import com.android.server.backup.PackageManagerBackupAgent;
import com.android.server.backup.ProcessedPackagesJournal;
import com.android.server.backup.Trampoline;
import com.android.server.backup.TransportManager;
import com.android.server.backup.UserBackupManagerFilePersistedSettings;
import com.android.server.backup.UserBackupManagerFiles;
import com.android.server.backup.fullbackup.FullBackupEntry;
import com.android.server.backup.fullbackup.PerformFullTransportBackupTask;
import com.android.server.backup.internal.BackupHandler;
import com.android.server.backup.internal.ClearDataObserver;
import com.android.server.backup.internal.OnTaskFinishedListener;
import com.android.server.backup.internal.Operation;
import com.android.server.backup.internal.PerformInitializeTask;
import com.android.server.backup.internal.RunBackupReceiver;
import com.android.server.backup.internal.RunInitializeReceiver;
import com.android.server.backup.internal.SetupObserver;
import com.android.server.backup.keyvalue.BackupRequest;
import com.android.server.backup.params.AdbBackupParams;
import com.android.server.backup.params.AdbParams;
import com.android.server.backup.params.AdbRestoreParams;
import com.android.server.backup.params.BackupParams;
import com.android.server.backup.params.ClearParams;
import com.android.server.backup.params.ClearRetryParams;
import com.android.server.backup.params.RestoreParams;
import com.android.server.backup.restore.ActiveRestoreSession;
import com.android.server.backup.restore.PerformUnifiedRestoreTask;
import com.android.server.backup.transport.TransportClient;
import com.android.server.backup.transport.TransportNotRegisteredException;
import com.android.server.backup.utils.AppBackupUtils;
import com.android.server.backup.utils.BackupManagerMonitorUtils;
import com.android.server.backup.utils.BackupObserverUtils;
import com.android.server.backup.utils.FileUtils;
import com.android.server.backup.utils.SparseArrayUtils;
import com.google.android.collect.Sets;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class UserBackupManagerService {
    private static final String INIT_SENTINEL_FILE_NAME = "_need_init_";
    public static final String KEY_WIDGET_STATE = "\uffed\uffedwidget";
    public static final String BACKUP_MANIFEST_FILENAME = "_manifest";
    public static final int BACKUP_MANIFEST_VERSION = 1;
    public static final int BACKUP_FILE_VERSION = 5;
    public static final String BACKUP_FILE_HEADER_MAGIC = "ANDROID BACKUP\n";
    public static final String BACKUP_METADATA_FILENAME = "_meta";
    public static final int BACKUP_METADATA_VERSION = 1;
    public static final int BACKUP_WIDGET_METADATA_TOKEN = 33549569;
    private static final int CURRENT_ANCESTRAL_RECORD_VERSION = 1;
    private static final int SCHEDULE_FILE_VERSION = 1;
    public static final String SETTINGS_PACKAGE = "com.android.providers.settings";
    public static final String SHARED_BACKUP_AGENT_PACKAGE = "com.android.sharedstoragebackup";
    public static final String PACKAGE_MANAGER_SENTINEL = "@pm@";
    private static final long TRANSPORT_RETRY_INTERVAL = 3600000L;
    public static final String RUN_BACKUP_ACTION = "android.app.backup.intent.RUN";
    public static final String RUN_INITIALIZE_ACTION = "android.app.backup.intent.INIT";
    private static final String BACKUP_FINISHED_ACTION = "android.intent.action.BACKUP_FINISHED";
    private static final String BACKUP_FINISHED_PACKAGE_EXTRA = "packageName";
    public static final int OP_PENDING = 0;
    private static final int OP_ACKNOWLEDGED = 1;
    private static final int OP_TIMEOUT = -1;
    public static final int OP_TYPE_BACKUP_WAIT = 0;
    public static final int OP_TYPE_RESTORE_WAIT = 1;
    public static final int OP_TYPE_BACKUP = 2;
    private static final long INITIALIZATION_DELAY_MILLIS = 3000L;
    private static final long BIND_TIMEOUT_INTERVAL = 10000L;
    private static final long CLEAR_DATA_TIMEOUT_INTERVAL = 30000L;
    private static final long TIMEOUT_FULL_CONFIRMATION = 60000L;
    private static final long BUSY_BACKOFF_MIN_MILLIS = 3600000L;
    private static final int BUSY_BACKOFF_FUZZ = 0x6DDD00;
    private static final String SERIAL_ID_FILE = "serial_id";
    private final int mUserId;
    private final BackupAgentTimeoutParameters mAgentTimeoutParameters;
    private final TransportManager mTransportManager;
    private final HandlerThread mUserBackupThread;
    private final Context mContext;
    private final PackageManager mPackageManager;
    private final IPackageManager mPackageManagerBinder;
    private final IActivityManager mActivityManager;
    private final ActivityManagerInternal mActivityManagerInternal;
    private PowerManager mPowerManager;
    private final AlarmManager mAlarmManager;
    private final IStorageManager mStorageManager;
    private final BackupManagerConstants mConstants;
    private final PowerManager.WakeLock mWakelock;
    private final BackupHandler mBackupHandler;
    private final IBackupManager mBackupManagerBinder;
    private boolean mEnabled;
    private boolean mSetupComplete;
    private boolean mAutoRestore;
    private final PendingIntent mRunBackupIntent;
    private final PendingIntent mRunInitIntent;
    private final ArraySet<String> mPendingInits = new ArraySet();
    private final SparseArray<HashSet<String>> mBackupParticipants = new SparseArray();
    private final HashMap<String, BackupRequest> mPendingBackups = new HashMap();
    private final Object mQueueLock = new Object();
    private final Object mAgentConnectLock = new Object();
    private IBackupAgent mConnectedAgent;
    private volatile boolean mConnecting;
    private volatile boolean mBackupRunning;
    private volatile long mLastBackupPass;
    private final Object mClearDataLock = new Object();
    private volatile boolean mClearingData;
    private final BackupPasswordManager mBackupPasswordManager;
    private final SparseArray<AdbParams> mAdbBackupRestoreConfirmations = new SparseArray();
    private final SecureRandom mRng = new SecureRandom();
    private final long mRegisterTransportsRequestedTime;
    @GuardedBy(value={"mQueueLock"})
    private PerformFullTransportBackupTask mRunningFullBackupTask;
    @GuardedBy(value={"mQueueLock"})
    private ArrayList<FullBackupEntry> mFullBackupQueue;
    @GuardedBy(value={"mPendingRestores"})
    private boolean mIsRestoreInProgress;
    @GuardedBy(value={"mPendingRestores"})
    private final Queue<PerformUnifiedRestoreTask> mPendingRestores = new ArrayDeque<PerformUnifiedRestoreTask>();
    private ActiveRestoreSession mActiveRestoreSession;
    @GuardedBy(value={"mCurrentOpLock"})
    private final SparseArray<Operation> mCurrentOperations = new SparseArray();
    private final Object mCurrentOpLock = new Object();
    private final Random mTokenGenerator = new Random();
    private final AtomicInteger mNextToken = new AtomicInteger();
    private final File mBaseStateDir;
    private final File mDataDir;
    private final File mJournalDir;
    private DataChangedJournal mJournal;
    private final File mFullBackupScheduleFile;
    private ProcessedPackagesJournal mProcessedPackagesJournal;
    private File mTokenFile;
    private Set<String> mAncestralPackages = null;
    private long mAncestralToken = 0L;
    private long mCurrentToken = 0L;
    private File mAncestralSerialNumberFile;
    private Runnable mFullBackupScheduleWriter = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = UserBackupManagerService.this.mQueueLock;
            synchronized (object) {
                try {
                    ByteArrayOutputStream bufStream = new ByteArrayOutputStream(4096);
                    DataOutputStream bufOut = new DataOutputStream(bufStream);
                    bufOut.writeInt(1);
                    int numPackages = UserBackupManagerService.this.mFullBackupQueue.size();
                    bufOut.writeInt(numPackages);
                    for (int i = 0; i < numPackages; ++i) {
                        FullBackupEntry entry = (FullBackupEntry)UserBackupManagerService.this.mFullBackupQueue.get(i);
                        bufOut.writeUTF(entry.packageName);
                        bufOut.writeLong(entry.lastBackup);
                    }
                    bufOut.flush();
                    AtomicFile af = new AtomicFile(UserBackupManagerService.this.mFullBackupScheduleFile);
                    FileOutputStream out = af.startWrite();
                    out.write(bufStream.toByteArray());
                    af.finishWrite(out);
                }
                catch (Exception e) {
                    Slog.e("BackupManagerService", "Unable to write backup schedule!", e);
                }
            }
        }
    };
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            boolean replacing = false;
            boolean added = false;
            boolean changed = false;
            Bundle extras = intent.getExtras();
            String[] packageList = null;
            if ("android.intent.action.PACKAGE_ADDED".equals(action) || "android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.PACKAGE_CHANGED".equals(action)) {
                Uri uri = intent.getData();
                if (uri == null) {
                    return;
                }
                String object = uri.getSchemeSpecificPart();
                if (object != null) {
                    packageList = new String[]{object};
                }
                if (changed = "android.intent.action.PACKAGE_CHANGED".equals(action)) {
                    String[] components = intent.getStringArrayExtra("android.intent.extra.changed_component_name_list");
                    UserBackupManagerService.this.mBackupHandler.post(() -> UserBackupManagerService.this.mTransportManager.onPackageChanged(object, components));
                    return;
                }
                added = "android.intent.action.PACKAGE_ADDED".equals(action);
                replacing = extras.getBoolean("android.intent.extra.REPLACING", false);
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(action)) {
                added = true;
                packageList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                added = false;
                packageList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            }
            if (packageList == null || packageList.length == 0) {
                return;
            }
            int uid = extras.getInt("android.intent.extra.UID");
            if (added) {
                SparseArray sparseArray = UserBackupManagerService.this.mBackupParticipants;
                synchronized (sparseArray) {
                    if (replacing) {
                        UserBackupManagerService.this.removePackageParticipantsLocked(packageList, uid);
                    }
                    UserBackupManagerService.this.addPackageParticipantsLocked(packageList);
                }
                long l = System.currentTimeMillis();
                for (String packageName2 : packageList) {
                    try {
                        PackageInfo app = UserBackupManagerService.this.mPackageManager.getPackageInfoAsUser(packageName2, 0, UserBackupManagerService.this.mUserId);
                        if (AppBackupUtils.appGetsFullBackup(app) && AppBackupUtils.appIsEligibleForBackup(app.applicationInfo, UserBackupManagerService.this.mUserId)) {
                            UserBackupManagerService.this.enqueueFullBackup(packageName2, l);
                            UserBackupManagerService.this.scheduleNextFullBackupJob(0L);
                        } else {
                            Object object = UserBackupManagerService.this.mQueueLock;
                            synchronized (object) {
                                UserBackupManagerService.this.dequeueFullBackupLocked(packageName2);
                            }
                            UserBackupManagerService.this.writeFullBackupScheduleAsync();
                        }
                        UserBackupManagerService.this.mBackupHandler.post(() -> UserBackupManagerService.this.mTransportManager.onPackageAdded(packageName2));
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.w("BackupManagerService", "Can't resolve new app " + packageName2);
                    }
                }
                UserBackupManagerService.this.dataChangedImpl(UserBackupManagerService.PACKAGE_MANAGER_SENTINEL);
            } else {
                if (!replacing) {
                    SparseArray sparseArray = UserBackupManagerService.this.mBackupParticipants;
                    synchronized (sparseArray) {
                        UserBackupManagerService.this.removePackageParticipantsLocked(packageList, uid);
                    }
                }
                for (String packageName3 : packageList) {
                    UserBackupManagerService.this.mBackupHandler.post(() -> UserBackupManagerService.this.mTransportManager.onPackageRemoved(packageName3));
                }
            }
        }
    };

    static UserBackupManagerService createAndInitializeService(int userId, Context context, Trampoline trampoline, Set<ComponentName> transportWhitelist) {
        String currentTransport = Settings.Secure.getStringForUser(context.getContentResolver(), "backup_transport", userId);
        if (TextUtils.isEmpty(currentTransport)) {
            currentTransport = null;
        }
        Slog.v("BackupManagerService", "Starting with transport " + currentTransport);
        TransportManager transportManager = new TransportManager(userId, context, transportWhitelist, currentTransport);
        File baseStateDir = UserBackupManagerFiles.getBaseStateDir(userId);
        File dataDir = UserBackupManagerFiles.getDataDir(userId);
        HandlerThread userBackupThread = new HandlerThread("backup-" + userId, 10);
        userBackupThread.start();
        Slog.d("BackupManagerService", "Started thread " + userBackupThread.getName() + " for user " + userId);
        return UserBackupManagerService.createAndInitializeService(userId, context, trampoline, userBackupThread, baseStateDir, dataDir, transportManager);
    }

    @VisibleForTesting
    public static UserBackupManagerService createAndInitializeService(int userId, Context context, Trampoline trampoline, HandlerThread userBackupThread, File baseStateDir, File dataDir, TransportManager transportManager) {
        return new UserBackupManagerService(userId, context, trampoline, userBackupThread, baseStateDir, dataDir, transportManager);
    }

    public static boolean getSetupCompleteSettingForUser(Context context, int userId) {
        return Settings.Secure.getIntForUser(context.getContentResolver(), "user_setup_complete", 0, userId) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserBackupManagerService(int userId, Context context, Trampoline parent, HandlerThread userBackupThread, File baseStateDir, File dataDir, TransportManager transportManager) {
        this.mUserId = userId;
        this.mContext = Preconditions.checkNotNull(context, "context cannot be null");
        this.mPackageManager = context.getPackageManager();
        this.mPackageManagerBinder = AppGlobals.getPackageManager();
        this.mActivityManager = ActivityManager.getService();
        this.mActivityManagerInternal = LocalServices.getService(ActivityManagerInternal.class);
        this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mStorageManager = IStorageManager.Stub.asInterface(ServiceManager.getService("mount"));
        Preconditions.checkNotNull(parent, "trampoline cannot be null");
        this.mBackupManagerBinder = Trampoline.asInterface(parent.asBinder());
        this.mAgentTimeoutParameters = new BackupAgentTimeoutParameters(Handler.getMain(), this.mContext.getContentResolver());
        this.mAgentTimeoutParameters.start();
        Preconditions.checkNotNull(userBackupThread, "userBackupThread cannot be null");
        this.mUserBackupThread = userBackupThread;
        this.mBackupHandler = new BackupHandler(this, userBackupThread.getLooper());
        ContentResolver resolver = context.getContentResolver();
        this.mSetupComplete = UserBackupManagerService.getSetupCompleteSettingForUser(context, userId);
        this.mAutoRestore = Settings.Secure.getIntForUser(resolver, "backup_auto_restore", 1, userId) != 0;
        SetupObserver setupObserver = new SetupObserver(this, this.mBackupHandler);
        resolver.registerContentObserver(Settings.Secure.getUriFor("user_setup_complete"), false, setupObserver, this.mUserId);
        this.mBaseStateDir = Preconditions.checkNotNull(baseStateDir, "baseStateDir cannot be null");
        if (userId == 0) {
            this.mBaseStateDir.mkdirs();
            if (!SELinux.restorecon(this.mBaseStateDir)) {
                Slog.w("BackupManagerService", "SELinux restorecon failed on " + this.mBaseStateDir);
            }
        }
        this.mDataDir = Preconditions.checkNotNull(dataDir, "dataDir cannot be null");
        this.mBackupPasswordManager = new BackupPasswordManager(this.mContext, this.mBaseStateDir, this.mRng);
        RunBackupReceiver runBackupReceiver = new RunBackupReceiver(this);
        IntentFilter filter = new IntentFilter();
        filter.addAction(RUN_BACKUP_ACTION);
        context.registerReceiverAsUser(runBackupReceiver, UserHandle.of(userId), filter, "android.permission.BACKUP", null);
        RunInitializeReceiver runInitReceiver = new RunInitializeReceiver(this);
        filter = new IntentFilter();
        filter.addAction(RUN_INITIALIZE_ACTION);
        context.registerReceiverAsUser(runInitReceiver, UserHandle.of(userId), filter, "android.permission.BACKUP", null);
        Intent backupIntent = new Intent(RUN_BACKUP_ACTION);
        backupIntent.addFlags(0x40000000);
        this.mRunBackupIntent = PendingIntent.getBroadcastAsUser(context, 0, backupIntent, 0, UserHandle.of(userId));
        Intent initIntent = new Intent(RUN_INITIALIZE_ACTION);
        initIntent.addFlags(0x40000000);
        this.mRunInitIntent = PendingIntent.getBroadcastAsUser(context, 0, initIntent, 0, UserHandle.of(userId));
        this.mJournalDir = new File(this.mBaseStateDir, "pending");
        this.mJournalDir.mkdirs();
        this.mJournal = null;
        this.mConstants = new BackupManagerConstants(this.mBackupHandler, this.mContext.getContentResolver());
        this.mConstants.start();
        SparseArray<HashSet<String>> sparseArray = this.mBackupParticipants;
        synchronized (sparseArray) {
            this.addPackageParticipantsLocked(null);
        }
        this.mTransportManager = Preconditions.checkNotNull(transportManager, "transportManager cannot be null");
        this.mTransportManager.setOnTransportRegisteredListener(this::onTransportRegistered);
        this.mRegisterTransportsRequestedTime = SystemClock.elapsedRealtime();
        this.mBackupHandler.postDelayed(this.mTransportManager::registerTransports, 3000L);
        this.mBackupHandler.postDelayed(this::parseLeftoverJournals, 3000L);
        this.mWakelock = this.mPowerManager.newWakeLock(1, "*backup*-" + userId);
        this.mFullBackupScheduleFile = new File(this.mBaseStateDir, "fb-schedule");
        this.initPackageTracking();
    }

    void initializeBackupEnableState() {
        boolean isEnabled = UserBackupManagerFilePersistedSettings.readBackupEnableState(this.mUserId);
        this.setBackupEnabled(isEnabled);
    }

    void tearDownService() {
        this.mUserBackupThread.quit();
    }

    public int getUserId() {
        return this.mUserId;
    }

    public BackupManagerConstants getConstants() {
        return this.mConstants;
    }

    public BackupAgentTimeoutParameters getAgentTimeoutParameters() {
        return this.mAgentTimeoutParameters;
    }

    public Context getContext() {
        return this.mContext;
    }

    public PackageManager getPackageManager() {
        return this.mPackageManager;
    }

    public IPackageManager getPackageManagerBinder() {
        return this.mPackageManagerBinder;
    }

    public IActivityManager getActivityManager() {
        return this.mActivityManager;
    }

    public AlarmManager getAlarmManager() {
        return this.mAlarmManager;
    }

    @VisibleForTesting
    void setPowerManager(PowerManager powerManager) {
        this.mPowerManager = powerManager;
    }

    public TransportManager getTransportManager() {
        return this.mTransportManager;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public boolean isSetupComplete() {
        return this.mSetupComplete;
    }

    public void setSetupComplete(boolean setupComplete) {
        this.mSetupComplete = setupComplete;
    }

    public PowerManager.WakeLock getWakelock() {
        return this.mWakelock;
    }

    @VisibleForTesting
    public void setWorkSource(WorkSource workSource) {
        this.mWakelock.setWorkSource(workSource);
    }

    public Handler getBackupHandler() {
        return this.mBackupHandler;
    }

    public PendingIntent getRunInitIntent() {
        return this.mRunInitIntent;
    }

    public HashMap<String, BackupRequest> getPendingBackups() {
        return this.mPendingBackups;
    }

    public Object getQueueLock() {
        return this.mQueueLock;
    }

    public boolean isBackupRunning() {
        return this.mBackupRunning;
    }

    public void setBackupRunning(boolean backupRunning) {
        this.mBackupRunning = backupRunning;
    }

    public void setLastBackupPass(long lastBackupPass) {
        this.mLastBackupPass = lastBackupPass;
    }

    public Object getClearDataLock() {
        return this.mClearDataLock;
    }

    public void setClearingData(boolean clearingData) {
        this.mClearingData = clearingData;
    }

    public boolean isRestoreInProgress() {
        return this.mIsRestoreInProgress;
    }

    public void setRestoreInProgress(boolean restoreInProgress) {
        this.mIsRestoreInProgress = restoreInProgress;
    }

    public Queue<PerformUnifiedRestoreTask> getPendingRestores() {
        return this.mPendingRestores;
    }

    public ActiveRestoreSession getActiveRestoreSession() {
        return this.mActiveRestoreSession;
    }

    public SparseArray<Operation> getCurrentOperations() {
        return this.mCurrentOperations;
    }

    public Object getCurrentOpLock() {
        return this.mCurrentOpLock;
    }

    public SparseArray<AdbParams> getAdbBackupRestoreConfirmations() {
        return this.mAdbBackupRestoreConfirmations;
    }

    public File getBaseStateDir() {
        return this.mBaseStateDir;
    }

    public File getDataDir() {
        return this.mDataDir;
    }

    @VisibleForTesting
    BroadcastReceiver getPackageTrackingReceiver() {
        return this.mBroadcastReceiver;
    }

    public DataChangedJournal getJournal() {
        return this.mJournal;
    }

    public void setJournal(DataChangedJournal journal) {
        this.mJournal = journal;
    }

    public SecureRandom getRng() {
        return this.mRng;
    }

    public void setAncestralPackages(Set<String> ancestralPackages) {
        this.mAncestralPackages = ancestralPackages;
    }

    public void setAncestralToken(long ancestralToken) {
        this.mAncestralToken = ancestralToken;
    }

    public long getCurrentToken() {
        return this.mCurrentToken;
    }

    public void setCurrentToken(long currentToken) {
        this.mCurrentToken = currentToken;
    }

    public ArraySet<String> getPendingInits() {
        return this.mPendingInits;
    }

    public void clearPendingInits() {
        this.mPendingInits.clear();
    }

    public PerformFullTransportBackupTask getRunningFullBackupTask() {
        return this.mRunningFullBackupTask;
    }

    public void setRunningFullBackupTask(PerformFullTransportBackupTask runningFullBackupTask) {
        this.mRunningFullBackupTask = runningFullBackupTask;
    }

    public int generateRandomIntegerToken() {
        int token = this.mTokenGenerator.nextInt();
        if (token < 0) {
            token = -token;
        }
        token &= 0xFFFFFF00;
        return token |= this.mNextToken.incrementAndGet() & 0xFF;
    }

    public BackupAgent makeMetadataAgent() {
        PackageManagerBackupAgent pmAgent = new PackageManagerBackupAgent(this.mPackageManager, this.mUserId);
        pmAgent.attach(this.mContext);
        pmAgent.onCreate(UserHandle.of(this.mUserId));
        return pmAgent;
    }

    public PackageManagerBackupAgent makeMetadataAgent(List<PackageInfo> packages) {
        PackageManagerBackupAgent pmAgent = new PackageManagerBackupAgent(this.mPackageManager, packages, this.mUserId);
        pmAgent.attach(this.mContext);
        pmAgent.onCreate(UserHandle.of(this.mUserId));
        return pmAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPackageTracking() {
        this.mTokenFile = new File(this.mBaseStateDir, "ancestral");
        try (DataInputStream tokenStream = new DataInputStream(new BufferedInputStream(new FileInputStream(this.mTokenFile)));){
            int version = tokenStream.readInt();
            if (version == 1) {
                this.mAncestralToken = tokenStream.readLong();
                this.mCurrentToken = tokenStream.readLong();
                int numPackages = tokenStream.readInt();
                if (numPackages >= 0) {
                    this.mAncestralPackages = new HashSet<String>();
                    for (int i = 0; i < numPackages; ++i) {
                        String pkgName = tokenStream.readUTF();
                        this.mAncestralPackages.add(pkgName);
                    }
                }
            }
        }
        catch (FileNotFoundException fnf) {
            Slog.v("BackupManagerService", "No ancestral data");
        }
        catch (IOException e) {
            Slog.w("BackupManagerService", "Unable to read token file", e);
        }
        this.mProcessedPackagesJournal = new ProcessedPackagesJournal(this.mBaseStateDir);
        this.mProcessedPackagesJournal.init();
        Object e = this.mQueueLock;
        synchronized (e) {
            this.mFullBackupQueue = this.readFullBackupSchedule();
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.of(this.mUserId), filter, null, null);
        IntentFilter sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.of(this.mUserId), sdFilter, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<FullBackupEntry> readFullBackupSchedule() {
        boolean changed = false;
        ArrayList<FullBackupEntry> schedule = null;
        List<PackageInfo> apps = PackageManagerBackupAgent.getStorableApplications(this.mPackageManager, this.mUserId);
        if (this.mFullBackupScheduleFile.exists()) {
            try (FileInputStream fstream = new FileInputStream(this.mFullBackupScheduleFile);
                 BufferedInputStream bufStream = new BufferedInputStream(fstream);
                 DataInputStream in = new DataInputStream(bufStream);){
                int version = in.readInt();
                if (version != 1) {
                    Slog.e("BackupManagerService", "Unknown backup schedule version " + version);
                    ArrayList<FullBackupEntry> arrayList = null;
                    return arrayList;
                }
                int numPackages = in.readInt();
                schedule = new ArrayList(numPackages);
                HashSet<String> foundApps = new HashSet<String>(numPackages);
                for (int i = 0; i < numPackages; ++i) {
                    String pkgName = in.readUTF();
                    long lastBackup = in.readLong();
                    foundApps.add(pkgName);
                    try {
                        PackageInfo pkg = this.mPackageManager.getPackageInfoAsUser(pkgName, 0, this.mUserId);
                        if (AppBackupUtils.appGetsFullBackup(pkg) && AppBackupUtils.appIsEligibleForBackup(pkg.applicationInfo, this.mUserId)) {
                            schedule.add(new FullBackupEntry(pkgName, lastBackup));
                            continue;
                        }
                        Slog.i("BackupManagerService", "Package " + pkgName + " no longer eligible for full backup");
                        continue;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.i("BackupManagerService", "Package " + pkgName + " not installed; dropping from full backup");
                    }
                }
                for (PackageInfo app : apps) {
                    if (!AppBackupUtils.appGetsFullBackup(app) || !AppBackupUtils.appIsEligibleForBackup(app.applicationInfo, this.mUserId) || foundApps.contains(app.packageName)) continue;
                    schedule.add(new FullBackupEntry(app.packageName, 0L));
                    changed = true;
                }
                Collections.sort(schedule);
            }
            catch (Exception e) {
                Slog.e("BackupManagerService", "Unable to read backup schedule", e);
                this.mFullBackupScheduleFile.delete();
                schedule = null;
            }
        }
        if (schedule == null) {
            changed = true;
            schedule = new ArrayList<FullBackupEntry>(apps.size());
            for (PackageInfo info : apps) {
                if (!AppBackupUtils.appGetsFullBackup(info) || !AppBackupUtils.appIsEligibleForBackup(info.applicationInfo, this.mUserId)) continue;
                schedule.add(new FullBackupEntry(info.packageName, 0L));
            }
        }
        if (!changed) return schedule;
        this.writeFullBackupScheduleAsync();
        return schedule;
    }

    private void writeFullBackupScheduleAsync() {
        this.mBackupHandler.removeCallbacks(this.mFullBackupScheduleWriter);
        this.mBackupHandler.post(this.mFullBackupScheduleWriter);
    }

    private void parseLeftoverJournals() {
        ArrayList<DataChangedJournal> journals = DataChangedJournal.listJournals(this.mJournalDir);
        for (DataChangedJournal journal : journals) {
            if (journal.equals(this.mJournal)) continue;
            try {
                journal.forEach(packageName -> {
                    Slog.i("BackupManagerService", "Found stale backup journal, scheduling");
                    this.dataChangedImpl((String)packageName);
                });
            }
            catch (IOException e) {
                Slog.e("BackupManagerService", "Can't read " + journal, e);
            }
        }
    }

    public byte[] randomBytes(int bits) {
        byte[] array2 = new byte[bits / 8];
        this.mRng.nextBytes(array2);
        return array2;
    }

    public boolean setBackupPassword(String currentPw, String newPw) {
        return this.mBackupPasswordManager.setBackupPassword(currentPw, newPw);
    }

    public boolean hasBackupPassword() {
        return this.mBackupPasswordManager.hasBackupPassword();
    }

    public boolean backupPasswordMatches(String currentPw) {
        return this.mBackupPasswordManager.backupPasswordMatches(currentPw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordInitPending(boolean isPending, String transportName, String transportDirName) {
        Object object = this.mQueueLock;
        synchronized (object) {
            File stateDir = new File(this.mBaseStateDir, transportDirName);
            File initPendingFile = new File(stateDir, INIT_SENTINEL_FILE_NAME);
            if (isPending) {
                this.mPendingInits.add(transportName);
                try {
                    new FileOutputStream(initPendingFile).close();
                }
                catch (IOException iOException) {}
            } else {
                initPendingFile.delete();
                this.mPendingInits.remove(transportName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBackupState(File stateFileDir) {
        SparseArray<HashSet<String>> sparseArray = this.mQueueLock;
        synchronized (sparseArray) {
            this.mProcessedPackagesJournal.reset();
            this.mCurrentToken = 0L;
            this.writeRestoreTokens();
            for (File sf : stateFileDir.listFiles()) {
                if (sf.getName().equals(INIT_SENTINEL_FILE_NAME)) continue;
                sf.delete();
            }
        }
        sparseArray = this.mBackupParticipants;
        synchronized (sparseArray) {
            int numParticipants = this.mBackupParticipants.size();
            for (int i = 0; i < numParticipants; ++i) {
                HashSet<String> participants = this.mBackupParticipants.valueAt(i);
                if (participants == null) continue;
                for (String packageName : participants) {
                    this.dataChangedImpl(packageName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTransportRegistered(String transportName, String transportDirName) {
        long timeMs = SystemClock.elapsedRealtime() - this.mRegisterTransportsRequestedTime;
        Slog.d("BackupManagerService", "Transport " + transportName + " registered " + timeMs + "ms after first request (delay = " + 3000L + "ms)");
        File stateDir = new File(this.mBaseStateDir, transportDirName);
        stateDir.mkdirs();
        File initSentinel = new File(stateDir, INIT_SENTINEL_FILE_NAME);
        if (initSentinel.exists()) {
            Object object = this.mQueueLock;
            synchronized (object) {
                this.mPendingInits.add(transportName);
                long delay = 60000L;
                this.mAlarmManager.set(0, System.currentTimeMillis() + delay, this.mRunInitIntent);
            }
        }
    }

    private void addPackageParticipantsLocked(String[] packageNames) {
        List<PackageInfo> targetApps = this.allAgentPackages();
        if (packageNames != null) {
            for (String packageName : packageNames) {
                this.addPackageParticipantsLockedInner(packageName, targetApps);
            }
        } else {
            this.addPackageParticipantsLockedInner(null, targetApps);
        }
    }

    private void addPackageParticipantsLockedInner(String packageName, List<PackageInfo> targetPkgs) {
        for (PackageInfo pkg : targetPkgs) {
            if (packageName != null && !pkg.packageName.equals(packageName)) continue;
            int uid = pkg.applicationInfo.uid;
            HashSet<String> set = this.mBackupParticipants.get(uid);
            if (set == null) {
                set = new HashSet();
                this.mBackupParticipants.put(uid, set);
            }
            set.add(pkg.packageName);
            Message msg = this.mBackupHandler.obtainMessage(16, pkg.packageName);
            this.mBackupHandler.sendMessage(msg);
        }
    }

    private void removePackageParticipantsLocked(String[] packageNames, int oldUid) {
        if (packageNames == null) {
            Slog.w("BackupManagerService", "removePackageParticipants with null list");
            return;
        }
        for (String pkg : packageNames) {
            HashSet<String> set = this.mBackupParticipants.get(oldUid);
            if (set == null || !set.contains(pkg)) continue;
            this.removePackageFromSetLocked(set, pkg);
            if (!set.isEmpty()) continue;
            this.mBackupParticipants.remove(oldUid);
        }
    }

    private void removePackageFromSetLocked(HashSet<String> set, String packageName) {
        if (set.contains(packageName)) {
            set.remove(packageName);
            this.mPendingBackups.remove(packageName);
        }
    }

    private List<PackageInfo> allAgentPackages() {
        int flags = 0x8000000;
        List<PackageInfo> packages = this.mPackageManager.getInstalledPackagesAsUser(flags, this.mUserId);
        int numPackages = packages.size();
        for (int a = numPackages - 1; a >= 0; --a) {
            PackageInfo pkg = packages.get(a);
            try {
                ApplicationInfo app = pkg.applicationInfo;
                if ((app.flags & 0x8000) == 0 || app.backupAgentName == null || (app.flags & 0x4000000) != 0) {
                    packages.remove(a);
                    continue;
                }
                app = this.mPackageManager.getApplicationInfoAsUser(pkg.packageName, 1024, this.mUserId);
                pkg.applicationInfo.sharedLibraryFiles = app.sharedLibraryFiles;
                pkg.applicationInfo.sharedLibraryInfos = app.sharedLibraryInfos;
                continue;
            }
            catch (PackageManager.NameNotFoundException e) {
                packages.remove(a);
            }
        }
        return packages;
    }

    public void logBackupComplete(String packageName) {
        if (packageName.equals(PACKAGE_MANAGER_SENTINEL)) {
            return;
        }
        for (String receiver : this.mConstants.getBackupFinishedNotificationReceivers()) {
            Intent notification = new Intent();
            notification.setAction(BACKUP_FINISHED_ACTION);
            notification.setPackage(receiver);
            notification.addFlags(0x10000020);
            notification.putExtra(BACKUP_FINISHED_PACKAGE_EXTRA, packageName);
            this.mContext.sendBroadcastAsUser(notification, UserHandle.of(this.mUserId));
        }
        this.mProcessedPackagesJournal.addPackage(packageName);
    }

    public void writeRestoreTokens() {
        try (RandomAccessFile af = new RandomAccessFile(this.mTokenFile, "rwd");){
            af.writeInt(1);
            af.writeLong(this.mAncestralToken);
            af.writeLong(this.mCurrentToken);
            if (this.mAncestralPackages == null) {
                af.writeInt(-1);
            } else {
                af.writeInt(this.mAncestralPackages.size());
                Slog.v("BackupManagerService", "Ancestral packages:  " + this.mAncestralPackages.size());
                for (String pkgName : this.mAncestralPackages) {
                    af.writeUTF(pkgName);
                }
            }
        }
        catch (IOException e) {
            Slog.w("BackupManagerService", "Unable to write token file:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBackupAgent bindToAgentSynchronous(ApplicationInfo app, int mode) {
        IBackupAgent agent = null;
        Object object = this.mAgentConnectLock;
        synchronized (object) {
            this.mConnecting = true;
            this.mConnectedAgent = null;
            try {
                if (this.mActivityManager.bindBackupAgent(app.packageName, mode, this.mUserId)) {
                    Slog.d("BackupManagerService", "awaiting agent for " + app);
                    long timeoutMark = System.currentTimeMillis() + 10000L;
                    while (this.mConnecting && this.mConnectedAgent == null && System.currentTimeMillis() < timeoutMark) {
                        try {
                            this.mAgentConnectLock.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            Slog.w("BackupManagerService", "Interrupted: " + e);
                            this.mConnecting = false;
                            this.mConnectedAgent = null;
                        }
                    }
                    if (this.mConnecting) {
                        Slog.w("BackupManagerService", "Timeout waiting for agent " + app);
                        this.mConnectedAgent = null;
                    }
                    Slog.i("BackupManagerService", "got agent " + this.mConnectedAgent);
                    agent = this.mConnectedAgent;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (agent == null) {
            this.mActivityManagerInternal.clearPendingBackup(this.mUserId);
        }
        return agent;
    }

    public void unbindAgent(ApplicationInfo app) {
        try {
            this.mActivityManager.unbindBackupAgent(app);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void clearApplicationDataAfterRestoreFailure(String packageName) {
        this.clearApplicationDataSynchronous(packageName, true, false);
    }

    public void clearApplicationDataBeforeRestore(String packageName) {
        this.clearApplicationDataSynchronous(packageName, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearApplicationDataSynchronous(String packageName, boolean checkFlagAllowClearUserDataOnFailedRestore, boolean keepSystemState) {
        try {
            boolean shouldClearData;
            ApplicationInfo applicationInfo = this.mPackageManager.getPackageInfoAsUser((String)packageName, (int)0, (int)this.mUserId).applicationInfo;
            if (checkFlagAllowClearUserDataOnFailedRestore && applicationInfo.targetSdkVersion >= 29) {
                shouldClearData = (applicationInfo.privateFlags & 0x4000000) != 0;
            } else {
                boolean bl = shouldClearData = (applicationInfo.flags & 0x40) != 0;
            }
            if (!shouldClearData) {
                return;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.w("BackupManagerService", "Tried to clear data for " + packageName + " but not found");
            return;
        }
        ClearDataObserver observer = new ClearDataObserver(this);
        Object object = this.mClearDataLock;
        synchronized (object) {
            this.mClearingData = true;
            try {
                this.mActivityManager.clearApplicationUserData(packageName, keepSystemState, observer, this.mUserId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            long timeoutMark = System.currentTimeMillis() + 30000L;
            while (this.mClearingData && System.currentTimeMillis() < timeoutMark) {
                try {
                    this.mClearDataLock.wait(5000L);
                }
                catch (InterruptedException e) {
                    this.mClearingData = false;
                    Slog.w("BackupManagerService", "Interrupted while waiting for " + packageName + " data to be cleared", e);
                }
            }
            if (this.mClearingData) {
                Slog.w("BackupManagerService", "Clearing app data for " + packageName + " timed out");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAvailableRestoreToken(String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getAvailableRestoreToken");
        long token = this.mAncestralToken;
        Object object = this.mQueueLock;
        synchronized (object) {
            if (this.mCurrentToken != 0L && this.mProcessedPackagesJournal.hasBeenProcessed(packageName)) {
                token = this.mCurrentToken;
            }
        }
        return token;
    }

    public int requestBackup(String[] packages, IBackupObserver observer, int flags) {
        return this.requestBackup(packages, observer, null, flags);
    }

    public int requestBackup(String[] packages, IBackupObserver observer, IBackupManagerMonitor monitor, int flags) {
        TransportClient transportClient;
        String transportDirName;
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "requestBackup");
        if (packages == null || packages.length < 1) {
            Slog.e("BackupManagerService", "No packages named for backup request");
            BackupObserverUtils.sendBackupFinished(observer, -1000);
            monitor = BackupManagerMonitorUtils.monitorEvent(monitor, 49, null, 1, null);
            throw new IllegalArgumentException("No packages are provided for backup");
        }
        if (!this.mEnabled || !this.mSetupComplete) {
            Slog.i("BackupManagerService", "Backup requested but enabled=" + this.mEnabled + " setupComplete=" + this.mSetupComplete);
            BackupObserverUtils.sendBackupFinished(observer, -2001);
            int logTag = this.mSetupComplete ? 13 : 14;
            monitor = BackupManagerMonitorUtils.monitorEvent(monitor, logTag, null, 3, null);
            return -2001;
        }
        try {
            transportDirName = this.mTransportManager.getTransportDirName(this.mTransportManager.getCurrentTransportName());
            transportClient = this.mTransportManager.getCurrentTransportClientOrThrow("BMS.requestBackup()");
        }
        catch (TransportNotRegisteredException e) {
            BackupObserverUtils.sendBackupFinished(observer, -1000);
            monitor = BackupManagerMonitorUtils.monitorEvent(monitor, 50, null, 1, null);
            return -1000;
        }
        OnTaskFinishedListener listener = caller -> this.mTransportManager.disposeOfTransportClient(transportClient, caller);
        ArrayList<String> fullBackupList = new ArrayList<String>();
        ArrayList<String> kvBackupList = new ArrayList<String>();
        for (String packageName : packages) {
            if (PACKAGE_MANAGER_SENTINEL.equals(packageName)) {
                kvBackupList.add(packageName);
                continue;
            }
            try {
                PackageInfo packageInfo = this.mPackageManager.getPackageInfoAsUser(packageName, 0x8000000, this.mUserId);
                if (!AppBackupUtils.appIsEligibleForBackup(packageInfo.applicationInfo, this.mUserId)) {
                    BackupObserverUtils.sendBackupOnPackageResult(observer, packageName, -2001);
                    continue;
                }
                if (AppBackupUtils.appGetsFullBackup(packageInfo)) {
                    fullBackupList.add(packageInfo.packageName);
                    continue;
                }
                kvBackupList.add(packageInfo.packageName);
            }
            catch (PackageManager.NameNotFoundException e) {
                BackupObserverUtils.sendBackupOnPackageResult(observer, packageName, -2002);
            }
        }
        EventLog.writeEvent(2828, packages.length, kvBackupList.size(), fullBackupList.size());
        boolean nonIncrementalBackup = (flags & 1) != 0;
        Message msg = this.mBackupHandler.obtainMessage(15);
        msg.obj = new BackupParams(transportClient, transportDirName, kvBackupList, fullBackupList, observer, monitor, listener, true, nonIncrementalBackup);
        this.mBackupHandler.sendMessage(msg);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelBackups() {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "cancelBackups");
        long oldToken = Binder.clearCallingIdentity();
        try {
            ArrayList<Integer> operationsToCancel = new ArrayList<Integer>();
            Iterator iterator = this.mCurrentOpLock;
            synchronized (iterator) {
                for (int i = 0; i < this.mCurrentOperations.size(); ++i) {
                    Operation op = this.mCurrentOperations.valueAt(i);
                    int token = this.mCurrentOperations.keyAt(i);
                    if (op.type != 2) continue;
                    operationsToCancel.add(token);
                }
            }
            for (Integer token : operationsToCancel) {
                this.handleCancel(token, true);
            }
            KeyValueBackupJob.schedule(this.mUserId, this.mContext, 3600000L, this.mConstants);
            FullBackupJob.schedule(this.mUserId, this.mContext, 0x6DDD00L, this.mConstants);
        }
        finally {
            Binder.restoreCallingIdentity(oldToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareOperationTimeout(int token, long interval, BackupRestoreTask callback, int operationType) {
        if (operationType != 0 && operationType != 1) {
            Slog.wtf("BackupManagerService", "prepareOperationTimeout() doesn't support operation " + Integer.toHexString(token) + " of type " + operationType);
            return;
        }
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            this.mCurrentOperations.put(token, new Operation(0, callback, operationType));
            Message msg = this.mBackupHandler.obtainMessage(this.getMessageIdForOperationType(operationType), token, 0, callback);
            this.mBackupHandler.sendMessageDelayed(msg, interval);
        }
    }

    private int getMessageIdForOperationType(int operationType) {
        switch (operationType) {
            case 0: {
                return 17;
            }
            case 1: {
                return 18;
            }
        }
        Slog.wtf("BackupManagerService", "getMessageIdForOperationType called on invalid operation type: " + operationType);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putOperation(int token, Operation operation) {
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            this.mCurrentOperations.put(token, operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOperation(int token) {
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            if (this.mCurrentOperations.get(token) == null) {
                Slog.w("BackupManagerService", "Duplicate remove for operation. token=" + Integer.toHexString(token));
            }
            this.mCurrentOperations.remove(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilOperationComplete(int token) {
        int finalState = 0;
        Operation op = null;
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            while ((op = this.mCurrentOperations.get(token)) != null) {
                if (op.state == 0) {
                    try {
                        this.mCurrentOpLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                finalState = op.state;
                break;
            }
        }
        this.removeOperation(token);
        if (op != null) {
            this.mBackupHandler.removeMessages(this.getMessageIdForOperationType(op.type));
        }
        return finalState == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCancel(int token, boolean cancelAll) {
        Operation op = null;
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            int state;
            op = this.mCurrentOperations.get(token);
            int n = state = op != null ? op.state : -1;
            if (state == 1) {
                Slog.w("BackupManagerService", "Operation already got an ack.Should have been removed from mCurrentOperations.");
                op = null;
                this.mCurrentOperations.delete(token);
            } else if (state == 0) {
                Slog.v("BackupManagerService", "Cancel: token=" + Integer.toHexString(token));
                op.state = -1;
                if (op.type == 0 || op.type == 1) {
                    this.mBackupHandler.removeMessages(this.getMessageIdForOperationType(op.type));
                }
            }
            this.mCurrentOpLock.notifyAll();
        }
        if (op != null && op.callback != null) {
            op.callback.handleCancel(cancelAll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBackupOperationInProgress() {
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            for (int i = 0; i < this.mCurrentOperations.size(); ++i) {
                Operation op = this.mCurrentOperations.valueAt(i);
                if (op.type != 2 || op.state != 0) continue;
                return true;
            }
        }
        return false;
    }

    public void tearDownAgentAndKill(ApplicationInfo app) {
        if (app == null) {
            return;
        }
        try {
            this.mActivityManager.unbindBackupAgent(app);
            if (!UserHandle.isCore(app.uid) && !app.packageName.equals("com.android.backupconfirm")) {
                this.mActivityManager.killApplicationProcess(app.processName, app.uid);
            }
        }
        catch (RemoteException e) {
            Slog.d("BackupManagerService", "Lost app trying to shut down");
        }
    }

    public boolean deviceIsEncrypted() {
        try {
            return this.mStorageManager.getEncryptionState() != 1 && this.mStorageManager.getPasswordType() != 1;
        }
        catch (Exception e) {
            Slog.e("BackupManagerService", "Unable to communicate with storagemanager service: " + e.getMessage());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleNextFullBackupJob(long transportMinLatency) {
        Object object = this.mQueueLock;
        synchronized (object) {
            if (this.mFullBackupQueue.size() > 0) {
                long interval;
                long upcomingLastBackup = this.mFullBackupQueue.get((int)0).lastBackup;
                long timeSinceLast = System.currentTimeMillis() - upcomingLastBackup;
                long appLatency = timeSinceLast < (interval = this.mConstants.getFullBackupIntervalMilliseconds()) ? interval - timeSinceLast : 0L;
                long latency = Math.max(transportMinLatency, appLatency);
                FullBackupJob.schedule(this.mUserId, this.mContext, latency, this.mConstants);
            } else {
                Slog.i("BackupManagerService", "Full backup queue empty; not scheduling");
            }
        }
    }

    @GuardedBy(value={"mQueueLock"})
    private void dequeueFullBackupLocked(String packageName) {
        int numPackages = this.mFullBackupQueue.size();
        for (int i = numPackages - 1; i >= 0; --i) {
            FullBackupEntry e = this.mFullBackupQueue.get(i);
            if (!packageName.equals(e.packageName)) continue;
            this.mFullBackupQueue.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueFullBackup(String packageName, long lastBackedUp) {
        FullBackupEntry newEntry = new FullBackupEntry(packageName, lastBackedUp);
        Object object = this.mQueueLock;
        synchronized (object) {
            this.dequeueFullBackupLocked(packageName);
            int which = -1;
            if (lastBackedUp > 0L) {
                for (which = this.mFullBackupQueue.size() - 1; which >= 0; --which) {
                    FullBackupEntry entry = this.mFullBackupQueue.get(which);
                    if (entry.lastBackup > lastBackedUp) continue;
                    this.mFullBackupQueue.add(which + 1, newEntry);
                    break;
                }
            }
            if (which < 0) {
                this.mFullBackupQueue.add(0, newEntry);
            }
        }
        this.writeFullBackupScheduleAsync();
    }

    private boolean fullBackupAllowable(String transportName) {
        if (!this.mTransportManager.isTransportRegistered(transportName)) {
            Slog.w("BackupManagerService", "Transport not registered; full data backup not performed");
            return false;
        }
        try {
            String transportDirName = this.mTransportManager.getTransportDirName(transportName);
            File stateDir = new File(this.mBaseStateDir, transportDirName);
            File pmState = new File(stateDir, PACKAGE_MANAGER_SENTINEL);
            if (pmState.length() <= 0L) {
                Slog.i("BackupManagerService", "Full backup requested but dataset not yet initialized");
                return false;
            }
        }
        catch (Exception e) {
            Slog.w("BackupManagerService", "Unable to get transport name: " + e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginFullBackup(FullBackupJob scheduledJob) {
        long keyValueBackupInterval;
        long fullBackupInterval;
        long now = System.currentTimeMillis();
        BackupManagerConstants backupManagerConstants = this.mConstants;
        synchronized (backupManagerConstants) {
            fullBackupInterval = this.mConstants.getFullBackupIntervalMilliseconds();
            keyValueBackupInterval = this.mConstants.getKeyValueBackupIntervalMilliseconds();
        }
        FullBackupEntry entry = null;
        long latency = fullBackupInterval;
        if (!this.mEnabled || !this.mSetupComplete) {
            return false;
        }
        PowerSaveState result = this.mPowerManager.getPowerSaveState(4);
        if (result.batterySaverEnabled) {
            Slog.i("BackupManagerService", "Deferring scheduled full backups in battery saver mode");
            FullBackupJob.schedule(this.mUserId, this.mContext, keyValueBackupInterval, this.mConstants);
            return false;
        }
        Slog.i("BackupManagerService", "Beginning scheduled full backup operation");
        Object object = this.mQueueLock;
        synchronized (object) {
            boolean headBusy;
            if (this.mRunningFullBackupTask != null) {
                Slog.e("BackupManagerService", "Backup triggered but one already/still running!");
                return false;
            }
            boolean runBackup = true;
            do {
                if (this.mFullBackupQueue.size() == 0) {
                    Slog.i("BackupManagerService", "Backup queue empty; doing nothing");
                    runBackup = false;
                    break;
                }
                headBusy = false;
                String transportName = this.mTransportManager.getCurrentTransportName();
                if (!this.fullBackupAllowable(transportName)) {
                    runBackup = false;
                    latency = keyValueBackupInterval;
                }
                if (!runBackup) continue;
                entry = this.mFullBackupQueue.get(0);
                long timeSinceRun = now - entry.lastBackup;
                boolean bl = runBackup = timeSinceRun >= fullBackupInterval;
                if (!runBackup) {
                    latency = fullBackupInterval - timeSinceRun;
                    break;
                }
                try {
                    PackageInfo appInfo = this.mPackageManager.getPackageInfoAsUser(entry.packageName, 0, this.mUserId);
                    if (!AppBackupUtils.appGetsFullBackup(appInfo)) {
                        this.mFullBackupQueue.remove(0);
                        headBusy = true;
                        continue;
                    }
                    int privFlags = appInfo.applicationInfo.privateFlags;
                    boolean bl2 = headBusy = (privFlags & 0x2000) == 0 && this.mActivityManagerInternal.isAppForeground(appInfo.applicationInfo.uid);
                    if (!headBusy) continue;
                    long nextEligible = System.currentTimeMillis() + 3600000L + (long)this.mTokenGenerator.nextInt(0x6DDD00);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Slog.i("BackupManagerService", "Full backup time but " + entry.packageName + " is busy; deferring to " + sdf.format(new Date(nextEligible)));
                    this.enqueueFullBackup(entry.packageName, nextEligible - fullBackupInterval);
                }
                catch (PackageManager.NameNotFoundException nnf) {
                    boolean bl3 = runBackup = this.mFullBackupQueue.size() > 1;
                }
            } while (headBusy);
            if (!runBackup) {
                Slog.i("BackupManagerService", "Nothing pending full backup; rescheduling +" + latency);
                long deferTime = latency;
                FullBackupJob.schedule(this.mUserId, this.mContext, deferTime, this.mConstants);
                return false;
            }
            this.mFullBackupQueue.remove(0);
            CountDownLatch latch = new CountDownLatch(1);
            String[] pkg = new String[]{entry.packageName};
            this.mRunningFullBackupTask = PerformFullTransportBackupTask.newWithCurrentTransport(this, null, pkg, true, scheduledJob, latch, null, null, false, "BMS.beginFullBackup()");
            this.mWakelock.acquire();
            new Thread(this.mRunningFullBackupTask).start();
        }
        return true;
    }

    public void endFullBackup() {
        Runnable endFullBackupRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PerformFullTransportBackupTask pftbt = null;
                Object object = UserBackupManagerService.this.mQueueLock;
                synchronized (object) {
                    if (UserBackupManagerService.this.mRunningFullBackupTask != null) {
                        pftbt = UserBackupManagerService.this.mRunningFullBackupTask;
                    }
                }
                if (pftbt != null) {
                    Slog.i("BackupManagerService", "Telling running backup to stop");
                    pftbt.handleCancel(true);
                }
            }
        };
        new Thread(endFullBackupRunnable, "end-full-backup").start();
    }

    public void restoreWidgetData(String packageName, byte[] widgetData) {
        AppWidgetBackupBridge.restoreWidgetState(packageName, widgetData, this.mUserId);
    }

    public void dataChangedImpl(String packageName) {
        HashSet<String> targets = this.dataChangedTargets(packageName);
        this.dataChangedImpl(packageName, targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataChangedImpl(String packageName, HashSet<String> targets) {
        if (targets == null) {
            Slog.w("BackupManagerService", "dataChanged but no participant pkg='" + packageName + "' uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mQueueLock;
        synchronized (object) {
            BackupRequest req;
            if (targets.contains(packageName) && this.mPendingBackups.put(packageName, req = new BackupRequest(packageName)) == null) {
                this.writeToJournalLocked(packageName);
            }
        }
        KeyValueBackupJob.schedule(this.mUserId, this.mContext, this.mConstants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<String> dataChangedTargets(String packageName) {
        if (this.mContext.checkPermission("android.permission.BACKUP", Binder.getCallingPid(), Binder.getCallingUid()) == -1) {
            SparseArray<HashSet<String>> sparseArray = this.mBackupParticipants;
            synchronized (sparseArray) {
                return this.mBackupParticipants.get(Binder.getCallingUid());
            }
        }
        if (PACKAGE_MANAGER_SENTINEL.equals(packageName)) {
            return Sets.newHashSet(PACKAGE_MANAGER_SENTINEL);
        }
        SparseArray<HashSet<String>> sparseArray = this.mBackupParticipants;
        synchronized (sparseArray) {
            return SparseArrayUtils.union(this.mBackupParticipants);
        }
    }

    private void writeToJournalLocked(String str) {
        try {
            if (this.mJournal == null) {
                this.mJournal = DataChangedJournal.newJournal(this.mJournalDir);
            }
            this.mJournal.addPackage(str);
        }
        catch (IOException e) {
            Slog.e("BackupManagerService", "Can't write " + str + " to backup journal", e);
            this.mJournal = null;
        }
    }

    public void dataChanged(final String packageName) {
        final HashSet<String> targets = this.dataChangedTargets(packageName);
        if (targets == null) {
            Slog.w("BackupManagerService", "dataChanged but no participant pkg='" + packageName + "' uid=" + Binder.getCallingUid());
            return;
        }
        this.mBackupHandler.post(new Runnable(){

            @Override
            public void run() {
                UserBackupManagerService.this.dataChangedImpl(packageName, targets);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeTransports(String[] transportNames, IBackupObserver observer) {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "initializeTransport");
        Slog.v("BackupManagerService", "initializeTransport(): " + Arrays.asList(transportNames));
        long oldId = Binder.clearCallingIdentity();
        try {
            this.mWakelock.acquire();
            OnTaskFinishedListener listener = caller -> this.mWakelock.release();
            this.mBackupHandler.post(new PerformInitializeTask(this, transportNames, observer, listener));
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    public void setAncestralSerialNumber(long ancestralSerialNumber) {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "setAncestralSerialNumber");
        Slog.v("BackupManagerService", "Setting ancestral work profile id to " + ancestralSerialNumber);
        try (RandomAccessFile af = this.getAncestralSerialNumberFile();){
            af.writeLong(ancestralSerialNumber);
        }
        catch (IOException e) {
            Slog.w("BackupManagerService", "Unable to write to work profile serial mapping file:", e);
        }
    }

    public long getAncestralSerialNumber() {
        long l;
        block8: {
            RandomAccessFile af = this.getAncestralSerialNumberFile();
            Throwable throwable = null;
            try {
                l = af.readLong();
                if (af == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (af != null) {
                            UserBackupManagerService.$closeResource(throwable, af);
                        }
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    Slog.w("BackupManagerService", "Unable to write to work profile serial number file:", e);
                    return -1L;
                }
            }
            UserBackupManagerService.$closeResource(throwable, af);
        }
        return l;
    }

    private RandomAccessFile getAncestralSerialNumberFile() throws FileNotFoundException {
        if (this.mAncestralSerialNumberFile == null) {
            this.mAncestralSerialNumberFile = new File(UserBackupManagerFiles.getBaseStateDir(this.getUserId()), SERIAL_ID_FILE);
            FileUtils.createNewFile(this.mAncestralSerialNumberFile);
        }
        return new RandomAccessFile(this.mAncestralSerialNumberFile, "rwd");
    }

    @VisibleForTesting
    void setAncestralSerialNumberFile(File ancestralSerialNumberFile) {
        this.mAncestralSerialNumberFile = ancestralSerialNumberFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBackupData(String transportName, String packageName) {
        PackageInfo info;
        Slog.v("BackupManagerService", "clearBackupData() of " + packageName + " on " + transportName);
        try {
            info = this.mPackageManager.getPackageInfoAsUser(packageName, 0x8000000, this.mUserId);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.d("BackupManagerService", "No such package '" + packageName + "' - not clearing backup data");
            return;
        }
        Set apps = this.mContext.checkPermission("android.permission.BACKUP", Binder.getCallingPid(), Binder.getCallingUid()) == -1 ? (Set)this.mBackupParticipants.get(Binder.getCallingUid()) : this.mProcessedPackagesJournal.getPackagesCopy();
        if (apps.contains(packageName)) {
            this.mBackupHandler.removeMessages(12);
            Object object = this.mQueueLock;
            synchronized (object) {
                TransportClient transportClient = this.mTransportManager.getTransportClient(transportName, "BMS.clearBackupData()");
                if (transportClient == null) {
                    Message msg = this.mBackupHandler.obtainMessage(12, new ClearRetryParams(transportName, packageName));
                    this.mBackupHandler.sendMessageDelayed(msg, 3600000L);
                    return;
                }
                long oldId = Binder.clearCallingIdentity();
                OnTaskFinishedListener listener = caller -> this.mTransportManager.disposeOfTransportClient(transportClient, caller);
                this.mWakelock.acquire();
                Message msg = this.mBackupHandler.obtainMessage(4, new ClearParams(transportClient, info, listener));
                this.mBackupHandler.sendMessage(msg);
                Binder.restoreCallingIdentity(oldId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupNow() {
        block9: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "backupNow");
            long oldId = Binder.clearCallingIdentity();
            try {
                PowerSaveState result = this.mPowerManager.getPowerSaveState(5);
                if (result.batterySaverEnabled) {
                    Slog.v("BackupManagerService", "Not running backup while in battery save mode");
                    KeyValueBackupJob.schedule(this.mUserId, this.mContext, this.mConstants);
                    break block9;
                }
                Slog.v("BackupManagerService", "Scheduling immediate backup pass");
                Object object = this.mQueueLock;
                synchronized (object) {
                    try {
                        this.mRunBackupIntent.send();
                    }
                    catch (PendingIntent.CanceledException e) {
                        Slog.e("BackupManagerService", "run-backup intent cancelled!");
                    }
                    KeyValueBackupJob.cancel(this.mUserId, this.mContext);
                }
            }
            finally {
                Binder.restoreCallingIdentity(oldId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adbBackup(ParcelFileDescriptor fd, boolean includeApks, boolean includeObbs, boolean includeShared, boolean doWidgets, boolean doAllApps, boolean includeSystem, boolean compress, boolean doKeyValue, String[] pkgList) {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "adbBackup");
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != 0) {
            throw new IllegalStateException("Backup supported only for the device owner");
        }
        if (!(doAllApps || includeShared || pkgList != null && pkgList.length != 0)) {
            throw new IllegalArgumentException("Backup requested but neither shared nor any apps named");
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            if (!this.mSetupComplete) {
                Slog.i("BackupManagerService", "Backup not supported before setup");
                return;
            }
            Slog.v("BackupManagerService", "Requesting backup: apks=" + includeApks + " obb=" + includeObbs + " shared=" + includeShared + " all=" + doAllApps + " system=" + includeSystem + " includekeyvalue=" + doKeyValue + " pkgs=" + pkgList);
            Slog.i("BackupManagerService", "Beginning adb backup...");
            AdbBackupParams params = new AdbBackupParams(fd, includeApks, includeObbs, includeShared, doWidgets, doAllApps, includeSystem, compress, doKeyValue, pkgList);
            int token = this.generateRandomIntegerToken();
            SparseArray<AdbParams> sparseArray = this.mAdbBackupRestoreConfirmations;
            synchronized (sparseArray) {
                this.mAdbBackupRestoreConfirmations.put(token, params);
            }
            Slog.d("BackupManagerService", "Starting backup confirmation UI, token=" + token);
            if (!this.startConfirmationUi(token, "fullback")) {
                Slog.e("BackupManagerService", "Unable to launch backup confirmation UI");
                this.mAdbBackupRestoreConfirmations.delete(token);
                return;
            }
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), 0, 0);
            this.startConfirmationTimeout(token, params);
            Slog.d("BackupManagerService", "Waiting for backup completion...");
            this.waitForCompletion(params);
        }
        finally {
            try {
                fd.close();
            }
            catch (IOException e) {
                Slog.e("BackupManagerService", "IO error closing output for adb backup: " + e.getMessage());
            }
            Binder.restoreCallingIdentity(oldId);
            Slog.d("BackupManagerService", "Adb backup processing complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullTransportBackup(String[] pkgNames) {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "fullTransportBackup");
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != 0) {
            throw new IllegalStateException("Restore supported only for the device owner");
        }
        String transportName = this.mTransportManager.getCurrentTransportName();
        if (!this.fullBackupAllowable(transportName)) {
            Slog.i("BackupManagerService", "Full backup not currently possible -- key/value backup not yet run?");
        } else {
            Slog.d("BackupManagerService", "fullTransportBackup()");
            long oldId = Binder.clearCallingIdentity();
            try {
                CountDownLatch latch = new CountDownLatch(1);
                PerformFullTransportBackupTask task = PerformFullTransportBackupTask.newWithCurrentTransport(this, null, pkgNames, false, null, latch, null, null, false, "BMS.fullTransportBackup()");
                this.mWakelock.acquire();
                new Thread((Runnable)task, "full-transport-master").start();
                while (true) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                long now = System.currentTimeMillis();
                for (String pkg : pkgNames) {
                    this.enqueueFullBackup(pkg, now);
                }
            }
            finally {
                Binder.restoreCallingIdentity(oldId);
            }
        }
        Slog.d("BackupManagerService", "Done with full transport backup.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adbRestore(ParcelFileDescriptor fd) {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "adbRestore");
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != 0) {
            throw new IllegalStateException("Restore supported only for the device owner");
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            if (!this.mSetupComplete) {
                Slog.i("BackupManagerService", "Full restore not permitted before setup");
                return;
            }
            Slog.i("BackupManagerService", "Beginning restore...");
            AdbRestoreParams params = new AdbRestoreParams(fd);
            int token = this.generateRandomIntegerToken();
            SparseArray<AdbParams> sparseArray = this.mAdbBackupRestoreConfirmations;
            synchronized (sparseArray) {
                this.mAdbBackupRestoreConfirmations.put(token, params);
            }
            Slog.d("BackupManagerService", "Starting restore confirmation UI, token=" + token);
            if (!this.startConfirmationUi(token, "fullrest")) {
                Slog.e("BackupManagerService", "Unable to launch restore confirmation");
                this.mAdbBackupRestoreConfirmations.delete(token);
                return;
            }
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), 0, 0);
            this.startConfirmationTimeout(token, params);
            Slog.d("BackupManagerService", "Waiting for restore completion...");
            this.waitForCompletion(params);
        }
        finally {
            try {
                fd.close();
            }
            catch (IOException e) {
                Slog.w("BackupManagerService", "Error trying to close fd after adb restore: " + e);
            }
            Binder.restoreCallingIdentity(oldId);
            Slog.i("BackupManagerService", "adb restore processing complete.");
        }
    }

    private boolean startConfirmationUi(int token, String action) {
        try {
            Intent confIntent = new Intent(action);
            confIntent.setClassName("com.android.backupconfirm", "com.android.backupconfirm.BackupRestoreConfirmation");
            confIntent.putExtra("conftoken", token);
            confIntent.addFlags(0x20000000);
            this.mContext.startActivityAsUser(confIntent, UserHandle.SYSTEM);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    private void startConfirmationTimeout(int token, AdbParams params) {
        Message msg = this.mBackupHandler.obtainMessage(9, token, 0, params);
        this.mBackupHandler.sendMessageDelayed(msg, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCompletion(AdbParams params) {
        AtomicBoolean atomicBoolean = params.latch;
        synchronized (atomicBoolean) {
            while (!params.latch.get()) {
                try {
                    params.latch.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAdbBackupRestoreCompletion(AdbParams params) {
        AtomicBoolean atomicBoolean = params.latch;
        synchronized (atomicBoolean) {
            params.latch.set(true);
            params.latch.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeAdbBackupOrRestore(int token, boolean allow, String curPassword, String encPpassword, IFullBackupRestoreObserver observer) {
        Slog.d("BackupManagerService", "acknowledgeAdbBackupOrRestore : token=" + token + " allow=" + allow);
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "acknowledgeAdbBackupOrRestore");
        long oldId = Binder.clearCallingIdentity();
        try {
            SparseArray<AdbParams> sparseArray = this.mAdbBackupRestoreConfirmations;
            synchronized (sparseArray) {
                AdbParams params = this.mAdbBackupRestoreConfirmations.get(token);
                if (params != null) {
                    this.mBackupHandler.removeMessages(9, params);
                    this.mAdbBackupRestoreConfirmations.delete(token);
                    if (allow) {
                        int verb = params instanceof AdbBackupParams ? 2 : 10;
                        params.observer = observer;
                        params.curPassword = curPassword;
                        params.encryptPassword = encPpassword;
                        this.mWakelock.acquire();
                        Message msg = this.mBackupHandler.obtainMessage(verb, params);
                        this.mBackupHandler.sendMessage(msg);
                    } else {
                        Slog.w("BackupManagerService", "User rejected full backup/restore operation");
                        this.signalAdbBackupRestoreCompletion(params);
                    }
                } else {
                    Slog.w("BackupManagerService", "Attempted to ack full backup/restore with invalid token");
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackupEnabled(boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setBackupEnabled");
        Slog.i("BackupManagerService", "Backup enabled => " + enable);
        long oldId = Binder.clearCallingIdentity();
        try {
            boolean wasEnabled = this.mEnabled;
            Object object = this;
            synchronized (object) {
                UserBackupManagerFilePersistedSettings.writeBackupEnableState(this.mUserId, enable);
                this.mEnabled = enable;
            }
            object = this.mQueueLock;
            synchronized (object) {
                if (enable && !wasEnabled && this.mSetupComplete) {
                    KeyValueBackupJob.schedule(this.mUserId, this.mContext, this.mConstants);
                    this.scheduleNextFullBackupJob(0L);
                } else if (!enable) {
                    KeyValueBackupJob.cancel(this.mUserId, this.mContext);
                    if (wasEnabled && this.mSetupComplete) {
                        ArrayList transportNames = new ArrayList();
                        ArrayList transportDirNames = new ArrayList();
                        this.mTransportManager.forEachRegisteredTransport(name -> {
                            String dirName;
                            try {
                                dirName = this.mTransportManager.getTransportDirName((String)name);
                            }
                            catch (TransportNotRegisteredException e) {
                                Slog.e("BackupManagerService", "Unexpected unregistered transport", e);
                                return;
                            }
                            transportNames.add(name);
                            transportDirNames.add(dirName);
                        });
                        for (int i = 0; i < transportNames.size(); ++i) {
                            this.recordInitPending(true, (String)transportNames.get(i), (String)transportDirNames.get(i));
                        }
                        this.mAlarmManager.set(0, System.currentTimeMillis(), this.mRunInitIntent);
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoRestore(boolean doAutoRestore) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setAutoRestore");
        Slog.i("BackupManagerService", "Auto restore => " + doAutoRestore);
        long oldId = Binder.clearCallingIdentity();
        try {
            UserBackupManagerService userBackupManagerService = this;
            synchronized (userBackupManagerService) {
                Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "backup_auto_restore", doAutoRestore ? 1 : 0, this.mUserId);
                this.mAutoRestore = doAutoRestore;
            }
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    public boolean isBackupEnabled() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "isBackupEnabled");
        return this.mEnabled;
    }

    public String getCurrentTransport() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getCurrentTransport");
        String currentTransport = this.mTransportManager.getCurrentTransportName();
        return currentTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentName getCurrentTransportComponent() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getCurrentTransportComponent");
        long oldId = Binder.clearCallingIdentity();
        try {
            ComponentName componentName = this.mTransportManager.getCurrentTransportComponent();
            return componentName;
        }
        catch (TransportNotRegisteredException e) {
            ComponentName componentName = null;
            return componentName;
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    public String[] listAllTransports() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "listAllTransports");
        return this.mTransportManager.getRegisteredTransportNames();
    }

    public ComponentName[] listAllTransportComponents() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "listAllTransportComponents");
        return this.mTransportManager.getRegisteredTransportComponents();
    }

    public void updateTransportAttributes(ComponentName transportComponent, String name, Intent configurationIntent, String currentDestinationString, Intent dataManagementIntent, CharSequence dataManagementLabel) {
        this.updateTransportAttributes(Binder.getCallingUid(), transportComponent, name, configurationIntent, currentDestinationString, dataManagementIntent, dataManagementLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateTransportAttributes(int callingUid, ComponentName transportComponent, String name, Intent configurationIntent, String currentDestinationString, Intent dataManagementIntent, CharSequence dataManagementLabel) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "updateTransportAttributes");
        Preconditions.checkNotNull(transportComponent, "transportComponent can't be null");
        Preconditions.checkNotNull(name, "name can't be null");
        Preconditions.checkNotNull(currentDestinationString, "currentDestinationString can't be null");
        Preconditions.checkArgument(dataManagementIntent == null == (dataManagementLabel == null), "dataManagementLabel should be null iff dataManagementIntent is null");
        try {
            int transportUid = this.mContext.getPackageManager().getPackageUidAsUser(transportComponent.getPackageName(), 0, this.mUserId);
            if (callingUid != transportUid) {
                throw new SecurityException("Only the transport can change its description");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new SecurityException("Transport package not found", e);
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            this.mTransportManager.updateTransportAttributes(transportComponent, name, configurationIntent, currentDestinationString, dataManagementIntent, dataManagementLabel);
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public String selectBackupTransport(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "selectBackupTransport");
        long oldId = Binder.clearCallingIdentity();
        try {
            String previousTransportName = this.mTransportManager.selectTransport(transportName);
            this.updateStateForTransport(transportName);
            Slog.v("BackupManagerService", "selectBackupTransport(transport = " + transportName + "): previous transport = " + previousTransportName);
            String string2 = previousTransportName;
            return string2;
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectBackupTransportAsync(ComponentName transportComponent, ISelectBackupTransportCallback listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "selectBackupTransportAsync");
        long oldId = Binder.clearCallingIdentity();
        try {
            String transportString = transportComponent.flattenToShortString();
            Slog.v("BackupManagerService", "selectBackupTransportAsync(transport = " + transportString + ")");
            this.mBackupHandler.post(() -> {
                String transportName = null;
                int result = this.mTransportManager.registerAndSelectTransport(transportComponent);
                if (result == 0) {
                    try {
                        transportName = this.mTransportManager.getTransportName(transportComponent);
                        this.updateStateForTransport(transportName);
                    }
                    catch (TransportNotRegisteredException e) {
                        Slog.e("BackupManagerService", "Transport got unregistered");
                        result = -1;
                    }
                }
                try {
                    if (transportName != null) {
                        listener.onSuccess(transportName);
                    } else {
                        listener.onFailure(result);
                    }
                }
                catch (RemoteException e) {
                    Slog.e("BackupManagerService", "ISelectBackupTransportCallback listener not available");
                }
            });
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    private void updateStateForTransport(String newTransportName) {
        Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "backup_transport", newTransportName, this.mUserId);
        String callerLogString = "BMS.updateStateForTransport()";
        TransportClient transportClient = this.mTransportManager.getTransportClient(newTransportName, callerLogString);
        if (transportClient != null) {
            try {
                IBackupTransport transport = transportClient.connectOrThrow(callerLogString);
                this.mCurrentToken = transport.getCurrentRestoreSet();
            }
            catch (Exception e) {
                this.mCurrentToken = 0L;
                Slog.w("BackupManagerService", "Transport " + newTransportName + " not available: current token = 0");
            }
            this.mTransportManager.disposeOfTransportClient(transportClient, callerLogString);
        } else {
            Slog.w("BackupManagerService", "Transport " + newTransportName + " not registered: current token = 0");
            this.mCurrentToken = 0L;
        }
    }

    public Intent getConfigurationIntent(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getConfigurationIntent");
        try {
            Intent intent = this.mTransportManager.getTransportConfigurationIntent(transportName);
            return intent;
        }
        catch (TransportNotRegisteredException e) {
            Slog.e("BackupManagerService", "Unable to get configuration intent from transport: " + e.getMessage());
            return null;
        }
    }

    public String getDestinationString(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getDestinationString");
        try {
            String string2 = this.mTransportManager.getTransportCurrentDestinationString(transportName);
            return string2;
        }
        catch (TransportNotRegisteredException e) {
            Slog.e("BackupManagerService", "Unable to get destination string from transport: " + e.getMessage());
            return null;
        }
    }

    public Intent getDataManagementIntent(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getDataManagementIntent");
        try {
            Intent intent = this.mTransportManager.getTransportDataManagementIntent(transportName);
            return intent;
        }
        catch (TransportNotRegisteredException e) {
            Slog.e("BackupManagerService", "Unable to get management intent from transport: " + e.getMessage());
            return null;
        }
    }

    public CharSequence getDataManagementLabel(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getDataManagementLabel");
        try {
            CharSequence label = this.mTransportManager.getTransportDataManagementLabel(transportName);
            return label;
        }
        catch (TransportNotRegisteredException e) {
            Slog.e("BackupManagerService", "Unable to get management label from transport: " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void agentConnected(String packageName, IBinder agentBinder) {
        Object object = this.mAgentConnectLock;
        synchronized (object) {
            if (Binder.getCallingUid() == 1000) {
                Slog.d("BackupManagerService", "agentConnected pkg=" + packageName + " agent=" + agentBinder);
                this.mConnectedAgent = IBackupAgent.Stub.asInterface(agentBinder);
                this.mConnecting = false;
            } else {
                Slog.w("BackupManagerService", "Non-system process uid=" + Binder.getCallingUid() + " claiming agent connected");
            }
            this.mAgentConnectLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void agentDisconnected(String packageName) {
        Object object = this.mAgentConnectLock;
        synchronized (object) {
            if (Binder.getCallingUid() == 1000) {
                this.mConnectedAgent = null;
                this.mConnecting = false;
            } else {
                Slog.w("BackupManagerService", "Non-system process uid=" + Binder.getCallingUid() + " claiming agent disconnected");
            }
            this.mAgentConnectLock.notifyAll();
        }
    }

    public void restoreAtInstall(String packageName, int token) {
        TransportClient transportClient;
        if (Binder.getCallingUid() != 1000) {
            Slog.w("BackupManagerService", "Non-system process uid=" + Binder.getCallingUid() + " attemping install-time restore");
            return;
        }
        boolean skip = false;
        long restoreSet = this.getAvailableRestoreToken(packageName);
        Slog.v("BackupManagerService", "restoreAtInstall pkg=" + packageName + " token=" + Integer.toHexString(token) + " restoreSet=" + Long.toHexString(restoreSet));
        if (restoreSet == 0L) {
            skip = true;
        }
        if ((transportClient = this.mTransportManager.getCurrentTransportClient("BMS.restoreAtInstall()")) == null) {
            Slog.w("BackupManagerService", "No transport client");
            skip = true;
        }
        if (!this.mAutoRestore) {
            Slog.w("BackupManagerService", "Non-restorable state: auto=" + this.mAutoRestore);
            skip = true;
        }
        if (!skip) {
            try {
                this.mWakelock.acquire();
                OnTaskFinishedListener listener = caller -> {
                    this.mTransportManager.disposeOfTransportClient(transportClient, caller);
                    this.mWakelock.release();
                };
                Message msg = this.mBackupHandler.obtainMessage(3);
                msg.obj = RestoreParams.createForRestoreAtInstall(transportClient, null, null, restoreSet, packageName, token, listener);
                this.mBackupHandler.sendMessage(msg);
            }
            catch (Exception e) {
                Slog.e("BackupManagerService", "Unable to contact transport: " + e.getMessage());
                skip = true;
            }
        }
        if (skip) {
            if (transportClient != null) {
                this.mTransportManager.disposeOfTransportClient(transportClient, "BMS.restoreAtInstall()");
            }
            Slog.v("BackupManagerService", "Finishing install immediately");
            try {
                this.mPackageManagerBinder.finishPackageInstall(token, false);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRestoreSession beginRestoreSession(String packageName, String transport) {
        Slog.v("BackupManagerService", "beginRestoreSession: pkg=" + packageName + " transport=" + transport);
        boolean needPermission = true;
        if (transport == null) {
            transport = this.mTransportManager.getCurrentTransportName();
            if (packageName != null) {
                PackageInfo app = null;
                try {
                    app = this.mPackageManager.getPackageInfoAsUser(packageName, 0, this.mUserId);
                }
                catch (PackageManager.NameNotFoundException nnf) {
                    Slog.w("BackupManagerService", "Asked to restore nonexistent pkg " + packageName);
                    throw new IllegalArgumentException("Package " + packageName + " not found");
                }
                if (app.applicationInfo.uid == Binder.getCallingUid()) {
                    needPermission = false;
                }
            }
        }
        if (needPermission) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "beginRestoreSession");
        } else {
            Slog.d("BackupManagerService", "restoring self on current transport; no permission needed");
        }
        UserBackupManagerService userBackupManagerService = this;
        synchronized (userBackupManagerService) {
            if (this.mActiveRestoreSession != null) {
                Slog.i("BackupManagerService", "Restore session requested but one already active");
                return null;
            }
            if (this.mBackupRunning) {
                Slog.i("BackupManagerService", "Restore session requested but currently running backups");
                return null;
            }
            this.mActiveRestoreSession = new ActiveRestoreSession(this, packageName, transport);
            this.mBackupHandler.sendEmptyMessageDelayed(8, this.mAgentTimeoutParameters.getRestoreAgentTimeoutMillis());
        }
        return this.mActiveRestoreSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRestoreSession(ActiveRestoreSession currentSession) {
        UserBackupManagerService userBackupManagerService = this;
        synchronized (userBackupManagerService) {
            if (currentSession != this.mActiveRestoreSession) {
                Slog.e("BackupManagerService", "ending non-current restore session");
            } else {
                Slog.v("BackupManagerService", "Clearing restore session and halting timeout");
                this.mActiveRestoreSession = null;
                this.mBackupHandler.removeMessages(8);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void opComplete(int token, long result) {
        Operation op = null;
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            op = this.mCurrentOperations.get(token);
            if (op != null) {
                if (op.state == -1) {
                    op = null;
                    this.mCurrentOperations.delete(token);
                } else if (op.state == 1) {
                    Slog.w("BackupManagerService", "Received duplicate ack for token=" + Integer.toHexString(token));
                    op = null;
                    this.mCurrentOperations.remove(token);
                } else if (op.state == 0) {
                    op.state = 1;
                }
            }
            this.mCurrentOpLock.notifyAll();
        }
        if (op != null && op.callback != null) {
            Pair<BackupRestoreTask, Long> callbackAndResult = Pair.create(op.callback, result);
            Message msg = this.mBackupHandler.obtainMessage(21, callbackAndResult);
            this.mBackupHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAppEligibleForBackup(String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "isAppEligibleForBackup");
        long oldToken = Binder.clearCallingIdentity();
        try {
            String callerLogString = "BMS.isAppEligibleForBackup";
            TransportClient transportClient = this.mTransportManager.getCurrentTransportClient(callerLogString);
            boolean eligible = AppBackupUtils.appIsRunningAndEligibleForBackupWithTransport(transportClient, packageName, this.mPackageManager, this.mUserId);
            if (transportClient != null) {
                this.mTransportManager.disposeOfTransportClient(transportClient, callerLogString);
            }
            boolean bl = eligible;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(oldToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] filterAppsEligibleForBackup(String[] packages) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "filterAppsEligibleForBackup");
        long oldToken = Binder.clearCallingIdentity();
        try {
            String callerLogString = "BMS.filterAppsEligibleForBackup";
            TransportClient transportClient = this.mTransportManager.getCurrentTransportClient(callerLogString);
            LinkedList<String> eligibleApps = new LinkedList<String>();
            for (String packageName : packages) {
                if (!AppBackupUtils.appIsRunningAndEligibleForBackupWithTransport(transportClient, packageName, this.mPackageManager, this.mUserId)) continue;
                eligibleApps.add(packageName);
            }
            if (transportClient != null) {
                this.mTransportManager.disposeOfTransportClient(transportClient, callerLogString);
            }
            String[] stringArray = eligibleApps.toArray(new String[eligibleApps.size()]);
            return stringArray;
        }
        finally {
            Binder.restoreCallingIdentity(oldToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        long identityToken = Binder.clearCallingIdentity();
        try {
            if (args != null) {
                for (String arg : args) {
                    if ("-h".equals(arg)) {
                        pw.println("'dumpsys backup' optional arguments:");
                        pw.println("  -h       : this help text");
                        pw.println("  a[gents] : dump information about defined backup agents");
                        pw.println("  users    : dump the list of users for which backup service is running");
                        return;
                    }
                    if ("agents".startsWith(arg)) {
                        this.dumpAgents(pw);
                        return;
                    }
                    if ("transportclients".equals(arg.toLowerCase())) {
                        this.mTransportManager.dumpTransportClients(pw);
                        return;
                    }
                    if (!"transportstats".equals(arg.toLowerCase())) continue;
                    this.mTransportManager.dumpTransportStats(pw);
                    return;
                }
            }
            this.dumpInternal(pw);
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
        }
    }

    private void dumpAgents(PrintWriter pw) {
        List<PackageInfo> agentPackages = this.allAgentPackages();
        pw.println("Defined backup agents:");
        for (PackageInfo pkg : agentPackages) {
            pw.print("  ");
            pw.print(pkg.packageName);
            pw.println(':');
            pw.print("      ");
            pw.println(pkg.applicationInfo.backupAgentName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInternal(PrintWriter pw) {
        Object object = this.mQueueLock;
        synchronized (object) {
            pw.println("Backup Manager is " + (this.mEnabled ? "enabled" : "disabled") + " / " + (!this.mSetupComplete ? "not " : "") + "setup complete / " + (this.mPendingInits.size() == 0 ? "not " : "") + "pending init");
            pw.println("Auto-restore is " + (this.mAutoRestore ? "enabled" : "disabled"));
            if (this.mBackupRunning) {
                pw.println("Backup currently running");
            }
            pw.println(this.isBackupOperationInProgress() ? "Backup in progress" : "No backups running");
            pw.println("Last backup pass started: " + this.mLastBackupPass + " (now = " + System.currentTimeMillis() + ')');
            pw.println("  next scheduled: " + KeyValueBackupJob.nextScheduled(this.mUserId));
            pw.println("Transport whitelist:");
            for (ComponentName componentName : this.mTransportManager.getTransportWhitelist()) {
                pw.print("    ");
                pw.println(componentName.flattenToShortString());
            }
            pw.println("Available transports:");
            String[] transports = this.listAllTransports();
            if (transports != null) {
                for (String t : transports) {
                    pw.println((t.equals(this.mTransportManager.getCurrentTransportName()) ? "  * " : "    ") + t);
                    try {
                        File dir = new File(this.mBaseStateDir, this.mTransportManager.getTransportDirName(t));
                        pw.println("       destination: " + this.mTransportManager.getTransportCurrentDestinationString(t));
                        pw.println("       intent: " + this.mTransportManager.getTransportConfigurationIntent(t));
                        for (File f : dir.listFiles()) {
                            pw.println("       " + f.getName() + " - " + f.length() + " state bytes");
                        }
                    }
                    catch (Exception e) {
                        Slog.e("BackupManagerService", "Error in transport", e);
                        pw.println("        Error: " + e);
                    }
                }
            }
            this.mTransportManager.dumpTransportClients(pw);
            pw.println("Pending init: " + this.mPendingInits.size());
            for (String s : this.mPendingInits) {
                pw.println("    " + s);
            }
            pw.print("Ancestral: ");
            pw.println(Long.toHexString(this.mAncestralToken));
            pw.print("Current:   ");
            pw.println(Long.toHexString(this.mCurrentToken));
            int n = this.mBackupParticipants.size();
            pw.println("Participants:");
            for (int i = 0; i < n; ++i) {
                int uid = this.mBackupParticipants.keyAt(i);
                pw.print("  uid: ");
                pw.println(uid);
                HashSet<String> participants = this.mBackupParticipants.valueAt(i);
                for (String app : participants) {
                    pw.println("    " + app);
                }
            }
            pw.println("Ancestral packages: " + (this.mAncestralPackages == null ? "none" : Integer.valueOf(this.mAncestralPackages.size())));
            if (this.mAncestralPackages != null) {
                for (String pkg : this.mAncestralPackages) {
                    pw.println("    " + pkg);
                }
            }
            Set<String> processedPackages = this.mProcessedPackagesJournal.getPackagesCopy();
            pw.println("Ever backed up: " + processedPackages.size());
            for (String pkg : processedPackages) {
                pw.println("    " + pkg);
            }
            pw.println("Pending key/value backup: " + this.mPendingBackups.size());
            for (BackupRequest req : this.mPendingBackups.values()) {
                pw.println("    " + req);
            }
            pw.println("Full backup queue:" + this.mFullBackupQueue.size());
            for (FullBackupEntry entry : this.mFullBackupQueue) {
                pw.print("    ");
                pw.print(entry.lastBackup);
                pw.print(" : ");
                pw.println(entry.packageName);
            }
        }
    }

    public IBackupManager getBackupManagerBinder() {
        return this.mBackupManagerBinder;
    }
}

