/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.encryption.chunking;

import com.android.internal.util.Preconditions;

final class ByteRange {
    private final long mStart;
    private final long mEnd;

    ByteRange(long start, long end) {
        Preconditions.checkArgument(start >= 0L);
        Preconditions.checkArgument(end >= start);
        this.mStart = start;
        this.mEnd = end;
    }

    long getStart() {
        return this.mStart;
    }

    long getEnd() {
        return this.mEnd;
    }

    int getLength() {
        return (int)(this.mEnd - this.mStart + 1L);
    }

    ByteRange extend(long length) {
        Preconditions.checkArgument(length > 0L);
        return new ByteRange(this.mStart, this.mEnd + length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteRange)) {
            return false;
        }
        ByteRange byteRange = (ByteRange)o;
        return this.mEnd == byteRange.mEnd && this.mStart == byteRange.mStart;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.mStart ^ this.mStart >>> 32);
        result = 31 * result + (int)(this.mEnd ^ this.mEnd >>> 32);
        return result;
    }

    public String toString() {
        return String.format("ByteRange{mStart=%d, mEnd=%d}", this.mStart, this.mEnd);
    }
}

