/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.encryption.chunking;

import com.android.internal.annotations.VisibleForTesting;
import com.android.server.backup.encryption.chunking.BackupWriter;
import com.android.server.backup.encryption.chunking.SingleStreamDiffScriptWriter;
import java.io.IOException;
import java.io.OutputStream;

public class DiffScriptBackupWriter
implements BackupWriter {
    private static final int ENCRYPTION_DIFF_SCRIPT_MAX_CHUNK_SIZE_BYTES = 0x100000;
    private final SingleStreamDiffScriptWriter mWriter;
    private long mBytesWritten;

    public static DiffScriptBackupWriter newInstance(OutputStream outputStream) {
        SingleStreamDiffScriptWriter writer = new SingleStreamDiffScriptWriter(outputStream, 0x100000);
        return new DiffScriptBackupWriter(writer);
    }

    @VisibleForTesting
    DiffScriptBackupWriter(SingleStreamDiffScriptWriter writer) {
        this.mWriter = writer;
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        for (byte b : bytes) {
            this.mWriter.writeByte(b);
        }
        this.mBytesWritten += (long)bytes.length;
    }

    @Override
    public void writeChunk(long start, int length) throws IOException {
        this.mWriter.writeChunk(start, length);
        this.mBytesWritten += (long)length;
    }

    @Override
    public long getBytesWritten() {
        return this.mBytesWritten;
    }

    @Override
    public void flush() throws IOException {
        this.mWriter.flush();
    }
}

