/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.encryption.chunking;

import com.android.server.backup.encryption.chunking.BackupWriter;
import com.android.server.backup.encryption.chunking.EncryptedChunk;
import com.android.server.backup.encryption.chunking.EncryptedChunkEncoder;
import com.android.server.backup.encryption.chunking.LengthlessEncryptedChunkEncoder;
import java.io.IOException;

public class InlineLengthsEncryptedChunkEncoder
implements EncryptedChunkEncoder {
    public static final int BYTES_LENGTH = 4;
    private final LengthlessEncryptedChunkEncoder mLengthlessEncryptedChunkEncoder = new LengthlessEncryptedChunkEncoder();

    @Override
    public void writeChunkToWriter(BackupWriter writer, EncryptedChunk chunk) throws IOException {
        int length = this.mLengthlessEncryptedChunkEncoder.getEncodedLengthOfChunk(chunk);
        writer.writeBytes(InlineLengthsEncryptedChunkEncoder.toByteArray(length));
        this.mLengthlessEncryptedChunkEncoder.writeChunkToWriter(writer, chunk);
    }

    @Override
    public int getEncodedLengthOfChunk(EncryptedChunk chunk) {
        return 4 + this.mLengthlessEncryptedChunkEncoder.getEncodedLengthOfChunk(chunk);
    }

    @Override
    public int getChunkOrderingType() {
        return 2;
    }

    static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }
}

