/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.encryption.chunking;

import com.android.server.backup.encryption.chunking.BackupWriter;
import com.android.server.backup.encryption.chunking.EncryptedChunk;
import com.android.server.backup.encryption.chunking.EncryptedChunkEncoder;
import java.io.IOException;

public class LengthlessEncryptedChunkEncoder
implements EncryptedChunkEncoder {
    @Override
    public void writeChunkToWriter(BackupWriter writer, EncryptedChunk chunk) throws IOException {
        writer.writeBytes(chunk.nonce());
        writer.writeBytes(chunk.encryptedBytes());
    }

    @Override
    public int getEncodedLengthOfChunk(EncryptedChunk chunk) {
        return chunk.nonce().length + chunk.encryptedBytes().length;
    }

    @Override
    public int getChunkOrderingType() {
        return 1;
    }
}

