/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.encryption.chunking;

import com.android.server.backup.encryption.chunking.BackupWriter;
import java.io.IOException;
import java.io.OutputStream;

public class RawBackupWriter
implements BackupWriter {
    private final OutputStream outputStream;
    private long bytesWritten;

    public RawBackupWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        this.outputStream.write(bytes);
        this.bytesWritten += (long)bytes.length;
    }

    @Override
    public void writeChunk(long start, int length) throws IOException {
        throw new UnsupportedOperationException("RawBackupWriter cannot write existing chunks");
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }
}

