/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.encryption.chunking;

import com.android.internal.util.Preconditions;
import com.android.server.backup.encryption.chunking.ByteRange;
import com.android.server.backup.encryption.chunking.DiffScriptWriter;
import com.android.server.backup.encryption.chunking.OutputStreamWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Locale;

public class SingleStreamDiffScriptWriter
implements DiffScriptWriter {
    static final byte LINE_SEPARATOR = 10;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final int mMaxNewByteChunkSize;
    private final OutputStream mOutputStream;
    private final byte[] mByteBuffer;
    private int mBufferSize = 0;
    private ByteRange mReusableChunk;

    public SingleStreamDiffScriptWriter(OutputStream outputStream, int maxNewByteChunkSize) {
        this.mOutputStream = outputStream;
        this.mMaxNewByteChunkSize = maxNewByteChunkSize;
        this.mByteBuffer = new byte[maxNewByteChunkSize];
    }

    @Override
    public void writeByte(byte b) throws IOException {
        if (this.mReusableChunk != null) {
            this.writeReusableChunk();
        }
        this.mByteBuffer[this.mBufferSize++] = b;
        if (this.mBufferSize == this.mMaxNewByteChunkSize) {
            this.writeByteBuffer();
        }
    }

    @Override
    public void writeChunk(long chunkStart, int chunkLength) throws IOException {
        Preconditions.checkArgument(chunkStart >= 0L);
        Preconditions.checkArgument(chunkLength > 0);
        if (this.mBufferSize != 0) {
            this.writeByteBuffer();
        }
        if (this.mReusableChunk != null && this.mReusableChunk.getEnd() + 1L == chunkStart) {
            this.mReusableChunk = this.mReusableChunk.extend(chunkLength);
        } else {
            this.writeReusableChunk();
            this.mReusableChunk = new ByteRange(chunkStart, chunkStart + (long)chunkLength - 1L);
        }
    }

    @Override
    public void flush() throws IOException {
        Preconditions.checkState(this.mBufferSize == 0 || this.mReusableChunk == null);
        if (this.mBufferSize != 0) {
            this.writeByteBuffer();
        }
        if (this.mReusableChunk != null) {
            this.writeReusableChunk();
        }
        this.mOutputStream.flush();
    }

    private void writeByteBuffer() throws IOException {
        this.mOutputStream.write(Integer.toString(this.mBufferSize).getBytes(UTF_8));
        this.mOutputStream.write(10);
        this.mOutputStream.write(this.mByteBuffer, 0, this.mBufferSize);
        this.mOutputStream.write(10);
        this.mBufferSize = 0;
    }

    private void writeReusableChunk() throws IOException {
        if (this.mReusableChunk != null) {
            this.mOutputStream.write(String.format(Locale.US, "%d-%d", this.mReusableChunk.getStart(), this.mReusableChunk.getEnd()).getBytes(UTF_8));
            this.mOutputStream.write(10);
            this.mReusableChunk = null;
        }
    }

    public static class Factory
    implements DiffScriptWriter.Factory {
        private final int mMaxNewByteChunkSize;
        private final OutputStreamWrapper mOutputStreamWrapper;

        public Factory(int maxNewByteChunkSize, OutputStreamWrapper outputStreamWrapper) {
            this.mMaxNewByteChunkSize = maxNewByteChunkSize;
            this.mOutputStreamWrapper = outputStreamWrapper;
        }

        @Override
        public SingleStreamDiffScriptWriter create(OutputStream outputStream) {
            if (this.mOutputStreamWrapper != null) {
                outputStream = this.mOutputStreamWrapper.wrap(outputStream);
            }
            return new SingleStreamDiffScriptWriter(outputStream, this.mMaxNewByteChunkSize);
        }
    }
}

