/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.encryption.chunking.cdc;

import com.android.internal.util.Preconditions;
import com.android.server.backup.encryption.chunking.Chunker;
import com.android.server.backup.encryption.chunking.cdc.FingerprintMixer;
import com.android.server.backup.encryption.chunking.cdc.RabinFingerprint64;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public class ContentDefinedChunker
implements Chunker {
    private static final int WINDOW_SIZE = 31;
    private static final byte DEFAULT_OUT_BYTE = 0;
    private final byte[] mChunkBuffer;
    private final RabinFingerprint64 mRabinFingerprint64;
    private final FingerprintMixer mFingerprintMixer;
    private final BreakpointPredicate mBreakpointPredicate;
    private final int mMinChunkSize;
    private final int mMaxChunkSize;

    public ContentDefinedChunker(int minChunkSize, int maxChunkSize, RabinFingerprint64 rabinFingerprint64, FingerprintMixer fingerprintMixer, BreakpointPredicate breakpointPredicate) {
        Preconditions.checkArgument(minChunkSize >= 31, "Minimum chunk size must be greater than window size.");
        Preconditions.checkArgument(maxChunkSize >= minChunkSize, "Maximum chunk size cannot be smaller than minimum chunk size.");
        this.mChunkBuffer = new byte[maxChunkSize];
        this.mRabinFingerprint64 = rabinFingerprint64;
        this.mBreakpointPredicate = breakpointPredicate;
        this.mFingerprintMixer = fingerprintMixer;
        this.mMinChunkSize = minChunkSize;
        this.mMaxChunkSize = maxChunkSize;
    }

    @Override
    public void chunkify(InputStream inputStream, Chunker.ChunkConsumer chunkConsumer) throws IOException, GeneralSecurityException {
        int chunkLength;
        int initialReadLength = this.mMinChunkSize - 31;
        while ((chunkLength = inputStream.read(this.mChunkBuffer, 0, initialReadLength)) != -1) {
            int b;
            long fingerprint = 0L;
            while ((b = inputStream.read()) != -1) {
                byte inByte = (byte)b;
                byte outByte = this.getCurrentWindowStartByte(chunkLength);
                this.mChunkBuffer[chunkLength++] = inByte;
                fingerprint = this.mRabinFingerprint64.computeFingerprint64(inByte, outByte, fingerprint);
                if (chunkLength < this.mMaxChunkSize && (chunkLength < this.mMinChunkSize || !this.mBreakpointPredicate.isBreakpoint(this.mFingerprintMixer.mix(fingerprint)))) continue;
                chunkConsumer.accept(Arrays.copyOf(this.mChunkBuffer, chunkLength));
                chunkLength = 0;
                break;
            }
            if (chunkLength <= 0) continue;
            chunkConsumer.accept(Arrays.copyOf(this.mChunkBuffer, chunkLength));
        }
    }

    private byte getCurrentWindowStartByte(int chunkLength) {
        if (chunkLength < this.mMinChunkSize) {
            return 0;
        }
        return this.mChunkBuffer[chunkLength - 31];
    }

    public static interface BreakpointPredicate {
        public boolean isBreakpoint(long var1);
    }
}

