/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.encryption.chunking.cdc;

import com.android.internal.util.Preconditions;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class Hkdf {
    private static final byte[] CONSTANT_01 = new byte[]{1};
    private static final String HmacSHA256 = "HmacSHA256";
    private static final String AES = "AES";

    static byte[] hkdf(byte[] masterKey, byte[] salt, byte[] data) throws InvalidKeyException {
        Preconditions.checkNotNull(masterKey, "HKDF requires master key to be set.");
        Preconditions.checkNotNull(salt, "HKDF requires a salt.");
        Preconditions.checkNotNull(data, "No data provided to HKDF.");
        return Hkdf.hkdfSha256Expand(Hkdf.hkdfSha256Extract(masterKey, salt), data);
    }

    private Hkdf() {
    }

    private static byte[] hkdfSha256Extract(byte[] inputKeyMaterial, byte[] salt) throws InvalidKeyException {
        Mac sha256;
        try {
            sha256 = Mac.getInstance(HmacSHA256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        sha256.init(new SecretKeySpec(salt, AES));
        return sha256.doFinal(inputKeyMaterial);
    }

    private static byte[] hkdfSha256Expand(byte[] pseudoRandomKey, byte[] info) throws InvalidKeyException {
        Mac sha256;
        try {
            sha256 = Mac.getInstance(HmacSHA256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        sha256.init(new SecretKeySpec(pseudoRandomKey, AES));
        sha256.update(info);
        sha256.update(CONSTANT_01);
        return sha256.doFinal();
    }
}

