/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.encryption.chunking.cdc;

import com.android.internal.util.Preconditions;
import com.android.server.backup.encryption.chunking.cdc.ContentDefinedChunker;

public class IsChunkBreakpoint
implements ContentDefinedChunker.BreakpointPredicate {
    private final int mLeadingZeros;
    private final long mBitmask;

    public IsChunkBreakpoint(long averageNumberOfTrialsUntilBreakpoint) {
        Preconditions.checkArgument(averageNumberOfTrialsUntilBreakpoint >= 0L, "Average number of trials must be non-negative");
        this.mLeadingZeros = (int)Math.round(IsChunkBreakpoint.log2(averageNumberOfTrialsUntilBreakpoint));
        this.mBitmask = -1L >>> this.mLeadingZeros ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public boolean isBreakpoint(long fingerprint) {
        return (fingerprint & this.mBitmask) == 0L;
    }

    public int getLeadingZeros() {
        return this.mLeadingZeros;
    }

    private static double log2(double x) {
        return Math.log(x) / Math.log(2.0);
    }
}

