/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.encryption.chunking.cdc;

public class RabinFingerprint64 {
    private static final long DEFAULT_IRREDUCIBLE_POLYNOMIAL_64 = 27L;
    private static final int POLYNOMIAL_DEGREE = 64;
    private static final int SLIDING_WINDOW_SIZE_BYTES = 31;
    private final long mPoly64;
    private final long[] mTableFP64 = new long[256];
    private final long[] mTableOutByte = new long[256];

    public RabinFingerprint64(long poly64) {
        this.mPoly64 = poly64;
    }

    public RabinFingerprint64() {
        this(27L);
        this.computeFingerprintTables64();
        this.computeFingerprintTables64Windowed();
    }

    public long computeFingerprint64(byte inChar, byte outChar, long fingerPrint) {
        return fingerPrint << 8 ^ (long)(inChar & 0xFF) ^ this.mTableFP64[(int)(fingerPrint >>> 56)] ^ this.mTableOutByte[outChar & 0xFF];
    }

    private void computeFingerprintTables64() {
        int i;
        long[] degreesRes64 = new long[64];
        degreesRes64[0] = this.mPoly64;
        for (i = 1; i < 64; ++i) {
            degreesRes64[i] = (degreesRes64[i - 1] & Long.MIN_VALUE) == 0L ? degreesRes64[i - 1] << 1 : degreesRes64[i - 1] << 1 ^ this.mPoly64;
        }
        for (i = 0; i < 256; ++i) {
            int currIndex = i;
            for (int j = 0; currIndex > 0 && j < 8; currIndex >>>= 1, ++j) {
                if ((currIndex & 1) != 1) continue;
                int n = i;
                this.mTableFP64[n] = this.mTableFP64[n] ^ degreesRes64[j];
            }
        }
    }

    private void computeFingerprintTables64Windowed() {
        int i;
        long[] degsRes64 = new long[8];
        degsRes64[0] = this.mPoly64;
        for (i = 65; i < 256; ++i) {
            degsRes64[i % 8] = (degsRes64[(i - 1) % 8] & Long.MIN_VALUE) == 0L ? degsRes64[(i - 1) % 8] << 1 : degsRes64[(i - 1) % 8] << 1 ^ this.mPoly64;
        }
        for (i = 0; i < 256; ++i) {
            int currIndex = i;
            for (int j = 0; currIndex > 0 && j < 8; currIndex >>>= 1, ++j) {
                if ((currIndex & 1) != 1) continue;
                int n = i;
                this.mTableOutByte[n] = this.mTableOutByte[n] ^ degsRes64[j];
            }
        }
    }
}

