/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.encryption.keys;

import android.content.Context;
import android.security.keystore.recovery.InternalRecoveryServiceException;
import android.security.keystore.recovery.RecoveryController;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import javax.crypto.SecretKey;

public class RecoverableKeyStoreSecondaryKey {
    private static final String TAG = "RecoverableKeyStoreSecondaryKey";
    private final String mAlias;
    private final SecretKey mSecretKey;

    public RecoverableKeyStoreSecondaryKey(String alias, SecretKey secretKey) {
        this.mAlias = Preconditions.checkNotNull(alias);
        this.mSecretKey = Preconditions.checkNotNull(secretKey);
    }

    public String getAlias() {
        return this.mAlias;
    }

    public SecretKey getSecretKey() {
        return this.mSecretKey;
    }

    @Status
    public int getStatus(Context context) {
        try {
            return this.getStatusInternal(context);
        }
        catch (InternalRecoveryServiceException e) {
            Slog.wtf(TAG, "Internal error getting recovery status", e);
            return 1;
        }
    }

    @Status
    private int getStatusInternal(Context context) throws InternalRecoveryServiceException {
        int status = RecoveryController.getInstance(context).getRecoveryStatus(this.mAlias);
        switch (status) {
            case 3: {
                return 3;
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 1;
            }
        }
        throw new InternalRecoveryServiceException("Unexpected status from getRecoveryStatus: " + status);
    }

    public static @interface Status {
        public static final int NOT_SYNCED = 1;
        public static final int SYNCED = 2;
        public static final int DESTROYED = 3;
    }
}

