/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.encryption.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.ArrayMap;
import com.android.server.backup.encryption.storage.BackupEncryptionDbHelper;
import com.android.server.backup.encryption.storage.EncryptionDbException;
import com.android.server.backup.encryption.storage.TertiaryKey;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class TertiaryKeysTable {
    private final BackupEncryptionDbHelper mHelper;

    TertiaryKeysTable(BackupEncryptionDbHelper helper) {
        this.mHelper = helper;
    }

    public long addKey(TertiaryKey tertiaryKey) throws EncryptionDbException {
        SQLiteDatabase db = this.mHelper.getWritableDatabaseSafe();
        ContentValues values = new ContentValues();
        values.put("secondary_key_alias", tertiaryKey.getSecondaryKeyAlias());
        values.put("package_name", tertiaryKey.getPackageName());
        values.put("wrapped_key_bytes", tertiaryKey.getWrappedKeyBytes());
        return db.replace("tertiary_keys", null, values);
    }

    public Optional<TertiaryKey> getKey(String secondaryKeyAlias, String packageName) throws EncryptionDbException {
        SQLiteDatabase db = this.mHelper.getReadableDatabaseSafe();
        String[] projection = new String[]{"_id", "secondary_key_alias", "package_name", "wrapped_key_bytes"};
        String selection = "secondary_key_alias = ? AND package_name = ?";
        String[] selectionArguments = new String[]{secondaryKeyAlias, packageName};
        try (Cursor cursor = db.query("tertiary_keys", projection, selection, selectionArguments, null, null, null);){
            int count = cursor.getCount();
            if (count == 0) {
                Optional<TertiaryKey> optional = Optional.empty();
                return optional;
            }
            cursor.moveToFirst();
            byte[] wrappedKeyBytes = cursor.getBlob(cursor.getColumnIndexOrThrow("wrapped_key_bytes"));
            Optional<TertiaryKey> optional = Optional.of(new TertiaryKey(secondaryKeyAlias, packageName, wrappedKeyBytes));
            return optional;
        }
    }

    public Map<String, TertiaryKey> getAllKeys(String secondaryKeyAlias) throws EncryptionDbException {
        SQLiteDatabase db = this.mHelper.getReadableDatabaseSafe();
        String[] projection = new String[]{"_id", "secondary_key_alias", "package_name", "wrapped_key_bytes"};
        String selection = "secondary_key_alias = ?";
        String[] selectionArguments = new String[]{secondaryKeyAlias};
        ArrayMap<String, TertiaryKey> keysByPackageName = new ArrayMap<String, TertiaryKey>();
        try (Cursor cursor = db.query("tertiary_keys", projection, selection, selectionArguments, null, null, null);){
            while (cursor.moveToNext()) {
                String packageName = cursor.getString(cursor.getColumnIndexOrThrow("package_name"));
                byte[] wrappedKeyBytes = cursor.getBlob(cursor.getColumnIndexOrThrow("wrapped_key_bytes"));
                keysByPackageName.put(packageName, new TertiaryKey(secondaryKeyAlias, packageName, wrappedKeyBytes));
            }
        }
        return Collections.unmodifiableMap(keysByPackageName);
    }
}

