/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.fullbackup;

import android.app.IBackupAgent;
import android.app.backup.FullBackupDataOutput;
import android.app.backup.IBackupCallback;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.util.Preconditions;
import com.android.server.AppWidgetBackupBridge;
import com.android.server.backup.BackupAgentTimeoutParameters;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.UserBackupManagerService;
import com.android.server.backup.fullbackup.AppMetadataBackupWriter;
import com.android.server.backup.fullbackup.FullBackupPreflight;
import com.android.server.backup.remote.RemoteCall;
import com.android.server.backup.utils.FullBackupUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class FullBackupEngine {
    private UserBackupManagerService backupManagerService;
    private OutputStream mOutput;
    private FullBackupPreflight mPreflightHook;
    private BackupRestoreTask mTimeoutMonitor;
    private IBackupAgent mAgent;
    private boolean mIncludeApks;
    private PackageInfo mPkg;
    private final long mQuota;
    private final int mOpToken;
    private final int mTransportFlags;
    private final BackupAgentTimeoutParameters mAgentTimeoutParameters;

    public FullBackupEngine(UserBackupManagerService backupManagerService, OutputStream output, FullBackupPreflight preflightHook, PackageInfo pkg, boolean alsoApks, BackupRestoreTask timeoutMonitor, long quota, int opToken, int transportFlags) {
        this.backupManagerService = backupManagerService;
        this.mOutput = output;
        this.mPreflightHook = preflightHook;
        this.mPkg = pkg;
        this.mIncludeApks = alsoApks;
        this.mTimeoutMonitor = timeoutMonitor;
        this.mQuota = quota;
        this.mOpToken = opToken;
        this.mTransportFlags = transportFlags;
        this.mAgentTimeoutParameters = Preconditions.checkNotNull(backupManagerService.getAgentTimeoutParameters(), "Timeout parameters cannot be null");
    }

    public int preflightCheck() throws RemoteException {
        if (this.mPreflightHook == null) {
            return 0;
        }
        if (this.initializeAgent()) {
            int result = this.mPreflightHook.preflightFullBackup(this.mPkg, this.mAgent);
            return result;
        }
        Slog.w("BackupManagerService", "Unable to bind to full agent for " + this.mPkg.packageName);
        return -1003;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int backupOnePackage() throws RemoteException {
        int result = -1003;
        if (this.initializeAgent()) {
            ParcelFileDescriptor[] pipes = null;
            try {
                pipes = ParcelFileDescriptor.createPipe();
                FullBackupRunner runner = new FullBackupRunner(this.backupManagerService, this.mPkg, this.mAgent, pipes[1], this.mOpToken, this.mIncludeApks);
                pipes[1].close();
                pipes[1] = null;
                Thread t = new Thread((Runnable)runner, "app-data-runner");
                t.start();
                FullBackupUtils.routeSocketDataToOutput(pipes[0], this.mOutput);
                if (!this.backupManagerService.waitUntilOperationComplete(this.mOpToken)) {
                    Slog.e("BackupManagerService", "Full backup failed on package " + this.mPkg.packageName);
                }
                result = 0;
            }
            catch (IOException e) {
                Slog.e("BackupManagerService", "Error backing up " + this.mPkg.packageName + ": " + e.getMessage());
                result = -1003;
            }
            finally {
                try {
                    this.mOutput.flush();
                    if (pipes != null) {
                        if (pipes[0] != null) {
                            pipes[0].close();
                        }
                        if (pipes[1] != null) {
                            pipes[1].close();
                        }
                    }
                }
                catch (IOException e) {
                    Slog.w("BackupManagerService", "Error bringing down backup stack");
                    result = -1000;
                }
            }
        } else {
            Slog.w("BackupManagerService", "Unable to bind to full agent for " + this.mPkg.packageName);
        }
        this.tearDown();
        return result;
    }

    public void sendQuotaExceeded(long backupDataBytes, long quotaBytes) {
        if (this.initializeAgent()) {
            try {
                RemoteCall.execute(callback -> this.mAgent.doQuotaExceeded(backupDataBytes, quotaBytes, (IBackupCallback)callback), this.mAgentTimeoutParameters.getQuotaExceededTimeoutMillis());
            }
            catch (RemoteException e) {
                Slog.e("BackupManagerService", "Remote exception while telling agent about quota exceeded");
            }
        }
    }

    private boolean initializeAgent() {
        if (this.mAgent == null) {
            this.mAgent = this.backupManagerService.bindToAgentSynchronous(this.mPkg.applicationInfo, 1);
        }
        return this.mAgent != null;
    }

    private void tearDown() {
        if (this.mPkg != null) {
            this.backupManagerService.tearDownAgentAndKill(this.mPkg.applicationInfo);
        }
    }

    class FullBackupRunner
    implements Runnable {
        private final int mUserId;
        private final PackageManager mPackageManager;
        private final PackageInfo mPackage;
        private final IBackupAgent mAgent;
        private final ParcelFileDescriptor mPipe;
        private final int mToken;
        private final boolean mIncludeApks;
        private final File mFilesDir;

        FullBackupRunner(UserBackupManagerService userBackupManagerService, PackageInfo packageInfo, IBackupAgent agent, ParcelFileDescriptor pipe, int token, boolean includeApks) throws IOException {
            this.mUserId = userBackupManagerService.getUserId();
            this.mPackageManager = FullBackupEngine.this.backupManagerService.getPackageManager();
            this.mPackage = packageInfo;
            this.mAgent = agent;
            this.mPipe = ParcelFileDescriptor.dup(pipe.getFileDescriptor());
            this.mToken = token;
            this.mIncludeApks = includeApks;
            this.mFilesDir = userBackupManagerService.getDataDir();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                FullBackupDataOutput output = new FullBackupDataOutput(this.mPipe, -1L, FullBackupEngine.this.mTransportFlags);
                AppMetadataBackupWriter appMetadataBackupWriter = new AppMetadataBackupWriter(output, this.mPackageManager);
                String packageName = this.mPackage.packageName;
                boolean isSharedStorage = "com.android.sharedstoragebackup".equals(packageName);
                boolean writeApk = this.shouldWriteApk(this.mPackage.applicationInfo, this.mIncludeApks, isSharedStorage);
                if (!isSharedStorage) {
                    File manifestFile = new File(this.mFilesDir, "_manifest");
                    appMetadataBackupWriter.backupManifest(this.mPackage, manifestFile, this.mFilesDir, writeApk);
                    manifestFile.delete();
                    byte[] widgetData = AppWidgetBackupBridge.getWidgetState(packageName, this.mUserId);
                    if (widgetData != null && widgetData.length > 0) {
                        File metadataFile = new File(this.mFilesDir, "_meta");
                        appMetadataBackupWriter.backupWidget(this.mPackage, metadataFile, this.mFilesDir, widgetData);
                        metadataFile.delete();
                    }
                }
                if (writeApk) {
                    appMetadataBackupWriter.backupApk(this.mPackage);
                    appMetadataBackupWriter.backupObb(this.mUserId, this.mPackage);
                }
                Slog.d("BackupManagerService", "Calling doFullBackup() on " + packageName);
                long timeout = isSharedStorage ? FullBackupEngine.this.mAgentTimeoutParameters.getSharedBackupAgentTimeoutMillis() : FullBackupEngine.this.mAgentTimeoutParameters.getFullBackupAgentTimeoutMillis();
                FullBackupEngine.this.backupManagerService.prepareOperationTimeout(this.mToken, timeout, FullBackupEngine.this.mTimeoutMonitor, 0);
                this.mAgent.doFullBackup(this.mPipe, FullBackupEngine.this.mQuota, this.mToken, FullBackupEngine.this.backupManagerService.getBackupManagerBinder(), FullBackupEngine.this.mTransportFlags);
            }
            catch (IOException e) {
                Slog.e("BackupManagerService", "Error running full backup for " + this.mPackage.packageName, e);
            }
            catch (RemoteException e) {
                Slog.e("BackupManagerService", "Remote agent vanished during full backup of " + this.mPackage.packageName, e);
            }
            finally {
                try {
                    this.mPipe.close();
                }
                catch (IOException e) {}
            }
        }

        private boolean shouldWriteApk(ApplicationInfo applicationInfo, boolean includeApks, boolean isSharedStorage) {
            boolean isSystemApp = (applicationInfo.flags & 1) != 0;
            boolean isUpdatedSystemApp = (applicationInfo.flags & 0x80) != 0;
            return includeApks && !isSharedStorage && (!isSystemApp || isUpdatedSystemApp);
        }
    }
}

