/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.internal;

import android.app.backup.RestoreSet;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.EventLog;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.backup.IBackupTransport;
import com.android.internal.util.Preconditions;
import com.android.server.backup.BackupAgentTimeoutParameters;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.DataChangedJournal;
import com.android.server.backup.TransportManager;
import com.android.server.backup.UserBackupManagerService;
import com.android.server.backup.fullbackup.PerformAdbBackupTask;
import com.android.server.backup.fullbackup.PerformFullTransportBackupTask;
import com.android.server.backup.internal.OnTaskFinishedListener;
import com.android.server.backup.internal.PerformClearTask;
import com.android.server.backup.keyvalue.BackupRequest;
import com.android.server.backup.keyvalue.KeyValueBackupTask;
import com.android.server.backup.params.AdbBackupParams;
import com.android.server.backup.params.AdbParams;
import com.android.server.backup.params.AdbRestoreParams;
import com.android.server.backup.params.BackupParams;
import com.android.server.backup.params.ClearParams;
import com.android.server.backup.params.ClearRetryParams;
import com.android.server.backup.params.RestoreGetSetsParams;
import com.android.server.backup.params.RestoreParams;
import com.android.server.backup.restore.ActiveRestoreSession;
import com.android.server.backup.restore.PerformAdbRestoreTask;
import com.android.server.backup.restore.PerformUnifiedRestoreTask;
import com.android.server.backup.transport.TransportClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Queue;

public class BackupHandler
extends Handler {
    public static final int MSG_RUN_BACKUP = 1;
    public static final int MSG_RUN_ADB_BACKUP = 2;
    public static final int MSG_RUN_RESTORE = 3;
    public static final int MSG_RUN_CLEAR = 4;
    public static final int MSG_RUN_GET_RESTORE_SETS = 6;
    public static final int MSG_RESTORE_SESSION_TIMEOUT = 8;
    public static final int MSG_FULL_CONFIRMATION_TIMEOUT = 9;
    public static final int MSG_RUN_ADB_RESTORE = 10;
    public static final int MSG_RETRY_INIT = 11;
    public static final int MSG_RETRY_CLEAR = 12;
    public static final int MSG_WIDGET_BROADCAST = 13;
    public static final int MSG_RUN_FULL_TRANSPORT_BACKUP = 14;
    public static final int MSG_REQUEST_BACKUP = 15;
    public static final int MSG_SCHEDULE_BACKUP_PACKAGE = 16;
    public static final int MSG_BACKUP_OPERATION_TIMEOUT = 17;
    public static final int MSG_RESTORE_OPERATION_TIMEOUT = 18;
    public static final int MSG_BACKUP_RESTORE_STEP = 20;
    public static final int MSG_OP_COMPLETE = 21;
    private final UserBackupManagerService backupManagerService;
    private final BackupAgentTimeoutParameters mAgentTimeoutParameters;

    public BackupHandler(UserBackupManagerService backupManagerService, Looper looper) {
        super(looper);
        this.backupManagerService = backupManagerService;
        this.mAgentTimeoutParameters = Preconditions.checkNotNull(backupManagerService.getAgentTimeoutParameters(), "Timeout parameters cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        TransportManager transportManager = this.backupManagerService.getTransportManager();
        switch (msg.what) {
            case 1: {
                IBackupTransport transport;
                this.backupManagerService.setLastBackupPass(System.currentTimeMillis());
                String callerLogString = "BH/MSG_RUN_BACKUP";
                TransportClient transportClient = transportManager.getCurrentTransportClient(callerLogString);
                IBackupTransport iBackupTransport = transport = transportClient != null ? transportClient.connect(callerLogString) : null;
                if (transport == null) {
                    if (transportClient != null) {
                        transportManager.disposeOfTransportClient(transportClient, callerLogString);
                    }
                    Slog.v("BackupManagerService", "Backup requested but no transport available");
                    Object object = this.backupManagerService.getQueueLock();
                    synchronized (object) {
                        this.backupManagerService.setBackupRunning(false);
                    }
                    this.backupManagerService.getWakelock().release();
                    break;
                }
                ArrayList<String> queue = new ArrayList<String>();
                DataChangedJournal oldJournal = this.backupManagerService.getJournal();
                Object object = this.backupManagerService.getQueueLock();
                synchronized (object) {
                    if (this.backupManagerService.getPendingBackups().size() > 0) {
                        for (BackupRequest b : this.backupManagerService.getPendingBackups().values()) {
                            queue.add(b.packageName);
                        }
                        Slog.v("BackupManagerService", "clearing pending backups");
                        this.backupManagerService.getPendingBackups().clear();
                        this.backupManagerService.setJournal(null);
                    }
                }
                boolean staged = true;
                if (queue.size() > 0) {
                    try {
                        OnTaskFinishedListener listener = caller -> transportManager.disposeOfTransportClient(transportClient, caller);
                        KeyValueBackupTask.start(this.backupManagerService, transportClient, transport.transportDirName(), queue, oldJournal, null, null, listener, Collections.emptyList(), false, false);
                    }
                    catch (Exception e) {
                        Slog.e("BackupManagerService", "Transport became unavailable attempting backup or error initializing backup task", e);
                        staged = false;
                    }
                } else {
                    Slog.v("BackupManagerService", "Backup requested but nothing pending");
                    staged = false;
                }
                if (staged) break;
                transportManager.disposeOfTransportClient(transportClient, callerLogString);
                Object object2 = this.backupManagerService.getQueueLock();
                synchronized (object2) {
                    this.backupManagerService.setBackupRunning(false);
                }
                this.backupManagerService.getWakelock().release();
                break;
            }
            case 20: {
                try {
                    BackupRestoreTask task = (BackupRestoreTask)msg.obj;
                    task.execute();
                }
                catch (ClassCastException e) {
                    Slog.e("BackupManagerService", "Invalid backup/restore task in flight, obj=" + msg.obj);
                }
                break;
            }
            case 21: {
                try {
                    Pair taskWithResult = (Pair)msg.obj;
                    ((BackupRestoreTask)taskWithResult.first).operationComplete((Long)taskWithResult.second);
                }
                catch (ClassCastException e) {
                    Slog.e("BackupManagerService", "Invalid completion in flight, obj=" + msg.obj);
                }
                break;
            }
            case 2: {
                AdbBackupParams params = (AdbBackupParams)msg.obj;
                PerformAdbBackupTask task = new PerformAdbBackupTask(this.backupManagerService, params.fd, params.observer, params.includeApks, params.includeObbs, params.includeShared, params.doWidgets, params.curPassword, params.encryptPassword, params.allApps, params.includeSystem, params.doCompress, params.includeKeyValue, params.packages, params.latch);
                new Thread((Runnable)task, "adb-backup").start();
                break;
            }
            case 14: {
                PerformFullTransportBackupTask task = (PerformFullTransportBackupTask)msg.obj;
                new Thread((Runnable)task, "transport-backup").start();
                break;
            }
            case 3: {
                RestoreParams params = (RestoreParams)msg.obj;
                Slog.d("BackupManagerService", "MSG_RUN_RESTORE observer=" + params.observer);
                PerformUnifiedRestoreTask task = new PerformUnifiedRestoreTask(this.backupManagerService, params.transportClient, params.observer, params.monitor, params.token, params.packageInfo, params.pmToken, params.isSystemRestore, params.filterSet, params.listener);
                Queue<PerformUnifiedRestoreTask> transport = this.backupManagerService.getPendingRestores();
                synchronized (transport) {
                    if (this.backupManagerService.isRestoreInProgress()) {
                        Slog.d("BackupManagerService", "Restore in progress, queueing.");
                        this.backupManagerService.getPendingRestores().add(task);
                    } else {
                        Slog.d("BackupManagerService", "Starting restore.");
                        this.backupManagerService.setRestoreInProgress(true);
                        Message restoreMsg = this.obtainMessage(20, task);
                        this.sendMessage(restoreMsg);
                    }
                    break;
                }
            }
            case 10: {
                AdbRestoreParams params = (AdbRestoreParams)msg.obj;
                PerformAdbRestoreTask task = new PerformAdbRestoreTask(this.backupManagerService, params.fd, params.curPassword, params.encryptPassword, params.observer, params.latch);
                new Thread((Runnable)task, "adb-restore").start();
                break;
            }
            case 4: {
                ClearParams params = (ClearParams)msg.obj;
                PerformClearTask task = new PerformClearTask(this.backupManagerService, params.transportClient, params.packageInfo, params.listener);
                task.run();
                break;
            }
            case 12: {
                ClearRetryParams params = (ClearRetryParams)msg.obj;
                this.backupManagerService.clearBackupData(params.transportName, params.packageName);
                break;
            }
            case 6: {
                RestoreSet[] sets = null;
                RestoreGetSetsParams params = (RestoreGetSetsParams)msg.obj;
                String callerLogString = "BH/MSG_RUN_GET_RESTORE_SETS";
                try {
                    IBackupTransport transport = params.transportClient.connectOrThrow(callerLogString);
                    sets = transport.getAvailableRestoreSets();
                    ActiveRestoreSession activeRestoreSession = params.session;
                    synchronized (activeRestoreSession) {
                        params.session.setRestoreSets(sets);
                    }
                    if (sets != null) break;
                    EventLog.writeEvent(2831, new Object[0]);
                    break;
                }
                catch (Exception e) {
                    Slog.e("BackupManagerService", "Error from transport getting set list: " + e.getMessage());
                    break;
                }
                finally {
                    if (params.observer != null) {
                        try {
                            params.observer.restoreSetsAvailable(sets);
                        }
                        catch (RemoteException re) {
                            Slog.e("BackupManagerService", "Unable to report listing to observer");
                        }
                        catch (Exception e) {
                            Slog.e("BackupManagerService", "Restore observer threw: " + e.getMessage());
                        }
                    }
                    this.removeMessages(8);
                    this.sendEmptyMessageDelayed(8, this.mAgentTimeoutParameters.getRestoreAgentTimeoutMillis());
                    params.listener.onFinished(callerLogString);
                }
            }
            case 17: 
            case 18: {
                Slog.d("BackupManagerService", "Timeout message received for token=" + Integer.toHexString(msg.arg1));
                this.backupManagerService.handleCancel(msg.arg1, false);
                break;
            }
            case 8: {
                UserBackupManagerService sets = this.backupManagerService;
                synchronized (sets) {
                    if (this.backupManagerService.getActiveRestoreSession() != null) {
                        Slog.w("BackupManagerService", "Restore session timed out; aborting");
                        this.backupManagerService.getActiveRestoreSession().markTimedOut();
                        ActiveRestoreSession activeRestoreSession = this.backupManagerService.getActiveRestoreSession();
                        Objects.requireNonNull(activeRestoreSession);
                        this.post(activeRestoreSession.new ActiveRestoreSession.EndRestoreRunnable(this.backupManagerService, this.backupManagerService.getActiveRestoreSession()));
                    }
                    break;
                }
            }
            case 9: {
                SparseArray<AdbParams> sets = this.backupManagerService.getAdbBackupRestoreConfirmations();
                synchronized (sets) {
                    AdbParams params = this.backupManagerService.getAdbBackupRestoreConfirmations().get(msg.arg1);
                    if (params != null) {
                        Slog.i("BackupManagerService", "Full backup/restore timed out waiting for user confirmation");
                        this.backupManagerService.signalAdbBackupRestoreCompletion(params);
                        this.backupManagerService.getAdbBackupRestoreConfirmations().delete(msg.arg1);
                        if (params.observer != null) {
                            try {
                                params.observer.onTimeout();
                            }
                            catch (RemoteException remoteException) {}
                        }
                    } else {
                        Slog.d("BackupManagerService", "couldn't find params for token " + msg.arg1);
                    }
                    break;
                }
            }
            case 13: {
                Intent intent = (Intent)msg.obj;
                this.backupManagerService.getContext().sendBroadcastAsUser(intent, UserHandle.SYSTEM);
                break;
            }
            case 15: {
                BackupParams params = (BackupParams)msg.obj;
                this.backupManagerService.setBackupRunning(true);
                this.backupManagerService.getWakelock().acquire();
                KeyValueBackupTask.start(this.backupManagerService, params.transportClient, params.dirName, params.kvPackages, null, params.observer, params.monitor, params.listener, params.fullPackages, true, params.nonIncrementalBackup);
                break;
            }
            case 16: {
                String pkgName = (String)msg.obj;
                this.backupManagerService.dataChangedImpl(pkgName);
                break;
            }
        }
    }
}

