/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.internal;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.util.Slog;
import com.android.server.backup.UserBackupManagerService;

public class RunBackupReceiver
extends BroadcastReceiver {
    private final UserBackupManagerService mUserBackupManagerService;

    public RunBackupReceiver(UserBackupManagerService userBackupManagerService) {
        this.mUserBackupManagerService = userBackupManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceive(Context context, Intent intent) {
        if (!"android.app.backup.intent.RUN".equals(intent.getAction())) {
            return;
        }
        Object object = this.mUserBackupManagerService.getQueueLock();
        synchronized (object) {
            if (this.mUserBackupManagerService.getPendingInits().size() > 0) {
                try {
                    PendingIntent runInitIntent = this.mUserBackupManagerService.getRunInitIntent();
                    this.mUserBackupManagerService.getAlarmManager().cancel(runInitIntent);
                    runInitIntent.send();
                }
                catch (PendingIntent.CanceledException ce) {
                    Slog.w("BackupManagerService", "Run init intent cancelled");
                }
            } else {
                if (!this.mUserBackupManagerService.isEnabled() || !this.mUserBackupManagerService.isSetupComplete()) {
                    Slog.w("BackupManagerService", "Backup pass but enabled=" + this.mUserBackupManagerService.isEnabled() + " setupComplete=" + this.mUserBackupManagerService.isSetupComplete());
                    return;
                }
                if (this.mUserBackupManagerService.isBackupRunning()) {
                    Slog.i("BackupManagerService", "Backup time but one already running");
                    return;
                }
                Slog.v("BackupManagerService", "Running a backup pass");
                this.mUserBackupManagerService.setBackupRunning(true);
                this.mUserBackupManagerService.getWakelock().acquire();
                Handler backupHandler = this.mUserBackupManagerService.getBackupHandler();
                Message message = backupHandler.obtainMessage(1);
                backupHandler.sendMessage(message);
            }
        }
    }
}

