/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;
import android.util.ArraySet;
import android.util.Slog;
import com.android.server.backup.UserBackupManagerService;
import com.android.server.backup.internal.OnTaskFinishedListener;
import com.android.server.backup.internal.PerformInitializeTask;

public class RunInitializeReceiver
extends BroadcastReceiver {
    private final UserBackupManagerService mUserBackupManagerService;

    public RunInitializeReceiver(UserBackupManagerService userBackupManagerService) {
        this.mUserBackupManagerService = userBackupManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceive(Context context, Intent intent) {
        if (!"android.app.backup.intent.INIT".equals(intent.getAction())) {
            return;
        }
        Object object = this.mUserBackupManagerService.getQueueLock();
        synchronized (object) {
            ArraySet<String> pendingInits = this.mUserBackupManagerService.getPendingInits();
            Slog.v("BackupManagerService", "Running a device init; " + pendingInits.size() + " pending");
            if (pendingInits.size() > 0) {
                String[] transports = pendingInits.toArray(new String[pendingInits.size()]);
                this.mUserBackupManagerService.clearPendingInits();
                PowerManager.WakeLock wakelock = this.mUserBackupManagerService.getWakelock();
                wakelock.acquire();
                OnTaskFinishedListener listener = caller -> wakelock.release();
                PerformInitializeTask task = new PerformInitializeTask(this.mUserBackupManagerService, transports, null, listener);
                this.mUserBackupManagerService.getBackupHandler().post(task);
            }
        }
    }
}

