/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.internal;

import android.content.Context;
import android.database.ContentObserver;
import android.os.Handler;
import com.android.server.backup.KeyValueBackupJob;
import com.android.server.backup.UserBackupManagerService;

public class SetupObserver
extends ContentObserver {
    private final UserBackupManagerService mUserBackupManagerService;
    private final Context mContext;
    private final int mUserId;

    public SetupObserver(UserBackupManagerService userBackupManagerService, Handler handler) {
        super(handler);
        this.mUserBackupManagerService = userBackupManagerService;
        this.mContext = userBackupManagerService.getContext();
        this.mUserId = userBackupManagerService.getUserId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChange(boolean selfChange) {
        boolean previousSetupComplete = this.mUserBackupManagerService.isSetupComplete();
        boolean newSetupComplete = UserBackupManagerService.getSetupCompleteSettingForUser(this.mContext, this.mUserId);
        boolean resolvedSetupComplete = previousSetupComplete || newSetupComplete;
        this.mUserBackupManagerService.setSetupComplete(resolvedSetupComplete);
        Object object = this.mUserBackupManagerService.getQueueLock();
        synchronized (object) {
            if (resolvedSetupComplete && !previousSetupComplete && this.mUserBackupManagerService.isEnabled()) {
                KeyValueBackupJob.schedule(this.mUserBackupManagerService.getUserId(), this.mContext, this.mUserBackupManagerService.getConstants());
                this.mUserBackupManagerService.scheduleNextFullBackupJob(0L);
            }
        }
    }
}

