/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.keyvalue;

import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IBackupObserver;
import android.content.pm.PackageInfo;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.EventLogTags;
import com.android.server.backup.DataChangedJournal;
import com.android.server.backup.UserBackupManagerService;
import com.android.server.backup.remote.RemoteResult;
import com.android.server.backup.utils.BackupManagerMonitorUtils;
import com.android.server.backup.utils.BackupObserverUtils;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

@VisibleForTesting
public class KeyValueBackupReporter {
    @VisibleForTesting
    static final String TAG = "KeyValueBackupTask";
    private static final boolean DEBUG = true;
    @VisibleForTesting
    static final boolean MORE_DEBUG = false;
    private final UserBackupManagerService mBackupManagerService;
    private final IBackupObserver mObserver;
    private IBackupManagerMonitor mMonitor;

    static void onNewThread(String threadName) {
        Slog.d(TAG, "Spinning thread " + threadName);
    }

    KeyValueBackupReporter(UserBackupManagerService backupManagerService, IBackupObserver observer, IBackupManagerMonitor monitor) {
        this.mBackupManagerService = backupManagerService;
        this.mObserver = observer;
        this.mMonitor = monitor;
    }

    IBackupManagerMonitor getMonitor() {
        return this.mMonitor;
    }

    IBackupObserver getObserver() {
        return this.mObserver;
    }

    void onSkipBackup() {
        Slog.d(TAG, "Skipping backup since one is already in progress");
    }

    void onEmptyQueueAtStart() {
        Slog.w(TAG, "Backup begun with an empty queue, nothing to do");
    }

    void onQueueReady(List<String> queue) {
        Slog.v(TAG, "Beginning backup of " + queue.size() + " targets");
    }

    void onTransportReady(String transportName) {
        EventLog.writeEvent(2821, transportName);
    }

    void onInitializeTransport(String transportName) {
        Slog.i(TAG, "Initializing transport and resetting backup state");
    }

    void onTransportInitialized(int status) {
        if (status == 0) {
            EventLog.writeEvent(2827, new Object[0]);
        } else {
            EventLog.writeEvent(2822, "(initialize)");
            Slog.e(TAG, "Transport error in initializeDevice()");
        }
    }

    void onInitializeTransportError(Exception e) {
        Slog.e(TAG, "Error during initialization", e);
    }

    void onSkipPm() {
        Slog.d(TAG, "Skipping backup of PM metadata");
    }

    void onExtractPmAgentDataError(Exception e) {
        Slog.e(TAG, "Error during PM metadata backup", e);
    }

    void onStartPackageBackup(String packageName) {
        Slog.d(TAG, "Starting key-value backup of " + packageName);
    }

    void onPackageNotEligibleForBackup(String packageName) {
        Slog.i(TAG, "Package " + packageName + " no longer supports backup, skipping");
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -2001);
    }

    void onPackageEligibleForFullBackup(String packageName) {
        Slog.i(TAG, "Package " + packageName + " performs full-backup rather than key-value, skipping");
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -2001);
    }

    void onPackageStopped(String packageName) {
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -2001);
    }

    void onAgentUnknown(String packageName) {
        Slog.d(TAG, "Package does not exist, skipping");
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -2002);
    }

    void onBindAgentError(String packageName, SecurityException e) {
        Slog.d(TAG, "Error in bind/backup", e);
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -1003);
    }

    void onAgentError(String packageName) {
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -1003);
    }

    void onExtractAgentData(String packageName) {
        Slog.d(TAG, "Invoking agent on " + packageName);
    }

    void onAgentFilesReady(File backupDataFile) {
    }

    void onRestoreconFailed(File backupDataFile) {
        Slog.e(TAG, "SELinux restorecon failed on " + backupDataFile);
    }

    void onCallAgentDoBackupError(String packageName, boolean callingAgent, Exception e) {
        if (callingAgent) {
            Slog.e(TAG, "Error invoking agent on " + packageName + ": " + e);
            BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -1003);
        } else {
            Slog.e(TAG, "Error before invoking agent on " + packageName + ": " + e);
        }
        EventLog.writeEvent(2823, packageName, e.toString());
    }

    void onFailAgentError(String packageName) {
        Slog.w(TAG, "Error conveying failure to " + packageName);
    }

    void onAgentIllegalKey(PackageInfo packageInfo, String key) {
        String packageName = packageInfo.packageName;
        EventLog.writeEvent(2823, packageName, "bad key");
        this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 5, packageInfo, 3, BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_ILLEGAL_KEY", key));
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -1003);
    }

    void onAgentDataError(String packageName, IOException e) {
        Slog.w(TAG, "Unable to read/write agent data for " + packageName + ": " + e);
    }

    void onDigestError(NoSuchAlgorithmException e) {
        Slog.e(TAG, "Unable to use SHA-1!");
    }

    void onWriteWidgetData(boolean priorStateExists, byte[] widgetState) {
    }

    void onTransportPerformBackup(String packageName) {
    }

    void onEmptyData(PackageInfo packageInfo) {
        this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 7, packageInfo, 3, null);
    }

    void onPackageBackupComplete(String packageName, long size) {
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, 0);
        EventLog.writeEvent(2824, packageName, size);
        this.mBackupManagerService.logBackupComplete(packageName);
    }

    void onPackageBackupRejected(String packageName) {
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -1002);
        EventLogTags.writeBackupAgentFailure(packageName, "Transport rejected");
    }

    void onPackageBackupQuotaExceeded(String packageName) {
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -1005);
        EventLog.writeEvent(2829, packageName);
    }

    void onAgentDoQuotaExceededError(Exception e) {
        Slog.e(TAG, "Unable to notify about quota exceeded: " + e);
    }

    void onPackageBackupNonIncrementalRequired(PackageInfo packageInfo) {
        Slog.i(TAG, "Transport lost data, retrying package");
        BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 51, packageInfo, 1, null);
    }

    void onPackageBackupNonIncrementalAndNonIncrementalRequired(String packageName) {
        Slog.e(TAG, "Transport requested non-incremental but already the case");
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -1000);
        EventLog.writeEvent(2822, packageName);
    }

    void onPackageBackupTransportFailure(String packageName) {
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -1000);
        EventLog.writeEvent(2822, packageName);
    }

    void onPackageBackupTransportError(String packageName, Exception e) {
        Slog.e(TAG, "Transport error backing up " + packageName, e);
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -1000);
        EventLog.writeEvent(2822, packageName);
    }

    void onCloseFileDescriptorError(String logName) {
        Slog.w(TAG, "Error closing " + logName + " file-descriptor");
    }

    void onCancel() {
    }

    void onAgentTimedOut(PackageInfo packageInfo) {
        String packageName = this.getPackageName(packageInfo);
        Slog.i(TAG, "Agent " + packageName + " timed out");
        EventLog.writeEvent(2823, packageName);
        this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 21, packageInfo, 2, BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_CANCEL_ALL", false));
    }

    void onAgentCancelled(PackageInfo packageInfo) {
        String packageName = this.getPackageName(packageInfo);
        Slog.i(TAG, "Cancel backing up " + packageName);
        EventLog.writeEvent(2823, packageName);
        this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 21, packageInfo, 2, BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_CANCEL_ALL", true));
    }

    void onAgentResultError(PackageInfo packageInfo) {
        String packageName = this.getPackageName(packageInfo);
        BackupObserverUtils.sendBackupOnPackageResult(this.mObserver, packageName, -1003);
        EventLog.writeEvent(2823, packageName, "result error");
        Slog.w(TAG, "Agent " + packageName + " error in onBackup()");
    }

    private String getPackageName(PackageInfo packageInfo) {
        return packageInfo != null ? packageInfo.packageName : "no_package_yet";
    }

    void onRevertTask() {
    }

    void onTransportRequestBackupTimeError(Exception e) {
        Slog.w(TAG, "Unable to contact transport for recommended backoff: " + e);
    }

    void onRemoteCallReturned(RemoteResult result, String logIdentifier) {
    }

    void onJournalDeleteFailed(DataChangedJournal journal) {
        Slog.e(TAG, "Unable to remove backup journal file " + journal);
    }

    void onSetCurrentTokenError(Exception e) {
        Slog.e(TAG, "Transport threw reporting restore set: " + e);
    }

    void onTransportNotInitialized() {
    }

    void onPendingInitializeTransportError(Exception e) {
        Slog.w(TAG, "Failed to query transport name for pending init: " + e);
    }

    void onBackupFinished(int status) {
        BackupObserverUtils.sendBackupFinished(this.mObserver, status);
    }

    void onStartFullBackup(List<String> pendingFullBackups) {
        Slog.d(TAG, "Starting full backups for: " + pendingFullBackups);
    }

    void onTaskFinished() {
        Slog.i(TAG, "K/V backup pass finished");
    }
}

