/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.keyvalue;

import android.app.IBackupAgent;
import android.app.backup.BackupAgent;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.IBackupCallback;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IBackupObserver;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.ConditionVariable;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.WorkSource;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.backup.IBackupTransport;
import com.android.internal.util.Preconditions;
import com.android.server.AppWidgetBackupBridge;
import com.android.server.backup.BackupAgentTimeoutParameters;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.DataChangedJournal;
import com.android.server.backup.KeyValueBackupJob;
import com.android.server.backup.TransportManager;
import com.android.server.backup.UserBackupManagerService;
import com.android.server.backup.fullbackup.PerformFullTransportBackupTask;
import com.android.server.backup.internal.OnTaskFinishedListener;
import com.android.server.backup.internal.Operation;
import com.android.server.backup.keyvalue.AgentException;
import com.android.server.backup.keyvalue.BackupException;
import com.android.server.backup.keyvalue.KeyValueBackupReporter;
import com.android.server.backup.keyvalue.TaskException;
import com.android.server.backup.remote.RemoteCall;
import com.android.server.backup.remote.RemoteCallable;
import com.android.server.backup.remote.RemoteResult;
import com.android.server.backup.transport.TransportClient;
import com.android.server.backup.utils.AppBackupUtils;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class KeyValueBackupTask
implements BackupRestoreTask,
Runnable {
    private static final int THREAD_PRIORITY = 10;
    private static final AtomicInteger THREAD_COUNT = new AtomicInteger();
    private static final String BLANK_STATE_FILE_NAME = "blank_state";
    private static final String PM_PACKAGE = "@pm@";
    @VisibleForTesting
    public static final String STAGING_FILE_SUFFIX = ".data";
    @VisibleForTesting
    public static final String NEW_STATE_FILE_SUFFIX = ".new";
    private final UserBackupManagerService mBackupManagerService;
    private final PackageManager mPackageManager;
    private final TransportManager mTransportManager;
    private final TransportClient mTransportClient;
    private final BackupAgentTimeoutParameters mAgentTimeoutParameters;
    private final KeyValueBackupReporter mReporter;
    private final OnTaskFinishedListener mTaskFinishedListener;
    private final boolean mUserInitiated;
    private final boolean mNonIncremental;
    private final int mCurrentOpToken;
    private final int mUserId;
    private final File mStateDirectory;
    private final File mDataDirectory;
    private final File mBlankStateFile;
    private final List<String> mOriginalQueue;
    private final List<String> mQueue;
    private final List<String> mPendingFullBackups;
    private final Object mQueueLock;
    private final DataChangedJournal mJournal;
    private PerformFullTransportBackupTask mFullBackupTask;
    private IBackupAgent mAgent;
    private PackageInfo mCurrentPackage;
    private File mSavedStateFile;
    private File mBackupDataFile;
    private File mNewStateFile;
    private ParcelFileDescriptor mSavedState;
    private ParcelFileDescriptor mBackupData;
    private ParcelFileDescriptor mNewState;
    private boolean mHasDataToBackup;
    private final ConditionVariable mCancelAcknowledged = new ConditionVariable(false);
    private volatile boolean mCancelled = false;
    private volatile RemoteCall mPendingCall;

    public static KeyValueBackupTask start(UserBackupManagerService backupManagerService, TransportClient transportClient, String transportDirName, List<String> queue, DataChangedJournal dataChangedJournal, IBackupObserver observer, IBackupManagerMonitor monitor, OnTaskFinishedListener listener, List<String> pendingFullBackups, boolean userInitiated, boolean nonIncremental) {
        KeyValueBackupReporter reporter = new KeyValueBackupReporter(backupManagerService, observer, monitor);
        KeyValueBackupTask task = new KeyValueBackupTask(backupManagerService, transportClient, transportDirName, queue, dataChangedJournal, reporter, listener, pendingFullBackups, userInitiated, nonIncremental);
        Thread thread = new Thread((Runnable)task, "key-value-backup-" + THREAD_COUNT.incrementAndGet());
        thread.start();
        KeyValueBackupReporter.onNewThread(thread.getName());
        return task;
    }

    @VisibleForTesting
    public KeyValueBackupTask(UserBackupManagerService backupManagerService, TransportClient transportClient, String transportDirName, List<String> queue, DataChangedJournal journal, KeyValueBackupReporter reporter, OnTaskFinishedListener taskFinishedListener, List<String> pendingFullBackups, boolean userInitiated, boolean nonIncremental) {
        this.mBackupManagerService = backupManagerService;
        this.mTransportManager = backupManagerService.getTransportManager();
        this.mPackageManager = backupManagerService.getPackageManager();
        this.mTransportClient = transportClient;
        this.mOriginalQueue = queue;
        this.mQueue = new ArrayList<String>(queue);
        this.mJournal = journal;
        this.mReporter = reporter;
        this.mTaskFinishedListener = taskFinishedListener;
        this.mPendingFullBackups = pendingFullBackups;
        this.mUserInitiated = userInitiated;
        this.mNonIncremental = nonIncremental;
        this.mAgentTimeoutParameters = Preconditions.checkNotNull(backupManagerService.getAgentTimeoutParameters(), "Timeout parameters cannot be null");
        this.mStateDirectory = new File(backupManagerService.getBaseStateDir(), transportDirName);
        this.mDataDirectory = this.mBackupManagerService.getDataDir();
        this.mCurrentOpToken = backupManagerService.generateRandomIntegerToken();
        this.mQueueLock = this.mBackupManagerService.getQueueLock();
        this.mBlankStateFile = new File(this.mStateDirectory, BLANK_STATE_FILE_NAME);
        this.mUserId = backupManagerService.getUserId();
    }

    private void registerTask() {
        this.mBackupManagerService.putOperation(this.mCurrentOpToken, new Operation(0, this, 2));
    }

    private void unregisterTask() {
        this.mBackupManagerService.removeOperation(this.mCurrentOpToken);
    }

    @Override
    public void run() {
        Process.setThreadPriority(10);
        this.mHasDataToBackup = false;
        int status = 0;
        try {
            this.startTask();
            while (!this.mQueue.isEmpty() && !this.mCancelled) {
                String packageName = this.mQueue.remove(0);
                try {
                    if (PM_PACKAGE.equals(packageName)) {
                        this.backupPm();
                        continue;
                    }
                    this.backupPackage(packageName);
                }
                catch (AgentException e) {
                    if (!e.isTransitory()) continue;
                    this.mBackupManagerService.dataChangedImpl(packageName);
                }
            }
        }
        catch (TaskException e) {
            if (e.isStateCompromised()) {
                this.mBackupManagerService.resetBackupState(this.mStateDirectory);
            }
            this.revertTask();
            status = e.getStatus();
        }
        this.finishTask(status);
    }

    private int sendDataToTransport(PackageInfo packageInfo) throws AgentException, TaskException {
        try {
            return this.sendDataToTransport();
        }
        catch (IOException e) {
            this.mReporter.onAgentDataError(packageInfo.packageName, e);
            throw TaskException.causedBy(e);
        }
    }

    @Override
    public void execute() {
    }

    @Override
    public void operationComplete(long unusedResult) {
    }

    private void startTask() throws TaskException {
        boolean backupPm;
        if (this.mBackupManagerService.isBackupOperationInProgress()) {
            this.mReporter.onSkipBackup();
            throw TaskException.create();
        }
        this.mFullBackupTask = this.createFullBackupTask(this.mPendingFullBackups);
        this.registerTask();
        if (this.mQueue.isEmpty() && this.mPendingFullBackups.isEmpty()) {
            this.mReporter.onEmptyQueueAtStart();
            return;
        }
        boolean bl = backupPm = this.mQueue.remove(PM_PACKAGE) || !this.mNonIncremental;
        if (backupPm) {
            this.mQueue.add(0, PM_PACKAGE);
        } else {
            this.mReporter.onSkipPm();
        }
        this.mReporter.onQueueReady(this.mQueue);
        File pmState = new File(this.mStateDirectory, PM_PACKAGE);
        try {
            IBackupTransport transport = this.mTransportClient.connectOrThrow("KVBT.startTask()");
            String transportName = transport.name();
            this.mReporter.onTransportReady(transportName);
            if (pmState.length() <= 0L) {
                this.mReporter.onInitializeTransport(transportName);
                this.mBackupManagerService.resetBackupState(this.mStateDirectory);
                int status = transport.initializeDevice();
                this.mReporter.onTransportInitialized(status);
                if (status != 0) {
                    throw TaskException.stateCompromised();
                }
            }
        }
        catch (TaskException e) {
            throw e;
        }
        catch (Exception e) {
            this.mReporter.onInitializeTransportError(e);
            throw TaskException.stateCompromised();
        }
    }

    private PerformFullTransportBackupTask createFullBackupTask(List<String> packages) {
        return new PerformFullTransportBackupTask(this.mBackupManagerService, this.mTransportClient, null, packages.toArray(new String[packages.size()]), false, null, new CountDownLatch(1), this.mReporter.getObserver(), this.mReporter.getMonitor(), this.mTaskFinishedListener, this.mUserInitiated);
    }

    private void backupPm() throws TaskException {
        this.mReporter.onStartPackageBackup(PM_PACKAGE);
        this.mCurrentPackage = new PackageInfo();
        this.mCurrentPackage.packageName = PM_PACKAGE;
        try {
            this.extractPmAgentData(this.mCurrentPackage);
            int status = this.sendDataToTransport(this.mCurrentPackage);
            this.cleanUpAgentForTransportStatus(status);
        }
        catch (AgentException | TaskException e) {
            this.mReporter.onExtractPmAgentDataError(e);
            this.cleanUpAgentForError(e);
            throw TaskException.stateCompromised(e);
        }
    }

    private void backupPackage(String packageName) throws AgentException, TaskException {
        this.mReporter.onStartPackageBackup(packageName);
        this.mCurrentPackage = this.getPackageForBackup(packageName);
        try {
            this.extractAgentData(this.mCurrentPackage);
            int status = this.sendDataToTransport(this.mCurrentPackage);
            this.cleanUpAgentForTransportStatus(status);
        }
        catch (AgentException | TaskException e) {
            this.cleanUpAgentForError(e);
            throw e;
        }
    }

    private PackageInfo getPackageForBackup(String packageName) throws AgentException {
        PackageInfo packageInfo;
        try {
            packageInfo = this.mPackageManager.getPackageInfoAsUser(packageName, 0x8000000, this.mUserId);
        }
        catch (PackageManager.NameNotFoundException e) {
            this.mReporter.onAgentUnknown(packageName);
            throw AgentException.permanent(e);
        }
        ApplicationInfo applicationInfo = packageInfo.applicationInfo;
        if (!AppBackupUtils.appIsEligibleForBackup(applicationInfo, this.mUserId)) {
            this.mReporter.onPackageNotEligibleForBackup(packageName);
            throw AgentException.permanent();
        }
        if (AppBackupUtils.appGetsFullBackup(packageInfo)) {
            this.mReporter.onPackageEligibleForFullBackup(packageName);
            throw AgentException.permanent();
        }
        if (AppBackupUtils.appIsStopped(applicationInfo)) {
            this.mReporter.onPackageStopped(packageName);
            throw AgentException.permanent();
        }
        return packageInfo;
    }

    private IBackupAgent bindAgent(PackageInfo packageInfo) throws AgentException {
        IBackupAgent agent;
        String packageName = packageInfo.packageName;
        try {
            agent = this.mBackupManagerService.bindToAgentSynchronous(packageInfo.applicationInfo, 0);
            if (agent == null) {
                this.mReporter.onAgentError(packageName);
                throw AgentException.transitory();
            }
        }
        catch (SecurityException e) {
            this.mReporter.onBindAgentError(packageName, e);
            throw AgentException.transitory(e);
        }
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishTask(int status) {
        for (String packageName : this.mQueue) {
            this.mBackupManagerService.dataChangedImpl(packageName);
        }
        if (this.mJournal != null && !this.mJournal.delete()) {
            this.mReporter.onJournalDeleteFailed(this.mJournal);
        }
        String callerLogString = "KVBT.finishTask()";
        long currentToken = this.mBackupManagerService.getCurrentToken();
        if (this.mHasDataToBackup && status == 0 && currentToken == 0L) {
            try {
                IBackupTransport transport = this.mTransportClient.connectOrThrow(callerLogString);
                this.mBackupManagerService.setCurrentToken(transport.getCurrentRestoreSet());
                this.mBackupManagerService.writeRestoreTokens();
            }
            catch (Exception e) {
                this.mReporter.onSetCurrentTokenError(e);
            }
        }
        Object object = this.mQueueLock;
        synchronized (object) {
            this.mBackupManagerService.setBackupRunning(false);
            if (status == -1001) {
                this.mReporter.onTransportNotInitialized();
                try {
                    this.triggerTransportInitializationLocked();
                }
                catch (Exception e) {
                    this.mReporter.onPendingInitializeTransportError(e);
                    status = -1000;
                }
            }
        }
        this.unregisterTask();
        this.mReporter.onTaskFinished();
        if (this.mCancelled) {
            this.mCancelAcknowledged.open();
        }
        if (!this.mCancelled && status == 0 && this.mFullBackupTask != null && !this.mPendingFullBackups.isEmpty()) {
            this.mReporter.onStartFullBackup(this.mPendingFullBackups);
            new Thread((Runnable)this.mFullBackupTask, "full-transport-requested").start();
            return;
        }
        if (this.mFullBackupTask != null) {
            this.mFullBackupTask.unregisterTask();
        }
        this.mTaskFinishedListener.onFinished(callerLogString);
        this.mReporter.onBackupFinished(this.getBackupFinishedStatus(this.mCancelled, status));
        this.mBackupManagerService.getWakelock().release();
    }

    private int getBackupFinishedStatus(boolean cancelled, int transportStatus) {
        if (cancelled) {
            return -2003;
        }
        switch (transportStatus) {
            case -1005: 
            case -1002: 
            case 0: {
                return 0;
            }
        }
        return -1000;
    }

    @GuardedBy(value={"mQueueLock"})
    private void triggerTransportInitializationLocked() throws Exception {
        IBackupTransport transport = this.mTransportClient.connectOrThrow("KVBT.triggerTransportInitializationLocked");
        this.mBackupManagerService.getPendingInits().add(transport.name());
        this.deletePmStateFile();
        this.mBackupManagerService.backupNow();
    }

    private void deletePmStateFile() {
        new File(this.mStateDirectory, PM_PACKAGE).delete();
    }

    private void extractPmAgentData(PackageInfo packageInfo) throws AgentException, TaskException {
        Preconditions.checkArgument(packageInfo.packageName.equals(PM_PACKAGE));
        BackupAgent pmAgent = this.mBackupManagerService.makeMetadataAgent();
        this.mAgent = IBackupAgent.Stub.asInterface(pmAgent.onBind());
        this.extractAgentData(packageInfo, this.mAgent);
    }

    private void extractAgentData(PackageInfo packageInfo) throws AgentException, TaskException {
        this.mBackupManagerService.setWorkSource(new WorkSource(packageInfo.applicationInfo.uid));
        try {
            this.mAgent = this.bindAgent(packageInfo);
            this.extractAgentData(packageInfo, this.mAgent);
        }
        finally {
            this.mBackupManagerService.setWorkSource(null);
        }
    }

    private void extractAgentData(PackageInfo packageInfo, IBackupAgent agent) throws AgentException, TaskException {
        RemoteResult agentResult;
        String packageName = packageInfo.packageName;
        this.mReporter.onExtractAgentData(packageName);
        this.mSavedStateFile = new File(this.mStateDirectory, packageName);
        this.mBackupDataFile = new File(this.mDataDirectory, packageName + STAGING_FILE_SUFFIX);
        this.mNewStateFile = new File(this.mStateDirectory, packageName + NEW_STATE_FILE_SUFFIX);
        this.mReporter.onAgentFilesReady(this.mBackupDataFile);
        boolean callingAgent = false;
        try {
            File savedStateFileForAgent = this.mNonIncremental ? this.mBlankStateFile : this.mSavedStateFile;
            this.mSavedState = ParcelFileDescriptor.open(savedStateFileForAgent, 0x18000000);
            this.mBackupData = ParcelFileDescriptor.open(this.mBackupDataFile, 0x3C000000);
            this.mNewState = ParcelFileDescriptor.open(this.mNewStateFile, 0x3C000000);
            if (this.mUserId == 0 && !SELinux.restorecon(this.mBackupDataFile)) {
                this.mReporter.onRestoreconFailed(this.mBackupDataFile);
            }
            IBackupTransport transport = this.mTransportClient.connectOrThrow("KVBT.extractAgentData()");
            long quota = transport.getBackupQuota(packageName, false);
            int transportFlags = transport.getTransportFlags();
            callingAgent = true;
            agentResult = this.remoteCall(callback -> agent.doBackup(this.mSavedState, this.mBackupData, this.mNewState, quota, (IBackupCallback)callback, transportFlags), this.mAgentTimeoutParameters.getKvBackupAgentTimeoutMillis(), "doBackup()");
        }
        catch (Exception e) {
            this.mReporter.onCallAgentDoBackupError(packageName, callingAgent, e);
            if (callingAgent) {
                throw AgentException.transitory(e);
            }
            throw TaskException.create();
        }
        this.checkAgentResult(packageInfo, agentResult);
    }

    private void checkAgentResult(PackageInfo packageInfo, RemoteResult result) throws AgentException, TaskException {
        if (result == RemoteResult.FAILED_THREAD_INTERRUPTED) {
            this.mCancelled = true;
            this.mReporter.onAgentCancelled(packageInfo);
            throw TaskException.create();
        }
        if (result == RemoteResult.FAILED_CANCELLED) {
            this.mReporter.onAgentCancelled(packageInfo);
            throw TaskException.create();
        }
        if (result == RemoteResult.FAILED_TIMED_OUT) {
            this.mReporter.onAgentTimedOut(packageInfo);
            throw AgentException.transitory();
        }
        Preconditions.checkState(result.isPresent());
        long resultCode = result.get();
        if (resultCode == -1L) {
            this.mReporter.onAgentResultError(packageInfo);
            throw AgentException.transitory();
        }
        Preconditions.checkState(resultCode == 0L);
    }

    private void agentFail(IBackupAgent agent, String message) {
        try {
            agent.fail(message);
        }
        catch (Exception e) {
            this.mReporter.onFailAgentError(this.mCurrentPackage.packageName);
        }
    }

    private String SHA1Checksum(byte[] input) {
        byte[] checksum;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            checksum = md.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            this.mReporter.onDigestError(e);
            return "00";
        }
        StringBuilder string2 = new StringBuilder(checksum.length * 2);
        for (byte item : checksum) {
            string2.append(Integer.toHexString(item));
        }
        return string2.toString();
    }

    private void writeWidgetPayloadIfAppropriate(FileDescriptor fd, String pkgName) throws IOException {
        Throwable throwable;
        Throwable throwable2;
        byte[] widgetState = AppWidgetBackupBridge.getWidgetState(pkgName, this.mUserId);
        File widgetFile = new File(this.mStateDirectory, pkgName + "_widget");
        boolean priorStateExists = widgetFile.exists();
        if (!priorStateExists && widgetState == null) {
            return;
        }
        this.mReporter.onWriteWidgetData(priorStateExists, widgetState);
        String newChecksum = null;
        if (widgetState != null) {
            newChecksum = this.SHA1Checksum(widgetState);
            if (priorStateExists) {
                String priorChecksum;
                throwable2 = null;
                try (FileInputStream fin = new FileInputStream(widgetFile);){
                    throwable = null;
                    try (DataInputStream in = new DataInputStream(fin);){
                        priorChecksum = in.readUTF();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable in) {
                    throwable2 = in;
                    throw in;
                }
                if (Objects.equals(newChecksum, priorChecksum)) {
                    return;
                }
            }
        }
        BackupDataOutput out = new BackupDataOutput(fd);
        if (widgetState != null) {
            throwable2 = null;
            try (FileOutputStream fout = new FileOutputStream(widgetFile);){
                throwable = null;
                try (DataOutputStream stateOut = new DataOutputStream(fout);){
                    stateOut.writeUTF(newChecksum);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            out.writeEntityHeader("\uffed\uffedwidget", widgetState.length);
            out.writeEntityData(widgetState, widgetState.length);
        } else {
            out.writeEntityHeader("\uffed\uffedwidget", -1);
            widgetFile.delete();
        }
    }

    private int sendDataToTransport() throws AgentException, TaskException, IOException {
        Preconditions.checkState(this.mBackupData != null);
        this.checkBackupData(this.mCurrentPackage.applicationInfo, this.mBackupDataFile);
        String packageName = this.mCurrentPackage.packageName;
        this.writeWidgetPayloadIfAppropriate(this.mBackupData.getFileDescriptor(), packageName);
        boolean nonIncremental = this.mSavedStateFile.length() == 0L;
        int status = this.transportPerformBackup(this.mCurrentPackage, this.mBackupDataFile, nonIncremental);
        this.handleTransportStatus(status, packageName, this.mBackupDataFile.length());
        return status;
    }

    private int transportPerformBackup(PackageInfo packageInfo, File backupDataFile, boolean nonIncremental) throws TaskException {
        int status;
        String packageName = packageInfo.packageName;
        long size = backupDataFile.length();
        if (size <= 0L) {
            this.mReporter.onEmptyData(packageInfo);
            return 0;
        }
        this.mHasDataToBackup = true;
        try (ParcelFileDescriptor backupData = ParcelFileDescriptor.open(backupDataFile, 0x10000000);){
            IBackupTransport transport = this.mTransportClient.connectOrThrow("KVBT.transportPerformBackup()");
            this.mReporter.onTransportPerformBackup(packageName);
            int flags = this.getPerformBackupFlags(this.mUserInitiated, nonIncremental);
            status = transport.performBackup(packageInfo, backupData, flags);
            if (status == 0) {
                status = transport.finishBackup();
            }
        }
        catch (Exception e) {
            this.mReporter.onPackageBackupTransportError(packageName, e);
            throw TaskException.causedBy(e);
        }
        if (nonIncremental && status == -1006) {
            this.mReporter.onPackageBackupNonIncrementalAndNonIncrementalRequired(packageName);
            throw TaskException.create();
        }
        return status;
    }

    private void handleTransportStatus(int status, String packageName, long size) throws TaskException, AgentException {
        if (status == 0) {
            this.mReporter.onPackageBackupComplete(packageName, size);
            return;
        }
        if (status == -1006) {
            this.mReporter.onPackageBackupNonIncrementalRequired(this.mCurrentPackage);
            this.mQueue.add(0, packageName);
            return;
        }
        if (status == -1002) {
            this.mReporter.onPackageBackupRejected(packageName);
            throw AgentException.permanent();
        }
        if (status == -1005) {
            this.mReporter.onPackageBackupQuotaExceeded(packageName);
            this.agentDoQuotaExceeded(this.mAgent, packageName, size);
            throw AgentException.permanent();
        }
        this.mReporter.onPackageBackupTransportFailure(packageName);
        throw TaskException.forStatus(status);
    }

    private void agentDoQuotaExceeded(IBackupAgent agent, String packageName, long size) {
        if (agent != null) {
            try {
                IBackupTransport transport = this.mTransportClient.connectOrThrow("KVBT.agentDoQuotaExceeded()");
                long quota = transport.getBackupQuota(packageName, false);
                this.remoteCall(callback -> agent.doQuotaExceeded(size, quota, (IBackupCallback)callback), this.mAgentTimeoutParameters.getQuotaExceededTimeoutMillis(), "doQuotaExceeded()");
            }
            catch (Exception e) {
                this.mReporter.onAgentDoQuotaExceededError(e);
            }
        }
    }

    private void checkBackupData(ApplicationInfo applicationInfo, File backupDataFile) throws IOException, AgentException {
        if (applicationInfo == null || (applicationInfo.flags & 1) != 0) {
            return;
        }
        try (ParcelFileDescriptor backupData = ParcelFileDescriptor.open(backupDataFile, 0x10000000);){
            BackupDataInput backupDataInput = new BackupDataInput(backupData.getFileDescriptor());
            while (backupDataInput.readNextHeader()) {
                String key = backupDataInput.getKey();
                if (key != null && key.charAt(0) >= '\uff00') {
                    this.mReporter.onAgentIllegalKey(this.mCurrentPackage, key);
                    this.agentFail(this.mAgent, "Illegal backup key: " + key);
                    throw AgentException.permanent();
                }
                backupDataInput.skipEntityData();
            }
        }
    }

    private int getPerformBackupFlags(boolean userInitiated, boolean nonIncremental) {
        int userInitiatedFlag = userInitiated ? 1 : 0;
        int incrementalFlag = nonIncremental ? 4 : 2;
        return userInitiatedFlag | incrementalFlag;
    }

    @Override
    public void handleCancel(boolean cancelAll) {
        Preconditions.checkArgument(cancelAll, "Can't partially cancel a key-value backup task");
        this.markCancel();
        this.waitCancel();
    }

    @VisibleForTesting
    public void markCancel() {
        this.mReporter.onCancel();
        this.mCancelled = true;
        RemoteCall pendingCall = this.mPendingCall;
        if (pendingCall != null) {
            pendingCall.cancel();
        }
    }

    @VisibleForTesting
    public void waitCancel() {
        this.mCancelAcknowledged.block();
    }

    private void revertTask() {
        long delay;
        this.mReporter.onRevertTask();
        try {
            IBackupTransport transport = this.mTransportClient.connectOrThrow("KVBT.revertTask()");
            delay = transport.requestBackupTime();
        }
        catch (Exception e) {
            this.mReporter.onTransportRequestBackupTimeError(e);
            delay = 0L;
        }
        KeyValueBackupJob.schedule(this.mBackupManagerService.getUserId(), this.mBackupManagerService.getContext(), delay, this.mBackupManagerService.getConstants());
        for (String packageName : this.mOriginalQueue) {
            this.mBackupManagerService.dataChangedImpl(packageName);
        }
    }

    private void cleanUpAgentForError(BackupException exception) {
        this.cleanUpAgent(1);
    }

    private void cleanUpAgentForTransportStatus(int status) {
        switch (status) {
            case 0: {
                this.cleanUpAgent(0);
                break;
            }
            case -1006: {
                this.cleanUpAgent(2);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void cleanUpAgent(int stateTransaction) {
        this.applyStateTransaction(stateTransaction);
        if (this.mBackupDataFile != null) {
            this.mBackupDataFile.delete();
        }
        this.mBlankStateFile.delete();
        this.mSavedStateFile = null;
        this.mBackupDataFile = null;
        this.mNewStateFile = null;
        this.tryCloseFileDescriptor(this.mSavedState, "old state");
        this.tryCloseFileDescriptor(this.mBackupData, "backup data");
        this.tryCloseFileDescriptor(this.mNewState, "new state");
        this.mSavedState = null;
        this.mBackupData = null;
        this.mNewState = null;
        if (this.mCurrentPackage.applicationInfo != null) {
            this.mBackupManagerService.unbindAgent(this.mCurrentPackage.applicationInfo);
        }
        this.mAgent = null;
    }

    private void applyStateTransaction(int stateTransaction) {
        switch (stateTransaction) {
            case 0: {
                this.mNewStateFile.renameTo(this.mSavedStateFile);
                break;
            }
            case 1: {
                if (this.mNewStateFile == null) break;
                this.mNewStateFile.delete();
                break;
            }
            case 2: {
                this.mSavedStateFile.delete();
                this.mNewStateFile.delete();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state transaction " + stateTransaction);
            }
        }
    }

    private void tryCloseFileDescriptor(Closeable closeable, String logName) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.mReporter.onCloseFileDescriptorError(logName);
            }
        }
    }

    private RemoteResult remoteCall(RemoteCallable<IBackupCallback> remoteCallable, long timeoutMs, String logIdentifier) throws RemoteException {
        this.mPendingCall = new RemoteCall(this.mCancelled, remoteCallable, timeoutMs);
        RemoteResult result = this.mPendingCall.call();
        this.mReporter.onRemoteCallReturned(result, logIdentifier);
        this.mPendingCall = null;
        return result;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface StateTransaction {
        public static final int COMMIT_NEW = 0;
        public static final int DISCARD_NEW = 1;
        public static final int DISCARD_ALL = 2;
    }
}

