/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.params;

import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IRestoreObserver;
import android.content.pm.PackageInfo;
import com.android.server.backup.internal.OnTaskFinishedListener;
import com.android.server.backup.transport.TransportClient;

public class RestoreParams {
    public final TransportClient transportClient;
    public final IRestoreObserver observer;
    public final IBackupManagerMonitor monitor;
    public final long token;
    public final PackageInfo packageInfo;
    public final int pmToken;
    public final boolean isSystemRestore;
    public final String[] filterSet;
    public final OnTaskFinishedListener listener;

    public static RestoreParams createForSinglePackage(TransportClient transportClient, IRestoreObserver observer, IBackupManagerMonitor monitor, long token, PackageInfo packageInfo, OnTaskFinishedListener listener) {
        return new RestoreParams(transportClient, observer, monitor, token, packageInfo, 0, false, null, listener);
    }

    public static RestoreParams createForRestoreAtInstall(TransportClient transportClient, IRestoreObserver observer, IBackupManagerMonitor monitor, long token, String packageName, int pmToken, OnTaskFinishedListener listener) {
        String[] filterSet = new String[]{packageName};
        return new RestoreParams(transportClient, observer, monitor, token, null, pmToken, false, filterSet, listener);
    }

    public static RestoreParams createForRestoreAll(TransportClient transportClient, IRestoreObserver observer, IBackupManagerMonitor monitor, long token, OnTaskFinishedListener listener) {
        return new RestoreParams(transportClient, observer, monitor, token, null, 0, true, null, listener);
    }

    public static RestoreParams createForRestorePackages(TransportClient transportClient, IRestoreObserver observer, IBackupManagerMonitor monitor, long token, String[] filterSet, boolean isSystemRestore, OnTaskFinishedListener listener) {
        return new RestoreParams(transportClient, observer, monitor, token, null, 0, isSystemRestore, filterSet, listener);
    }

    private RestoreParams(TransportClient transportClient, IRestoreObserver observer, IBackupManagerMonitor monitor, long token, PackageInfo packageInfo, int pmToken, boolean isSystemRestore, String[] filterSet, OnTaskFinishedListener listener) {
        this.transportClient = transportClient;
        this.observer = observer;
        this.monitor = monitor;
        this.token = token;
        this.packageInfo = packageInfo;
        this.pmToken = pmToken;
        this.isSystemRestore = isSystemRestore;
        this.filterSet = filterSet;
        this.listener = listener;
    }
}

