/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.remote;

import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class RemoteResult {
    public static final RemoteResult FAILED_TIMED_OUT = new RemoteResult(1, 0L);
    public static final RemoteResult FAILED_CANCELLED = new RemoteResult(2, 0L);
    public static final RemoteResult FAILED_THREAD_INTERRUPTED = new RemoteResult(3, 0L);
    private final int mType;
    private final long mValue;

    public static RemoteResult of(long value) {
        return new RemoteResult(0, value);
    }

    private RemoteResult(int type, long value) {
        this.mType = type;
        this.mValue = value;
    }

    public boolean isPresent() {
        return this.mType == 0;
    }

    public long get() {
        Preconditions.checkState(this.isPresent(), "Can't obtain value of failed result");
        return this.mValue;
    }

    public String toString() {
        return "RemoteResult{" + this.toStringDescription() + "}";
    }

    private String toStringDescription() {
        switch (this.mType) {
            case 0: {
                return Long.toString(this.mValue);
            }
            case 1: {
                return "FAILED_TIMED_OUT";
            }
            case 2: {
                return "FAILED_CANCELLED";
            }
            case 3: {
                return "FAILED_THREAD_INTERRUPTED";
            }
        }
        throw new AssertionError((Object)"Unknown type");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteResult)) {
            return false;
        }
        RemoteResult that = (RemoteResult)o;
        return this.mType == that.mType && this.mValue == that.mValue;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mValue);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface Type {
        public static final int SUCCESS = 0;
        public static final int FAILED_TIMED_OUT = 1;
        public static final int FAILED_CANCELLED = 2;
        public static final int FAILED_THREAD_INTERRUPTED = 3;
    }
}

