/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.restore;

import android.app.IBackupAgent;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IFullBackupRestoreObserver;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.Signature;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.server.LocalServices;
import com.android.server.backup.BackupAgentTimeoutParameters;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.FileMetadata;
import com.android.server.backup.KeyValueAdbRestoreEngine;
import com.android.server.backup.UserBackupManagerService;
import com.android.server.backup.fullbackup.FullBackupObbConnection;
import com.android.server.backup.restore.AdbRestoreFinishedLatch;
import com.android.server.backup.restore.AdbRestoreFinishedRunnable;
import com.android.server.backup.restore.RestoreDeleteObserver;
import com.android.server.backup.restore.RestoreEngine;
import com.android.server.backup.restore.RestoreFileRunnable;
import com.android.server.backup.restore.RestorePolicy;
import com.android.server.backup.utils.BytesReadListener;
import com.android.server.backup.utils.FullBackupRestoreObserverUtils;
import com.android.server.backup.utils.RestoreUtils;
import com.android.server.backup.utils.TarBackupReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class FullRestoreEngine
extends RestoreEngine {
    private final UserBackupManagerService mBackupManagerService;
    private final int mUserId;
    private final BackupRestoreTask mMonitorTask;
    private final RestoreDeleteObserver mDeleteObserver = new RestoreDeleteObserver();
    private IFullBackupRestoreObserver mObserver;
    final IBackupManagerMonitor mMonitor;
    private IBackupAgent mAgent;
    final PackageInfo mOnlyPackage;
    final boolean mAllowApks;
    private final boolean mAllowObbs;
    private String mAgentPackage;
    private ApplicationInfo mTargetApp;
    private FullBackupObbConnection mObbConnection = null;
    private final HashMap<String, RestorePolicy> mPackagePolicies = new HashMap();
    private final HashMap<String, String> mPackageInstallers = new HashMap();
    private final HashMap<String, Signature[]> mManifestSignatures = new HashMap();
    private final HashSet<String> mClearedPackages = new HashSet();
    private long mBytes;
    final byte[] mBuffer;
    private ParcelFileDescriptor[] mPipes = null;
    private final Object mPipesLock = new Object();
    private byte[] mWidgetData = null;
    private long mAppVersion;
    final int mEphemeralOpToken;
    private final BackupAgentTimeoutParameters mAgentTimeoutParameters;
    final boolean mIsAdbRestore;
    @GuardedBy(value={"mPipesLock"})
    private boolean mPipesClosed;

    public FullRestoreEngine(UserBackupManagerService backupManagerService, BackupRestoreTask monitorTask, IFullBackupRestoreObserver observer, IBackupManagerMonitor monitor, PackageInfo onlyPackage, boolean allowApks, boolean allowObbs, int ephemeralOpToken, boolean isAdbRestore) {
        this.mBackupManagerService = backupManagerService;
        this.mEphemeralOpToken = ephemeralOpToken;
        this.mMonitorTask = monitorTask;
        this.mObserver = observer;
        this.mMonitor = monitor;
        this.mOnlyPackage = onlyPackage;
        this.mAllowApks = allowApks;
        this.mAllowObbs = allowObbs;
        this.mBuffer = new byte[32768];
        this.mBytes = 0L;
        this.mAgentTimeoutParameters = Preconditions.checkNotNull(backupManagerService.getAgentTimeoutParameters(), "Timeout parameters cannot be null");
        this.mIsAdbRestore = isAdbRestore;
        this.mUserId = backupManagerService.getUserId();
    }

    public IBackupAgent getAgent() {
        return this.mAgent;
    }

    public byte[] getWidgetData() {
        return this.mWidgetData;
    }

    public boolean restoreOneFile(InputStream instream, boolean mustKillAgent, byte[] buffer, PackageInfo onlyPackage, boolean allowApks, int token, IBackupManagerMonitor monitor) {
        FileMetadata info;
        block46: {
            if (!this.isRunning()) {
                Slog.w("BackupManagerService", "Restore engine used after halting");
                return false;
            }
            BytesReadListener bytesReadListener = new BytesReadListener(){

                @Override
                public void onBytesRead(long bytesRead) {
                    FullRestoreEngine.this.mBytes += bytesRead;
                }
            };
            TarBackupReader tarBackupReader = new TarBackupReader(instream, bytesReadListener, monitor);
            try {
                long nRead;
                info = tarBackupReader.readTarHeaders();
                if (info == null) break block46;
                String pkg = info.packageName;
                if (!pkg.equals(this.mAgentPackage)) {
                    if (onlyPackage != null && !pkg.equals(onlyPackage.packageName)) {
                        Slog.w("BackupManagerService", "Expected data for " + onlyPackage + " but saw " + pkg);
                        this.setResult(-3);
                        this.setRunning(false);
                        return false;
                    }
                    if (!this.mPackagePolicies.containsKey(pkg)) {
                        this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                    }
                    if (this.mAgent != null) {
                        Slog.d("BackupManagerService", "Saw new package; finalizing old one");
                        this.tearDownPipes();
                        this.tearDownAgent(this.mTargetApp, this.mIsAdbRestore);
                        this.mTargetApp = null;
                        this.mAgentPackage = null;
                    }
                }
                if (info.path.equals("_manifest")) {
                    Signature[] signatures = tarBackupReader.readAppManifestAndReturnSignatures(info);
                    this.mAppVersion = info.version;
                    PackageManagerInternal pmi = LocalServices.getService(PackageManagerInternal.class);
                    RestorePolicy restorePolicy = tarBackupReader.chooseRestorePolicy(this.mBackupManagerService.getPackageManager(), allowApks, info, signatures, pmi, this.mUserId);
                    this.mManifestSignatures.put(info.packageName, signatures);
                    this.mPackagePolicies.put(pkg, restorePolicy);
                    this.mPackageInstallers.put(pkg, info.installerPackageName);
                    tarBackupReader.skipTarPadding(info.size);
                    this.mObserver = FullBackupRestoreObserverUtils.sendOnRestorePackage(this.mObserver, pkg);
                    break block46;
                }
                if (info.path.equals("_meta")) {
                    tarBackupReader.readMetadata(info);
                    this.mWidgetData = tarBackupReader.getWidgetData();
                    monitor = tarBackupReader.getMonitor();
                    tarBackupReader.skipTarPadding(info.size);
                    break block46;
                }
                boolean okay = true;
                RestorePolicy policy = this.mPackagePolicies.get(pkg);
                switch (policy) {
                    case IGNORE: {
                        okay = false;
                        break;
                    }
                    case ACCEPT_IF_APK: {
                        if (info.domain.equals("a")) {
                            Slog.d("BackupManagerService", "APK file; installing");
                            String installerPackageName = this.mPackageInstallers.get(pkg);
                            boolean isSuccessfullyInstalled = RestoreUtils.installApk(instream, this.mBackupManagerService.getContext(), this.mDeleteObserver, this.mManifestSignatures, this.mPackagePolicies, info, installerPackageName, bytesReadListener, this.mUserId);
                            this.mPackagePolicies.put(pkg, isSuccessfullyInstalled ? RestorePolicy.ACCEPT : RestorePolicy.IGNORE);
                            tarBackupReader.skipTarPadding(info.size);
                            return true;
                        }
                        this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        okay = false;
                        break;
                    }
                    case ACCEPT: {
                        if (!info.domain.equals("a")) break;
                        Slog.d("BackupManagerService", "apk present but ACCEPT");
                        okay = false;
                        break;
                    }
                    default: {
                        Slog.e("BackupManagerService", "Invalid policy from manifest");
                        okay = false;
                        this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                    }
                }
                if (!FullRestoreEngine.isRestorableFile(info) || !FullRestoreEngine.isCanonicalFilePath(info.path)) {
                    okay = false;
                }
                if (okay && this.mAgent == null) {
                    try {
                        this.mTargetApp = this.mBackupManagerService.getPackageManager().getApplicationInfoAsUser(pkg, 0, this.mUserId);
                        if (!this.mClearedPackages.contains(pkg)) {
                            boolean forceClear = this.shouldForceClearAppDataOnFullRestore(this.mTargetApp.packageName);
                            if (this.mTargetApp.backupAgentName == null || forceClear) {
                                Slog.d("BackupManagerService", "Clearing app data preparatory to full restore");
                                this.mBackupManagerService.clearApplicationDataBeforeRestore(pkg);
                            }
                            this.mClearedPackages.add(pkg);
                        }
                        this.setUpPipes();
                        this.mAgent = this.mBackupManagerService.bindToAgentSynchronous(this.mTargetApp, "k".equals(info.domain) ? 0 : 3);
                        this.mAgentPackage = pkg;
                    }
                    catch (IOException forceClear) {
                    }
                    catch (PackageManager.NameNotFoundException forceClear) {
                        // empty catch block
                    }
                    if (this.mAgent == null) {
                        Slog.e("BackupManagerService", "Unable to create agent for " + pkg);
                        okay = false;
                        this.tearDownPipes();
                        this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                    }
                }
                if (okay && !pkg.equals(this.mAgentPackage)) {
                    Slog.e("BackupManagerService", "Restoring data for " + pkg + " but agent is for " + this.mAgentPackage);
                    okay = false;
                }
                if (okay) {
                    boolean agentSuccess = true;
                    long toCopy = info.size;
                    boolean isSharedStorage = pkg.equals("com.android.sharedstoragebackup");
                    long timeout = isSharedStorage ? this.mAgentTimeoutParameters.getSharedBackupAgentTimeoutMillis() : this.mAgentTimeoutParameters.getRestoreAgentTimeoutMillis();
                    try {
                        this.mBackupManagerService.prepareOperationTimeout(token, timeout, this.mMonitorTask, 1);
                        if ("obb".equals(info.domain)) {
                            Slog.d("BackupManagerService", "Restoring OBB file for " + pkg + " : " + info.path);
                            this.mObbConnection.restoreObbFile(pkg, this.mPipes[0], info.size, info.type, info.path, info.mode, info.mtime, token, this.mBackupManagerService.getBackupManagerBinder());
                        } else if ("k".equals(info.domain)) {
                            Slog.d("BackupManagerService", "Restoring key-value file for " + pkg + " : " + info.path);
                            info.version = this.mAppVersion;
                            KeyValueAdbRestoreEngine restoreEngine = new KeyValueAdbRestoreEngine(this.mBackupManagerService, this.mBackupManagerService.getDataDir(), info, this.mPipes[0], this.mAgent, token);
                            new Thread((Runnable)restoreEngine, "restore-key-value-runner").start();
                        } else if (this.mTargetApp.processName.equals("system")) {
                            Slog.d("BackupManagerService", "system process agent - spinning a thread");
                            RestoreFileRunnable runner = new RestoreFileRunnable(this.mBackupManagerService, this.mAgent, info, this.mPipes[0], token);
                            new Thread((Runnable)runner, "restore-sys-runner").start();
                        } else {
                            this.mAgent.doRestoreFile(this.mPipes[0], info.size, info.type, info.domain, info.path, info.mode, info.mtime, token, this.mBackupManagerService.getBackupManagerBinder());
                        }
                    }
                    catch (IOException e) {
                        Slog.d("BackupManagerService", "Couldn't establish restore");
                        agentSuccess = false;
                        okay = false;
                    }
                    catch (RemoteException e) {
                        Slog.e("BackupManagerService", "Agent crashed during full restore");
                        agentSuccess = false;
                        okay = false;
                    }
                    if (okay) {
                        boolean pipeOkay = true;
                        FileOutputStream pipe = new FileOutputStream(this.mPipes[1].getFileDescriptor());
                        while (toCopy > 0L) {
                            int toRead = toCopy > (long)buffer.length ? buffer.length : (int)toCopy;
                            int nRead2 = instream.read(buffer, 0, toRead);
                            if (nRead2 >= 0) {
                                this.mBytes += (long)nRead2;
                            }
                            if (nRead2 <= 0) break;
                            toCopy -= (long)nRead2;
                            if (!pipeOkay) continue;
                            try {
                                pipe.write(buffer, 0, nRead2);
                            }
                            catch (IOException e) {
                                Slog.e("BackupManagerService", "Failed to write to restore pipe: " + e.getMessage());
                                pipeOkay = false;
                            }
                        }
                        tarBackupReader.skipTarPadding(info.size);
                        agentSuccess = this.mBackupManagerService.waitUntilOperationComplete(token);
                    }
                    if (!agentSuccess) {
                        Slog.w("BackupManagerService", "Agent failure restoring " + pkg + "; ending restore");
                        this.mBackupManagerService.getBackupHandler().removeMessages(18);
                        this.tearDownPipes();
                        this.tearDownAgent(this.mTargetApp, false);
                        this.mAgent = null;
                        this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        if (onlyPackage != null) {
                            this.setResult(-2);
                            this.setRunning(false);
                            return false;
                        }
                    }
                }
                if (okay) break block46;
                for (long bytesToConsume = info.size + 511L & 0xFFFFFFFFFFFFFE00L; bytesToConsume > 0L; bytesToConsume -= nRead) {
                    int toRead = bytesToConsume > (long)buffer.length ? buffer.length : (int)bytesToConsume;
                    nRead = instream.read(buffer, 0, toRead);
                    if (nRead >= 0L) {
                        this.mBytes += nRead;
                    }
                    if (nRead > 0L) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                Slog.w("BackupManagerService", "io exception on restore socket read: " + e.getMessage());
                this.setResult(-3);
                info = null;
            }
        }
        if (info == null) {
            this.tearDownPipes();
            this.setRunning(false);
            if (mustKillAgent) {
                this.tearDownAgent(this.mTargetApp, this.mIsAdbRestore);
            }
        }
        return info != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpPipes() throws IOException {
        Object object = this.mPipesLock;
        synchronized (object) {
            this.mPipes = ParcelFileDescriptor.createPipe();
            this.mPipesClosed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tearDownPipes() {
        Object object = this.mPipesLock;
        synchronized (object) {
            if (!this.mPipesClosed && this.mPipes != null) {
                try {
                    this.mPipes[0].close();
                    this.mPipes[1].close();
                    this.mPipesClosed = true;
                }
                catch (IOException e) {
                    Slog.w("BackupManagerService", "Couldn't close agent pipes", e);
                }
            }
        }
    }

    private void tearDownAgent(ApplicationInfo app, boolean doRestoreFinished) {
        if (this.mAgent != null) {
            try {
                if (doRestoreFinished) {
                    int token = this.mBackupManagerService.generateRandomIntegerToken();
                    long fullBackupAgentTimeoutMillis = this.mAgentTimeoutParameters.getFullBackupAgentTimeoutMillis();
                    AdbRestoreFinishedLatch latch = new AdbRestoreFinishedLatch(this.mBackupManagerService, token);
                    this.mBackupManagerService.prepareOperationTimeout(token, fullBackupAgentTimeoutMillis, latch, 1);
                    if (this.mTargetApp.processName.equals("system")) {
                        AdbRestoreFinishedRunnable runner = new AdbRestoreFinishedRunnable(this.mAgent, token, this.mBackupManagerService);
                        new Thread((Runnable)runner, "restore-sys-finished-runner").start();
                    } else {
                        this.mAgent.doRestoreFinished(token, this.mBackupManagerService.getBackupManagerBinder());
                    }
                    latch.await();
                }
                this.mBackupManagerService.tearDownAgentAndKill(app);
            }
            catch (RemoteException e) {
                Slog.d("BackupManagerService", "Lost app trying to shut down");
            }
            this.mAgent = null;
        }
    }

    void handleTimeout() {
        this.tearDownPipes();
        this.setResult(-2);
        this.setRunning(false);
    }

    private static boolean isRestorableFile(FileMetadata info) {
        if ("c".equals(info.domain)) {
            return false;
        }
        return !"r".equals(info.domain) || !info.path.startsWith("no_backup/");
    }

    private static boolean isCanonicalFilePath(String path) {
        return !path.contains("..") && !path.contains("//");
    }

    private boolean shouldForceClearAppDataOnFullRestore(String packageName) {
        String packageListString = Settings.Secure.getStringForUser(this.mBackupManagerService.getContext().getContentResolver(), "packages_to_clear_data_before_full_restore", this.mUserId);
        if (TextUtils.isEmpty(packageListString)) {
            return false;
        }
        List<String> packages = Arrays.asList(packageListString.split(";"));
        return packages.contains(packageName);
    }

    void sendOnRestorePackage(String name) {
        if (this.mObserver != null) {
            try {
                this.mObserver.onRestorePackage(name);
            }
            catch (RemoteException e) {
                Slog.w("BackupManagerService", "full restore observer went away: restorePackage");
                this.mObserver = null;
            }
        }
    }
}

