/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.restore;

import android.os.ParcelFileDescriptor;
import com.android.server.backup.restore.FullRestoreEngine;
import java.io.FileInputStream;
import java.io.InputStream;
import libcore.io.IoUtils;

class FullRestoreEngineThread
implements Runnable {
    FullRestoreEngine mEngine;
    InputStream mEngineStream;
    private final boolean mMustKillAgent;

    FullRestoreEngineThread(FullRestoreEngine engine, ParcelFileDescriptor engineSocket) {
        this.mEngine = engine;
        engine.setRunning(true);
        this.mEngineStream = new FileInputStream(engineSocket.getFileDescriptor(), true);
        this.mMustKillAgent = false;
    }

    FullRestoreEngineThread(FullRestoreEngine engine, InputStream inputStream) {
        this.mEngine = engine;
        engine.setRunning(true);
        this.mEngineStream = inputStream;
        this.mMustKillAgent = true;
    }

    public boolean isRunning() {
        return this.mEngine.isRunning();
    }

    public int waitForResult() {
        return this.mEngine.waitForResult();
    }

    @Override
    public void run() {
        try {
            while (this.mEngine.isRunning()) {
                this.mEngine.restoreOneFile(this.mEngineStream, this.mMustKillAgent, this.mEngine.mBuffer, this.mEngine.mOnlyPackage, this.mEngine.mAllowApks, this.mEngine.mEphemeralOpToken, this.mEngine.mMonitor);
            }
        }
        finally {
            IoUtils.closeQuietly(this.mEngineStream);
        }
    }

    public void handleTimeout() {
        IoUtils.closeQuietly(this.mEngineStream);
        this.mEngine.handleTimeout();
    }
}

