/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.restore;

import android.app.IBackupAgent;
import android.app.backup.BackupAgent;
import android.app.backup.IFullBackupRestoreObserver;
import android.content.pm.ApplicationInfo;
import android.content.pm.Signature;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.server.backup.BackupAgentTimeoutParameters;
import com.android.server.backup.UserBackupManagerService;
import com.android.server.backup.fullbackup.FullBackupObbConnection;
import com.android.server.backup.restore.FullRestoreEngine;
import com.android.server.backup.restore.FullRestoreEngineThread;
import com.android.server.backup.restore.RestoreDeleteObserver;
import com.android.server.backup.restore.RestorePolicy;
import com.android.server.backup.utils.FullBackupRestoreObserverUtils;
import com.android.server.backup.utils.PasswordUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.InflaterInputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PerformAdbRestoreTask
implements Runnable {
    private final UserBackupManagerService mBackupManagerService;
    private final ParcelFileDescriptor mInputFile;
    private final String mCurrentPassword;
    private final String mDecryptPassword;
    private final AtomicBoolean mLatchObject;
    private final BackupAgent mPackageManagerBackupAgent;
    private final RestoreDeleteObserver mDeleteObserver = new RestoreDeleteObserver();
    private IFullBackupRestoreObserver mObserver;
    private IBackupAgent mAgent;
    private String mAgentPackage;
    private ApplicationInfo mTargetApp;
    private FullBackupObbConnection mObbConnection = null;
    private ParcelFileDescriptor[] mPipes = null;
    private byte[] mWidgetData = null;
    private long mAppVersion;
    private long mBytes;
    private final BackupAgentTimeoutParameters mAgentTimeoutParameters;
    private final HashMap<String, RestorePolicy> mPackagePolicies = new HashMap();
    private final HashMap<String, String> mPackageInstallers = new HashMap();
    private final HashMap<String, Signature[]> mManifestSignatures = new HashMap();
    private final HashSet<String> mClearedPackages = new HashSet();

    public PerformAdbRestoreTask(UserBackupManagerService backupManagerService, ParcelFileDescriptor fd, String curPassword, String decryptPassword, IFullBackupRestoreObserver observer, AtomicBoolean latch) {
        this.mBackupManagerService = backupManagerService;
        this.mInputFile = fd;
        this.mCurrentPassword = curPassword;
        this.mDecryptPassword = decryptPassword;
        this.mObserver = observer;
        this.mLatchObject = latch;
        this.mAgent = null;
        this.mPackageManagerBackupAgent = backupManagerService.makeMetadataAgent();
        this.mAgentPackage = null;
        this.mTargetApp = null;
        this.mObbConnection = new FullBackupObbConnection(backupManagerService);
        this.mAgentTimeoutParameters = Preconditions.checkNotNull(backupManagerService.getAgentTimeoutParameters(), "Timeout parameters cannot be null");
        this.mClearedPackages.add("android");
        this.mClearedPackages.add("com.android.providers.settings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Slog.i("BackupManagerService", "--- Performing full-dataset restore ---");
        this.mObbConnection.establish();
        this.mObserver = FullBackupRestoreObserverUtils.sendStartRestore(this.mObserver);
        if (Environment.getExternalStorageState().equals("mounted")) {
            this.mPackagePolicies.put("com.android.sharedstoragebackup", RestorePolicy.ACCEPT);
        }
        FileInputStream rawInStream = null;
        try {
            if (!this.mBackupManagerService.backupPasswordMatches(this.mCurrentPassword)) {
                Slog.w("BackupManagerService", "Backup password mismatch; aborting");
                return;
            }
            this.mBytes = 0L;
            rawInStream = new FileInputStream(this.mInputFile.getFileDescriptor());
            InputStream tarInputStream = PerformAdbRestoreTask.parseBackupFileHeaderAndReturnTarStream(rawInStream, this.mDecryptPassword);
            if (tarInputStream == null) {
                return;
            }
            FullRestoreEngine mEngine = new FullRestoreEngine(this.mBackupManagerService, null, this.mObserver, null, null, true, true, 0, true);
            FullRestoreEngineThread mEngineThread = new FullRestoreEngineThread(mEngine, tarInputStream);
            mEngineThread.run();
        }
        catch (IOException e) {
            Slog.e("BackupManagerService", "Unable to read restore input");
        }
        finally {
            try {
                if (rawInStream != null) {
                    rawInStream.close();
                }
                this.mInputFile.close();
            }
            catch (IOException e) {
                Slog.w("BackupManagerService", "Close of restore data pipe threw", e);
            }
            AtomicBoolean atomicBoolean = this.mLatchObject;
            synchronized (atomicBoolean) {
                this.mLatchObject.set(true);
                this.mLatchObject.notifyAll();
            }
            this.mObbConnection.tearDown();
            this.mObserver = FullBackupRestoreObserverUtils.sendEndRestore(this.mObserver);
            Slog.d("BackupManagerService", "Full restore pass complete.");
            this.mBackupManagerService.getWakelock().release();
        }
    }

    private static void readFullyOrThrow(InputStream in, byte[] buffer) throws IOException {
        int bytesRead;
        for (int offset = 0; offset < buffer.length; offset += bytesRead) {
            bytesRead = in.read(buffer, offset, buffer.length - offset);
            if (bytesRead > 0) continue;
            throw new IOException("Couldn't fully read data");
        }
    }

    @VisibleForTesting
    public static InputStream parseBackupFileHeaderAndReturnTarStream(InputStream rawInputStream, String decryptPassword) throws IOException {
        boolean compressed = false;
        InputStream preCompressStream = rawInputStream;
        boolean okay = false;
        int headerLen = "ANDROID BACKUP\n".length();
        byte[] streamHeader = new byte[headerLen];
        PerformAdbRestoreTask.readFullyOrThrow(rawInputStream, streamHeader);
        byte[] magicBytes = "ANDROID BACKUP\n".getBytes("UTF-8");
        if (Arrays.equals(magicBytes, streamHeader)) {
            String s = PerformAdbRestoreTask.readHeaderLine(rawInputStream);
            int archiveVersion = Integer.parseInt(s);
            if (archiveVersion <= 5) {
                boolean pbkdf2Fallback = archiveVersion == 1;
                s = PerformAdbRestoreTask.readHeaderLine(rawInputStream);
                compressed = Integer.parseInt(s) != 0;
                s = PerformAdbRestoreTask.readHeaderLine(rawInputStream);
                if (s.equals("none")) {
                    okay = true;
                } else if (decryptPassword != null && decryptPassword.length() > 0) {
                    preCompressStream = PerformAdbRestoreTask.decodeAesHeaderAndInitialize(decryptPassword, s, pbkdf2Fallback, rawInputStream);
                    if (preCompressStream != null) {
                        okay = true;
                    }
                } else {
                    Slog.w("BackupManagerService", "Archive is encrypted but no password given");
                }
            } else {
                Slog.w("BackupManagerService", "Wrong header version: " + s);
            }
        } else {
            Slog.w("BackupManagerService", "Didn't read the right header magic");
        }
        if (!okay) {
            Slog.w("BackupManagerService", "Invalid restore data; aborting.");
            return null;
        }
        return compressed ? new InflaterInputStream(preCompressStream) : preCompressStream;
    }

    private static String readHeaderLine(InputStream in) throws IOException {
        int c;
        StringBuilder buffer = new StringBuilder(80);
        while ((c = in.read()) >= 0 && c != 10) {
            buffer.append((char)c);
        }
        return buffer.toString();
    }

    private static InputStream attemptMasterKeyDecryption(String decryptPassword, String algorithm, byte[] userSalt, byte[] ckSalt, int rounds, String userIvHex, String masterKeyBlobHex, InputStream rawInStream, boolean doLog) {
        CipherInputStream result;
        block15: {
            result = null;
            try {
                Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
                SecretKey userKey = PasswordUtils.buildPasswordKey(algorithm, decryptPassword, userSalt, rounds);
                byte[] IV = PasswordUtils.hexToByteArray(userIvHex);
                IvParameterSpec ivSpec = new IvParameterSpec(IV);
                c.init(2, (Key)new SecretKeySpec(userKey.getEncoded(), "AES"), ivSpec);
                byte[] mkCipher = PasswordUtils.hexToByteArray(masterKeyBlobHex);
                byte[] mkBlob = c.doFinal(mkCipher);
                int offset = 0;
                byte len = mkBlob[offset++];
                IV = Arrays.copyOfRange(mkBlob, offset, offset + len);
                offset += len;
                len = mkBlob[offset++];
                byte[] mk = Arrays.copyOfRange(mkBlob, offset, offset + len);
                offset += len;
                len = mkBlob[offset++];
                byte[] mkChecksum = Arrays.copyOfRange(mkBlob, offset, offset + len);
                byte[] calculatedCk = PasswordUtils.makeKeyChecksum(algorithm, mk, ckSalt, rounds);
                if (Arrays.equals(calculatedCk, mkChecksum)) {
                    ivSpec = new IvParameterSpec(IV);
                    c.init(2, (Key)new SecretKeySpec(mk, "AES"), ivSpec);
                    result = new CipherInputStream(rawInStream, c);
                } else if (doLog) {
                    Slog.w("BackupManagerService", "Incorrect password");
                }
            }
            catch (InvalidAlgorithmParameterException e) {
                if (doLog) {
                    Slog.e("BackupManagerService", "Needed parameter spec unavailable!", e);
                }
            }
            catch (BadPaddingException e) {
                if (doLog) {
                    Slog.w("BackupManagerService", "Incorrect password");
                }
            }
            catch (IllegalBlockSizeException e) {
                if (doLog) {
                    Slog.w("BackupManagerService", "Invalid block size in master key");
                }
            }
            catch (NoSuchAlgorithmException e) {
                if (doLog) {
                    Slog.e("BackupManagerService", "Needed decryption algorithm unavailable!");
                }
            }
            catch (NoSuchPaddingException e) {
                if (doLog) {
                    Slog.e("BackupManagerService", "Needed padding mechanism unavailable!");
                }
            }
            catch (InvalidKeyException e) {
                if (!doLog) break block15;
                Slog.w("BackupManagerService", "Illegal password; aborting");
            }
        }
        return result;
    }

    private static InputStream decodeAesHeaderAndInitialize(String decryptPassword, String encryptionName, boolean pbkdf2Fallback, InputStream rawInStream) {
        InputStream result = null;
        try {
            if (encryptionName.equals("AES-256")) {
                String masterKeyBlobHex;
                String userIvHex;
                int rounds;
                String ckSaltHex;
                byte[] ckSalt;
                String userSaltHex = PerformAdbRestoreTask.readHeaderLine(rawInStream);
                byte[] userSalt = PasswordUtils.hexToByteArray(userSaltHex);
                result = PerformAdbRestoreTask.attemptMasterKeyDecryption(decryptPassword, "PBKDF2WithHmacSHA1", userSalt, ckSalt = PasswordUtils.hexToByteArray(ckSaltHex = PerformAdbRestoreTask.readHeaderLine(rawInStream)), rounds = Integer.parseInt(PerformAdbRestoreTask.readHeaderLine(rawInStream)), userIvHex = PerformAdbRestoreTask.readHeaderLine(rawInStream), masterKeyBlobHex = PerformAdbRestoreTask.readHeaderLine(rawInStream), rawInStream, false);
                if (result == null && pbkdf2Fallback) {
                    result = PerformAdbRestoreTask.attemptMasterKeyDecryption(decryptPassword, "PBKDF2WithHmacSHA1And8bit", userSalt, ckSalt, rounds, userIvHex, masterKeyBlobHex, rawInStream, true);
                }
            } else {
                Slog.w("BackupManagerService", "Unsupported encryption method: " + encryptionName);
            }
        }
        catch (NumberFormatException e) {
            Slog.w("BackupManagerService", "Can't parse restore data header");
        }
        catch (IOException e) {
            Slog.w("BackupManagerService", "Can't read input header");
        }
        return result;
    }
}

