/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.restore;

import android.app.IBackupAgent;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IRestoreObserver;
import android.app.backup.RestoreDescription;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.os.Bundle;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.backup.IBackupTransport;
import com.android.internal.util.Preconditions;
import com.android.server.AppWidgetBackupBridge;
import com.android.server.LocalServices;
import com.android.server.backup.BackupAgentTimeoutParameters;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.BackupUtils;
import com.android.server.backup.PackageManagerBackupAgent;
import com.android.server.backup.TransportManager;
import com.android.server.backup.UserBackupManagerService;
import com.android.server.backup.internal.OnTaskFinishedListener;
import com.android.server.backup.restore.FullRestoreEngine;
import com.android.server.backup.restore.FullRestoreEngineThread;
import com.android.server.backup.restore.RestoreEngine;
import com.android.server.backup.restore.UnifiedRestoreState;
import com.android.server.backup.transport.TransportClient;
import com.android.server.backup.utils.AppBackupUtils;
import com.android.server.backup.utils.BackupManagerMonitorUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import libcore.io.IoUtils;

public class PerformUnifiedRestoreTask
implements BackupRestoreTask {
    private UserBackupManagerService backupManagerService;
    private final int mUserId;
    private final TransportManager mTransportManager;
    private final TransportClient mTransportClient;
    File mStateDir;
    private IRestoreObserver mObserver;
    private IBackupManagerMonitor mMonitor;
    private long mToken;
    private int mPmToken;
    private boolean mDidLaunch;
    private boolean mIsSystemRestore;
    private PackageInfo mTargetPackage;
    private List<PackageInfo> mAcceptSet;
    private PackageManagerBackupAgent mPmAgent;
    private IBackupAgent mAgent;
    private RestoreDescription mRestoreDescription;
    private PackageInfo mCurrentPackage;
    private byte[] mWidgetData;
    private int mCount;
    private long mStartRealtime;
    private UnifiedRestoreState mState;
    private int mStatus;
    private boolean mFinished;
    private final OnTaskFinishedListener mListener;
    private File mBackupDataName;
    private File mStageName;
    private File mSavedStateName;
    private File mNewStateName;
    ParcelFileDescriptor mBackupData;
    ParcelFileDescriptor mNewState;
    private final int mEphemeralOpToken;
    private final BackupAgentTimeoutParameters mAgentTimeoutParameters;

    public PerformUnifiedRestoreTask(UserBackupManagerService backupManagerService, TransportClient transportClient, IRestoreObserver observer, IBackupManagerMonitor monitor, long restoreSetToken, PackageInfo targetPackage, int pmToken, boolean isFullSystemRestore, String[] filterSet, OnTaskFinishedListener listener) {
        this.backupManagerService = backupManagerService;
        this.mUserId = backupManagerService.getUserId();
        this.mTransportManager = backupManagerService.getTransportManager();
        this.mEphemeralOpToken = backupManagerService.generateRandomIntegerToken();
        this.mState = UnifiedRestoreState.INITIAL;
        this.mStartRealtime = SystemClock.elapsedRealtime();
        this.mTransportClient = transportClient;
        this.mObserver = observer;
        this.mMonitor = monitor;
        this.mToken = restoreSetToken;
        this.mPmToken = pmToken;
        this.mTargetPackage = targetPackage;
        this.mIsSystemRestore = isFullSystemRestore;
        this.mFinished = false;
        this.mDidLaunch = false;
        this.mListener = listener;
        this.mAgentTimeoutParameters = Preconditions.checkNotNull(backupManagerService.getAgentTimeoutParameters(), "Timeout parameters cannot be null");
        if (targetPackage != null) {
            this.mAcceptSet = new ArrayList<PackageInfo>();
            this.mAcceptSet.add(targetPackage);
        } else {
            if (filterSet == null) {
                List<PackageInfo> apps = PackageManagerBackupAgent.getStorableApplications(backupManagerService.getPackageManager(), this.mUserId);
                filterSet = this.packagesToNames(apps);
                Slog.i("BackupManagerService", "Full restore; asking about " + filterSet.length + " apps");
            }
            this.mAcceptSet = new ArrayList<PackageInfo>(filterSet.length);
            boolean hasSystem = false;
            boolean hasSettings = false;
            for (int i = 0; i < filterSet.length; ++i) {
                try {
                    PackageManager pm = backupManagerService.getPackageManager();
                    PackageInfo info = pm.getPackageInfoAsUser(filterSet[i], 0, this.mUserId);
                    if ("android".equals(info.packageName)) {
                        hasSystem = true;
                        continue;
                    }
                    if ("com.android.providers.settings".equals(info.packageName)) {
                        hasSettings = true;
                        continue;
                    }
                    if (!AppBackupUtils.appIsEligibleForBackup(info.applicationInfo, this.mUserId)) continue;
                    this.mAcceptSet.add(info);
                    continue;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            if (hasSystem) {
                try {
                    this.mAcceptSet.add(0, backupManagerService.getPackageManager().getPackageInfoAsUser("android", 0, this.mUserId));
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
            if (hasSettings) {
                try {
                    this.mAcceptSet.add(backupManagerService.getPackageManager().getPackageInfoAsUser("com.android.providers.settings", 0, this.mUserId));
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private String[] packagesToNames(List<PackageInfo> apps) {
        int N = apps.size();
        String[] names = new String[N];
        for (int i = 0; i < N; ++i) {
            names[i] = apps.get((int)i).packageName;
        }
        return names;
    }

    @Override
    public void execute() {
        switch (this.mState) {
            case INITIAL: {
                this.startRestore();
                break;
            }
            case RUNNING_QUEUE: {
                this.dispatchNextRestore();
                break;
            }
            case RESTORE_KEYVALUE: {
                this.restoreKeyValue();
                break;
            }
            case RESTORE_FULL: {
                this.restoreFull();
                break;
            }
            case RESTORE_FINISHED: {
                this.restoreFinished();
                break;
            }
            case FINAL: {
                if (!this.mFinished) {
                    this.finalizeRestore();
                } else {
                    Slog.e("BackupManagerService", "Duplicate finish");
                }
                this.mFinished = true;
            }
        }
    }

    private void startRestore() {
        this.sendStartRestore(this.mAcceptSet.size());
        if (this.mIsSystemRestore) {
            AppWidgetBackupBridge.restoreStarting(this.mUserId);
        }
        try {
            String transportDirName = this.mTransportManager.getTransportDirName(this.mTransportClient.getTransportComponent());
            this.mStateDir = new File(this.backupManagerService.getBaseStateDir(), transportDirName);
            PackageInfo pmPackage = new PackageInfo();
            pmPackage.packageName = "@pm@";
            this.mAcceptSet.add(0, pmPackage);
            PackageInfo[] packages = this.mAcceptSet.toArray(new PackageInfo[0]);
            IBackupTransport transport = this.mTransportClient.connectOrThrow("PerformUnifiedRestoreTask.startRestore()");
            this.mStatus = transport.startRestore(this.mToken, packages);
            if (this.mStatus != 0) {
                Slog.e("BackupManagerService", "Transport error " + this.mStatus + "; no restore possible");
                this.mStatus = -1000;
                this.executeNextState(UnifiedRestoreState.FINAL);
                return;
            }
            RestoreDescription desc = transport.nextRestorePackage();
            if (desc == null) {
                Slog.e("BackupManagerService", "No restore metadata available; halting");
                this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 22, this.mCurrentPackage, 3, null);
                this.mStatus = -1000;
                this.executeNextState(UnifiedRestoreState.FINAL);
                return;
            }
            if (!"@pm@".equals(desc.getPackageName())) {
                Slog.e("BackupManagerService", "Required package metadata but got " + desc.getPackageName());
                this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 23, this.mCurrentPackage, 3, null);
                this.mStatus = -1000;
                this.executeNextState(UnifiedRestoreState.FINAL);
                return;
            }
            this.mCurrentPackage = new PackageInfo();
            this.mCurrentPackage.packageName = "@pm@";
            this.mPmAgent = this.backupManagerService.makeMetadataAgent(null);
            this.mAgent = IBackupAgent.Stub.asInterface(this.mPmAgent.onBind());
            this.initiateOneRestore(this.mCurrentPackage, 0L);
            this.backupManagerService.getBackupHandler().removeMessages(18);
            if (!this.mPmAgent.hasMetadata()) {
                Slog.e("BackupManagerService", "PM agent has no metadata, so not restoring");
                this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 24, this.mCurrentPackage, 3, null);
                EventLog.writeEvent(2832, "@pm@", "Package manager restore metadata missing");
                this.mStatus = -1000;
                this.backupManagerService.getBackupHandler().removeMessages(20, this);
                this.executeNextState(UnifiedRestoreState.FINAL);
                return;
            }
        }
        catch (Exception e) {
            Slog.e("BackupManagerService", "Unable to contact transport for restore: " + e.getMessage());
            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 25, null, 1, null);
            this.mStatus = -1000;
            this.backupManagerService.getBackupHandler().removeMessages(20, this);
            this.executeNextState(UnifiedRestoreState.FINAL);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchNextRestore() {
        block19: {
            UnifiedRestoreState nextState = UnifiedRestoreState.FINAL;
            try {
                String pkgName;
                IBackupTransport transport = this.mTransportClient.connectOrThrow("PerformUnifiedRestoreTask.dispatchNextRestore()");
                this.mRestoreDescription = transport.nextRestorePackage();
                String string2 = pkgName = this.mRestoreDescription != null ? this.mRestoreDescription.getPackageName() : null;
                if (pkgName == null) {
                    Slog.e("BackupManagerService", "Failure getting next package name");
                    EventLog.writeEvent(2831, new Object[0]);
                    nextState = UnifiedRestoreState.FINAL;
                    return;
                }
                if (this.mRestoreDescription == RestoreDescription.NO_MORE_PACKAGES) {
                    Slog.v("BackupManagerService", "No more packages; finishing restore");
                    int millis = (int)(SystemClock.elapsedRealtime() - this.mStartRealtime);
                    EventLog.writeEvent(2834, this.mCount, millis);
                    nextState = UnifiedRestoreState.FINAL;
                    return;
                }
                Slog.i("BackupManagerService", "Next restore package: " + this.mRestoreDescription);
                this.sendOnRestorePackage(pkgName);
                PackageManagerBackupAgent.Metadata metaInfo = this.mPmAgent.getRestoredMetadata(pkgName);
                if (metaInfo == null) {
                    Slog.e("BackupManagerService", "No metadata for " + pkgName);
                    EventLog.writeEvent(2832, pkgName, "Package metadata missing");
                    nextState = UnifiedRestoreState.RUNNING_QUEUE;
                    return;
                }
                try {
                    this.mCurrentPackage = this.backupManagerService.getPackageManager().getPackageInfoAsUser(pkgName, 0x8000000, this.mUserId);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.e("BackupManagerService", "Package not present: " + pkgName);
                    this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 26, this.mCurrentPackage, 3, null);
                    EventLog.writeEvent(2832, pkgName, "Package missing on device");
                    nextState = UnifiedRestoreState.RUNNING_QUEUE;
                    this.executeNextState(nextState);
                    return;
                }
                if (metaInfo.versionCode > this.mCurrentPackage.getLongVersionCode()) {
                    if ((this.mCurrentPackage.applicationInfo.flags & 0x20000) == 0) {
                        String message = "Source version " + metaInfo.versionCode + " > installed version " + this.mCurrentPackage.getLongVersionCode();
                        Slog.w("BackupManagerService", "Package " + pkgName + ": " + message);
                        Bundle monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_RESTORE_VERSION", metaInfo.versionCode);
                        monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(monitoringExtras, "android.app.backup.extra.LOG_RESTORE_ANYWAY", false);
                        this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 27, this.mCurrentPackage, 3, monitoringExtras);
                        EventLog.writeEvent(2832, pkgName, message);
                        nextState = UnifiedRestoreState.RUNNING_QUEUE;
                        return;
                    }
                    Slog.v("BackupManagerService", "Source version " + metaInfo.versionCode + " > installed version " + this.mCurrentPackage.getLongVersionCode() + " but restoreAnyVersion");
                    Bundle monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(null, "android.app.backup.extra.LOG_RESTORE_VERSION", metaInfo.versionCode);
                    monitoringExtras = BackupManagerMonitorUtils.putMonitoringExtra(monitoringExtras, "android.app.backup.extra.LOG_RESTORE_ANYWAY", true);
                    this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 27, this.mCurrentPackage, 3, monitoringExtras);
                }
                this.mWidgetData = null;
                int type = this.mRestoreDescription.getDataType();
                if (type == 1) {
                    nextState = UnifiedRestoreState.RESTORE_KEYVALUE;
                    break block19;
                }
                if (type == 2) {
                    nextState = UnifiedRestoreState.RESTORE_FULL;
                    break block19;
                }
                Slog.e("BackupManagerService", "Unrecognized restore type " + type);
                nextState = UnifiedRestoreState.RUNNING_QUEUE;
                return;
            }
            catch (Exception e) {
                Slog.e("BackupManagerService", "Can't get next restore target from transport; halting: " + e.getMessage());
                EventLog.writeEvent(2831, new Object[0]);
                nextState = UnifiedRestoreState.FINAL;
                return;
            }
            finally {
                this.executeNextState(nextState);
            }
        }
    }

    private void restoreKeyValue() {
        String packageName = this.mCurrentPackage.packageName;
        if (this.mCurrentPackage.applicationInfo.backupAgentName == null || "".equals(this.mCurrentPackage.applicationInfo.backupAgentName)) {
            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 28, this.mCurrentPackage, 2, null);
            EventLog.writeEvent(2832, packageName, "Package has no agent");
            this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
            return;
        }
        PackageManagerBackupAgent.Metadata metaInfo = this.mPmAgent.getRestoredMetadata(packageName);
        PackageManagerInternal pmi = LocalServices.getService(PackageManagerInternal.class);
        if (!BackupUtils.signaturesMatch(metaInfo.sigHashes, this.mCurrentPackage, pmi)) {
            Slog.w("BackupManagerService", "Signature mismatch restoring " + packageName);
            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 29, this.mCurrentPackage, 3, null);
            EventLog.writeEvent(2832, packageName, "Signature mismatch");
            this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
            return;
        }
        this.mAgent = this.backupManagerService.bindToAgentSynchronous(this.mCurrentPackage.applicationInfo, 0);
        if (this.mAgent == null) {
            Slog.w("BackupManagerService", "Can't find backup agent for " + packageName);
            this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 30, this.mCurrentPackage, 3, null);
            EventLog.writeEvent(2832, packageName, "Restore agent missing");
            this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
            return;
        }
        this.mDidLaunch = true;
        try {
            this.initiateOneRestore(this.mCurrentPackage, metaInfo.versionCode);
            ++this.mCount;
        }
        catch (Exception e) {
            Slog.e("BackupManagerService", "Error when attempting restore: " + e.toString());
            this.keyValueAgentErrorCleanup(false);
            this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
        }
    }

    void initiateOneRestore(PackageInfo app, long appVersionCode) {
        String packageName = app.packageName;
        Slog.d("BackupManagerService", "initiateOneRestore packageName=" + packageName);
        this.mBackupDataName = new File(this.backupManagerService.getDataDir(), packageName + ".restore");
        this.mStageName = new File(this.backupManagerService.getDataDir(), packageName + ".stage");
        this.mNewStateName = new File(this.mStateDir, packageName + ".new");
        this.mSavedStateName = new File(this.mStateDir, packageName);
        boolean staging = !packageName.equals("android");
        File downloadFile = staging ? this.mStageName : this.mBackupDataName;
        boolean startedAgentRestore = false;
        try {
            IBackupTransport transport = this.mTransportClient.connectOrThrow("PerformUnifiedRestoreTask.initiateOneRestore()");
            ParcelFileDescriptor stage = ParcelFileDescriptor.open(downloadFile, 0x3C000000);
            if (transport.getRestoreData(stage) != 0) {
                Slog.e("BackupManagerService", "Error getting restore data for " + packageName);
                EventLog.writeEvent(2831, new Object[0]);
                stage.close();
                downloadFile.delete();
                this.executeNextState(UnifiedRestoreState.FINAL);
                return;
            }
            if (staging) {
                stage.close();
                stage = ParcelFileDescriptor.open(downloadFile, 0x10000000);
                this.mBackupData = ParcelFileDescriptor.open(this.mBackupDataName, 0x3C000000);
                BackupDataInput in = new BackupDataInput(stage.getFileDescriptor());
                BackupDataOutput out = new BackupDataOutput(this.mBackupData.getFileDescriptor());
                byte[] buffer = new byte[8192];
                while (in.readNextHeader()) {
                    String key = in.getKey();
                    int size = in.getDataSize();
                    if (key.equals("\uffed\uffedwidget")) {
                        Slog.i("BackupManagerService", "Restoring widget state for " + packageName);
                        this.mWidgetData = new byte[size];
                        in.readEntityData(this.mWidgetData, 0, size);
                        continue;
                    }
                    if (size > buffer.length) {
                        buffer = new byte[size];
                    }
                    in.readEntityData(buffer, 0, size);
                    out.writeEntityHeader(key, size);
                    out.writeEntityData(buffer, size);
                }
                this.mBackupData.close();
            }
            stage.close();
            this.mBackupData = ParcelFileDescriptor.open(this.mBackupDataName, 0x10000000);
            this.mNewState = ParcelFileDescriptor.open(this.mNewStateName, 0x3C000000);
            long restoreAgentTimeoutMillis = this.mAgentTimeoutParameters.getRestoreAgentTimeoutMillis();
            this.backupManagerService.prepareOperationTimeout(this.mEphemeralOpToken, restoreAgentTimeoutMillis, this, 1);
            startedAgentRestore = true;
            this.mAgent.doRestore(this.mBackupData, appVersionCode, this.mNewState, this.mEphemeralOpToken, this.backupManagerService.getBackupManagerBinder());
        }
        catch (Exception e) {
            Slog.e("BackupManagerService", "Unable to call app for restore: " + packageName, e);
            EventLog.writeEvent(2832, packageName, e.toString());
            this.keyValueAgentErrorCleanup(startedAgentRestore);
            this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
        }
    }

    private void restoreFull() {
        try {
            StreamFeederThread feeder = new StreamFeederThread();
            new Thread((Runnable)feeder, "unified-stream-feeder").start();
        }
        catch (IOException e) {
            Slog.e("BackupManagerService", "Unable to construct pipes for stream restore!");
            this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
        }
    }

    private void restoreFinished() {
        Slog.d("BackupManagerService", "restoreFinished packageName=" + this.mCurrentPackage.packageName);
        try {
            long restoreAgentFinishedTimeoutMillis = this.mAgentTimeoutParameters.getRestoreAgentFinishedTimeoutMillis();
            this.backupManagerService.prepareOperationTimeout(this.mEphemeralOpToken, restoreAgentFinishedTimeoutMillis, this, 1);
            this.mAgent.doRestoreFinished(this.mEphemeralOpToken, this.backupManagerService.getBackupManagerBinder());
        }
        catch (Exception e) {
            String packageName = this.mCurrentPackage.packageName;
            Slog.e("BackupManagerService", "Unable to finalize restore of " + packageName);
            EventLog.writeEvent(2832, packageName, e.toString());
            this.keyValueAgentErrorCleanup(true);
            this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeRestore() {
        String callerLogString = "PerformUnifiedRestoreTask.finalizeRestore()";
        try {
            IBackupTransport transport = this.mTransportClient.connectOrThrow(callerLogString);
            transport.finishRestore();
        }
        catch (Exception e) {
            Slog.e("BackupManagerService", "Error finishing restore", e);
        }
        if (this.mObserver != null) {
            try {
                this.mObserver.restoreFinished(this.mStatus);
            }
            catch (RemoteException e) {
                Slog.d("BackupManagerService", "Restore observer died at restoreFinished");
            }
        }
        this.backupManagerService.getBackupHandler().removeMessages(8);
        if (this.mPmToken > 0) {
            try {
                this.backupManagerService.getPackageManagerBinder().finishPackageInstall(this.mPmToken, this.mDidLaunch);
            }
            catch (RemoteException e) {}
        } else {
            long restoreAgentTimeoutMillis = this.mAgentTimeoutParameters.getRestoreAgentTimeoutMillis();
            this.backupManagerService.getBackupHandler().sendEmptyMessageDelayed(8, restoreAgentTimeoutMillis);
        }
        AppWidgetBackupBridge.restoreFinished(this.mUserId);
        if (this.mIsSystemRestore && this.mPmAgent != null) {
            this.backupManagerService.setAncestralPackages(this.mPmAgent.getRestoredPackages());
            this.backupManagerService.setAncestralToken(this.mToken);
            this.backupManagerService.writeRestoreTokens();
        }
        Queue<PerformUnifiedRestoreTask> queue = this.backupManagerService.getPendingRestores();
        synchronized (queue) {
            if (this.backupManagerService.getPendingRestores().size() > 0) {
                Slog.d("BackupManagerService", "Starting next pending restore.");
                PerformUnifiedRestoreTask task = this.backupManagerService.getPendingRestores().remove();
                this.backupManagerService.getBackupHandler().sendMessage(this.backupManagerService.getBackupHandler().obtainMessage(20, task));
            } else {
                this.backupManagerService.setRestoreInProgress(false);
            }
        }
        Slog.i("BackupManagerService", "Restore complete.");
        this.mListener.onFinished(callerLogString);
    }

    void keyValueAgentErrorCleanup(boolean clearAppData) {
        if (clearAppData) {
            this.backupManagerService.clearApplicationDataAfterRestoreFailure(this.mCurrentPackage.packageName);
        }
        this.keyValueAgentCleanup();
    }

    void keyValueAgentCleanup() {
        this.mBackupDataName.delete();
        this.mStageName.delete();
        try {
            if (this.mBackupData != null) {
                this.mBackupData.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.mNewState != null) {
                this.mNewState.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mNewState = null;
        this.mBackupData = null;
        this.mNewStateName.delete();
        if (this.mCurrentPackage.applicationInfo != null) {
            try {
                boolean killAfterRestore;
                this.backupManagerService.getActivityManager().unbindBackupAgent(this.mCurrentPackage.applicationInfo);
                int appFlags = this.mCurrentPackage.applicationInfo.flags;
                boolean bl = killAfterRestore = !UserHandle.isCore(this.mCurrentPackage.applicationInfo.uid) && (this.mRestoreDescription.getDataType() == 2 || (appFlags & 0x10000) != 0);
                if (this.mTargetPackage == null && killAfterRestore) {
                    Slog.d("BackupManagerService", "Restore complete, killing host process of " + this.mCurrentPackage.applicationInfo.processName);
                    this.backupManagerService.getActivityManager().killApplicationProcess(this.mCurrentPackage.applicationInfo.processName, this.mCurrentPackage.applicationInfo.uid);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.backupManagerService.getBackupHandler().removeMessages(18, this);
    }

    @Override
    public void operationComplete(long unusedResult) {
        UnifiedRestoreState nextState;
        this.backupManagerService.removeOperation(this.mEphemeralOpToken);
        switch (this.mState) {
            case INITIAL: {
                nextState = UnifiedRestoreState.RUNNING_QUEUE;
                break;
            }
            case RESTORE_KEYVALUE: 
            case RESTORE_FULL: {
                nextState = UnifiedRestoreState.RESTORE_FINISHED;
                break;
            }
            case RESTORE_FINISHED: {
                int size = (int)this.mBackupDataName.length();
                EventLog.writeEvent(2833, this.mCurrentPackage.packageName, size);
                this.keyValueAgentCleanup();
                if (this.mWidgetData != null) {
                    this.backupManagerService.restoreWidgetData(this.mCurrentPackage.packageName, this.mWidgetData);
                }
                nextState = UnifiedRestoreState.RUNNING_QUEUE;
                break;
            }
            default: {
                Slog.e("BackupManagerService", "Unexpected restore callback into state " + (Object)((Object)this.mState));
                this.keyValueAgentErrorCleanup(true);
                nextState = UnifiedRestoreState.FINAL;
            }
        }
        this.executeNextState(nextState);
    }

    @Override
    public void handleCancel(boolean cancelAll) {
        this.backupManagerService.removeOperation(this.mEphemeralOpToken);
        Slog.e("BackupManagerService", "Timeout restoring application " + this.mCurrentPackage.packageName);
        this.mMonitor = BackupManagerMonitorUtils.monitorEvent(this.mMonitor, 31, this.mCurrentPackage, 2, null);
        EventLog.writeEvent(2832, this.mCurrentPackage.packageName, "restore timeout");
        this.keyValueAgentErrorCleanup(true);
        this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
    }

    void executeNextState(UnifiedRestoreState nextState) {
        this.mState = nextState;
        Message msg = this.backupManagerService.getBackupHandler().obtainMessage(20, this);
        this.backupManagerService.getBackupHandler().sendMessage(msg);
    }

    void sendStartRestore(int numPackages) {
        if (this.mObserver != null) {
            try {
                this.mObserver.restoreStarting(numPackages);
            }
            catch (RemoteException e) {
                Slog.w("BackupManagerService", "Restore observer went away: startRestore");
                this.mObserver = null;
            }
        }
    }

    void sendOnRestorePackage(String name) {
        if (this.mObserver != null) {
            try {
                this.mObserver.onUpdate(this.mCount, name);
            }
            catch (RemoteException e) {
                Slog.d("BackupManagerService", "Restore observer died in onUpdate");
                this.mObserver = null;
            }
        }
    }

    void sendEndRestore() {
        if (this.mObserver != null) {
            try {
                this.mObserver.restoreFinished(this.mStatus);
            }
            catch (RemoteException e) {
                Slog.w("BackupManagerService", "Restore observer went away: endRestore");
                this.mObserver = null;
            }
        }
    }

    static /* synthetic */ byte[] access$602(PerformUnifiedRestoreTask x0, byte[] x1) {
        x0.mWidgetData = x1;
        return x1;
    }

    class StreamFeederThread
    extends RestoreEngine
    implements Runnable,
    BackupRestoreTask {
        final String TAG = "StreamFeederThread";
        FullRestoreEngine mEngine;
        FullRestoreEngineThread mEngineThread;
        ParcelFileDescriptor[] mTransportPipes;
        ParcelFileDescriptor[] mEnginePipes;
        private final int mEphemeralOpToken;

        public StreamFeederThread() throws IOException {
            this.mEphemeralOpToken = PerformUnifiedRestoreTask.this.backupManagerService.generateRandomIntegerToken();
            this.mTransportPipes = ParcelFileDescriptor.createPipe();
            this.mEnginePipes = ParcelFileDescriptor.createPipe();
            this.setRunning(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            IBackupTransport transport;
            UnifiedRestoreState nextState = UnifiedRestoreState.RUNNING_QUEUE;
            int status = 0;
            EventLog.writeEvent(2844, ((PerformUnifiedRestoreTask)PerformUnifiedRestoreTask.this).mCurrentPackage.packageName);
            this.mEngine = new FullRestoreEngine(PerformUnifiedRestoreTask.this.backupManagerService, this, null, PerformUnifiedRestoreTask.this.mMonitor, PerformUnifiedRestoreTask.this.mCurrentPackage, false, false, this.mEphemeralOpToken, false);
            this.mEngineThread = new FullRestoreEngineThread(this.mEngine, this.mEnginePipes[0]);
            ParcelFileDescriptor eWriteEnd = this.mEnginePipes[1];
            ParcelFileDescriptor tReadEnd = this.mTransportPipes[0];
            ParcelFileDescriptor tWriteEnd = this.mTransportPipes[1];
            int bufferSize = 32768;
            byte[] buffer = new byte[bufferSize];
            FileOutputStream engineOut = new FileOutputStream(eWriteEnd.getFileDescriptor());
            FileInputStream transportIn = new FileInputStream(tReadEnd.getFileDescriptor());
            new Thread((Runnable)this.mEngineThread, "unified-restore-engine").start();
            String callerLogString = "PerformUnifiedRestoreTask$StreamFeederThread.run()";
            try {
                transport = PerformUnifiedRestoreTask.this.mTransportClient.connectOrThrow(callerLogString);
                while (status == 0) {
                    int result = transport.getNextFullRestoreDataChunk(tWriteEnd);
                    if (result > 0) {
                        int n;
                        if (result > bufferSize) {
                            bufferSize = result;
                            buffer = new byte[bufferSize];
                        }
                        for (int toCopy = result; toCopy > 0; toCopy -= n) {
                            n = transportIn.read(buffer, 0, toCopy);
                            engineOut.write(buffer, 0, n);
                        }
                        continue;
                    }
                    if (result == -1) {
                        status = 0;
                        break;
                    }
                    Slog.e("StreamFeederThread", "Error " + result + " streaming restore for " + ((PerformUnifiedRestoreTask)PerformUnifiedRestoreTask.this).mCurrentPackage.packageName);
                    EventLog.writeEvent(2831, new Object[0]);
                    status = result;
                }
            }
            catch (IOException e) {
                Slog.e("StreamFeederThread", "Unable to route data for restore");
                EventLog.writeEvent(2832, ((PerformUnifiedRestoreTask)PerformUnifiedRestoreTask.this).mCurrentPackage.packageName, "I/O error on pipes");
                status = -1003;
                IoUtils.closeQuietly(this.mEnginePipes[1]);
                IoUtils.closeQuietly(this.mTransportPipes[0]);
                IoUtils.closeQuietly(this.mTransportPipes[1]);
                this.mEngineThread.waitForResult();
                IoUtils.closeQuietly(this.mEnginePipes[0]);
                PerformUnifiedRestoreTask.this.mDidLaunch = this.mEngine.getAgent() != null;
                if (status == 0) {
                    nextState = UnifiedRestoreState.RESTORE_FINISHED;
                    PerformUnifiedRestoreTask.this.mAgent = this.mEngine.getAgent();
                    PerformUnifiedRestoreTask.access$602(PerformUnifiedRestoreTask.this, this.mEngine.getWidgetData());
                } else {
                    try {
                        IBackupTransport transport2 = PerformUnifiedRestoreTask.this.mTransportClient.connectOrThrow(callerLogString);
                        transport2.abortFullRestore();
                    }
                    catch (Exception e2) {
                        Slog.e("StreamFeederThread", "Transport threw from abortFullRestore: " + e2.getMessage());
                        status = -1000;
                    }
                    PerformUnifiedRestoreTask.this.backupManagerService.clearApplicationDataAfterRestoreFailure(((PerformUnifiedRestoreTask)PerformUnifiedRestoreTask.this).mCurrentPackage.packageName);
                    nextState = status == -1000 ? UnifiedRestoreState.FINAL : UnifiedRestoreState.RUNNING_QUEUE;
                }
                PerformUnifiedRestoreTask.this.executeNextState(nextState);
                this.setRunning(false);
            }
            catch (Exception e2) {
                Slog.e("StreamFeederThread", "Transport failed during restore: " + e2.getMessage());
                EventLog.writeEvent(2831, new Object[0]);
                status = -1000;
                {
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(this.mEnginePipes[1]);
                        IoUtils.closeQuietly(this.mTransportPipes[0]);
                        IoUtils.closeQuietly(this.mTransportPipes[1]);
                        this.mEngineThread.waitForResult();
                        IoUtils.closeQuietly(this.mEnginePipes[0]);
                        PerformUnifiedRestoreTask.this.mDidLaunch = this.mEngine.getAgent() != null;
                        if (status == 0) {
                            nextState = UnifiedRestoreState.RESTORE_FINISHED;
                            PerformUnifiedRestoreTask.this.mAgent = this.mEngine.getAgent();
                            PerformUnifiedRestoreTask.access$602(PerformUnifiedRestoreTask.this, this.mEngine.getWidgetData());
                        } else {
                            try {
                                IBackupTransport transport3 = PerformUnifiedRestoreTask.this.mTransportClient.connectOrThrow(callerLogString);
                                transport3.abortFullRestore();
                            }
                            catch (Exception e3) {
                                Slog.e("StreamFeederThread", "Transport threw from abortFullRestore: " + e3.getMessage());
                                status = -1000;
                            }
                            PerformUnifiedRestoreTask.this.backupManagerService.clearApplicationDataAfterRestoreFailure(((PerformUnifiedRestoreTask)PerformUnifiedRestoreTask.this).mCurrentPackage.packageName);
                            nextState = status == -1000 ? UnifiedRestoreState.FINAL : UnifiedRestoreState.RUNNING_QUEUE;
                        }
                        PerformUnifiedRestoreTask.this.executeNextState(nextState);
                        this.setRunning(false);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(this.mEnginePipes[1]);
                IoUtils.closeQuietly(this.mTransportPipes[0]);
                IoUtils.closeQuietly(this.mTransportPipes[1]);
                this.mEngineThread.waitForResult();
                IoUtils.closeQuietly(this.mEnginePipes[0]);
                PerformUnifiedRestoreTask.this.mDidLaunch = this.mEngine.getAgent() != null;
                if (status == 0) {
                    nextState = UnifiedRestoreState.RESTORE_FINISHED;
                    PerformUnifiedRestoreTask.this.mAgent = this.mEngine.getAgent();
                    PerformUnifiedRestoreTask.access$602(PerformUnifiedRestoreTask.this, this.mEngine.getWidgetData());
                } else {
                    try {
                        IBackupTransport transport4 = PerformUnifiedRestoreTask.this.mTransportClient.connectOrThrow(callerLogString);
                        transport4.abortFullRestore();
                    }
                    catch (Exception e4) {
                        Slog.e("StreamFeederThread", "Transport threw from abortFullRestore: " + e4.getMessage());
                        status = -1000;
                    }
                    PerformUnifiedRestoreTask.this.backupManagerService.clearApplicationDataAfterRestoreFailure(((PerformUnifiedRestoreTask)PerformUnifiedRestoreTask.this).mCurrentPackage.packageName);
                    nextState = status == -1000 ? UnifiedRestoreState.FINAL : UnifiedRestoreState.RUNNING_QUEUE;
                }
                PerformUnifiedRestoreTask.this.executeNextState(nextState);
                this.setRunning(false);
            }
            IoUtils.closeQuietly(this.mEnginePipes[1]);
            IoUtils.closeQuietly(this.mTransportPipes[0]);
            IoUtils.closeQuietly(this.mTransportPipes[1]);
            this.mEngineThread.waitForResult();
            IoUtils.closeQuietly(this.mEnginePipes[0]);
            PerformUnifiedRestoreTask.this.mDidLaunch = this.mEngine.getAgent() != null;
            if (status == 0) {
                nextState = UnifiedRestoreState.RESTORE_FINISHED;
                PerformUnifiedRestoreTask.this.mAgent = this.mEngine.getAgent();
                PerformUnifiedRestoreTask.access$602(PerformUnifiedRestoreTask.this, this.mEngine.getWidgetData());
            } else {
                try {
                    transport = PerformUnifiedRestoreTask.this.mTransportClient.connectOrThrow(callerLogString);
                    transport.abortFullRestore();
                }
                catch (Exception e) {
                    Slog.e("StreamFeederThread", "Transport threw from abortFullRestore: " + e.getMessage());
                    status = -1000;
                }
                PerformUnifiedRestoreTask.this.backupManagerService.clearApplicationDataAfterRestoreFailure(((PerformUnifiedRestoreTask)PerformUnifiedRestoreTask.this).mCurrentPackage.packageName);
                nextState = status == -1000 ? UnifiedRestoreState.FINAL : UnifiedRestoreState.RUNNING_QUEUE;
            }
            PerformUnifiedRestoreTask.this.executeNextState(nextState);
            this.setRunning(false);
        }

        @Override
        public void execute() {
        }

        @Override
        public void operationComplete(long result) {
        }

        @Override
        public void handleCancel(boolean cancelAll) {
            PerformUnifiedRestoreTask.this.backupManagerService.removeOperation(this.mEphemeralOpToken);
            Slog.w("StreamFeederThread", "Full-data restore target timed out; shutting down");
            PerformUnifiedRestoreTask.this.mMonitor = BackupManagerMonitorUtils.monitorEvent(PerformUnifiedRestoreTask.this.mMonitor, 45, PerformUnifiedRestoreTask.this.mCurrentPackage, 2, null);
            this.mEngineThread.handleTimeout();
            IoUtils.closeQuietly(this.mEnginePipes[1]);
            this.mEnginePipes[1] = null;
            IoUtils.closeQuietly(this.mEnginePipes[0]);
            this.mEnginePipes[0] = null;
        }
    }
}

