/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.transport;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.android.server.backup.transport.TransportClient;
import com.android.server.backup.transport.TransportStats;
import com.android.server.backup.transport.TransportUtils;
import java.io.PrintWriter;
import java.util.Map;
import java.util.WeakHashMap;

public class TransportClientManager {
    private static final String TAG = "TransportClientManager";
    private final int mUserId;
    private final Context mContext;
    private final TransportStats mTransportStats;
    private final Object mTransportClientsLock = new Object();
    private int mTransportClientsCreated = 0;
    private Map<TransportClient, String> mTransportClientsCallerMap = new WeakHashMap<TransportClient, String>();

    public TransportClientManager(int userId, Context context, TransportStats transportStats) {
        this.mUserId = userId;
        this.mContext = context;
        this.mTransportStats = transportStats;
    }

    public TransportClient getTransportClient(ComponentName transportComponent, String caller) {
        Intent bindIntent = new Intent("android.backup.TRANSPORT_HOST").setComponent(transportComponent);
        return this.getTransportClient(transportComponent, caller, bindIntent);
    }

    public TransportClient getTransportClient(ComponentName transportComponent, Bundle extras, String caller) {
        Intent bindIntent = new Intent("android.backup.TRANSPORT_HOST").setComponent(transportComponent);
        bindIntent.putExtras(extras);
        return this.getTransportClient(transportComponent, caller, bindIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransportClient getTransportClient(ComponentName transportComponent, String caller, Intent bindIntent) {
        Object object = this.mTransportClientsLock;
        synchronized (object) {
            TransportClient transportClient = new TransportClient(this.mUserId, this.mContext, this.mTransportStats, bindIntent, transportComponent, Integer.toString(this.mTransportClientsCreated), caller);
            this.mTransportClientsCallerMap.put(transportClient, caller);
            ++this.mTransportClientsCreated;
            TransportUtils.log(3, TAG, TransportUtils.formatMessage(null, caller, "Retrieving " + transportClient));
            return transportClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeOfTransportClient(TransportClient transportClient, String caller) {
        transportClient.unbind(caller);
        transportClient.markAsDisposed();
        Object object = this.mTransportClientsLock;
        synchronized (object) {
            TransportUtils.log(3, TAG, TransportUtils.formatMessage(null, caller, "Disposing of " + transportClient));
            this.mTransportClientsCallerMap.remove(transportClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        pw.println("Transport clients created: " + this.mTransportClientsCreated);
        Object object = this.mTransportClientsLock;
        synchronized (object) {
            pw.println("Current transport clients: " + this.mTransportClientsCallerMap.size());
            for (TransportClient transportClient : this.mTransportClientsCallerMap.keySet()) {
                String caller = this.mTransportClientsCallerMap.get(transportClient);
                pw.println("    " + transportClient + " [" + caller + "]");
                for (String logEntry : transportClient.getLogBuffer()) {
                    pw.println("        " + logEntry);
                }
            }
        }
    }
}

