/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.transport;

import android.util.Log;
import android.util.Slog;
import com.android.internal.backup.IBackupTransport;
import com.android.server.backup.transport.TransportNotAvailableException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TransportUtils {
    private static final String TAG = "TransportUtils";

    public static IBackupTransport checkTransportNotNull(IBackupTransport transport) throws TransportNotAvailableException {
        if (transport == null) {
            TransportUtils.log(6, TAG, "Transport not available");
            throw new TransportNotAvailableException();
        }
        return transport;
    }

    static void log(int priority, String tag, String message) {
        if (priority == -1) {
            Slog.wtf(tag, message);
        } else if (Log.isLoggable(tag, priority)) {
            Slog.println(priority, tag, message);
        }
    }

    static String formatMessage(String prefix, String caller, String message) {
        StringBuilder string2 = new StringBuilder();
        if (prefix != null) {
            string2.append(prefix).append(" ");
        }
        if (caller != null) {
            string2.append("[").append(caller).append("] ");
        }
        return string2.append(message).toString();
    }

    private TransportUtils() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Priority {
        public static final int VERBOSE = 2;
        public static final int DEBUG = 3;
        public static final int INFO = 4;
        public static final int WARN = 5;
        public static final int ERROR = 6;
        public static final int WTF = -1;
    }
}

