/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.utils;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.backup.IBackupTransport;
import com.android.internal.util.ArrayUtils;
import com.android.server.LocalServices;
import com.android.server.backup.transport.TransportClient;
import com.google.android.collect.Sets;
import java.util.Set;

public class AppBackupUtils {
    private static final boolean DEBUG = false;
    private static final Set<String> systemPackagesWhitelistedForAllUsers = Sets.newArraySet("@pm@", "android");

    public static boolean appIsEligibleForBackup(ApplicationInfo app, int userId) {
        return AppBackupUtils.appIsEligibleForBackup(app, LocalServices.getService(PackageManagerInternal.class), userId);
    }

    @VisibleForTesting
    static boolean appIsEligibleForBackup(ApplicationInfo app, PackageManagerInternal packageManager, int userId) {
        if ((app.flags & 0x8000) == 0) {
            return false;
        }
        if (UserHandle.isCore(app.uid)) {
            if (userId != 0 && !systemPackagesWhitelistedForAllUsers.contains(app.packageName)) {
                return false;
            }
            if (app.backupAgentName == null) {
                return false;
            }
        }
        if (app.packageName.equals("com.android.sharedstoragebackup")) {
            return false;
        }
        if (app.isInstantApp()) {
            return false;
        }
        return !AppBackupUtils.appIsDisabled(app, packageManager, userId);
    }

    public static boolean appIsRunningAndEligibleForBackupWithTransport(TransportClient transportClient, String packageName, PackageManager pm, int userId) {
        try {
            PackageInfo packageInfo = pm.getPackageInfoAsUser(packageName, 0x8000000, userId);
            ApplicationInfo applicationInfo = packageInfo.applicationInfo;
            if (!AppBackupUtils.appIsEligibleForBackup(applicationInfo, userId) || AppBackupUtils.appIsStopped(applicationInfo) || AppBackupUtils.appIsDisabled(applicationInfo, userId)) {
                return false;
            }
            if (transportClient != null) {
                try {
                    IBackupTransport transport = transportClient.connectOrThrow("AppBackupUtils.appIsRunningAndEligibleForBackupWithTransport");
                    return transport.isAppEligibleForBackup(packageInfo, AppBackupUtils.appGetsFullBackup(packageInfo));
                }
                catch (Exception e) {
                    Slog.e("BackupManagerService", "Unable to ask about eligibility: " + e.getMessage());
                }
            }
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    static boolean appIsDisabled(ApplicationInfo app, int userId) {
        return AppBackupUtils.appIsDisabled(app, LocalServices.getService(PackageManagerInternal.class), userId);
    }

    @VisibleForTesting
    static boolean appIsDisabled(ApplicationInfo app, PackageManagerInternal packageManager, int userId) {
        int enabledSetting = packageManager.getApplicationEnabledState(app.packageName, userId);
        switch (enabledSetting) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
            case 0: {
                return !app.enabled;
            }
        }
        return false;
    }

    public static boolean appIsStopped(ApplicationInfo app) {
        return (app.flags & 0x200000) != 0;
    }

    public static boolean appGetsFullBackup(PackageInfo pkg) {
        if (pkg.applicationInfo.backupAgentName != null) {
            return (pkg.applicationInfo.flags & 0x4000000) != 0;
        }
        return true;
    }

    public static boolean appIsKeyValueOnly(PackageInfo pkg) {
        return !AppBackupUtils.appGetsFullBackup(pkg);
    }

    public static boolean signaturesMatch(Signature[] storedSigs, PackageInfo target, PackageManagerInternal pmi) {
        if (target == null || target.packageName == null) {
            return false;
        }
        if ((target.applicationInfo.flags & 1) != 0) {
            return true;
        }
        if (ArrayUtils.isEmpty(storedSigs)) {
            return false;
        }
        SigningInfo signingInfo = target.signingInfo;
        if (signingInfo == null) {
            Slog.w("BackupManagerService", "signingInfo is empty, app was either unsigned or the flag PackageManager#GET_SIGNING_CERTIFICATES was not specified");
            return false;
        }
        int nStored = storedSigs.length;
        if (nStored == 1) {
            return pmi.isDataRestoreSafe(storedSigs[0], target.packageName);
        }
        Signature[] deviceSigs = signingInfo.getApkContentsSigners();
        int nDevice = deviceSigs.length;
        for (int i = 0; i < nStored; ++i) {
            boolean match = false;
            for (int j = 0; j < nDevice; ++j) {
                if (!storedSigs[i].equals(deviceSigs[j])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }
}

