/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.utils;

import android.os.ParcelFileDescriptor;
import android.util.Slog;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FullBackupUtils {
    public static void routeSocketDataToOutput(ParcelFileDescriptor inPipe, OutputStream out) throws IOException {
        int chunkTotal;
        FileInputStream raw2 = new FileInputStream(inPipe.getFileDescriptor());
        DataInputStream in = new DataInputStream(raw2);
        byte[] buffer = new byte[32768];
        while ((chunkTotal = in.readInt()) > 0) {
            while (chunkTotal > 0) {
                int toRead = chunkTotal > buffer.length ? buffer.length : chunkTotal;
                int nRead = in.read(buffer, 0, toRead);
                if (nRead < 0) {
                    Slog.e("BackupManagerService", "Unexpectedly reached end of file while reading data");
                    throw new EOFException();
                }
                out.write(buffer, 0, nRead);
                chunkTotal -= nRead;
            }
        }
    }
}

