/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics;

import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.os.IBinder;
import android.os.RemoteException;
import android.security.KeyStore;
import android.util.Slog;
import com.android.server.biometrics.BiometricServiceBase;
import com.android.server.biometrics.ClientMonitor;
import com.android.server.biometrics.Constants;
import java.util.ArrayList;

public abstract class AuthenticationClient
extends ClientMonitor {
    private long mOpId;
    public static final int LOCKOUT_NONE = 0;
    public static final int LOCKOUT_TIMED = 1;
    public static final int LOCKOUT_PERMANENT = 2;
    private final boolean mRequireConfirmation;
    private boolean mStarted;

    public abstract int handleFailedAttempt();

    public void resetFailedAttempts() {
    }

    public abstract void onStart();

    public abstract void onStop();

    public abstract boolean shouldFrameworkHandleLockout();

    public abstract boolean wasUserDetected();

    public AuthenticationClient(Context context, Constants constants, BiometricServiceBase.DaemonWrapper daemon, long halDeviceId, IBinder token, BiometricServiceBase.ServiceListener listener, int targetUserId, int groupId, long opId, boolean restricted, String owner, int cookie, boolean requireConfirmation) {
        super(context, constants, daemon, halDeviceId, token, listener, targetUserId, groupId, restricted, owner, cookie);
        this.mOpId = opId;
        this.mRequireConfirmation = requireConfirmation;
    }

    @Override
    public void binderDied() {
        super.binderDied();
        this.stop(false);
    }

    @Override
    protected int statsAction() {
        return 2;
    }

    public boolean isBiometricPrompt() {
        return this.getCookie() != 0;
    }

    public boolean getRequireConfirmation() {
        return this.mRequireConfirmation;
    }

    @Override
    protected boolean isCryptoOperation() {
        return this.mOpId != 0L;
    }

    @Override
    public boolean onError(long deviceId, int error, int vendorCode) {
        if (!this.shouldFrameworkHandleLockout()) {
            switch (error) {
                case 3: {
                    if (!this.wasUserDetected() && !this.isBiometricPrompt()) break;
                }
                case 7: 
                case 9: {
                    if (!this.mStarted) break;
                    this.vibrateError();
                    break;
                }
            }
        }
        return super.onError(deviceId, error, vendorCode);
    }

    @Override
    public boolean onAuthenticated(BiometricAuthenticator.Identifier identifier, boolean authenticated, ArrayList<Byte> token) {
        boolean result;
        block17: {
            super.logOnAuthenticated(this.getContext(), authenticated, this.mRequireConfirmation, this.getTargetUserId(), this.isBiometricPrompt());
            BiometricServiceBase.ServiceListener listener = this.getListener();
            this.mMetricsLogger.action(this.mConstants.actionBiometricAuth(), authenticated);
            result = false;
            try {
                int lockoutMode;
                Slog.v(this.getLogTag(), "onAuthenticated(" + authenticated + "), ID:" + identifier.getBiometricId() + ", Owner: " + this.getOwnerString() + ", isBP: " + this.isBiometricPrompt() + ", listener: " + listener + ", requireConfirmation: " + this.mRequireConfirmation + ", user: " + this.getTargetUserId());
                if (authenticated) {
                    this.mAlreadyDone = true;
                    if (listener != null) {
                        this.vibrateSuccess();
                    }
                    result = true;
                    if (this.shouldFrameworkHandleLockout()) {
                        this.resetFailedAttempts();
                    }
                    this.onStop();
                    byte[] byteToken = new byte[token.size()];
                    for (int i = 0; i < token.size(); ++i) {
                        byteToken[i] = token.get(i);
                    }
                    if (this.isBiometricPrompt() && listener != null) {
                        listener.onAuthenticationSucceededInternal(this.mRequireConfirmation, byteToken);
                        break block17;
                    }
                    if (!this.isBiometricPrompt() && listener != null) {
                        KeyStore.getInstance().addAuthToken(byteToken);
                        try {
                            if (!this.getIsRestricted()) {
                                listener.onAuthenticationSucceeded(this.getHalDeviceId(), identifier, this.getTargetUserId());
                                break block17;
                            }
                            listener.onAuthenticationSucceeded(this.getHalDeviceId(), null, this.getTargetUserId());
                        }
                        catch (RemoteException e) {
                            Slog.e(this.getLogTag(), "Remote exception", e);
                        }
                        break block17;
                    }
                    Slog.w(this.getLogTag(), "Client not listening");
                    result = true;
                    break block17;
                }
                if (listener != null) {
                    this.vibrateError();
                }
                if ((lockoutMode = this.handleFailedAttempt()) != 0 && this.shouldFrameworkHandleLockout()) {
                    Slog.w(this.getLogTag(), "Forcing lockout (driver code should do this!), mode(" + lockoutMode + ")");
                    this.stop(false);
                    int errorCode = lockoutMode == 1 ? 7 : 9;
                    this.onError(this.getHalDeviceId(), errorCode, 0);
                } else if (listener != null) {
                    if (this.isBiometricPrompt()) {
                        listener.onAuthenticationFailedInternal(this.getCookie(), this.getRequireConfirmation());
                    } else {
                        listener.onAuthenticationFailed(this.getHalDeviceId());
                    }
                }
                result = lockoutMode != 0;
            }
            catch (RemoteException e) {
                Slog.e(this.getLogTag(), "Remote exception", e);
                result = true;
            }
        }
        return result;
    }

    @Override
    public int start() {
        this.mStarted = true;
        this.onStart();
        try {
            int result = this.getDaemonWrapper().authenticate(this.mOpId, this.getGroupId());
            if (result != 0) {
                Slog.w(this.getLogTag(), "startAuthentication failed, result=" + result);
                this.mMetricsLogger.histogram(this.mConstants.tagAuthStartError(), result);
                this.onError(this.getHalDeviceId(), 1, 0);
                return result;
            }
            Slog.w(this.getLogTag(), "client " + this.getOwnerString() + " is authenticating...");
        }
        catch (RemoteException e) {
            Slog.e(this.getLogTag(), "startAuthentication failed", e);
            return 3;
        }
        return 0;
    }

    @Override
    public int stop(boolean initiatedByClient) {
        if (this.mAlreadyCancelled) {
            Slog.w(this.getLogTag(), "stopAuthentication: already cancelled!");
            return 0;
        }
        this.mStarted = false;
        this.onStop();
        try {
            int result = this.getDaemonWrapper().cancel();
            if (result != 0) {
                Slog.w(this.getLogTag(), "stopAuthentication failed, result=" + result);
                return result;
            }
            Slog.w(this.getLogTag(), "client " + this.getOwnerString() + " is no longer authenticating");
        }
        catch (RemoteException e) {
            Slog.e(this.getLogTag(), "stopAuthentication failed", e);
            return 3;
        }
        this.mAlreadyCancelled = true;
        return 0;
    }

    @Override
    public boolean onEnrollResult(BiometricAuthenticator.Identifier identifier, int remaining) {
        Slog.w(this.getLogTag(), "onEnrollResult() called for authenticate!");
        return true;
    }

    @Override
    public boolean onRemoved(BiometricAuthenticator.Identifier identifier, int remaining) {
        Slog.w(this.getLogTag(), "onRemoved() called for authenticate!");
        return true;
    }

    @Override
    public boolean onEnumerationResult(BiometricAuthenticator.Identifier identifier, int remaining) {
        Slog.w(this.getLogTag(), "onEnumerationResult() called for authenticate!");
        return true;
    }
}

