/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics;

import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.app.AppOpsManager;
import android.app.IActivityTaskManager;
import android.app.KeyguardManager;
import android.app.TaskStackListener;
import android.app.UserSwitchObserver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.BiometricSourceType;
import android.hardware.biometrics.IBiometricConfirmDeviceCredentialCallback;
import android.hardware.biometrics.IBiometricEnabledOnKeyguardCallback;
import android.hardware.biometrics.IBiometricService;
import android.hardware.biometrics.IBiometricServiceReceiver;
import android.hardware.biometrics.IBiometricServiceReceiverInternal;
import android.hardware.face.FaceManager;
import android.hardware.face.IFaceService;
import android.hardware.fingerprint.FingerprintManager;
import android.hardware.fingerprint.IFingerprintService;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.security.KeyStore;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Slog;
import android.util.StatsLog;
import com.android.internal.os.SomeArgs;
import com.android.internal.statusbar.IStatusBarService;
import com.android.server.SystemService;
import com.android.server.biometrics.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class BiometricService
extends SystemService {
    private static final String TAG = "BiometricService";
    private static final boolean DEBUG = true;
    private static final int MSG_ON_TASK_STACK_CHANGED = 1;
    private static final int MSG_ON_AUTHENTICATION_SUCCEEDED = 2;
    private static final int MSG_ON_AUTHENTICATION_FAILED = 3;
    private static final int MSG_ON_ERROR = 4;
    private static final int MSG_ON_ACQUIRED = 5;
    private static final int MSG_ON_DISMISSED = 6;
    private static final int MSG_ON_TRY_AGAIN_PRESSED = 7;
    private static final int MSG_ON_READY_FOR_AUTHENTICATION = 8;
    private static final int MSG_AUTHENTICATE = 9;
    private static final int MSG_CANCEL_AUTHENTICATION = 10;
    private static final int MSG_ON_CONFIRM_DEVICE_CREDENTIAL_SUCCESS = 11;
    private static final int MSG_ON_CONFIRM_DEVICE_CREDENTIAL_ERROR = 12;
    private static final int MSG_REGISTER_CANCELLATION_CALLBACK = 13;
    private static final int[] FEATURE_ID = new int[]{1, 2, 4};
    private static final int STATE_AUTH_IDLE = 0;
    private static final int STATE_AUTH_CALLED = 1;
    private static final int STATE_AUTH_STARTED = 2;
    private static final int STATE_AUTH_PAUSED = 3;
    private static final int STATE_AUTH_PENDING_CONFIRM = 5;
    private static final int STATE_BIOMETRIC_AUTH_CANCELED_SHOWING_CDC = 6;
    private final AppOpsManager mAppOps;
    private final boolean mHasFeatureFingerprint;
    private final boolean mHasFeatureIris;
    private final boolean mHasFeatureFace;
    private final SettingObserver mSettingObserver;
    private final List<EnabledOnKeyguardCallback> mEnabledOnKeyguardCallbacks;
    private final BiometricTaskStackListener mTaskStackListener = new BiometricTaskStackListener();
    private final Random mRandom = new Random();
    private IFingerprintService mFingerprintService;
    private IFaceService mFaceService;
    private IActivityTaskManager mActivityTaskManager;
    private IStatusBarService mStatusBarService;
    final ArrayList<Authenticator> mAuthenticators = new ArrayList();
    private int mCurrentModality;
    private AuthSession mCurrentAuthSession;
    private AuthSession mPendingAuthSession;
    private IBiometricServiceReceiver mConfirmDeviceCredentialReceiver;
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    BiometricService.this.handleTaskStackChanged();
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    BiometricService.this.handleAuthenticationSucceeded((Boolean)args.arg1, (byte[])args.arg2);
                    args.recycle();
                    break;
                }
                case 3: {
                    BiometricService.this.handleAuthenticationFailed((String)msg.obj);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    BiometricService.this.handleOnError(args.argi1, args.argi2, (String)args.arg1);
                    args.recycle();
                    break;
                }
                case 5: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    BiometricService.this.handleOnAcquired(args.argi1, (String)args.arg1);
                    args.recycle();
                    break;
                }
                case 6: {
                    BiometricService.this.handleOnDismissed(msg.arg1);
                    break;
                }
                case 7: {
                    BiometricService.this.handleOnTryAgainPressed();
                    break;
                }
                case 8: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    BiometricService.this.handleOnReadyForAuthentication(args.argi1, (Boolean)args.arg1, args.argi2);
                    args.recycle();
                    break;
                }
                case 9: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    BiometricService.this.handleAuthenticate((IBinder)args.arg1, (Long)args.arg2, args.argi1, (IBiometricServiceReceiver)args.arg3, (String)args.arg4, (Bundle)args.arg5, args.argi2, args.argi3, args.argi4, (IBiometricConfirmDeviceCredentialCallback)args.arg6);
                    args.recycle();
                    break;
                }
                case 10: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    BiometricService.this.handleCancelAuthentication((IBinder)args.arg1, (String)args.arg2);
                    args.recycle();
                    break;
                }
                case 11: {
                    BiometricService.this.handleOnConfirmDeviceCredentialSuccess();
                    break;
                }
                case 12: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    BiometricService.this.handleOnConfirmDeviceCredentialError(args.argi1, (String)args.arg1);
                    args.recycle();
                    break;
                }
                case 13: {
                    BiometricService.this.handleRegisterCancellationCallback((IBiometricConfirmDeviceCredentialCallback)msg.obj);
                    break;
                }
                default: {
                    Slog.e(BiometricService.TAG, "Unknown message: " + msg);
                }
            }
        }
    };
    private final IBiometricServiceReceiverInternal mInternalReceiver = new IBiometricServiceReceiverInternal.Stub(){

        @Override
        public void onAuthenticationSucceeded(boolean requireConfirmation, byte[] token) throws RemoteException {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = requireConfirmation;
            args.arg2 = token;
            BiometricService.this.mHandler.obtainMessage(2, args).sendToTarget();
        }

        @Override
        public void onAuthenticationFailed(int cookie, boolean requireConfirmation) throws RemoteException {
            String failureReason = BiometricService.this.getContext().getString(17039614);
            BiometricService.this.mHandler.obtainMessage(3, failureReason).sendToTarget();
        }

        @Override
        public void onError(int cookie, int error, String message) throws RemoteException {
            if (error == 3) {
                BiometricService.this.mHandler.obtainMessage(3, message).sendToTarget();
            } else {
                SomeArgs args = SomeArgs.obtain();
                args.argi1 = cookie;
                args.argi2 = error;
                args.arg1 = message;
                BiometricService.this.mHandler.obtainMessage(4, args).sendToTarget();
            }
        }

        @Override
        public void onAcquired(int acquiredInfo, String message) throws RemoteException {
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = acquiredInfo;
            args.arg1 = message;
            BiometricService.this.mHandler.obtainMessage(5, args).sendToTarget();
        }

        @Override
        public void onDialogDismissed(int reason) throws RemoteException {
            BiometricService.this.mHandler.obtainMessage(6, reason, 0).sendToTarget();
        }

        @Override
        public void onTryAgainPressed() {
            BiometricService.this.mHandler.sendEmptyMessage(7);
        }
    };

    private void checkAppOp(String opPackageName, int callingUid) {
        if (this.mAppOps.noteOp(78, callingUid, opPackageName) != 0) {
            Slog.w(TAG, "Rejecting " + opPackageName + "; permission denied");
            throw new SecurityException("Permission denied");
        }
    }

    private void checkInternalPermission() {
        this.getContext().enforceCallingOrSelfPermission("android.permission.USE_BIOMETRIC_INTERNAL", "Must have USE_BIOMETRIC_INTERNAL permission");
    }

    private void checkPermission() {
        if (this.getContext().checkCallingOrSelfPermission("android.permission.USE_FINGERPRINT") != 0) {
            this.getContext().enforceCallingOrSelfPermission("android.permission.USE_BIOMETRIC", "Must have USE_BIOMETRIC permission");
        }
    }

    public BiometricService(Context context) {
        super(context);
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        this.mEnabledOnKeyguardCallbacks = new ArrayList<EnabledOnKeyguardCallback>();
        this.mSettingObserver = new SettingObserver(this.mHandler);
        PackageManager pm = context.getPackageManager();
        this.mHasFeatureFingerprint = pm.hasSystemFeature("android.hardware.fingerprint");
        this.mHasFeatureIris = pm.hasSystemFeature("android.hardware.biometrics.iris");
        this.mHasFeatureFace = pm.hasSystemFeature("android.hardware.biometrics.face");
        try {
            ActivityManager.getService().registerUserSwitchObserver(new UserSwitchObserver(){

                @Override
                public void onUserSwitchComplete(int newUserId) {
                    BiometricService.this.mSettingObserver.updateContentObserver();
                    BiometricService.this.mSettingObserver.notifyEnabledOnKeyguardCallbacks(newUserId);
                }
            }, BiometricService.class.getName());
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to register user switch observer", e);
        }
    }

    @Override
    public void onStart() {
        if (this.mHasFeatureFingerprint) {
            this.mFingerprintService = IFingerprintService.Stub.asInterface(ServiceManager.getService("fingerprint"));
        }
        if (this.mHasFeatureFace) {
            this.mFaceService = IFaceService.Stub.asInterface(ServiceManager.getService("face"));
        }
        this.mActivityTaskManager = ActivityTaskManager.getService();
        this.mStatusBarService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
        for (int i = 0; i < FEATURE_ID.length; ++i) {
            if (!this.hasFeature(FEATURE_ID[i])) continue;
            Authenticator authenticator = new Authenticator(FEATURE_ID[i], this.getAuthenticator(FEATURE_ID[i]));
            this.mAuthenticators.add(authenticator);
        }
        this.publishBinderService("biometric", new BiometricServiceWrapper());
    }

    private Pair<Integer, Integer> checkAndGetBiometricModality(int userId) {
        int modality = 0;
        if (this.mAuthenticators.isEmpty()) {
            return new Pair<Integer, Integer>(0, 12);
        }
        boolean isHardwareDetected = false;
        boolean hasTemplatesEnrolled = false;
        boolean enabledForApps = false;
        int firstHwAvailable = 0;
        for (int i = 0; i < this.mAuthenticators.size(); ++i) {
            modality = this.mAuthenticators.get(i).getType();
            BiometricAuthenticator authenticator = this.mAuthenticators.get(i).getAuthenticator();
            if (!authenticator.isHardwareDetected()) continue;
            isHardwareDetected = true;
            if (firstHwAvailable == 0) {
                firstHwAvailable = modality;
            }
            if (!authenticator.hasEnrolledTemplates(userId)) continue;
            hasTemplatesEnrolled = true;
            if (!this.isEnabledForApp(modality, userId)) continue;
            enabledForApps = true;
            break;
        }
        if (!isHardwareDetected) {
            return new Pair<Integer, Integer>(0, 1);
        }
        if (!hasTemplatesEnrolled) {
            return new Pair<Integer, Integer>(firstHwAvailable, 11);
        }
        if (!enabledForApps) {
            return new Pair<Integer, Integer>(0, 1);
        }
        return new Pair<Integer, Integer>(modality, 0);
    }

    private boolean isEnabledForApp(int modality, int userId) {
        switch (modality) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return this.mSettingObserver.getFaceEnabledForApps(userId);
            }
        }
        Slog.w(TAG, "Unsupported modality: " + modality);
        return false;
    }

    private String getErrorString(int type, int error, int vendorCode) {
        switch (type) {
            case 1: {
                return FingerprintManager.getErrorString(this.getContext(), error, vendorCode);
            }
            case 2: {
                Slog.w(TAG, "Modality not supported");
                return null;
            }
            case 4: {
                return FaceManager.getErrorString(this.getContext(), error, vendorCode);
            }
        }
        Slog.w(TAG, "Unable to get error string for modality: " + type);
        return null;
    }

    private BiometricAuthenticator getAuthenticator(int type) {
        switch (type) {
            case 1: {
                return (FingerprintManager)this.getContext().getSystemService("fingerprint");
            }
            case 2: {
                return null;
            }
            case 4: {
                return (FaceManager)this.getContext().getSystemService("face");
            }
        }
        return null;
    }

    private boolean hasFeature(int type) {
        switch (type) {
            case 1: {
                return this.mHasFeatureFingerprint;
            }
            case 2: {
                return this.mHasFeatureIris;
            }
            case 4: {
                return this.mHasFeatureFace;
            }
        }
        return false;
    }

    private void logDialogDismissed(int reason) {
        if (reason == 1) {
            long latency = System.currentTimeMillis() - this.mCurrentAuthSession.mAuthenticatedTimeMs;
            StatsLog.write(88, this.statsModality(), this.mCurrentAuthSession.mUserId, this.mCurrentAuthSession.isCrypto(), 2, this.mCurrentAuthSession.mRequireConfirmation, 3, latency, Utils.isDebugEnabled(this.getContext(), this.mCurrentAuthSession.mUserId));
        } else {
            int error = reason == 2 ? 13 : (reason == 3 ? 10 : 0);
            StatsLog.write(89, this.statsModality(), this.mCurrentAuthSession.mUserId, this.mCurrentAuthSession.isCrypto(), 2, 2, error, 0, Utils.isDebugEnabled(this.getContext(), this.mCurrentAuthSession.mUserId));
        }
    }

    private int statsModality() {
        int modality = 0;
        if (this.mCurrentAuthSession == null) {
            return 0;
        }
        if ((this.mCurrentAuthSession.mModality & 1) != 0) {
            modality |= 1;
        }
        if ((this.mCurrentAuthSession.mModality & 2) != 0) {
            modality |= 2;
        }
        if ((this.mCurrentAuthSession.mModality & 4) != 0) {
            modality |= 4;
        }
        return modality;
    }

    private void handleTaskStackChanged() {
        try {
            List<ActivityManager.RunningTaskInfo> runningTasks = this.mActivityTaskManager.getTasks(1);
            if (!runningTasks.isEmpty()) {
                String topPackage = runningTasks.get((int)0).topActivity.getPackageName();
                if (this.mCurrentAuthSession != null && !topPackage.contentEquals(this.mCurrentAuthSession.mOpPackageName)) {
                    this.mStatusBarService.hideBiometricDialog();
                    this.mActivityTaskManager.unregisterTaskStackListener(this.mTaskStackListener);
                    this.mCurrentAuthSession.mClientReceiver.onError(5, this.getContext().getString(17039610));
                    this.mCurrentAuthSession.mState = 0;
                    this.mCurrentAuthSession = null;
                }
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to get running tasks", e);
        }
    }

    private void handleAuthenticationSucceeded(boolean requireConfirmation, byte[] token) {
        try {
            if (this.mCurrentAuthSession == null) {
                Slog.e(TAG, "onAuthenticationSucceeded(): Auth session is null");
                return;
            }
            if (!requireConfirmation) {
                this.mActivityTaskManager.unregisterTaskStackListener(this.mTaskStackListener);
                KeyStore.getInstance().addAuthToken(token);
                this.mCurrentAuthSession.mClientReceiver.onAuthenticationSucceeded();
                this.mCurrentAuthSession.mState = 0;
                this.mCurrentAuthSession = null;
            } else {
                this.mCurrentAuthSession.mAuthenticatedTimeMs = System.currentTimeMillis();
                this.mCurrentAuthSession.mTokenEscrow = token;
                this.mCurrentAuthSession.mState = 5;
            }
            this.mStatusBarService.onBiometricAuthenticated(true, null);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Remote exception", e);
        }
    }

    private void handleAuthenticationFailed(String failureReason) {
        try {
            if (this.mCurrentAuthSession == null) {
                Slog.e(TAG, "onAuthenticationFailed(): Auth session is null");
                return;
            }
            this.mStatusBarService.onBiometricAuthenticated(false, failureReason);
            if ((this.mCurrentAuthSession.mModality & 4) != 0) {
                this.mCurrentAuthSession.mState = 3;
            }
            this.mCurrentAuthSession.mClientReceiver.onAuthenticationFailed();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Remote exception", e);
        }
    }

    private void handleOnConfirmDeviceCredentialSuccess() {
        if (this.mConfirmDeviceCredentialReceiver == null) {
            Slog.w(TAG, "onCDCASuccess null!");
            return;
        }
        try {
            this.mActivityTaskManager.unregisterTaskStackListener(this.mTaskStackListener);
            this.mConfirmDeviceCredentialReceiver.onAuthenticationSucceeded();
            if (this.mCurrentAuthSession != null) {
                this.mCurrentAuthSession.mState = 0;
                this.mCurrentAuthSession = null;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "RemoteException", e);
        }
        this.mConfirmDeviceCredentialReceiver = null;
    }

    private void handleOnConfirmDeviceCredentialError(int error, String message) {
        if (this.mConfirmDeviceCredentialReceiver == null) {
            Slog.w(TAG, "onCDCAError null! Error: " + error + " " + message);
            return;
        }
        try {
            this.mActivityTaskManager.unregisterTaskStackListener(this.mTaskStackListener);
            this.mConfirmDeviceCredentialReceiver.onError(error, message);
            if (this.mCurrentAuthSession != null) {
                this.mCurrentAuthSession.mState = 0;
                this.mCurrentAuthSession = null;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "RemoteException", e);
        }
        this.mConfirmDeviceCredentialReceiver = null;
    }

    private void handleRegisterCancellationCallback(IBiometricConfirmDeviceCredentialCallback callback) {
        if (this.mCurrentAuthSession == null) {
            Slog.d(TAG, "Current auth session null");
            return;
        }
        Slog.d(TAG, "Updating cancel callback");
        this.mCurrentAuthSession.mConfirmDeviceCredentialCallback = callback;
    }

    private void handleOnError(int cookie, int error, String message) {
        Slog.d(TAG, "Error: " + error + " cookie: " + cookie);
        try {
            if (this.mCurrentAuthSession != null && this.mCurrentAuthSession.containsCookie(cookie)) {
                if (this.mCurrentAuthSession.isFromConfirmDeviceCredential()) {
                    Slog.d(TAG, "From CDC, transition to CANCELED_SHOWING_CDC state");
                    this.mCurrentAuthSession.mClientReceiver.onError(error, message);
                    this.mCurrentAuthSession.mState = 6;
                    this.mStatusBarService.hideBiometricDialog();
                } else if (this.mCurrentAuthSession.mState == 2) {
                    this.mStatusBarService.onBiometricError(message);
                    if (error == 5) {
                        this.mActivityTaskManager.unregisterTaskStackListener(this.mTaskStackListener);
                        this.mCurrentAuthSession.mClientReceiver.onError(error, message);
                        this.mCurrentAuthSession.mState = 0;
                        this.mCurrentAuthSession = null;
                        this.mStatusBarService.hideBiometricDialog();
                    } else {
                        this.mHandler.postDelayed(() -> {
                            try {
                                if (this.mCurrentAuthSession != null) {
                                    this.mActivityTaskManager.unregisterTaskStackListener(this.mTaskStackListener);
                                    this.mCurrentAuthSession.mClientReceiver.onError(error, message);
                                    this.mCurrentAuthSession.mState = 0;
                                    this.mCurrentAuthSession = null;
                                }
                            }
                            catch (RemoteException e) {
                                Slog.e(TAG, "Remote exception", e);
                            }
                        }, 2000L);
                    }
                } else if (this.mCurrentAuthSession.mState == 3) {
                    this.mCurrentAuthSession.mClientReceiver.onError(error, message);
                    this.mStatusBarService.onBiometricError(message);
                    this.mActivityTaskManager.unregisterTaskStackListener(this.mTaskStackListener);
                    this.mCurrentAuthSession.mState = 0;
                    this.mCurrentAuthSession = null;
                } else {
                    Slog.e(TAG, "Impossible session error state: " + this.mCurrentAuthSession.mState);
                }
            } else if (this.mPendingAuthSession != null && this.mPendingAuthSession.containsCookie(cookie)) {
                if (this.mPendingAuthSession.mState == 1) {
                    this.mPendingAuthSession.mClientReceiver.onError(error, message);
                    this.mPendingAuthSession.mState = 0;
                    this.mPendingAuthSession = null;
                } else {
                    Slog.e(TAG, "Impossible pending session error state: " + this.mPendingAuthSession.mState);
                }
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Remote exception", e);
        }
    }

    private void handleOnAcquired(int acquiredInfo, String message) {
        if (this.mCurrentAuthSession == null) {
            Slog.e(TAG, "onAcquired(): Auth session is null");
            return;
        }
        if (acquiredInfo != 0) {
            if (message == null) {
                Slog.w(TAG, "Ignoring null message: " + acquiredInfo);
                return;
            }
            try {
                this.mStatusBarService.onBiometricHelp(message);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Remote exception", e);
            }
        }
    }

    private void handleOnDismissed(int reason) {
        if (this.mCurrentAuthSession == null) {
            Slog.e(TAG, "onDialogDismissed: " + reason + ", auth session null");
            return;
        }
        this.logDialogDismissed(reason);
        try {
            if (reason != 1) {
                this.mCurrentAuthSession.mClientReceiver.onDialogDismissed(reason);
                this.cancelInternal(null, null, false);
            }
            if (reason == 3) {
                this.mCurrentAuthSession.mClientReceiver.onError(10, this.getContext().getString(17039613));
            } else if (reason == 1) {
                KeyStore.getInstance().addAuthToken(this.mCurrentAuthSession.mTokenEscrow);
                this.mCurrentAuthSession.mClientReceiver.onAuthenticationSucceeded();
            }
            if (!this.mCurrentAuthSession.isFromConfirmDeviceCredential()) {
                this.mActivityTaskManager.unregisterTaskStackListener(this.mTaskStackListener);
                this.mCurrentAuthSession.mState = 0;
                this.mCurrentAuthSession = null;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Remote exception", e);
        }
    }

    private void handleOnTryAgainPressed() {
        Slog.d(TAG, "onTryAgainPressed");
        this.authenticateInternal(this.mCurrentAuthSession.mToken, this.mCurrentAuthSession.mSessionId, this.mCurrentAuthSession.mUserId, this.mCurrentAuthSession.mClientReceiver, this.mCurrentAuthSession.mOpPackageName, this.mCurrentAuthSession.mBundle, this.mCurrentAuthSession.mCallingUid, this.mCurrentAuthSession.mCallingPid, this.mCurrentAuthSession.mCallingUserId, this.mCurrentAuthSession.mModality, this.mCurrentAuthSession.mConfirmDeviceCredentialCallback);
    }

    private void handleOnReadyForAuthentication(int cookie, boolean requireConfirmation, int userId) {
        for (Map.Entry<Integer, Integer> pair : this.mPendingAuthSession.mModalitiesWaiting.entrySet()) {
            if (pair.getValue() != cookie) continue;
            this.mPendingAuthSession.mModalitiesMatched.put(pair.getKey(), pair.getValue());
            this.mPendingAuthSession.mModalitiesWaiting.remove(pair.getKey());
            Slog.d(TAG, "Matched cookie: " + cookie + ", " + this.mPendingAuthSession.mModalitiesWaiting.size() + " remaining");
            break;
        }
        if (this.mPendingAuthSession.mModalitiesWaiting.isEmpty()) {
            boolean continuing = this.mCurrentAuthSession != null && this.mCurrentAuthSession.mState == 3;
            this.mCurrentAuthSession = this.mPendingAuthSession;
            this.mPendingAuthSession = null;
            this.mCurrentAuthSession.mState = 2;
            try {
                int modality = 0;
                for (Map.Entry<Integer, Integer> pair : this.mCurrentAuthSession.mModalitiesMatched.entrySet()) {
                    if (pair.getKey() == 1) {
                        this.mFingerprintService.startPreparedClient(pair.getValue());
                    } else if (pair.getKey() == 2) {
                        Slog.e(TAG, "Iris unsupported");
                    } else if (pair.getKey() == 4) {
                        this.mFaceService.startPreparedClient(pair.getValue());
                    } else {
                        Slog.e(TAG, "Unknown modality: " + pair.getKey());
                    }
                    modality |= pair.getKey().intValue();
                }
                if (!continuing) {
                    this.mStatusBarService.showBiometricDialog(this.mCurrentAuthSession.mBundle, this.mInternalReceiver, modality, requireConfirmation, userId);
                    this.mActivityTaskManager.registerTaskStackListener(this.mTaskStackListener);
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Remote exception", e);
            }
        }
    }

    private void handleAuthenticate(IBinder token, long sessionId, int userId, IBiometricServiceReceiver receiver, String opPackageName, Bundle bundle, int callingUid, int callingPid, int callingUserId, IBiometricConfirmDeviceCredentialCallback callback) {
        this.mHandler.post(() -> {
            Pair<Integer, Integer> result = this.checkAndGetBiometricModality(userId);
            int modality = (Integer)result.first;
            int error = (Integer)result.second;
            if (error != 0) {
                try {
                    String hardwareUnavailable = this.getContext().getString(17039612);
                    switch (error) {
                        case 12: {
                            receiver.onError(error, hardwareUnavailable);
                            break;
                        }
                        case 1: {
                            receiver.onError(error, hardwareUnavailable);
                            break;
                        }
                        case 11: {
                            receiver.onError(error, this.getErrorString(modality, error, 0));
                            break;
                        }
                        default: {
                            Slog.e(TAG, "Unhandled error");
                            break;
                        }
                    }
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Unable to send error", e);
                }
                return;
            }
            this.mCurrentModality = modality;
            this.authenticateInternal(token, sessionId, userId, receiver, opPackageName, bundle, callingUid, callingPid, callingUserId, modality, callback);
        });
    }

    private void authenticateInternal(IBinder token, long sessionId, int userId, IBiometricServiceReceiver receiver, String opPackageName, Bundle bundle, int callingUid, int callingPid, int callingUserId, int modality, IBiometricConfirmDeviceCredentialCallback callback) {
        try {
            boolean requireConfirmation = bundle.getBoolean("require_confirmation", true);
            if ((modality & 4) != 0) {
                requireConfirmation = requireConfirmation || this.mSettingObserver.getFaceAlwaysRequireConfirmation(userId);
            }
            int cookie = this.mRandom.nextInt(0x7FFFFFFE) + 1;
            Slog.d(TAG, "Creating auth session. Modality: " + modality + ", cookie: " + cookie);
            HashMap<Integer, Integer> authenticators = new HashMap<Integer, Integer>();
            authenticators.put(modality, cookie);
            this.mPendingAuthSession = new AuthSession(authenticators, token, sessionId, userId, receiver, opPackageName, bundle, callingUid, callingPid, callingUserId, modality, requireConfirmation, callback);
            this.mPendingAuthSession.mState = 1;
            if ((modality & 1) != 0) {
                this.mFingerprintService.prepareForAuthentication(token, sessionId, userId, this.mInternalReceiver, opPackageName, cookie, callingUid, callingPid, callingUserId);
            }
            if ((modality & 2) != 0) {
                Slog.w(TAG, "Iris unsupported");
            }
            if ((modality & 4) != 0) {
                this.mFaceService.prepareForAuthentication(requireConfirmation, token, sessionId, userId, this.mInternalReceiver, opPackageName, cookie, callingUid, callingPid, callingUserId);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to start authentication", e);
        }
    }

    private void handleCancelAuthentication(IBinder token, String opPackageName) {
        if (token == null || opPackageName == null) {
            Slog.e(TAG, "Unable to cancel, one or more null arguments");
            return;
        }
        if (this.mCurrentAuthSession != null && this.mCurrentAuthSession.mState == 6) {
            Slog.d(TAG, "Cancel received while ConfirmDeviceCredential showing");
            try {
                this.mCurrentAuthSession.mConfirmDeviceCredentialCallback.cancel();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Unable to cancel ConfirmDeviceCredential", e);
            }
            this.handleOnConfirmDeviceCredentialError(5, this.getContext().getString(17039610));
        } else if (this.mCurrentAuthSession != null && this.mCurrentAuthSession.mState != 2) {
            try {
                this.mCurrentAuthSession.mClientReceiver.onError(5, this.getContext().getString(17039613));
                this.mCurrentAuthSession.mState = 0;
                this.mCurrentAuthSession = null;
                this.mStatusBarService.hideBiometricDialog();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Remote exception", e);
            }
        } else {
            boolean fromCDC = false;
            if (this.mCurrentAuthSession != null) {
                fromCDC = this.mCurrentAuthSession.mBundle.getBoolean("from_confirm_device_credential", false);
            }
            if (fromCDC) {
                Slog.d(TAG, "Cancelling from CDC");
                this.cancelInternal(token, opPackageName, false);
            } else {
                this.cancelInternal(token, opPackageName, true);
            }
        }
    }

    void cancelInternal(IBinder token, String opPackageName, boolean fromClient) {
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        int callingUserId = UserHandle.getCallingUserId();
        this.mHandler.post(() -> {
            try {
                if ((this.mCurrentModality & 1) != 0) {
                    this.mFingerprintService.cancelAuthenticationFromService(token, opPackageName, callingUid, callingPid, callingUserId, fromClient);
                }
                if ((this.mCurrentModality & 2) != 0) {
                    Slog.w(TAG, "Iris unsupported");
                }
                if ((this.mCurrentModality & 4) != 0) {
                    this.mFaceService.cancelAuthenticationFromService(token, opPackageName, callingUid, callingPid, callingUserId, fromClient);
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Unable to cancel authentication");
            }
        });
    }

    private final class BiometricServiceWrapper
    extends IBiometricService.Stub {
        private BiometricServiceWrapper() {
        }

        @Override
        public void onReadyForAuthentication(int cookie, boolean requireConfirmation, int userId) {
            BiometricService.this.checkInternalPermission();
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = cookie;
            args.arg1 = requireConfirmation;
            args.argi2 = userId;
            BiometricService.this.mHandler.obtainMessage(8, args).sendToTarget();
        }

        @Override
        public void authenticate(IBinder token, long sessionId, int userId, IBiometricServiceReceiver receiver, String opPackageName, Bundle bundle, IBiometricConfirmDeviceCredentialCallback callback) throws RemoteException {
            boolean useDefaultTitle;
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            int callingUserId = UserHandle.getCallingUserId();
            if (callback != null) {
                BiometricService.this.checkInternalPermission();
            }
            if (userId == callingUserId) {
                BiometricService.this.checkPermission();
            } else {
                Slog.w(BiometricService.TAG, "User " + callingUserId + " is requesting authentication of userid: " + userId);
                BiometricService.this.checkInternalPermission();
            }
            if (token == null || receiver == null || opPackageName == null || bundle == null) {
                Slog.e(BiometricService.TAG, "Unable to authenticate, one or more null arguments");
                return;
            }
            boolean isFromConfirmDeviceCredential = bundle.getBoolean("from_confirm_device_credential", false);
            if (isFromConfirmDeviceCredential) {
                BiometricService.this.checkInternalPermission();
            }
            if (useDefaultTitle = bundle.getBoolean("use_default_title", false)) {
                BiometricService.this.checkInternalPermission();
                if (TextUtils.isEmpty(bundle.getCharSequence("title"))) {
                    bundle.putCharSequence("title", BiometricService.this.getContext().getString(17039609));
                }
            }
            if (bundle.getBoolean("allow_device_credential")) {
                BiometricService.this.mHandler.post(() -> {
                    KeyguardManager kgm = BiometricService.this.getContext().getSystemService(KeyguardManager.class);
                    if (!kgm.isDeviceSecure()) {
                        try {
                            receiver.onError(14, BiometricService.this.getContext().getString(17039611));
                        }
                        catch (RemoteException e) {
                            Slog.e(BiometricService.TAG, "Remote exception", e);
                        }
                        return;
                    }
                    BiometricService.this.mConfirmDeviceCredentialReceiver = receiver;
                    Intent intent = kgm.createConfirmDeviceCredentialIntent(null, null, userId);
                    intent.putExtra("android.app.extra.BIOMETRIC_PROMPT_BUNDLE", bundle);
                    intent.setFlags(0x8080000);
                    BiometricService.this.getContext().startActivityAsUser(intent, UserHandle.CURRENT);
                });
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = token;
            args.arg2 = sessionId;
            args.argi1 = userId;
            args.arg3 = receiver;
            args.arg4 = opPackageName;
            args.arg5 = bundle;
            args.argi2 = callingUid;
            args.argi3 = callingPid;
            args.argi4 = callingUserId;
            args.arg6 = callback;
            BiometricService.this.mHandler.obtainMessage(9, args).sendToTarget();
        }

        @Override
        public void onConfirmDeviceCredentialSuccess() {
            BiometricService.this.checkInternalPermission();
            BiometricService.this.mHandler.sendEmptyMessage(11);
        }

        @Override
        public void onConfirmDeviceCredentialError(int error, String message) {
            BiometricService.this.checkInternalPermission();
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = error;
            args.arg1 = message;
            BiometricService.this.mHandler.obtainMessage(12, args).sendToTarget();
        }

        @Override
        public void registerCancellationCallback(IBiometricConfirmDeviceCredentialCallback callback) {
            BiometricService.this.checkInternalPermission();
            BiometricService.this.mHandler.obtainMessage(13, callback).sendToTarget();
        }

        @Override
        public void cancelAuthentication(IBinder token, String opPackageName) throws RemoteException {
            BiometricService.this.checkPermission();
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = token;
            args.arg2 = opPackageName;
            BiometricService.this.mHandler.obtainMessage(10, args).sendToTarget();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int canAuthenticate(String opPackageName) {
            int error;
            BiometricService.this.checkPermission();
            int userId = UserHandle.getCallingUserId();
            long ident = Binder.clearCallingIdentity();
            try {
                Pair result = BiometricService.this.checkAndGetBiometricModality(userId);
                error = (Integer)result.second;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
            return error;
        }

        @Override
        public void registerEnabledOnKeyguardCallback(IBiometricEnabledOnKeyguardCallback callback) throws RemoteException {
            BiometricService.this.checkInternalPermission();
            BiometricService.this.mEnabledOnKeyguardCallbacks.add(new EnabledOnKeyguardCallback(callback));
            try {
                callback.onChanged(BiometricSourceType.FACE, BiometricService.this.mSettingObserver.getFaceEnabledOnKeyguard());
            }
            catch (RemoteException e) {
                Slog.w(BiometricService.TAG, "Remote exception", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setActiveUser(int userId) {
            BiometricService.this.checkInternalPermission();
            long ident = Binder.clearCallingIdentity();
            try {
                for (int i = 0; i < BiometricService.this.mAuthenticators.size(); ++i) {
                    BiometricService.this.mAuthenticators.get(i).getAuthenticator().setActiveUser(userId);
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetLockout(byte[] token) {
            BiometricService.this.checkInternalPermission();
            long ident = Binder.clearCallingIdentity();
            try {
                if (BiometricService.this.mFingerprintService != null) {
                    BiometricService.this.mFingerprintService.resetTimeout(token);
                }
                if (BiometricService.this.mFaceService != null) {
                    BiometricService.this.mFaceService.resetLockout(token);
                }
            }
            catch (RemoteException e) {
                Slog.e(BiometricService.TAG, "Remote exception", e);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    private final class EnabledOnKeyguardCallback
    implements IBinder.DeathRecipient {
        private final IBiometricEnabledOnKeyguardCallback mCallback;

        EnabledOnKeyguardCallback(IBiometricEnabledOnKeyguardCallback callback) {
            this.mCallback = callback;
            try {
                this.mCallback.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Slog.w(BiometricService.TAG, "Unable to linkToDeath", e);
            }
        }

        void notify(BiometricSourceType sourceType, boolean enabled) {
            try {
                this.mCallback.onChanged(sourceType, enabled);
            }
            catch (DeadObjectException e) {
                Slog.w(BiometricService.TAG, "Death while invoking notify", e);
                BiometricService.this.mEnabledOnKeyguardCallbacks.remove(this);
            }
            catch (RemoteException e) {
                Slog.w(BiometricService.TAG, "Failed to invoke onChanged", e);
            }
        }

        @Override
        public void binderDied() {
            Slog.e(BiometricService.TAG, "Enabled callback binder died");
            BiometricService.this.mEnabledOnKeyguardCallbacks.remove(this);
        }
    }

    private final class SettingObserver
    extends ContentObserver {
        private static final boolean DEFAULT_KEYGUARD_ENABLED = true;
        private static final boolean DEFAULT_APP_ENABLED = true;
        private static final boolean DEFAULT_ALWAYS_REQUIRE_CONFIRMATION = false;
        private final Uri FACE_UNLOCK_KEYGUARD_ENABLED;
        private final Uri FACE_UNLOCK_APP_ENABLED;
        private final Uri FACE_UNLOCK_ALWAYS_REQUIRE_CONFIRMATION;
        private final ContentResolver mContentResolver;
        private Map<Integer, Boolean> mFaceEnabledOnKeyguard;
        private Map<Integer, Boolean> mFaceEnabledForApps;
        private Map<Integer, Boolean> mFaceAlwaysRequireConfirmation;

        SettingObserver(Handler handler) {
            super(handler);
            this.FACE_UNLOCK_KEYGUARD_ENABLED = Settings.Secure.getUriFor("face_unlock_keyguard_enabled");
            this.FACE_UNLOCK_APP_ENABLED = Settings.Secure.getUriFor("face_unlock_app_enabled");
            this.FACE_UNLOCK_ALWAYS_REQUIRE_CONFIRMATION = Settings.Secure.getUriFor("face_unlock_always_require_confirmation");
            this.mFaceEnabledOnKeyguard = new HashMap<Integer, Boolean>();
            this.mFaceEnabledForApps = new HashMap<Integer, Boolean>();
            this.mFaceAlwaysRequireConfirmation = new HashMap<Integer, Boolean>();
            this.mContentResolver = BiometricService.this.getContext().getContentResolver();
            this.updateContentObserver();
        }

        void updateContentObserver() {
            this.mContentResolver.unregisterContentObserver(this);
            this.mContentResolver.registerContentObserver(this.FACE_UNLOCK_KEYGUARD_ENABLED, false, this, -1);
            this.mContentResolver.registerContentObserver(this.FACE_UNLOCK_APP_ENABLED, false, this, -1);
            this.mContentResolver.registerContentObserver(this.FACE_UNLOCK_ALWAYS_REQUIRE_CONFIRMATION, false, this, -1);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            if (this.FACE_UNLOCK_KEYGUARD_ENABLED.equals(uri)) {
                this.mFaceEnabledOnKeyguard.put(userId, Settings.Secure.getIntForUser(this.mContentResolver, "face_unlock_keyguard_enabled", 1, userId) != 0);
                if (userId == ActivityManager.getCurrentUser() && !selfChange) {
                    this.notifyEnabledOnKeyguardCallbacks(userId);
                }
            } else if (this.FACE_UNLOCK_APP_ENABLED.equals(uri)) {
                this.mFaceEnabledForApps.put(userId, Settings.Secure.getIntForUser(this.mContentResolver, "face_unlock_app_enabled", 1, userId) != 0);
            } else if (this.FACE_UNLOCK_ALWAYS_REQUIRE_CONFIRMATION.equals(uri)) {
                this.mFaceAlwaysRequireConfirmation.put(userId, Settings.Secure.getIntForUser(this.mContentResolver, "face_unlock_always_require_confirmation", 0, userId) != 0);
            }
        }

        boolean getFaceEnabledOnKeyguard() {
            int user = ActivityManager.getCurrentUser();
            if (!this.mFaceEnabledOnKeyguard.containsKey(user)) {
                this.onChange(true, this.FACE_UNLOCK_KEYGUARD_ENABLED, user);
            }
            return this.mFaceEnabledOnKeyguard.get(user);
        }

        boolean getFaceEnabledForApps(int userId) {
            if (!this.mFaceEnabledForApps.containsKey(userId)) {
                this.onChange(true, this.FACE_UNLOCK_APP_ENABLED, userId);
            }
            return this.mFaceEnabledForApps.getOrDefault(userId, true);
        }

        boolean getFaceAlwaysRequireConfirmation(int userId) {
            if (!this.mFaceAlwaysRequireConfirmation.containsKey(userId)) {
                this.onChange(true, this.FACE_UNLOCK_ALWAYS_REQUIRE_CONFIRMATION, userId);
            }
            return this.mFaceAlwaysRequireConfirmation.get(userId);
        }

        void notifyEnabledOnKeyguardCallbacks(int userId) {
            List callbacks = BiometricService.this.mEnabledOnKeyguardCallbacks;
            for (int i = 0; i < callbacks.size(); ++i) {
                ((EnabledOnKeyguardCallback)callbacks.get(i)).notify(BiometricSourceType.FACE, this.mFaceEnabledOnKeyguard.getOrDefault(userId, true));
            }
        }
    }

    private final class Authenticator {
        int mType;
        BiometricAuthenticator mAuthenticator;

        Authenticator(int type, BiometricAuthenticator authenticator) {
            this.mType = type;
            this.mAuthenticator = authenticator;
        }

        int getType() {
            return this.mType;
        }

        BiometricAuthenticator getAuthenticator() {
            return this.mAuthenticator;
        }
    }

    private final class BiometricTaskStackListener
    extends TaskStackListener {
        private BiometricTaskStackListener() {
        }

        @Override
        public void onTaskStackChanged() {
            BiometricService.this.mHandler.sendEmptyMessage(1);
        }
    }

    private final class AuthSession
    implements IBinder.DeathRecipient {
        final HashMap<Integer, Integer> mModalitiesWaiting;
        final HashMap<Integer, Integer> mModalitiesMatched = new HashMap();
        final IBinder mToken;
        final long mSessionId;
        final int mUserId;
        final IBiometricServiceReceiver mClientReceiver;
        final String mOpPackageName;
        final Bundle mBundle;
        final int mCallingUid;
        final int mCallingPid;
        final int mCallingUserId;
        final int mModality;
        final boolean mRequireConfirmation;
        private int mState = 0;
        byte[] mTokenEscrow;
        private long mAuthenticatedTimeMs;
        private IBiometricConfirmDeviceCredentialCallback mConfirmDeviceCredentialCallback;

        AuthSession(HashMap<Integer, Integer> modalities, IBinder token, long sessionId, int userId, IBiometricServiceReceiver receiver, String opPackageName, Bundle bundle, int callingUid, int callingPid, int callingUserId, int modality, boolean requireConfirmation, IBiometricConfirmDeviceCredentialCallback callback) {
            this.mModalitiesWaiting = modalities;
            this.mToken = token;
            this.mSessionId = sessionId;
            this.mUserId = userId;
            this.mClientReceiver = receiver;
            this.mOpPackageName = opPackageName;
            this.mBundle = bundle;
            this.mCallingUid = callingUid;
            this.mCallingPid = callingPid;
            this.mCallingUserId = callingUserId;
            this.mModality = modality;
            this.mRequireConfirmation = requireConfirmation;
            this.mConfirmDeviceCredentialCallback = callback;
            if (this.isFromConfirmDeviceCredential()) {
                try {
                    token.linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    Slog.e(BiometricService.TAG, "Unable to link to death", e);
                }
            }
        }

        boolean isCrypto() {
            return this.mSessionId != 0L;
        }

        boolean isFromConfirmDeviceCredential() {
            return this.mBundle.getBoolean("from_confirm_device_credential", false);
        }

        boolean containsCookie(int cookie) {
            if (this.mModalitiesWaiting != null && this.mModalitiesWaiting.containsValue(cookie)) {
                return true;
            }
            return this.mModalitiesMatched != null && this.mModalitiesMatched.containsValue(cookie);
        }

        @Override
        public void binderDied() {
            BiometricService.this.mHandler.post(() -> {
                Slog.e(BiometricService.TAG, "Binder died, killing ConfirmDeviceCredential");
                if (this.mConfirmDeviceCredentialCallback == null) {
                    Slog.e(BiometricService.TAG, "Callback is null");
                    return;
                }
                try {
                    this.mConfirmDeviceCredentialCallback.cancel();
                    this.mConfirmDeviceCredentialCallback = null;
                }
                catch (RemoteException e) {
                    Slog.e(BiometricService.TAG, "Unable to send cancel", e);
                }
            });
        }
    }
}

