/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics;

import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.app.AppOpsManager;
import android.app.IActivityTaskManager;
import android.app.SynchronousUserSwitchObserver;
import android.app.TaskStackListener;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.UserInfo;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.IBiometricService;
import android.hardware.biometrics.IBiometricServiceLockoutResetCallback;
import android.hardware.biometrics.IBiometricServiceReceiverInternal;
import android.hardware.fingerprint.Fingerprint;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IHwBinder;
import android.os.IRemoteCallback;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import android.util.StatsLog;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.statusbar.IStatusBarService;
import com.android.server.SystemService;
import com.android.server.biometrics.AuthenticationClient;
import com.android.server.biometrics.BiometricUtils;
import com.android.server.biometrics.ClientMonitor;
import com.android.server.biometrics.Constants;
import com.android.server.biometrics.EnrollClient;
import com.android.server.biometrics.EnumerateClient;
import com.android.server.biometrics.RemovalClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BiometricServiceBase
extends SystemService
implements IHwBinder.DeathRecipient {
    protected static final boolean DEBUG = true;
    private static final boolean CLEANUP_UNKNOWN_TEMPLATES = true;
    private static final String KEY_LOCKOUT_RESET_USER = "lockout_reset_user";
    private static final int MSG_USER_SWITCHING = 10;
    private static final long CANCEL_TIMEOUT_LIMIT = 3000L;
    private final Context mContext;
    private final String mKeyguardPackage;
    private final IActivityTaskManager mActivityTaskManager;
    private final PowerManager mPowerManager;
    private final UserManager mUserManager;
    private final MetricsLogger mMetricsLogger;
    private final BiometricTaskStackListener mTaskStackListener = new BiometricTaskStackListener();
    private final ResetClientStateRunnable mResetClientState = new ResetClientStateRunnable();
    private final ArrayList<LockoutResetMonitor> mLockoutMonitors = new ArrayList();
    protected final IStatusBarService mStatusBarService;
    protected final Map<Integer, Long> mAuthenticatorIds = Collections.synchronizedMap(new HashMap());
    protected final AppOpsManager mAppOps;
    protected final H mHandler = new H();
    private final IBinder mToken = new Binder();
    private final ArrayList<UserTemplate> mUnknownHALTemplates = new ArrayList();
    private IBiometricService mBiometricService;
    private ClientMonitor mCurrentClient;
    private ClientMonitor mPendingClient;
    private PerformanceStats mPerformanceStats;
    protected int mCurrentUserId = -10000;
    protected long mHalDeviceId;
    protected boolean mIsCrypto;
    protected HashMap<Integer, PerformanceStats> mPerformanceMap = new HashMap();
    protected HashMap<Integer, PerformanceStats> mCryptoPerformanceMap = new HashMap();
    protected int mHALDeathCount;

    protected abstract String getTag();

    protected abstract DaemonWrapper getDaemonWrapper();

    protected abstract BiometricUtils getBiometricUtils();

    protected abstract Constants getConstants();

    protected abstract boolean hasReachedEnrollmentLimit(int var1);

    protected abstract void updateActiveGroup(int var1, String var2);

    protected abstract String getLockoutResetIntent();

    protected abstract String getLockoutBroadcastPermission();

    protected abstract long getHalDeviceId();

    protected abstract boolean hasEnrolledBiometrics(int var1);

    protected abstract String getManageBiometricPermission();

    protected abstract void checkUseBiometricPermission();

    protected abstract boolean checkAppOps(int var1, String var2);

    protected abstract List<? extends BiometricAuthenticator.Identifier> getEnrolledTemplates(int var1);

    protected void notifyClientActiveCallbacks(boolean isActive) {
    }

    protected abstract int statsModality();

    protected abstract int getLockoutMode();

    public BiometricServiceBase(Context context) {
        super(context);
        this.mContext = context;
        this.mStatusBarService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
        this.mKeyguardPackage = ComponentName.unflattenFromString(context.getResources().getString(17039747)).getPackageName();
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        ActivityTaskManager cfr_ignored_0 = (ActivityTaskManager)context.getSystemService("activity_task");
        this.mActivityTaskManager = ActivityTaskManager.getService();
        this.mPowerManager = this.mContext.getSystemService(PowerManager.class);
        this.mUserManager = UserManager.get(this.mContext);
        this.mMetricsLogger = new MetricsLogger();
    }

    @Override
    public void onStart() {
        this.listenForUserSwitches();
    }

    @Override
    public void serviceDied(long cookie) {
        Slog.e(this.getTag(), "HAL died");
        this.mMetricsLogger.count(this.getConstants().tagHalDied(), 1);
        ++this.mHALDeathCount;
        this.mCurrentUserId = -10000;
        this.handleError(this.getHalDeviceId(), 1, 0);
        StatsLog.write(148, this.statsModality(), 1);
    }

    protected ClientMonitor getCurrentClient() {
        return this.mCurrentClient;
    }

    protected ClientMonitor getPendingClient() {
        return this.mPendingClient;
    }

    protected void handleAcquired(long deviceId, int acquiredInfo, int vendorCode) {
        ClientMonitor client = this.mCurrentClient;
        if (client != null && client.onAcquired(acquiredInfo, vendorCode)) {
            this.removeClient(client);
        }
        if (this.mPerformanceStats != null && this.getLockoutMode() == 0 && client instanceof AuthenticationClient) {
            ++this.mPerformanceStats.acquire;
        }
    }

    protected void handleAuthenticated(BiometricAuthenticator.Identifier identifier, ArrayList<Byte> token) {
        boolean authenticated;
        ClientMonitor client = this.mCurrentClient;
        boolean bl = authenticated = identifier.getBiometricId() != 0;
        if (client != null && client.onAuthenticated(identifier, authenticated, token)) {
            this.removeClient(client);
        }
        if (authenticated) {
            ++this.mPerformanceStats.accept;
        } else {
            ++this.mPerformanceStats.reject;
        }
    }

    protected void handleEnrollResult(BiometricAuthenticator.Identifier identifier, int remaining) {
        ClientMonitor client = this.mCurrentClient;
        if (client != null && client.onEnrollResult(identifier, remaining)) {
            this.removeClient(client);
            if (identifier instanceof Fingerprint) {
                this.updateActiveGroup(((Fingerprint)identifier).getGroupId(), null);
            } else {
                this.updateActiveGroup(this.mCurrentUserId, null);
            }
        }
    }

    protected void handleError(long deviceId, int error, int vendorCode) {
        ClientMonitor client = this.mCurrentClient;
        Slog.v(this.getTag(), "handleError(client=" + (client != null ? client.getOwnerString() : "null") + ", error = " + error + ")");
        if (client instanceof InternalRemovalClient || client instanceof InternalEnumerateClient) {
            this.clearEnumerateState();
        }
        if (client != null && client.onError(deviceId, error, vendorCode)) {
            this.removeClient(client);
        }
        if (error == 5) {
            this.mHandler.removeCallbacks(this.mResetClientState);
            if (this.mPendingClient != null) {
                Slog.v(this.getTag(), "start pending client " + this.mPendingClient.getOwnerString());
                this.startClient(this.mPendingClient, false);
                this.mPendingClient = null;
            }
        }
    }

    protected void handleRemoved(BiometricAuthenticator.Identifier identifier, int remaining) {
        Slog.w(this.getTag(), "Removed: fid=" + identifier.getBiometricId() + ", dev=" + identifier.getDeviceId() + ", rem=" + remaining);
        ClientMonitor client = this.mCurrentClient;
        if (client != null && client.onRemoved(identifier, remaining)) {
            this.removeClient(client);
            int userId = this.mCurrentUserId;
            if (identifier instanceof Fingerprint) {
                userId = ((Fingerprint)identifier).getGroupId();
            }
            if (!this.hasEnrolledBiometrics(userId)) {
                this.updateActiveGroup(userId, null);
            }
        }
        if (client instanceof InternalRemovalClient && !this.mUnknownHALTemplates.isEmpty()) {
            this.startCleanupUnknownHALTemplates();
        } else if (client instanceof InternalRemovalClient) {
            this.clearEnumerateState();
        }
    }

    protected void handleEnumerate(BiometricAuthenticator.Identifier identifier, int remaining) {
        ClientMonitor client = this.getCurrentClient();
        client.onEnumerationResult(identifier, remaining);
        if (remaining == 0) {
            if (client instanceof InternalEnumerateClient) {
                List<BiometricAuthenticator.Identifier> unknownHALTemplates = ((InternalEnumerateClient)client).getUnknownHALTemplates();
                if (!unknownHALTemplates.isEmpty()) {
                    Slog.w(this.getTag(), "Adding " + unknownHALTemplates.size() + " templates for deletion");
                }
                for (int i = 0; i < unknownHALTemplates.size(); ++i) {
                    this.mUnknownHALTemplates.add(new UserTemplate(unknownHALTemplates.get(i), client.getTargetUserId()));
                }
                this.removeClient(client);
                this.startCleanupUnknownHALTemplates();
            } else {
                this.removeClient(client);
            }
        }
    }

    protected void enrollInternal(EnrollClientImpl client, int userId) {
        if (this.hasReachedEnrollmentLimit(userId)) {
            return;
        }
        if (!this.isCurrentUserOrProfile(userId)) {
            return;
        }
        this.mHandler.post(() -> this.startClient(client, true));
    }

    protected void cancelEnrollmentInternal(IBinder token) {
        this.mHandler.post(() -> {
            ClientMonitor client = this.mCurrentClient;
            if (client instanceof EnrollClient && client.getToken() == token) {
                Slog.v(this.getTag(), "Cancelling enrollment");
                client.stop(client.getToken() == token);
            }
        });
    }

    protected void authenticateInternal(AuthenticationClientImpl client, long opId, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        int callingUserId = UserHandle.getCallingUserId();
        this.authenticateInternal(client, opId, opPackageName, callingUid, callingPid, callingUserId);
    }

    protected void authenticateInternal(AuthenticationClientImpl client, long opId, String opPackageName, int callingUid, int callingPid, int callingUserId) {
        if (!this.canUseBiometric(opPackageName, true, callingUid, callingPid, callingUserId)) {
            Slog.v(this.getTag(), "authenticate(): reject " + opPackageName);
            return;
        }
        this.mHandler.post(() -> {
            this.mMetricsLogger.histogram(this.getConstants().tagAuthToken(), opId != 0L ? 1 : 0);
            HashMap<Integer, PerformanceStats> pmap = opId == 0L ? this.mPerformanceMap : this.mCryptoPerformanceMap;
            PerformanceStats stats = pmap.get(this.mCurrentUserId);
            if (stats == null) {
                stats = new PerformanceStats();
                pmap.put(this.mCurrentUserId, stats);
            }
            this.mPerformanceStats = stats;
            this.mIsCrypto = opId != 0L;
            this.startAuthentication(client, opPackageName);
        });
    }

    protected void cancelAuthenticationInternal(IBinder token, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        int callingUserId = UserHandle.getCallingUserId();
        this.cancelAuthenticationInternal(token, opPackageName, callingUid, callingPid, callingUserId, true);
    }

    protected void cancelAuthenticationInternal(IBinder token, String opPackageName, int callingUid, int callingPid, int callingUserId, boolean fromClient) {
        if (fromClient && !this.canUseBiometric(opPackageName, true, callingUid, callingPid, callingUserId)) {
            Slog.v(this.getTag(), "cancelAuthentication(): reject " + opPackageName);
            return;
        }
        this.mHandler.post(() -> {
            ClientMonitor client = this.mCurrentClient;
            if (client instanceof AuthenticationClient) {
                if (client.getToken() == token || !fromClient) {
                    Slog.v(this.getTag(), "Stopping client " + client.getOwnerString() + ", fromClient: " + fromClient);
                    client.stop(client.getToken() == token);
                } else {
                    Slog.v(this.getTag(), "Can't stop client " + client.getOwnerString() + " since tokens don't match. fromClient: " + fromClient);
                }
            } else if (client != null) {
                Slog.v(this.getTag(), "Can't cancel non-authenticating client " + client.getOwnerString());
            }
        });
    }

    protected void setActiveUserInternal(int userId) {
        this.updateActiveGroup(userId, null);
    }

    protected void removeInternal(RemovalClient client) {
        this.mHandler.post(() -> this.startClient(client, true));
    }

    protected void enumerateInternal(EnumerateClient client) {
        this.mHandler.post(() -> this.startClient(client, true));
    }

    private void startAuthentication(AuthenticationClientImpl client, String opPackageName) {
        Slog.v(this.getTag(), "startAuthentication(" + opPackageName + ")");
        int lockoutMode = this.getLockoutMode();
        if (lockoutMode != 0) {
            int errorCode;
            Slog.v(this.getTag(), "In lockout mode(" + lockoutMode + ") ; disallowing authentication");
            int n = errorCode = lockoutMode == 1 ? 7 : 9;
            if (!client.onError(this.getHalDeviceId(), errorCode, 0)) {
                Slog.w(this.getTag(), "Cannot send permanent lockout message to client");
            }
            return;
        }
        this.startClient(client, true);
    }

    protected void addLockoutResetCallback(IBiometricServiceLockoutResetCallback callback) {
        this.mHandler.post(() -> {
            LockoutResetMonitor monitor = new LockoutResetMonitor(callback);
            if (!this.mLockoutMonitors.contains(monitor)) {
                this.mLockoutMonitors.add(monitor);
            }
        });
    }

    protected boolean canUseBiometric(String opPackageName, boolean requireForeground, int uid, int pid, int userId) {
        this.checkUseBiometricPermission();
        if (Binder.getCallingUid() == 1000) {
            return true;
        }
        if (this.isKeyguard(opPackageName)) {
            return true;
        }
        if (!this.isCurrentUserOrProfile(userId)) {
            Slog.w(this.getTag(), "Rejecting " + opPackageName + "; not a current user or profile");
            return false;
        }
        if (!this.checkAppOps(uid, opPackageName)) {
            Slog.w(this.getTag(), "Rejecting " + opPackageName + "; permission denied");
            return false;
        }
        if (requireForeground && !this.isForegroundActivity(uid, pid) && !this.isCurrentClient(opPackageName)) {
            Slog.w(this.getTag(), "Rejecting " + opPackageName + "; not in foreground");
            return false;
        }
        return true;
    }

    private boolean isCurrentClient(String opPackageName) {
        return this.mCurrentClient != null && this.mCurrentClient.getOwnerString().equals(opPackageName);
    }

    private boolean isKeyguard(String clientPackage) {
        return this.mKeyguardPackage.equals(clientPackage);
    }

    private boolean isForegroundActivity(int uid, int pid) {
        try {
            List<ActivityManager.RunningAppProcessInfo> procs = ActivityManager.getService().getRunningAppProcesses();
            int N = procs.size();
            for (int i = 0; i < N; ++i) {
                ActivityManager.RunningAppProcessInfo proc = procs.get(i);
                if (proc.pid != pid || proc.uid != uid || proc.importance > 125) continue;
                return true;
            }
        }
        catch (RemoteException e) {
            Slog.w(this.getTag(), "am.getRunningAppProcesses() failed");
        }
        return false;
    }

    private void startClient(ClientMonitor newClient, boolean initiatedByClient) {
        ClientMonitor currentClient = this.mCurrentClient;
        if (currentClient != null) {
            Slog.v(this.getTag(), "request stop current client " + currentClient.getOwnerString());
            if (currentClient instanceof InternalEnumerateClient || currentClient instanceof InternalRemovalClient) {
                if (newClient != null) {
                    Slog.w(this.getTag(), "Internal cleanup in progress but trying to start client " + newClient.getClass().getSuperclass().getSimpleName() + "(" + newClient.getOwnerString() + "), initiatedByClient = " + initiatedByClient);
                }
            } else {
                currentClient.stop(initiatedByClient);
                this.mHandler.removeCallbacks(this.mResetClientState);
                this.mHandler.postDelayed(this.mResetClientState, 3000L);
            }
            this.mPendingClient = newClient;
        } else if (newClient != null) {
            AuthenticationClient client;
            if (newClient instanceof AuthenticationClient && (client = (AuthenticationClient)newClient).isBiometricPrompt()) {
                Slog.v(this.getTag(), "Returning cookie: " + client.getCookie());
                this.mCurrentClient = newClient;
                if (this.mBiometricService == null) {
                    this.mBiometricService = IBiometricService.Stub.asInterface(ServiceManager.getService("biometric"));
                }
                try {
                    this.mBiometricService.onReadyForAuthentication(client.getCookie(), client.getRequireConfirmation(), client.getTargetUserId());
                }
                catch (RemoteException e) {
                    Slog.e(this.getTag(), "Remote exception", e);
                }
                return;
            }
            this.mCurrentClient = newClient;
            this.startCurrentClient(this.mCurrentClient.getCookie());
        }
    }

    protected void startCurrentClient(int cookie) {
        if (this.mCurrentClient == null) {
            Slog.e(this.getTag(), "Trying to start null client!");
            return;
        }
        Slog.v(this.getTag(), "starting client " + this.mCurrentClient.getClass().getSuperclass().getSimpleName() + "(" + this.mCurrentClient.getOwnerString() + ") cookie: " + cookie + "/" + this.mCurrentClient.getCookie());
        if (cookie != this.mCurrentClient.getCookie()) {
            Slog.e(this.getTag(), "Mismatched cookie");
            return;
        }
        this.notifyClientActiveCallbacks(true);
        this.mCurrentClient.start();
    }

    protected void removeClient(ClientMonitor client) {
        if (client != null) {
            client.destroy();
            if (client != this.mCurrentClient && this.mCurrentClient != null) {
                Slog.w(this.getTag(), "Unexpected client: " + client.getOwnerString() + "expected: " + this.mCurrentClient.getOwnerString());
            }
        }
        if (this.mCurrentClient != null) {
            Slog.v(this.getTag(), "Done with client: " + client.getOwnerString());
            this.mCurrentClient = null;
        }
        if (this.mPendingClient == null) {
            this.notifyClientActiveCallbacks(false);
        }
    }

    protected void loadAuthenticatorIds() {
        long t = System.currentTimeMillis();
        this.mAuthenticatorIds.clear();
        for (UserInfo user : UserManager.get(this.getContext()).getUsers(true)) {
            int userId = this.getUserOrWorkProfileId(null, user.id);
            if (this.mAuthenticatorIds.containsKey(userId)) continue;
            this.updateActiveGroup(userId, null);
        }
        t = System.currentTimeMillis() - t;
        if (t > 1000L) {
            Slog.w(this.getTag(), "loadAuthenticatorIds() taking too long: " + t + "ms");
        }
    }

    protected int getUserOrWorkProfileId(String clientPackage, int userId) {
        if (!this.isKeyguard(clientPackage) && this.isWorkProfile(userId)) {
            return userId;
        }
        return this.getEffectiveUserId(userId);
    }

    protected boolean isRestricted() {
        boolean restricted = !this.hasPermission(this.getManageBiometricPermission());
        return restricted;
    }

    protected boolean hasPermission(String permission2) {
        return this.getContext().checkCallingOrSelfPermission(permission2) == 0;
    }

    protected void checkPermission(String permission2) {
        this.getContext().enforceCallingOrSelfPermission(permission2, "Must have " + permission2 + " permission.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCurrentUserOrProfile(int userId) {
        UserManager um = UserManager.get(this.mContext);
        if (um == null) {
            Slog.e(this.getTag(), "Unable to acquire UserManager");
            return false;
        }
        long token = Binder.clearCallingIdentity();
        try {
            for (int profileId : um.getEnabledProfileIds(ActivityManager.getCurrentUser())) {
                if (profileId != userId) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return false;
    }

    protected long getAuthenticatorId(String opPackageName) {
        int userId = this.getUserOrWorkProfileId(opPackageName, UserHandle.getCallingUserId());
        return this.mAuthenticatorIds.getOrDefault(userId, 0L);
    }

    protected void doTemplateCleanupForUser(int userId) {
        this.enumerateUser(userId);
    }

    private void clearEnumerateState() {
        Slog.v(this.getTag(), "clearEnumerateState()");
        this.mUnknownHALTemplates.clear();
    }

    private void startCleanupUnknownHALTemplates() {
        if (!this.mUnknownHALTemplates.isEmpty()) {
            UserTemplate template = this.mUnknownHALTemplates.get(0);
            this.mUnknownHALTemplates.remove(template);
            boolean restricted = !this.hasPermission(this.getManageBiometricPermission());
            InternalRemovalClient client = new InternalRemovalClient(this.getContext(), this.getDaemonWrapper(), this.mHalDeviceId, this.mToken, null, template.mIdentifier.getBiometricId(), 0, template.mUserId, restricted, this.getContext().getPackageName());
            this.removeInternal(client);
            StatsLog.write(148, this.statsModality(), 3);
        } else {
            this.clearEnumerateState();
            if (this.mPendingClient != null) {
                Slog.d(this.getTag(), "Enumerate finished, starting pending client");
                this.startClient(this.mPendingClient, false);
                this.mPendingClient = null;
            }
        }
    }

    private void enumerateUser(int userId) {
        Slog.v(this.getTag(), "Enumerating user(" + userId + ")");
        boolean restricted = !this.hasPermission(this.getManageBiometricPermission());
        List<? extends BiometricAuthenticator.Identifier> enrolledList = this.getEnrolledTemplates(userId);
        InternalEnumerateClient client = new InternalEnumerateClient(this.getContext(), this.getDaemonWrapper(), this.mHalDeviceId, this.mToken, null, userId, userId, restricted, this.getContext().getOpPackageName(), enrolledList, this.getBiometricUtils());
        this.enumerateInternal(client);
    }

    protected void handleUserSwitching(int userId) {
        if (this.getCurrentClient() instanceof InternalRemovalClient || this.getCurrentClient() instanceof InternalEnumerateClient) {
            Slog.w(this.getTag(), "User switched while performing cleanup");
        }
        this.updateActiveGroup(userId, null);
        this.doTemplateCleanupForUser(userId);
    }

    protected void notifyLockoutResetMonitors() {
        for (int i = 0; i < this.mLockoutMonitors.size(); ++i) {
            this.mLockoutMonitors.get(i).sendLockoutReset();
        }
    }

    private void userActivity() {
        long now = SystemClock.uptimeMillis();
        this.mPowerManager.userActivity(now, 2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWorkProfile(int userId) {
        UserInfo userInfo = null;
        long token = Binder.clearCallingIdentity();
        try {
            userInfo = this.mUserManager.getUserInfo(userId);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return userInfo != null && userInfo.isManagedProfile();
    }

    private int getEffectiveUserId(int userId) {
        UserManager um = UserManager.get(this.mContext);
        if (um != null) {
            long callingIdentity = Binder.clearCallingIdentity();
            userId = um.getCredentialOwnerProfile(userId);
            Binder.restoreCallingIdentity(callingIdentity);
        } else {
            Slog.e(this.getTag(), "Unable to acquire UserManager");
        }
        return userId;
    }

    private void listenForUserSwitches() {
        try {
            ActivityManager.getService().registerUserSwitchObserver(new SynchronousUserSwitchObserver(){

                @Override
                public void onUserSwitching(int newUserId) throws RemoteException {
                    BiometricServiceBase.this.mHandler.obtainMessage(10, newUserId, 0).sendToTarget();
                }
            }, this.getTag());
        }
        catch (RemoteException e) {
            Slog.w(this.getTag(), "Failed to listen for user switching event", e);
        }
    }

    private void removeLockoutResetCallback(LockoutResetMonitor monitor) {
        this.mLockoutMonitors.remove(monitor);
    }

    private final class UserTemplate {
        final BiometricAuthenticator.Identifier mIdentifier;
        final int mUserId;

        UserTemplate(BiometricAuthenticator.Identifier identifier, int userId) {
            this.mIdentifier = identifier;
            this.mUserId = userId;
        }
    }

    private final class LockoutResetMonitor
    implements IBinder.DeathRecipient {
        private static final long WAKELOCK_TIMEOUT_MS = 2000L;
        private final IBiometricServiceLockoutResetCallback mCallback;
        private final PowerManager.WakeLock mWakeLock;
        private final Runnable mRemoveCallbackRunnable = new Runnable(){

            @Override
            public void run() {
                LockoutResetMonitor.this.releaseWakelock();
                BiometricServiceBase.this.removeLockoutResetCallback(LockoutResetMonitor.this);
            }
        };

        public LockoutResetMonitor(IBiometricServiceLockoutResetCallback callback) {
            this.mCallback = callback;
            this.mWakeLock = BiometricServiceBase.this.mPowerManager.newWakeLock(1, "lockout reset callback");
            try {
                this.mCallback.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Slog.w(BiometricServiceBase.this.getTag(), "caught remote exception in linkToDeath", e);
            }
        }

        public void sendLockoutReset() {
            if (this.mCallback != null) {
                try {
                    this.mWakeLock.acquire(2000L);
                    this.mCallback.onLockoutReset(BiometricServiceBase.this.getHalDeviceId(), new IRemoteCallback.Stub(){

                        @Override
                        public void sendResult(Bundle data) throws RemoteException {
                            LockoutResetMonitor.this.releaseWakelock();
                        }
                    });
                }
                catch (DeadObjectException e) {
                    Slog.w(BiometricServiceBase.this.getTag(), "Death object while invoking onLockoutReset: ", e);
                    BiometricServiceBase.this.mHandler.post(this.mRemoveCallbackRunnable);
                }
                catch (RemoteException e) {
                    Slog.w(BiometricServiceBase.this.getTag(), "Failed to invoke onLockoutReset: ", e);
                    this.releaseWakelock();
                }
            }
        }

        @Override
        public void binderDied() {
            Slog.e(BiometricServiceBase.this.getTag(), "Lockout reset callback binder died");
            BiometricServiceBase.this.mHandler.post(this.mRemoveCallbackRunnable);
        }

        private void releaseWakelock() {
            if (this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
    }

    private final class ResetClientStateRunnable
    implements Runnable {
        private ResetClientStateRunnable() {
        }

        @Override
        public void run() {
            Slog.w(BiometricServiceBase.this.getTag(), "Client " + (BiometricServiceBase.this.mCurrentClient != null ? BiometricServiceBase.this.mCurrentClient.getOwnerString() : "null") + " failed to respond to cancel, starting client " + (BiometricServiceBase.this.mPendingClient != null ? BiometricServiceBase.this.mPendingClient.getOwnerString() : "null"));
            StatsLog.write(148, BiometricServiceBase.this.statsModality(), 4);
            BiometricServiceBase.this.mCurrentClient = null;
            BiometricServiceBase.this.startClient(BiometricServiceBase.this.mPendingClient, false);
        }
    }

    private final class BiometricTaskStackListener
    extends TaskStackListener {
        private BiometricTaskStackListener() {
        }

        @Override
        public void onTaskStackChanged() {
            try {
                String topPackage;
                if (!(BiometricServiceBase.this.mCurrentClient instanceof AuthenticationClient)) {
                    return;
                }
                String currentClient = BiometricServiceBase.this.mCurrentClient.getOwnerString();
                if (BiometricServiceBase.this.isKeyguard(currentClient)) {
                    return;
                }
                List<ActivityManager.RunningTaskInfo> runningTasks = BiometricServiceBase.this.mActivityTaskManager.getTasks(1);
                if (!(runningTasks.isEmpty() || (topPackage = runningTasks.get((int)0).topActivity.getPackageName()).contentEquals(currentClient) || BiometricServiceBase.this.mCurrentClient.isAlreadyDone())) {
                    Slog.e(BiometricServiceBase.this.getTag(), "Stopping background authentication, top: " + topPackage + " currentClient: " + currentClient);
                    BiometricServiceBase.this.mCurrentClient.stop(false);
                }
            }
            catch (RemoteException e) {
                Slog.e(BiometricServiceBase.this.getTag(), "Unable to get running tasks", e);
            }
        }
    }

    protected final class H
    extends Handler {
        protected H() {
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 10: {
                    BiometricServiceBase.this.handleUserSwitching(msg.arg1);
                    break;
                }
                default: {
                    Slog.w(BiometricServiceBase.this.getTag(), "Unknown message:" + msg.what);
                }
            }
        }
    }

    protected static interface DaemonWrapper {
        public static final int ERROR_ESRCH = 3;

        public int authenticate(long var1, int var3) throws RemoteException;

        public int cancel() throws RemoteException;

        public int remove(int var1, int var2) throws RemoteException;

        public int enumerate() throws RemoteException;

        public int enroll(byte[] var1, int var2, int var3, ArrayList<Integer> var4) throws RemoteException;

        public void resetLockout(byte[] var1) throws RemoteException;
    }

    protected abstract class BiometricServiceListener
    implements ServiceListener {
        private IBiometricServiceReceiverInternal mWrapperReceiver;

        public BiometricServiceListener(IBiometricServiceReceiverInternal wrapperReceiver) {
            this.mWrapperReceiver = wrapperReceiver;
        }

        public IBiometricServiceReceiverInternal getWrapperReceiver() {
            return this.mWrapperReceiver;
        }

        @Override
        public void onAuthenticationSucceededInternal(boolean requireConfirmation, byte[] token) throws RemoteException {
            if (this.getWrapperReceiver() != null) {
                this.getWrapperReceiver().onAuthenticationSucceeded(requireConfirmation, token);
            }
        }

        @Override
        public void onAuthenticationFailedInternal(int cookie, boolean requireConfirmation) throws RemoteException {
            if (this.getWrapperReceiver() != null) {
                this.getWrapperReceiver().onAuthenticationFailed(cookie, requireConfirmation);
            }
        }
    }

    protected static interface ServiceListener {
        default public void onEnrollResult(BiometricAuthenticator.Identifier identifier, int remaining) throws RemoteException {
        }

        public void onAcquired(long var1, int var3, int var4) throws RemoteException;

        default public void onAuthenticationSucceeded(long deviceId, BiometricAuthenticator.Identifier biometric, int userId) throws RemoteException {
            throw new UnsupportedOperationException("Stub!");
        }

        default public void onAuthenticationSucceededInternal(boolean requireConfirmation, byte[] token) throws RemoteException {
            throw new UnsupportedOperationException("Stub!");
        }

        default public void onAuthenticationFailed(long deviceId) throws RemoteException {
            throw new UnsupportedOperationException("Stub!");
        }

        default public void onAuthenticationFailedInternal(int cookie, boolean requireConfirmation) throws RemoteException {
            throw new UnsupportedOperationException("Stub!");
        }

        public void onError(long var1, int var3, int var4, int var5) throws RemoteException;

        default public void onRemoved(BiometricAuthenticator.Identifier identifier, int remaining) throws RemoteException {
        }

        default public void onEnumerated(BiometricAuthenticator.Identifier identifier, int remaining) throws RemoteException {
        }
    }

    private final class InternalEnumerateClient
    extends EnumerateClient {
        private BiometricUtils mUtils;
        private List<? extends BiometricAuthenticator.Identifier> mEnrolledList;
        private List<BiometricAuthenticator.Identifier> mUnknownHALTemplates;

        InternalEnumerateClient(Context context, DaemonWrapper daemon, long halDeviceId, IBinder token, ServiceListener listener, int groupId, int userId, boolean restricted, String owner, List<? extends BiometricAuthenticator.Identifier> enrolledList, BiometricUtils utils) {
            super(context, BiometricServiceBase.this.getConstants(), daemon, halDeviceId, token, listener, groupId, userId, restricted, owner);
            this.mUnknownHALTemplates = new ArrayList<BiometricAuthenticator.Identifier>();
            this.mEnrolledList = enrolledList;
            this.mUtils = utils;
        }

        private void handleEnumeratedTemplate(BiometricAuthenticator.Identifier identifier) {
            if (identifier == null) {
                return;
            }
            Slog.v(BiometricServiceBase.this.getTag(), "handleEnumeratedTemplate: " + identifier.getBiometricId());
            boolean matched = false;
            for (int i = 0; i < this.mEnrolledList.size(); ++i) {
                if (this.mEnrolledList.get(i).getBiometricId() != identifier.getBiometricId()) continue;
                this.mEnrolledList.remove(i);
                matched = true;
                break;
            }
            if (!matched && identifier.getBiometricId() != 0) {
                this.mUnknownHALTemplates.add(identifier);
            }
            Slog.v(BiometricServiceBase.this.getTag(), "Matched: " + matched);
        }

        private void doTemplateCleanup() {
            if (this.mEnrolledList == null) {
                return;
            }
            for (int i = 0; i < this.mEnrolledList.size(); ++i) {
                BiometricAuthenticator.Identifier identifier = this.mEnrolledList.get(i);
                Slog.e(BiometricServiceBase.this.getTag(), "doTemplateCleanup(): Removing dangling template from framework: " + identifier.getBiometricId() + " " + identifier.getName());
                this.mUtils.removeBiometricForUser(this.getContext(), this.getTargetUserId(), identifier.getBiometricId());
                StatsLog.write(148, this.statsModality(), 2);
            }
            this.mEnrolledList.clear();
        }

        public List<BiometricAuthenticator.Identifier> getUnknownHALTemplates() {
            return this.mUnknownHALTemplates;
        }

        @Override
        public boolean onEnumerationResult(BiometricAuthenticator.Identifier identifier, int remaining) {
            this.handleEnumeratedTemplate(identifier);
            if (remaining == 0) {
                this.doTemplateCleanup();
            }
            return remaining == 0;
        }

        @Override
        protected int statsModality() {
            return BiometricServiceBase.this.statsModality();
        }
    }

    private final class InternalRemovalClient
    extends RemovalClient {
        InternalRemovalClient(Context context, DaemonWrapper daemon, long halDeviceId, IBinder token, ServiceListener listener, int templateId, int groupId, int userId, boolean restricted, String owner) {
            super(context, BiometricServiceBase.this.getConstants(), daemon, halDeviceId, token, listener, templateId, groupId, userId, restricted, owner, BiometricServiceBase.this.getBiometricUtils());
        }

        @Override
        protected int statsModality() {
            return BiometricServiceBase.this.statsModality();
        }
    }

    protected abstract class EnrollClientImpl
    extends EnrollClient {
        public EnrollClientImpl(Context context, DaemonWrapper daemon, long halDeviceId, IBinder token, ServiceListener listener, int userId, int groupId, byte[] cryptoToken, boolean restricted, String owner, int[] disabledFeatures) {
            super(context, BiometricServiceBase.this.getConstants(), daemon, halDeviceId, token, listener, userId, groupId, cryptoToken, restricted, owner, BiometricServiceBase.this.getBiometricUtils(), disabledFeatures);
        }

        @Override
        public void notifyUserActivity() {
            BiometricServiceBase.this.userActivity();
        }
    }

    protected abstract class AuthenticationClientImpl
    extends AuthenticationClient {
        protected boolean isFingerprint() {
            return false;
        }

        public AuthenticationClientImpl(Context context, DaemonWrapper daemon, long halDeviceId, IBinder token, ServiceListener listener, int targetUserId, int groupId, long opId, boolean restricted, String owner, int cookie, boolean requireConfirmation) {
            super(context, BiometricServiceBase.this.getConstants(), daemon, halDeviceId, token, listener, targetUserId, groupId, opId, restricted, owner, cookie, requireConfirmation);
        }

        @Override
        protected int statsClient() {
            if (BiometricServiceBase.this.isKeyguard(this.getOwnerString())) {
                return 1;
            }
            if (this.isBiometricPrompt()) {
                return 2;
            }
            if (this.isFingerprint()) {
                return 3;
            }
            return 0;
        }

        @Override
        public void onStart() {
            try {
                BiometricServiceBase.this.mActivityTaskManager.registerTaskStackListener(BiometricServiceBase.this.mTaskStackListener);
            }
            catch (RemoteException e) {
                Slog.e(BiometricServiceBase.this.getTag(), "Could not register task stack listener", e);
            }
        }

        @Override
        public void onStop() {
            try {
                BiometricServiceBase.this.mActivityTaskManager.unregisterTaskStackListener(BiometricServiceBase.this.mTaskStackListener);
            }
            catch (RemoteException e) {
                Slog.e(BiometricServiceBase.this.getTag(), "Could not unregister task stack listener", e);
            }
        }

        @Override
        public void notifyUserActivity() {
            BiometricServiceBase.this.userActivity();
        }

        @Override
        public int handleFailedAttempt() {
            int lockoutMode = BiometricServiceBase.this.getLockoutMode();
            if (lockoutMode == 2) {
                ++((BiometricServiceBase)BiometricServiceBase.this).mPerformanceStats.permanentLockout;
            } else if (lockoutMode == 1) {
                ++((BiometricServiceBase)BiometricServiceBase.this).mPerformanceStats.lockout;
            }
            if (lockoutMode != 0) {
                return lockoutMode;
            }
            return 0;
        }
    }

    protected class PerformanceStats {
        public int accept;
        public int reject;
        public int acquire;
        public int lockout;
        public int permanentLockout;

        protected PerformanceStats() {
        }
    }
}

