/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics;

import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.os.AsyncTask;
import android.os.Environment;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class BiometricUserState<T extends BiometricAuthenticator.Identifier> {
    private static final String TAG = "UserState";
    @GuardedBy(value={"this"})
    protected final ArrayList<T> mBiometrics = new ArrayList();
    protected final Context mContext;
    protected final File mFile;
    private final Runnable mWriteStateRunnable = new Runnable(){

        @Override
        public void run() {
            BiometricUserState.this.doWriteState();
        }
    };

    protected abstract String getBiometricsTag();

    protected abstract String getBiometricFile();

    protected abstract int getNameTemplateResource();

    protected abstract ArrayList<T> getCopy(ArrayList<T> var1);

    protected abstract void doWriteState();

    protected abstract void parseBiometricsLocked(XmlPullParser var1) throws IOException, XmlPullParserException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BiometricUserState(Context context, int userId) {
        this.mFile = this.getFileForUser(userId);
        this.mContext = context;
        BiometricUserState biometricUserState = this;
        synchronized (biometricUserState) {
            this.readStateSyncLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBiometric(T identifier) {
        BiometricUserState biometricUserState = this;
        synchronized (biometricUserState) {
            this.mBiometrics.add(identifier);
            this.scheduleWriteStateLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBiometric(int biometricId) {
        BiometricUserState biometricUserState = this;
        synchronized (biometricUserState) {
            for (int i = 0; i < this.mBiometrics.size(); ++i) {
                if (((BiometricAuthenticator.Identifier)this.mBiometrics.get(i)).getBiometricId() != biometricId) continue;
                this.mBiometrics.remove(i);
                this.scheduleWriteStateLocked();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameBiometric(int biometricId, CharSequence name) {
        BiometricUserState biometricUserState = this;
        synchronized (biometricUserState) {
            for (int i = 0; i < this.mBiometrics.size(); ++i) {
                if (((BiometricAuthenticator.Identifier)this.mBiometrics.get(i)).getBiometricId() != biometricId) continue;
                BiometricAuthenticator.Identifier identifier = (BiometricAuthenticator.Identifier)this.mBiometrics.get(i);
                identifier.setName(name);
                this.scheduleWriteStateLocked();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getBiometrics() {
        BiometricUserState biometricUserState = this;
        synchronized (biometricUserState) {
            return this.getCopy(this.mBiometrics);
        }
    }

    public String getUniqueName() {
        int guess = 1;
        String name;
        while (!this.isUnique(name = this.mContext.getString(this.getNameTemplateResource(), guess))) {
            ++guess;
        }
        return name;
    }

    private boolean isUnique(String name) {
        for (BiometricAuthenticator.Identifier identifier : this.mBiometrics) {
            if (!identifier.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    private File getFileForUser(int userId) {
        return new File(Environment.getUserSystemDirectory(userId), this.getBiometricFile());
    }

    private void scheduleWriteStateLocked() {
        AsyncTask.execute(this.mWriteStateRunnable);
    }

    @GuardedBy(value={"this"})
    private void readStateSyncLocked() {
        FileInputStream in;
        if (!this.mFile.exists()) {
            return;
        }
        try {
            in = new FileInputStream(this.mFile);
        }
        catch (FileNotFoundException fnfe) {
            Slog.i(TAG, "No fingerprint state");
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(in, null);
            this.parseStateLocked(parser);
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalStateException("Failed parsing settings file: " + this.mFile, e);
        }
        finally {
            IoUtils.closeQuietly(in);
        }
    }

    @GuardedBy(value={"this"})
    private void parseStateLocked(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tagName;
            if (type == 3 || type == 4 || !(tagName = parser.getName()).equals(this.getBiometricsTag())) continue;
            this.parseBiometricsLocked(parser);
        }
    }
}

