/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics;

import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.media.AudioAttributes;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.android.server.biometrics.BiometricServiceBase;
import com.android.server.biometrics.Constants;
import com.android.server.biometrics.LoggableMonitor;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public abstract class ClientMonitor
extends LoggableMonitor
implements IBinder.DeathRecipient {
    protected static final int ERROR_ESRCH = 3;
    protected static final boolean DEBUG = true;
    private static final AudioAttributes FINGERPRINT_SONFICATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
    private final Context mContext;
    private final long mHalDeviceId;
    private final int mTargetUserId;
    private final int mGroupId;
    private final boolean mIsRestricted;
    private final String mOwner;
    private final VibrationEffect mSuccessVibrationEffect;
    private final VibrationEffect mErrorVibrationEffect;
    private final BiometricServiceBase.DaemonWrapper mDaemon;
    private IBinder mToken;
    private BiometricServiceBase.ServiceListener mListener;
    private final int mCookie;
    protected final MetricsLogger mMetricsLogger;
    protected final Constants mConstants;
    protected boolean mAlreadyCancelled;
    protected boolean mAlreadyDone;

    public ClientMonitor(Context context, Constants constants, BiometricServiceBase.DaemonWrapper daemon, long halDeviceId, IBinder token, BiometricServiceBase.ServiceListener listener, int userId, int groupId, boolean restricted, String owner, int cookie) {
        this.mContext = context;
        this.mConstants = constants;
        this.mDaemon = daemon;
        this.mHalDeviceId = halDeviceId;
        this.mToken = token;
        this.mListener = listener;
        this.mTargetUserId = userId;
        this.mGroupId = groupId;
        this.mIsRestricted = restricted;
        this.mOwner = owner;
        this.mCookie = cookie;
        this.mSuccessVibrationEffect = VibrationEffect.get(0);
        this.mErrorVibrationEffect = VibrationEffect.get(1);
        this.mMetricsLogger = new MetricsLogger();
        try {
            if (token != null) {
                token.linkToDeath(this, 0);
            }
        }
        catch (RemoteException e) {
            Slog.w(this.getLogTag(), "caught remote exception in linkToDeath: ", e);
        }
    }

    protected String getLogTag() {
        return this.mConstants.logTag();
    }

    public int getCookie() {
        return this.mCookie;
    }

    public abstract int start();

    public abstract int stop(boolean var1);

    public abstract void notifyUserActivity();

    public abstract boolean onEnrollResult(BiometricAuthenticator.Identifier var1, int var2);

    public abstract boolean onAuthenticated(BiometricAuthenticator.Identifier var1, boolean var2, ArrayList<Byte> var3);

    public abstract boolean onRemoved(BiometricAuthenticator.Identifier var1, int var2);

    public abstract boolean onEnumerationResult(BiometricAuthenticator.Identifier var1, int var2);

    public int[] getAcquireIgnorelist() {
        return new int[0];
    }

    public int[] getAcquireVendorIgnorelist() {
        return new int[0];
    }

    private boolean blacklistContains(int acquiredInfo, int vendorCode) {
        if (acquiredInfo == this.mConstants.acquireVendorCode()) {
            for (int i = 0; i < this.getAcquireVendorIgnorelist().length; ++i) {
                if (this.getAcquireVendorIgnorelist()[i] != vendorCode) continue;
                Slog.v(this.getLogTag(), "Ignoring vendor message: " + vendorCode);
                return true;
            }
        } else {
            for (int i = 0; i < this.getAcquireIgnorelist().length; ++i) {
                if (this.getAcquireIgnorelist()[i] != acquiredInfo) continue;
                Slog.v(this.getLogTag(), "Ignoring message: " + acquiredInfo);
                return true;
            }
        }
        return false;
    }

    public boolean isAlreadyDone() {
        return this.mAlreadyDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onAcquired(int acquiredInfo, int vendorCode) {
        super.logOnAcquired(this.mContext, acquiredInfo, vendorCode, this.getTargetUserId());
        Slog.v(this.getLogTag(), "Acquired: " + acquiredInfo + " " + vendorCode);
        try {
            if (this.mListener != null && !this.blacklistContains(acquiredInfo, vendorCode)) {
                this.mListener.onAcquired(this.getHalDeviceId(), acquiredInfo, vendorCode);
            }
            boolean bl = false;
            return bl;
        }
        catch (RemoteException e) {
            Slog.w(this.getLogTag(), "Failed to invoke sendAcquired", e);
            boolean bl = true;
            return bl;
        }
        finally {
            if (acquiredInfo == 0) {
                this.notifyUserActivity();
            }
        }
    }

    public boolean onError(long deviceId, int error, int vendorCode) {
        super.logOnError(this.mContext, error, vendorCode, this.getTargetUserId());
        try {
            if (this.mListener != null) {
                this.mListener.onError(deviceId, error, vendorCode, this.getCookie());
            }
        }
        catch (RemoteException e) {
            Slog.w(this.getLogTag(), "Failed to invoke sendError", e);
        }
        return true;
    }

    public void destroy() {
        if (this.mToken != null) {
            try {
                this.mToken.unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException e) {
                Slog.e(this.getLogTag(), "destroy(): " + this + ":", new Exception("here"));
            }
            this.mToken = null;
        }
        this.mListener = null;
    }

    @Override
    public void binderDied() {
        Slog.e(this.getLogTag(), "Binder died, cancelling client");
        this.stop(false);
        this.mToken = null;
        this.mListener = null;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mToken != null) {
                Slog.w(this.getLogTag(), "removing leaked reference: " + this.mToken);
                this.onError(this.getHalDeviceId(), 1, 0);
            }
        }
        finally {
            super.finalize();
        }
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final long getHalDeviceId() {
        return this.mHalDeviceId;
    }

    public final String getOwnerString() {
        return this.mOwner;
    }

    public final BiometricServiceBase.ServiceListener getListener() {
        return this.mListener;
    }

    public final BiometricServiceBase.DaemonWrapper getDaemonWrapper() {
        return this.mDaemon;
    }

    public final boolean getIsRestricted() {
        return this.mIsRestricted;
    }

    public final int getTargetUserId() {
        return this.mTargetUserId;
    }

    public final int getGroupId() {
        return this.mGroupId;
    }

    public final IBinder getToken() {
        return this.mToken;
    }

    public final void vibrateSuccess() {
        Vibrator vibrator = this.mContext.getSystemService(Vibrator.class);
        if (vibrator != null) {
            vibrator.vibrate(this.mSuccessVibrationEffect, FINGERPRINT_SONFICATION_ATTRIBUTES);
        }
    }

    public final void vibrateError() {
        Vibrator vibrator = this.mContext.getSystemService(Vibrator.class);
        if (vibrator != null) {
            vibrator.vibrate(this.mErrorVibrationEffect, FINGERPRINT_SONFICATION_ATTRIBUTES);
        }
    }
}

