/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics;

import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.biometrics.BiometricServiceBase;
import com.android.server.biometrics.BiometricUtils;
import com.android.server.biometrics.ClientMonitor;
import com.android.server.biometrics.Constants;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class EnrollClient
extends ClientMonitor {
    private static final long MS_PER_SEC = 1000L;
    private static final int ENROLLMENT_TIMEOUT_MS = 60000;
    private final byte[] mCryptoToken;
    private final BiometricUtils mBiometricUtils;
    private final int[] mDisabledFeatures;
    private long mEnrollmentStartTimeMs;

    public abstract boolean shouldVibrate();

    public EnrollClient(Context context, Constants constants, BiometricServiceBase.DaemonWrapper daemon, long halDeviceId, IBinder token, BiometricServiceBase.ServiceListener listener, int userId, int groupId, byte[] cryptoToken, boolean restricted, String owner, BiometricUtils utils, int[] disabledFeatures) {
        super(context, constants, daemon, halDeviceId, token, listener, userId, groupId, restricted, owner, 0);
        this.mBiometricUtils = utils;
        this.mCryptoToken = Arrays.copyOf(cryptoToken, cryptoToken.length);
        this.mDisabledFeatures = Arrays.copyOf(disabledFeatures, disabledFeatures.length);
    }

    @Override
    protected int statsAction() {
        return 1;
    }

    @Override
    public boolean onEnrollResult(BiometricAuthenticator.Identifier identifier, int remaining) {
        if (remaining == 0) {
            this.mBiometricUtils.addBiometricForUser(this.getContext(), this.getTargetUserId(), identifier);
            this.logOnEnrolled(this.getTargetUserId(), System.currentTimeMillis() - this.mEnrollmentStartTimeMs, true);
        }
        this.notifyUserActivity();
        return this.sendEnrollResult(identifier, remaining);
    }

    private boolean sendEnrollResult(BiometricAuthenticator.Identifier identifier, int remaining) {
        if (this.shouldVibrate()) {
            this.vibrateSuccess();
        }
        this.mMetricsLogger.action(this.mConstants.actionBiometricEnroll());
        try {
            BiometricServiceBase.ServiceListener listener = this.getListener();
            if (listener != null) {
                listener.onEnrollResult(identifier, remaining);
            }
            return remaining == 0;
        }
        catch (RemoteException e) {
            Slog.w(this.getLogTag(), "Failed to notify EnrollResult:", e);
            return true;
        }
    }

    @Override
    public int start() {
        this.mEnrollmentStartTimeMs = System.currentTimeMillis();
        int timeout = 60;
        try {
            ArrayList<Integer> disabledFeatures = new ArrayList<Integer>();
            for (int i = 0; i < this.mDisabledFeatures.length; ++i) {
                disabledFeatures.add(this.mDisabledFeatures[i]);
            }
            int result = this.getDaemonWrapper().enroll(this.mCryptoToken, this.getGroupId(), 60, disabledFeatures);
            if (result != 0) {
                Slog.w(this.getLogTag(), "startEnroll failed, result=" + result);
                this.mMetricsLogger.histogram(this.mConstants.tagEnrollStartError(), result);
                this.onError(this.getHalDeviceId(), 1, 0);
                return result;
            }
        }
        catch (RemoteException e) {
            Slog.e(this.getLogTag(), "startEnroll failed", e);
        }
        return 0;
    }

    @Override
    public int stop(boolean initiatedByClient) {
        if (this.mAlreadyCancelled) {
            Slog.w(this.getLogTag(), "stopEnroll: already cancelled!");
            return 0;
        }
        try {
            int result = this.getDaemonWrapper().cancel();
            if (result != 0) {
                Slog.w(this.getLogTag(), "startEnrollCancel failed, result = " + result);
                return result;
            }
        }
        catch (RemoteException e) {
            Slog.e(this.getLogTag(), "stopEnrollment failed", e);
        }
        this.mAlreadyCancelled = true;
        return 0;
    }

    @Override
    public boolean onRemoved(BiometricAuthenticator.Identifier identifier, int remaining) {
        Slog.w(this.getLogTag(), "onRemoved() called for enroll!");
        return true;
    }

    @Override
    public boolean onEnumerationResult(BiometricAuthenticator.Identifier identifier, int remaining) {
        Slog.w(this.getLogTag(), "onEnumerationResult() called for enroll!");
        return true;
    }

    @Override
    public boolean onAuthenticated(BiometricAuthenticator.Identifier identifier, boolean authenticated, ArrayList<Byte> token) {
        Slog.w(this.getLogTag(), "onAuthenticated() called for enroll!");
        return true;
    }

    @Override
    public boolean onError(long deviceId, int error, int vendorCode) {
        this.logOnEnrolled(this.getTargetUserId(), System.currentTimeMillis() - this.mEnrollmentStartTimeMs, false);
        return super.onError(deviceId, error, vendorCode);
    }
}

