/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics;

import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.biometrics.BiometricServiceBase;
import com.android.server.biometrics.ClientMonitor;
import com.android.server.biometrics.Constants;
import java.util.ArrayList;

public abstract class EnumerateClient
extends ClientMonitor {
    public EnumerateClient(Context context, Constants constants, BiometricServiceBase.DaemonWrapper daemon, long halDeviceId, IBinder token, BiometricServiceBase.ServiceListener listener, int groupId, int userId, boolean restricted, String owner) {
        super(context, constants, daemon, halDeviceId, token, listener, userId, groupId, restricted, owner, 0);
    }

    @Override
    public void notifyUserActivity() {
    }

    @Override
    protected int statsAction() {
        return 3;
    }

    @Override
    public int start() {
        try {
            int result = this.getDaemonWrapper().enumerate();
            if (result != 0) {
                Slog.w(this.getLogTag(), "start enumerate for user " + this.getTargetUserId() + " failed, result=" + result);
                this.mMetricsLogger.histogram(this.mConstants.tagEnumerateStartError(), result);
                this.onError(this.getHalDeviceId(), 1, 0);
                return result;
            }
        }
        catch (RemoteException e) {
            Slog.e(this.getLogTag(), "startEnumeration failed", e);
        }
        return 0;
    }

    @Override
    public int stop(boolean initiatedByClient) {
        if (this.mAlreadyCancelled) {
            Slog.w(this.getLogTag(), "stopEnumerate: already cancelled!");
            return 0;
        }
        try {
            int result = this.getDaemonWrapper().cancel();
            if (result != 0) {
                Slog.w(this.getLogTag(), "stop enumeration failed, result=" + result);
                return result;
            }
        }
        catch (RemoteException e) {
            Slog.e(this.getLogTag(), "stopEnumeration failed", e);
            return 3;
        }
        if (initiatedByClient) {
            this.onError(this.getHalDeviceId(), 5, 0);
        }
        this.mAlreadyCancelled = true;
        return 0;
    }

    @Override
    public boolean onEnumerationResult(BiometricAuthenticator.Identifier identifier, int remaining) {
        try {
            if (this.getListener() != null) {
                this.getListener().onEnumerated(identifier, remaining);
            }
        }
        catch (RemoteException e) {
            Slog.w(this.getLogTag(), "Failed to notify enumerated:", e);
        }
        return remaining == 0;
    }

    @Override
    public boolean onAuthenticated(BiometricAuthenticator.Identifier identifier, boolean authenticated, ArrayList<Byte> token) {
        Slog.w(this.getLogTag(), "onAuthenticated() called for enumerate!");
        return true;
    }

    @Override
    public boolean onEnrollResult(BiometricAuthenticator.Identifier identifier, int rem) {
        Slog.w(this.getLogTag(), "onEnrollResult() called for enumerate!");
        return true;
    }

    @Override
    public boolean onRemoved(BiometricAuthenticator.Identifier identifier, int remaining) {
        Slog.w(this.getLogTag(), "onRemoved() called for enumerate!");
        return true;
    }
}

