/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics;

import android.content.Context;
import android.util.Slog;
import android.util.StatsLog;
import com.android.server.biometrics.Utils;

public abstract class LoggableMonitor {
    public static final String TAG = "BiometricStats";
    public static final boolean DEBUG = false;
    private long mFirstAcquireTimeMs;

    protected boolean isCryptoOperation() {
        return false;
    }

    protected abstract int statsModality();

    protected abstract int statsAction();

    protected int statsClient() {
        return 0;
    }

    protected final void logOnAcquired(Context context, int acquiredInfo, int vendorCode, int targetUserId) {
        if (this.statsModality() == 4) {
            if (acquiredInfo == 20) {
                this.mFirstAcquireTimeMs = System.currentTimeMillis();
            }
        } else if (acquiredInfo == 0 && this.mFirstAcquireTimeMs == 0L) {
            this.mFirstAcquireTimeMs = System.currentTimeMillis();
        }
        StatsLog.write(87, this.statsModality(), targetUserId, this.isCryptoOperation(), this.statsAction(), this.statsClient(), acquiredInfo, 0, Utils.isDebugEnabled(context, targetUserId));
    }

    protected final void logOnError(Context context, int error, int vendorCode, int targetUserId) {
        StatsLog.write(89, this.statsModality(), targetUserId, this.isCryptoOperation(), this.statsAction(), this.statsClient(), error, vendorCode, Utils.isDebugEnabled(context, targetUserId));
    }

    protected final void logOnAuthenticated(Context context, boolean authenticated, boolean requireConfirmation, int targetUserId, boolean isBiometricPrompt) {
        int authState = 0;
        authState = !authenticated ? 1 : (isBiometricPrompt && requireConfirmation ? 2 : 3);
        long latency = this.mFirstAcquireTimeMs != 0L ? System.currentTimeMillis() - this.mFirstAcquireTimeMs : -1L;
        Slog.v(TAG, "Authentication latency: " + latency);
        StatsLog.write(88, this.statsModality(), targetUserId, this.isCryptoOperation(), this.statsClient(), requireConfirmation, authState, latency, Utils.isDebugEnabled(context, targetUserId));
    }

    protected final void logOnEnrolled(int targetUserId, long latency, boolean enrollSuccessful) {
        Slog.v(TAG, "Enroll latency: " + latency);
        StatsLog.write(184, this.statsModality(), targetUserId, latency, enrollSuccessful);
    }
}

