/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.biometrics;

import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.biometrics.BiometricServiceBase;
import com.android.server.biometrics.BiometricUtils;
import com.android.server.biometrics.ClientMonitor;
import com.android.server.biometrics.Constants;
import java.util.ArrayList;

public abstract class RemovalClient
extends ClientMonitor {
    private final int mBiometricId;
    private final BiometricUtils mBiometricUtils;

    public RemovalClient(Context context, Constants constants, BiometricServiceBase.DaemonWrapper daemon, long halDeviceId, IBinder token, BiometricServiceBase.ServiceListener listener, int biometricId, int groupId, int userId, boolean restricted, String owner, BiometricUtils utils) {
        super(context, constants, daemon, halDeviceId, token, listener, userId, groupId, restricted, owner, 0);
        this.mBiometricId = biometricId;
        this.mBiometricUtils = utils;
    }

    @Override
    public void notifyUserActivity() {
    }

    @Override
    protected int statsAction() {
        return 4;
    }

    @Override
    public int start() {
        try {
            int result = this.getDaemonWrapper().remove(this.getGroupId(), this.mBiometricId);
            if (result != 0) {
                Slog.w(this.getLogTag(), "startRemove with id = " + this.mBiometricId + " failed, result=" + result);
                this.mMetricsLogger.histogram(this.mConstants.tagRemoveStartError(), result);
                this.onError(this.getHalDeviceId(), 1, 0);
                return result;
            }
        }
        catch (RemoteException e) {
            Slog.e(this.getLogTag(), "startRemove failed", e);
        }
        return 0;
    }

    @Override
    public int stop(boolean initiatedByClient) {
        if (this.mAlreadyCancelled) {
            Slog.w(this.getLogTag(), "stopRemove: already cancelled!");
            return 0;
        }
        try {
            int result = this.getDaemonWrapper().cancel();
            if (result != 0) {
                Slog.w(this.getLogTag(), "stopRemoval failed, result=" + result);
                return result;
            }
            Slog.w(this.getLogTag(), "client " + this.getOwnerString() + " is no longer removing");
        }
        catch (RemoteException e) {
            Slog.e(this.getLogTag(), "stopRemoval failed", e);
            return 3;
        }
        this.mAlreadyCancelled = true;
        return 0;
    }

    private boolean sendRemoved(BiometricAuthenticator.Identifier identifier, int remaining) {
        try {
            if (this.getListener() != null) {
                this.getListener().onRemoved(identifier, remaining);
            }
        }
        catch (RemoteException e) {
            Slog.w(this.getLogTag(), "Failed to notify Removed:", e);
        }
        return remaining == 0;
    }

    @Override
    public boolean onRemoved(BiometricAuthenticator.Identifier identifier, int remaining) {
        if (identifier.getBiometricId() != 0) {
            this.mBiometricUtils.removeBiometricForUser(this.getContext(), this.getTargetUserId(), identifier.getBiometricId());
        }
        return this.sendRemoved(identifier, remaining);
    }

    @Override
    public boolean onEnrollResult(BiometricAuthenticator.Identifier identifier, int rem) {
        Slog.w(this.getLogTag(), "onEnrollResult() called for remove!");
        return true;
    }

    @Override
    public boolean onAuthenticated(BiometricAuthenticator.Identifier identifier, boolean authenticated, ArrayList<Byte> token) {
        Slog.w(this.getLogTag(), "onAuthenticated() called for remove!");
        return true;
    }

    @Override
    public boolean onEnumerationResult(BiometricAuthenticator.Identifier identifier, int remaining) {
        Slog.w(this.getLogTag(), "onEnumerationResult() called for remove!");
        return true;
    }
}

